/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.model.object;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.internal.Consts;
import com.volcengine.tos.internal.model.HttpRange;
import com.volcengine.tos.internal.util.DateConverter;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class UploadPartCopyV2Input {
    private String bucket;
    private String key;
    private String uploadID;
    private int partNumber;
    private String sourceBucket;
    private String sourceKey;
    private String sourceVersionID;
    private HttpRange copySourceRange;
    private String copySourceRangeString;
    private String copySourceIfMatch;
    private Date copySourceIfModifiedSinceDate;
    private String copySourceIfNoneMatch;
    private Date copySourceIfUnmodifiedSinceDate;
    private String copySourceSSECAlgorithm;
    private String copySourceSSECKey;
    private String copySourceSSECKeyMD5;
    private ObjectMetaRequestOptions options;
    private Map<String, String> headers;

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getUploadID() {
        return this.uploadID;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public String getSourceVersionID() {
        return this.sourceVersionID;
    }

    public ObjectMetaRequestOptions getOptions() {
        return this.options;
    }

    public UploadPartCopyV2Input setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public UploadPartCopyV2Input setKey(String key) {
        this.key = key;
        return this;
    }

    public UploadPartCopyV2Input setUploadID(String uploadID) {
        this.uploadID = uploadID;
        return this;
    }

    public UploadPartCopyV2Input setPartNumber(int partNumber) {
        this.partNumber = partNumber;
        return this;
    }

    public UploadPartCopyV2Input setSourceBucket(String sourceBucket) {
        this.sourceBucket = sourceBucket;
        return this;
    }

    public UploadPartCopyV2Input setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
        return this;
    }

    public UploadPartCopyV2Input setSourceVersionID(String sourceVersionID) {
        this.sourceVersionID = sourceVersionID;
        return this;
    }

    public UploadPartCopyV2Input setOptions(ObjectMetaRequestOptions options) {
        this.options = options;
        return this;
    }

    public long getCopySourceRangeStart() {
        return this.copySourceRange == null ? 0L : this.copySourceRange.getStart();
    }

    public long getCopySourceRangeEnd() {
        return this.copySourceRange == null ? 0L : this.copySourceRange.getEnd();
    }

    public String getCopySourceRangeString() {
        return this.copySourceRangeString;
    }

    public UploadPartCopyV2Input setCopySourceRangeString(String copySourceRangeString) {
        this.copySourceRangeString = copySourceRangeString;
        return this;
    }

    public UploadPartCopyV2Input setCopySourceRange(long copySourceRangeStart, long copySourceRangeEnd) {
        this.copySourceRange = new HttpRange().setStart(copySourceRangeStart).setEnd(copySourceRangeEnd);
        return this;
    }

    public String getCopySourceIfMatch() {
        return this.copySourceIfMatch;
    }

    public UploadPartCopyV2Input setCopySourceIfMatch(String copySourceIfMatch) {
        this.copySourceIfMatch = copySourceIfMatch;
        return this;
    }

    public Date getCopySourceIfModifiedSinceDate() {
        return this.copySourceIfModifiedSinceDate;
    }

    public UploadPartCopyV2Input setCopySourceIfModifiedSinceDate(Date copySourceIfModifiedSinceDate) {
        this.copySourceIfModifiedSinceDate = copySourceIfModifiedSinceDate;
        return this;
    }

    public String getCopySourceIfNoneMatch() {
        return this.copySourceIfNoneMatch;
    }

    public UploadPartCopyV2Input setCopySourceIfNoneMatch(String copySourceIfNoneMatch) {
        this.copySourceIfNoneMatch = copySourceIfNoneMatch;
        return this;
    }

    public Date getCopySourceIfUnmodifiedSinceDate() {
        return this.copySourceIfUnmodifiedSinceDate;
    }

    public UploadPartCopyV2Input setCopySourceIfUnmodifiedSinceDate(Date copySourceIfUnmodifiedSinceDate) {
        this.copySourceIfUnmodifiedSinceDate = copySourceIfUnmodifiedSinceDate;
        return this;
    }

    public String getCopySourceSSECAlgorithm() {
        return this.copySourceSSECAlgorithm;
    }

    public UploadPartCopyV2Input setCopySourceSSECAlgorithm(String copySourceSSECAlgorithm) {
        this.copySourceSSECAlgorithm = copySourceSSECAlgorithm;
        return this;
    }

    public String getCopySourceSSECKey() {
        return this.copySourceSSECKey;
    }

    public UploadPartCopyV2Input setCopySourceSSECKey(String copySourceSSECKey) {
        this.copySourceSSECKey = copySourceSSECKey;
        return this;
    }

    public String getCopySourceSSECKeyMD5() {
        return this.copySourceSSECKeyMD5;
    }

    public UploadPartCopyV2Input setCopySourceSSECKeyMD5(String copySourceSSECKeyMD5) {
        this.copySourceSSECKeyMD5 = copySourceSSECKeyMD5;
        return this;
    }

    public Map<String, String> getAllSettedHeaders() {
        if (this.copySourceRange != null) {
            this.withHeader("X-Tos-Copy-Source-Range", this.copySourceRange.toString());
        }
        if (StringUtils.isNotEmpty(this.copySourceRangeString)) {
            this.withHeader("X-Tos-Copy-Source-Range", this.copySourceRangeString);
        }
        this.withHeader("X-Tos-Copy-Source-If-Match", this.copySourceIfMatch);
        this.withHeader("X-Tos-Copy-Source-If-None-Match", this.copySourceIfNoneMatch);
        if (StringUtils.isNotEmpty(this.copySourceSSECAlgorithm)) {
            if (Consts.CUSTOM_SERVER_SIDE_ENCRYPTION_ALGORITHM_LIST.contains(this.copySourceSSECAlgorithm)) {
                this.withHeader("X-Tos-Server-Side-Encryption-Customer-Algorithm", this.copySourceSSECAlgorithm);
            } else {
                throw new TosClientException("invalid copySourceSSECAlgorithm input, only support AES256", null);
            }
        }
        this.withHeader("x-tos-copy-source-server-side-encryption-customer-key", this.copySourceSSECKey);
        this.withHeader("x-tos-copy-source-server-side-encryption-customer-key-MD5", this.copySourceSSECKeyMD5);
        if (this.copySourceIfModifiedSinceDate != null) {
            this.withHeader(this.key, DateConverter.dateToRFC1123String(this.copySourceIfModifiedSinceDate));
        }
        if (this.copySourceIfUnmodifiedSinceDate != null) {
            this.withHeader(this.key, DateConverter.dateToRFC1123String(this.copySourceIfUnmodifiedSinceDate));
        }
        if (this.options != null) {
            this.headers.putAll(this.options.headers());
        }
        return this.headers;
    }

    private void withHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        if (value != null && value.length() != 0) {
            this.headers.put(key, value);
        }
    }

    public String toString() {
        return "UploadPartCopyV2Input{bucket='" + this.bucket + '\'' + ", key='" + this.key + '\'' + ", uploadID='" + this.uploadID + '\'' + ", partNumber=" + this.partNumber + ", sourceBucket='" + this.sourceBucket + '\'' + ", sourceKey='" + this.sourceKey + '\'' + ", sourceVersionID='" + this.sourceVersionID + '\'' + ", copySourceRange=" + this.copySourceRange + ", copySourceIfMatch='" + this.copySourceIfMatch + '\'' + ", copySourceIfModifiedSinceDate=" + this.copySourceIfModifiedSinceDate + ", copySourceIfNoneMatch='" + this.copySourceIfNoneMatch + '\'' + ", copySourceIfUnmodifiedSinceDate=" + this.copySourceIfUnmodifiedSinceDate + ", copySourceSSECAlgorithm='" + this.copySourceSSECAlgorithm + '\'' + ", copySourceSSECKey='" + this.copySourceSSECKey + '\'' + ", copySourceSSECKeyMD5='" + this.copySourceSSECKeyMD5 + '\'' + ", options=" + this.options + '}';
    }

    public static UploadPartCopyV2InputBuilder builder() {
        return new UploadPartCopyV2InputBuilder();
    }

    public static final class UploadPartCopyV2InputBuilder {
        private String bucket;
        private String key;
        private String uploadID;
        private int partNumber;
        private String sourceBucket;
        private String sourceKey;
        private String sourceVersionID;
        private HttpRange range;
        private String copySourceIfMatch;
        private Date copySourceIfModifiedSinceDate;
        private String copySourceIfNoneMatch;
        private Date copySourceIfUnmodifiedSinceDate;
        private String copySourceSSECAlgorithm;
        private String copySourceSSECKey;
        private String copySourceSSECKeyMD5;
        private ObjectMetaRequestOptions options;

        private UploadPartCopyV2InputBuilder() {
        }

        public UploadPartCopyV2InputBuilder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public UploadPartCopyV2InputBuilder key(String key) {
            this.key = key;
            return this;
        }

        public UploadPartCopyV2InputBuilder uploadID(String uploadID) {
            this.uploadID = uploadID;
            return this;
        }

        public UploadPartCopyV2InputBuilder partNumber(int partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public UploadPartCopyV2InputBuilder sourceBucket(String sourceBucket) {
            this.sourceBucket = sourceBucket;
            return this;
        }

        public UploadPartCopyV2InputBuilder sourceKey(String sourceKey) {
            this.sourceKey = sourceKey;
            return this;
        }

        public UploadPartCopyV2InputBuilder sourceVersionID(String sourceVersionID) {
            this.sourceVersionID = sourceVersionID;
            return this;
        }

        public UploadPartCopyV2InputBuilder copySourceRange(long copySourceRangeStart, long copySourceRangeEnd) {
            this.range = new HttpRange().setStart(copySourceRangeStart).setEnd(copySourceRangeEnd);
            return this;
        }

        public UploadPartCopyV2InputBuilder copySourceIfMatch(String copySourceIfMatch) {
            this.copySourceIfMatch = copySourceIfMatch;
            return this;
        }

        public UploadPartCopyV2InputBuilder copySourceIfModifiedSinceDate(Date copySourceIfModifiedSinceDate) {
            this.copySourceIfModifiedSinceDate = copySourceIfModifiedSinceDate;
            return this;
        }

        public UploadPartCopyV2InputBuilder copySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
            return this;
        }

        public UploadPartCopyV2InputBuilder copySourceIfUnmodifiedSinceDate(Date copySourceIfUnmodifiedSinceDate) {
            this.copySourceIfUnmodifiedSinceDate = copySourceIfUnmodifiedSinceDate;
            return this;
        }

        public UploadPartCopyV2InputBuilder copySourceSSECAlgorithm(String copySourceSSECAlgorithm) {
            this.copySourceSSECAlgorithm = copySourceSSECAlgorithm;
            return this;
        }

        public UploadPartCopyV2InputBuilder copySourceSSECKey(String copySourceSSECKey) {
            this.copySourceSSECKey = copySourceSSECKey;
            return this;
        }

        public UploadPartCopyV2InputBuilder copySourceSSECKeyMD5(String copySourceSSECKeyMD5) {
            this.copySourceSSECKeyMD5 = copySourceSSECKeyMD5;
            return this;
        }

        public UploadPartCopyV2InputBuilder options(ObjectMetaRequestOptions options) {
            this.options = options;
            return this;
        }

        public UploadPartCopyV2Input build() {
            UploadPartCopyV2Input uploadPartCopyV2Input = new UploadPartCopyV2Input();
            uploadPartCopyV2Input.setBucket(this.bucket);
            uploadPartCopyV2Input.setKey(this.key);
            uploadPartCopyV2Input.setUploadID(this.uploadID);
            uploadPartCopyV2Input.setPartNumber(this.partNumber);
            uploadPartCopyV2Input.setSourceBucket(this.sourceBucket);
            uploadPartCopyV2Input.setSourceKey(this.sourceKey);
            uploadPartCopyV2Input.setSourceVersionID(this.sourceVersionID);
            uploadPartCopyV2Input.setCopySourceIfMatch(this.copySourceIfMatch);
            uploadPartCopyV2Input.setCopySourceIfModifiedSinceDate(this.copySourceIfModifiedSinceDate);
            uploadPartCopyV2Input.setCopySourceIfNoneMatch(this.copySourceIfNoneMatch);
            uploadPartCopyV2Input.setCopySourceIfUnmodifiedSinceDate(this.copySourceIfUnmodifiedSinceDate);
            uploadPartCopyV2Input.setCopySourceSSECAlgorithm(this.copySourceSSECAlgorithm);
            uploadPartCopyV2Input.setCopySourceSSECKey(this.copySourceSSECKey);
            uploadPartCopyV2Input.setCopySourceSSECKeyMD5(this.copySourceSSECKeyMD5);
            if (this.range != null) {
                uploadPartCopyV2Input.copySourceRange = this.range;
            }
            uploadPartCopyV2Input.setOptions(this.options);
            return uploadPartCopyV2Input;
        }
    }
}

