/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.transport;

import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.transport.InputStreamRequestBody;
import com.volcengine.tos.transport.TransportConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

@Deprecated
public class DefaultTransport
implements Transport {
    private static final MediaType DEFAULT_MEDIA_TYPE = null;
    private final OkHttpClient client;

    public DefaultTransport(TransportConfig config) {
        ConnectionPool connectionPool = new ConnectionPool(config.getMaxIdleCount(), (long)config.getKeepAlive(), TimeUnit.SECONDS);
        Dispatcher dispatcher = new Dispatcher();
        this.client = new OkHttpClient.Builder().dispatcher(dispatcher).connectionPool(connectionPool).retryOnConnectionFailure(false).readTimeout((long)config.getReadTimeout(), TimeUnit.SECONDS).writeTimeout((long)config.getWriteTimeout(), TimeUnit.SECONDS).connectTimeout((long)config.getConnectTimeout(), TimeUnit.SECONDS).build();
    }

    @Override
    public void switchConfig(TransportConfig config) {
    }

    private MediaType getMediaType(TosRequest request) {
        String type = "";
        if (request.getHeaders() != null) {
            type = request.getHeaders().get("Content-Type");
        }
        return StringUtils.isEmpty(type) ? DEFAULT_MEDIA_TYPE : MediaType.parse((String)type);
    }

    @Override
    public TosResponse roundTrip(TosRequest request) throws IOException {
        Objects.requireNonNull(request.getScheme(), "scheme is null");
        Objects.requireNonNull(request.getHost(), "host is null");
        HttpUrl url = request.toURL();
        Objects.requireNonNull(url, "url is null");
        Request.Builder builder = new Request.Builder().url(url);
        if (request.getHeaders() != null) {
            request.getHeaders().forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        }
        switch (request.getMethod() == null ? "" : request.getMethod().toUpperCase()) {
            case "GET": {
                builder.get();
                break;
            }
            case "POST": {
                if (request.getContent() != null) {
                    byte[] data = new byte[request.getContent().available()];
                    int exact = request.getContent().read(data);
                    if (exact != data.length) {
                        throw new IOException("expected " + data.length + " bytes, but got " + exact + " bytes.");
                    }
                    builder.post(RequestBody.create((MediaType)this.getMediaType(request), (byte[])data));
                    break;
                }
                builder.post(RequestBody.create((MediaType)this.getMediaType(request), (byte[])request.getData()));
                break;
            }
            case "PUT": {
                if (request.getContent() != null) {
                    builder.put((RequestBody)new InputStreamRequestBody(this.getMediaType(request), request.getContent(), request.getContentLength()));
                    break;
                }
                builder.put(RequestBody.create((MediaType)this.getMediaType(request), (byte[])request.getData()));
                break;
            }
            case "HEAD": {
                builder.head();
                break;
            }
            case "DELETE": {
                builder.delete();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Method is not supported: " + request.getMethod());
            }
        }
        Response response = this.client.newCall(builder.build()).execute();
        InputStream inputStream = response.body() == null ? null : response.body().byteStream();
        return new TosResponse().setStatusCode(response.code()).setContentLength(this.getSize(response)).setHeaders(this.getHeaders(response)).setInputStream(inputStream);
    }

    private long getSize(Response response) {
        String size = response.header("Content-Length");
        if (StringUtils.isEmpty(size)) {
            return 0L;
        }
        return Long.parseLong(size);
    }

    private Map<String, String> getHeaders(Response response) {
        if (response == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headers = new HashMap<String, String>(response.headers().size());
        for (String name : response.headers().names()) {
            headers.put(name.toLowerCase(), response.header(name));
        }
        return headers;
    }
}

