/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.auth;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.auth.Credential;
import com.volcengine.tos.auth.Credentials;
import com.volcengine.tos.auth.SignKeyInfo;
import com.volcengine.tos.auth.Signer;
import com.volcengine.tos.auth.signKey;
import com.volcengine.tos.auth.signingHeader;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.SigningUtils;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SignV4
implements Signer {
    private Credentials credentials;
    private final String region;
    private signingHeader signingHeader;
    private Predicate<String> signingQuery;
    private Supplier<Instant> now;
    private signKey signKey;

    public SignV4(Credentials credentials, String region) {
        ParamsChecker.ensureNotNull(credentials, "Credentials");
        ParamsChecker.ensureNotNull(region, "Region");
        this.credentials = credentials;
        this.region = region;
        this.signingHeader = SignV4::defaultSigningHeaderV4;
        this.signingQuery = SignV4::defaultSigningQueryV4;
        this.now = SignV4::defaultUTCNow;
        this.signKey = SigningUtils::signKey;
    }

    public Supplier<Instant> getNow() {
        return this.now;
    }

    public void setNow(Supplier<Instant> date) {
        this.now = date;
    }

    @Override
    public Credentials getCredential() {
        return this.credentials;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public Map<String, String> signHeader(TosRequest req) {
        ParamsChecker.ensureNotNull(req.getHost(), "host");
        HashMap<String, String> signed = new HashMap<String, String>(4);
        OffsetDateTime now = this.now.get().atOffset(ZoneOffset.UTC);
        String date = now.format(SigningUtils.iso8601Layout);
        String contentSha256 = req.getHeaders().get("X-Tos-Content-Sha256");
        Map<String, String> header = req.getHeaders();
        List<Map.Entry<String, String>> signedHeader = this.signedHeader(header, false, null);
        signedHeader.add(new AbstractMap.SimpleEntry<String, String>("X-Tos-Date".toLowerCase(), date));
        signedHeader.add(new AbstractMap.SimpleEntry<String, String>("date", date));
        signedHeader.add(new AbstractMap.SimpleEntry<String, String>("host", req.getHost()));
        Credential cred = this.credentials.credential();
        if (StringUtils.isNotEmpty(cred.getSecurityToken())) {
            signedHeader.add(new AbstractMap.SimpleEntry<String, String>("X-Tos-Security-Token".toLowerCase(), cred.getSecurityToken()));
            signed.put("X-Tos-Security-Token", cred.getSecurityToken());
        }
        Collections.sort(signedHeader, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        List<Map.Entry<String, String>> signedQuery = this.signedQuery(req.getQuery(), null);
        String sign = this.doSign(req.getMethod(), req.getPath(), contentSha256, signedHeader, signedQuery, now, cred);
        String credential = String.format("%s/%s/%s/tos/request", cred.getAccessKeyId(), now.format(SigningUtils.yyyyMMdd), this.region);
        String keys = signedHeader.stream().map(Map.Entry::getKey).sorted().collect(Collectors.joining(";"));
        String auth = String.format("TOS4-HMAC-SHA256 Credential=%s,SignedHeaders=%s,Signature=%s", credential, keys, sign);
        signed.put("Authorization", auth);
        signed.put("X-Tos-Date", date);
        signed.put("Date", date);
        return signed;
    }

    @Override
    public Map<String, String> signQuery(TosRequest req, Duration ttl) {
        OffsetDateTime now = this.now.get().atOffset(ZoneOffset.UTC);
        String date = now.format(SigningUtils.iso8601Layout);
        Map<String, String> query = req.getQuery();
        HashMap<String, String> extra = new HashMap<String, String>();
        Credential cred = this.credentials.credential();
        String credential = String.format("%s/%s/%s/tos/request", cred.getAccessKeyId(), now.format(SigningUtils.yyyyMMdd), this.region);
        extra.put("X-Tos-Algorithm", "TOS4-HMAC-SHA256");
        extra.put("X-Tos-Credential", credential);
        extra.put("X-Tos-Date", date);
        extra.put("X-Tos-Expires", String.valueOf(ttl.toMillis() / 1000L));
        if (StringUtils.isNotEmpty(cred.getSecurityToken())) {
            extra.put("X-Tos-Security-Token", cred.getSecurityToken());
        }
        ArrayList<String> contentSha256Container = new ArrayList<String>(1);
        List<Map.Entry<String, String>> signedHeader = this.signedHeader(req.getHeaders(), true, contentSha256Container);
        String host = req.getHost();
        if (StringUtils.isEmpty(host)) {
            throw new TosClientException("empty host", null);
        }
        signedHeader.add(new AbstractMap.SimpleEntry<String, String>("host", host));
        Collections.sort(signedHeader, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        String keys = signedHeader.stream().map(Map.Entry::getKey).sorted().collect(Collectors.joining(";"));
        extra.put("X-Tos-SignedHeaders", keys);
        List<Map.Entry<String, String>> signedQuery = this.signedQuery(query, extra);
        String contentSha256 = "UNSIGNED-PAYLOAD";
        if (contentSha256Container.size() > 0) {
            contentSha256 = (String)contentSha256Container.get(0);
        }
        String sign = this.doSign(req.getMethod(), req.getPath(), contentSha256, signedHeader, signedQuery, now, cred);
        extra.put("X-Tos-Signature", sign);
        return extra;
    }

    public SignV4 withSignKey(signKey signKey2) {
        this.signKey = signKey2;
        return this;
    }

    public static Instant defaultUTCNow() {
        return Instant.now();
    }

    public static boolean defaultSigningHeaderV4(String key, boolean isSigningQuery) {
        if (StringUtils.isEmpty(key)) {
            return false;
        }
        return "content-type".equals(key) && !isSigningQuery || key.startsWith("x-tos");
    }

    public static boolean defaultSigningQueryV4(String key) {
        return !"x-tos-signature".equals(key);
    }

    private List<Map.Entry<String, String>> signedHeader(Map<String, String> header, boolean isSignedQuery, List<String> contentSha256) {
        ArrayList<Map.Entry<String, String>> signed = new ArrayList<Map.Entry<String, String>>(10);
        if (header == null || header.isEmpty()) {
            return signed;
        }
        for (Map.Entry<String, String> entry : header.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.isNotEmpty(key)) continue;
            String kk = key.toLowerCase();
            if (contentSha256 != null && kk.equalsIgnoreCase("X-Tos-Content-Sha256") && StringUtils.isNotEmpty(value)) {
                contentSha256.add(value);
            }
            if (!this.signingHeader.isSigningHeader(kk, isSignedQuery)) continue;
            value = value == null ? "" : value;
            signed.add(new AbstractMap.SimpleEntry<String, String>(kk, value));
        }
        return signed;
    }

    private List<Map.Entry<String, String>> signedQuery(Map<String, String> query, Map<String, String> extra) {
        ArrayList<Map.Entry<String, String>> signed = new ArrayList<Map.Entry<String, String>>(10);
        if (query != null) {
            query.forEach((k, v) -> {
                if (this.signingQuery.test(k.toLowerCase())) {
                    signed.add(new AbstractMap.SimpleEntry<String, String>((String)k, (String)v));
                }
            });
        }
        if (extra != null) {
            extra.forEach((k, v) -> {
                if (this.signingQuery.test(k.toLowerCase())) {
                    signed.add(new AbstractMap.SimpleEntry<String, String>((String)k, (String)v));
                }
            });
        }
        return signed;
    }

    private String canonicalRequest(String method, String path, String contentSha256, List<Map.Entry<String, String>> header, List<Map.Entry<String, String>> query) {
        int split = 10;
        StringBuilder buf = new StringBuilder(512);
        buf.append(method);
        buf.append('\n');
        buf.append(SigningUtils.encodePath(path));
        buf.append('\n');
        buf.append(SigningUtils.encodeQuery(query));
        buf.append('\n');
        if (header == null) {
            header = Collections.emptyList();
        }
        ArrayList<String> keys = new ArrayList<String>(header.size());
        Collections.sort(header, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry<String, String> entry : header) {
            String key = entry.getKey();
            keys.add(key);
            buf.append(key);
            buf.append(':');
            buf.append(entry.getValue() == null ? "" : entry.getValue());
            buf.append('\n');
        }
        buf.append('\n');
        buf.append(StringUtils.join(keys, ";"));
        buf.append('\n');
        if (StringUtils.isNotEmpty(contentSha256)) {
            buf.append(contentSha256);
        } else {
            buf.append("e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
        }
        return buf.toString();
    }

    private String doSign(String method, String path, String contentSha256, List<Map.Entry<String, String>> header, List<Map.Entry<String, String>> query, OffsetDateTime now, Credential cred) {
        int split = 10;
        String req = this.canonicalRequest(method, path, contentSha256, header, query);
        TosUtils.getLogger().debug("canonical request:\n{}", (Object)req);
        StringBuilder buf = new StringBuilder("TOS4-HMAC-SHA256".length() + 128);
        buf.append("TOS4-HMAC-SHA256");
        buf.append('\n');
        buf.append(now.format(SigningUtils.iso8601Layout));
        buf.append('\n');
        String date = now.format(SigningUtils.yyyyMMdd);
        buf.append(date).append('/').append(this.region).append("/tos/request");
        buf.append('\n');
        byte[] sum = SigningUtils.sha256(req);
        buf.append(SigningUtils.toHex(sum));
        TosUtils.getLogger().debug("string to sign:\n {}", (Object)buf.toString());
        byte[] signK = SigningUtils.signKey(new SignKeyInfo(date, this.region, cred));
        byte[] sign = SigningUtils.hmacSha256(signK, buf.toString().getBytes(StandardCharsets.UTF_8));
        return String.valueOf(SigningUtils.toHex(sign));
    }
}

