/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.TosServerException;
import com.volcengine.tos.UnexpectedStatusCodeException;
import com.volcengine.tos.comm.MimeType;
import com.volcengine.tos.internal.RequestBuilder;
import com.volcengine.tos.internal.RequestOptionsBuilder;
import com.volcengine.tos.internal.ServerExceptionJson;
import com.volcengine.tos.internal.TosBucketRequestHandler;
import com.volcengine.tos.internal.TosFileRequestHandler;
import com.volcengine.tos.internal.TosObjectRequestHandler;
import com.volcengine.tos.internal.TosPreSignedRequestHandler;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosRequestFactory;
import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.internal.util.DateConverter;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.internal.util.TypeConverter;
import com.volcengine.tos.model.acl.GetObjectAclOutput;
import com.volcengine.tos.model.acl.Grant;
import com.volcengine.tos.model.acl.GrantV2;
import com.volcengine.tos.model.acl.Grantee;
import com.volcengine.tos.model.acl.GranteeV2;
import com.volcengine.tos.model.acl.Owner;
import com.volcengine.tos.model.acl.PutObjectAclInput;
import com.volcengine.tos.model.acl.PutObjectAclOutput;
import com.volcengine.tos.model.bucket.CreateBucketInput;
import com.volcengine.tos.model.bucket.CreateBucketOutput;
import com.volcengine.tos.model.bucket.CreateBucketV2Input;
import com.volcengine.tos.model.bucket.CreateBucketV2Output;
import com.volcengine.tos.model.bucket.HeadBucketOutput;
import com.volcengine.tos.model.bucket.HeadBucketV2Input;
import com.volcengine.tos.model.bucket.HeadBucketV2Output;
import com.volcengine.tos.model.bucket.ListBucketsInput;
import com.volcengine.tos.model.bucket.ListBucketsOutput;
import com.volcengine.tos.model.bucket.ListBucketsV2Input;
import com.volcengine.tos.model.bucket.ListBucketsV2Output;
import com.volcengine.tos.model.bucket.ListedBucket;
import com.volcengine.tos.model.bucket.ListedOwner;
import com.volcengine.tos.model.object.AbortMultipartUploadInput;
import com.volcengine.tos.model.object.AbortMultipartUploadOutput;
import com.volcengine.tos.model.object.AppendObjectOutput;
import com.volcengine.tos.model.object.CompleteMultipartUploadInput;
import com.volcengine.tos.model.object.CompleteMultipartUploadOutput;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Input;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Output;
import com.volcengine.tos.model.object.CopyObjectOutput;
import com.volcengine.tos.model.object.CopyObjectV2Input;
import com.volcengine.tos.model.object.CopyObjectV2Output;
import com.volcengine.tos.model.object.CreateMultipartUploadInput;
import com.volcengine.tos.model.object.CreateMultipartUploadOutput;
import com.volcengine.tos.model.object.DeleteError;
import com.volcengine.tos.model.object.DeleteMultiObjectsInput;
import com.volcengine.tos.model.object.DeleteMultiObjectsOutput;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Input;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Output;
import com.volcengine.tos.model.object.DeleteObjectInput;
import com.volcengine.tos.model.object.DeleteObjectOutput;
import com.volcengine.tos.model.object.Deleted;
import com.volcengine.tos.model.object.GetObjectACLV2Input;
import com.volcengine.tos.model.object.GetObjectACLV2Output;
import com.volcengine.tos.model.object.GetObjectOutput;
import com.volcengine.tos.model.object.GetObjectV2Input;
import com.volcengine.tos.model.object.GetObjectV2Output;
import com.volcengine.tos.model.object.HeadObjectOutput;
import com.volcengine.tos.model.object.HeadObjectV2Input;
import com.volcengine.tos.model.object.HeadObjectV2Output;
import com.volcengine.tos.model.object.InnerUploadedPart;
import com.volcengine.tos.model.object.ListMultipartUploadsInput;
import com.volcengine.tos.model.object.ListMultipartUploadsOutput;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Input;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Output;
import com.volcengine.tos.model.object.ListObjectVersionsInput;
import com.volcengine.tos.model.object.ListObjectVersionsOutput;
import com.volcengine.tos.model.object.ListObjectVersionsV2Input;
import com.volcengine.tos.model.object.ListObjectVersionsV2Output;
import com.volcengine.tos.model.object.ListObjectsInput;
import com.volcengine.tos.model.object.ListObjectsOutput;
import com.volcengine.tos.model.object.ListObjectsV2Input;
import com.volcengine.tos.model.object.ListObjectsV2Output;
import com.volcengine.tos.model.object.ListPartsInput;
import com.volcengine.tos.model.object.ListPartsOutput;
import com.volcengine.tos.model.object.ListUploadedPartsInput;
import com.volcengine.tos.model.object.ListUploadedPartsOutput;
import com.volcengine.tos.model.object.ListedCommonPrefix;
import com.volcengine.tos.model.object.ListedDeleteMarkerEntry;
import com.volcengine.tos.model.object.ListedObject;
import com.volcengine.tos.model.object.ListedObjectV2;
import com.volcengine.tos.model.object.ListedObjectVersion;
import com.volcengine.tos.model.object.ListedUpload;
import com.volcengine.tos.model.object.MultipartUploadedPart;
import com.volcengine.tos.model.object.ObjectAclRulesV2;
import com.volcengine.tos.model.object.ObjectMeta;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import com.volcengine.tos.model.object.ObjectTobeDeleted;
import com.volcengine.tos.model.object.PreSignedURLInput;
import com.volcengine.tos.model.object.PreSignedURLOutput;
import com.volcengine.tos.model.object.PutObjectACLInput;
import com.volcengine.tos.model.object.PutObjectACLOutput;
import com.volcengine.tos.model.object.PutObjectInput;
import com.volcengine.tos.model.object.PutObjectOutput;
import com.volcengine.tos.model.object.SetObjectMetaInput;
import com.volcengine.tos.model.object.SetObjectMetaOutput;
import com.volcengine.tos.model.object.UploadCommonPrefix;
import com.volcengine.tos.model.object.UploadFileInput;
import com.volcengine.tos.model.object.UploadFileOutput;
import com.volcengine.tos.model.object.UploadFileV2Input;
import com.volcengine.tos.model.object.UploadFileV2Output;
import com.volcengine.tos.model.object.UploadInfo;
import com.volcengine.tos.model.object.UploadPartCopyInput;
import com.volcengine.tos.model.object.UploadPartCopyOutput;
import com.volcengine.tos.model.object.UploadPartCopyV2Input;
import com.volcengine.tos.model.object.UploadPartCopyV2Output;
import com.volcengine.tos.model.object.UploadPartInput;
import com.volcengine.tos.model.object.UploadPartOutput;
import com.volcengine.tos.model.object.UploadPartV2Input;
import com.volcengine.tos.model.object.UploadPartV2Output;
import com.volcengine.tos.model.object.UploadedPart;
import com.volcengine.tos.model.object.UploadedPartV2;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TosClientV1Adapter {
    private final TosBucketRequestHandler bucketRequestHandler;
    private final TosObjectRequestHandler objectRequestHandler;
    private final TosFileRequestHandler fileRequestHandler;
    private final TosPreSignedRequestHandler preSignedRequestHandler;

    public TosClientV1Adapter(TosBucketRequestHandler bucketRequestHandler, TosObjectRequestHandler objectRequestHandler, TosFileRequestHandler fileRequestHandler, TosPreSignedRequestHandler preSignedRequestHandler) {
        ParamsChecker.ensureNotNull(bucketRequestHandler, "TosBucketRequestHandler");
        ParamsChecker.ensureNotNull(objectRequestHandler, "TosObjectRequestHandler");
        ParamsChecker.ensureNotNull(fileRequestHandler, "TosFileRequestHandler");
        ParamsChecker.ensureNotNull(preSignedRequestHandler, "TosPreSignedRequestHandler");
        ParamsChecker.ensureNotNull(objectRequestHandler.getTransport(), "Transport");
        ParamsChecker.ensureNotNull(objectRequestHandler.getFactory(), "TosFactory");
        this.bucketRequestHandler = bucketRequestHandler;
        this.objectRequestHandler = objectRequestHandler;
        this.fileRequestHandler = fileRequestHandler;
        this.preSignedRequestHandler = preSignedRequestHandler;
    }

    public CreateBucketOutput createBucket(CreateBucketInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "CreateBucketInput");
        CreateBucketV2Input v2Input = CreateBucketV2Input.builder().bucket(input.getBucket()).acl(TypeConverter.convertACLType(input.getAcl())).storageClass(TypeConverter.convertStorageClassType(input.getStorageClass())).grantFullControl(input.getGrantFullControl()).grantRead(input.getGrantRead()).grantReadAcp(input.getGrantReadAcp()).grantWrite(input.getGrantWrite()).grantWriteAcp(input.getGrantWriteAcp()).build();
        CreateBucketV2Output v2Output = this.bucketRequestHandler.createBucket(v2Input);
        return new CreateBucketOutput(v2Output.getRequestInfo(), v2Output.getLocation());
    }

    public HeadBucketOutput headBucket(String bucket) throws TosException {
        HeadBucketV2Input v2Input = HeadBucketV2Input.builder().bucket(bucket).build();
        HeadBucketV2Output v2Output = this.bucketRequestHandler.headBucket(v2Input);
        String storageClass = v2Output.getStorageClass() == null ? null : v2Output.getStorageClass().toString();
        return new HeadBucketOutput(v2Output.getRequestInfo(), v2Output.getRegion(), storageClass);
    }

    public ListBucketsOutput listBuckets(ListBucketsInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListBucketsInput");
        ListBucketsV2Output v2Output = this.bucketRequestHandler.listBuckets(new ListBucketsV2Input());
        ListBucketsOutput output = new ListBucketsOutput().setRequestInfo(v2Output.getRequestInfo());
        if (v2Output.getBuckets() != null) {
            ListedBucket[] buckets = new ListedBucket[v2Output.getBuckets().size()];
            for (int i = 0; i < v2Output.getBuckets().size(); ++i) {
                buckets[i] = v2Output.getBuckets().get(i);
            }
            output.setBuckets(buckets);
        }
        if (v2Output.getOwner() != null) {
            Owner owner = v2Output.getOwner();
            output.setOwner(new ListedOwner().setId(owner.getId()).setDisplayName(owner.getDisplayName()));
        }
        return output;
    }

    public GetObjectOutput getObject(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        GetObjectV2Input v2Input = new GetObjectV2Input().setBucket(bucket).setKey(objectKey);
        if (builders != null && builders.length > 0) {
            RequestBuilder builder = new RequestBuilder();
            for (RequestOptionsBuilder b : builders) {
                b.withOption(builder);
            }
            if (builder.getQuery() != null && builder.getQuery().containsKey("versionId")) {
                v2Input.setVersionID(builder.getQuery().get("versionId"));
            }
            if (builder.getHeaders() != null && builder.getHeaders().size() > 0) {
                v2Input.setOptions(new ObjectMetaRequestOptions().setHeaders(builder.getHeaders()));
            }
        }
        GetObjectV2Output v2Output = this.objectRequestHandler.getObject(v2Input);
        GetObjectOutput output = new GetObjectOutput().setContent(v2Output.getContent());
        if (v2Output.getGetObjectBasicOutput() != null) {
            output.setRequestInfo(v2Output.getGetObjectBasicOutput().getRequestInfo()).setObjectMeta(new ObjectMeta().fromGetObjectV2Output(v2Output.getGetObjectBasicOutput())).setContentRange(v2Output.getGetObjectBasicOutput().getContentRange());
        }
        return output;
    }

    public HeadObjectOutput headObject(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        HeadObjectV2Input v2Input = new HeadObjectV2Input().setBucket(bucket).setKey(objectKey);
        if (builders != null && builders.length > 0) {
            RequestBuilder builder = new RequestBuilder();
            for (RequestOptionsBuilder b : builders) {
                b.withOption(builder);
            }
            if (builder.getQuery() != null && builder.getQuery().containsKey("versionId")) {
                v2Input.setVersionID(builder.getQuery().get("versionId"));
            }
            if (builder.getHeaders() != null && builder.getHeaders().size() > 0) {
                v2Input.setOptions(new ObjectMetaRequestOptions().setHeaders(builder.getHeaders()));
            }
        }
        HeadObjectV2Output v2Output = this.objectRequestHandler.headObject(v2Input);
        return new HeadObjectOutput().setRequestInfo(v2Output.getRequestInfo()).setContentRange(v2Output.getContentRange()).setObjectMeta(new ObjectMeta().fromGetObjectV2Output(v2Output.getHeadObjectBasicOutput()));
    }

    public DeleteObjectOutput deleteObject(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        DeleteObjectInput v2Input = new DeleteObjectInput().setBucket(bucket).setKey(objectKey);
        if (builders != null && builders.length > 0) {
            RequestBuilder builder = new RequestBuilder();
            for (RequestOptionsBuilder b : builders) {
                b.withOption(builder);
            }
            if (builder.getQuery() != null && builder.getQuery().containsKey("versionId")) {
                v2Input.setVersionID(builder.getQuery().get("versionId"));
            }
        }
        return this.objectRequestHandler.deleteObject(v2Input);
    }

    public DeleteMultiObjectsOutput deleteMultiObjects(String bucket, DeleteMultiObjectsInput input, RequestOptionsBuilder ... builders) throws TosException {
        int i;
        ParamsChecker.ensureNotNull(input, "DeleteMultiObjectsInput");
        DeleteMultiObjectsV2Input v2Input = new DeleteMultiObjectsV2Input().setBucket(bucket).setQuiet(input.isQuiet());
        if (input.getObjectTobeDeleteds() != null) {
            v2Input.setObjects(new ArrayList<ObjectTobeDeleted>(Arrays.asList(input.getObjectTobeDeleteds())));
        }
        DeleteMultiObjectsV2Output v2Output = this.objectRequestHandler.deleteMultiObjects(v2Input);
        DeleteMultiObjectsOutput output = new DeleteMultiObjectsOutput().setRequestInfo(v2Output.getRequestInfo());
        if (v2Output.getDeleteds() != null) {
            Deleted[] deleteds = new Deleted[v2Output.getDeleteds().size()];
            for (i = 0; i < v2Output.getDeleteds().size(); ++i) {
                deleteds[i] = v2Output.getDeleteds().get(i);
            }
            output.setDeleteds(deleteds);
        }
        if (v2Output.getErrors() != null) {
            DeleteError[] errors = new DeleteError[v2Output.getDeleteds().size()];
            for (i = 0; i < v2Output.getDeleteds().size(); ++i) {
                errors[i] = v2Output.getErrors().get(i);
            }
            output.setErrors(errors);
        }
        return output;
    }

    public PutObjectOutput putObject(String bucket, String objectKey, InputStream inputStream, RequestOptionsBuilder ... builders) throws TosException {
        PutObjectInput input = new PutObjectInput().setContent(inputStream).setBucket(bucket).setKey(objectKey);
        if (builders != null && builders.length > 0) {
            RequestBuilder builder = new RequestBuilder();
            for (RequestOptionsBuilder b : builders) {
                b.withOption(builder);
            }
            if (builder.getHeaders() != null && builder.getHeaders().size() > 0) {
                input.setOptions(new ObjectMetaRequestOptions().setHeaders(builder.getHeaders()));
            }
        }
        return this.objectRequestHandler.putObject(input);
    }

    public UploadFileOutput uploadFile(String bucket, UploadFileInput input, RequestOptionsBuilder ... builders) throws TosException {
        ParamsChecker.ensureNotNull(input, "UploadFileInput");
        UploadFileV2Input v2Input = new UploadFileV2Input().setBucket(bucket).setKey(input.getObjectKey()).setCheckpointFile(input.getCheckpointFile()).setFilePath(input.getUploadFilePath()).setPartSize(input.getPartSize()).setTaskNum(input.getTaskNum()).setEnableCheckpoint(input.isEnableCheckpoint());
        if (builders != null && builders.length > 0) {
            RequestBuilder builder = new RequestBuilder();
            for (RequestOptionsBuilder b : builders) {
                b.withOption(builder);
            }
            if (builder.getHeaders() != null && builder.getHeaders().size() > 0) {
                v2Input.setOptions(new ObjectMetaRequestOptions().setHeaders(builder.getHeaders()));
            }
        }
        UploadFileV2Output v2Output = this.fileRequestHandler.uploadFile(v2Input);
        CompleteMultipartUploadOutput completeMultipartUploadOutput = new CompleteMultipartUploadOutput().setRequestInfo(v2Output.getRequestInfo()).setVersionID(v2Output.getVersionID()).setCrc64(v2Output.getHashCrc64ecma());
        return new UploadFileOutput().setCompleteMultipartUploadOutput(completeMultipartUploadOutput).setUploadID(v2Output.getUploadID()).setBucket(v2Output.getBucket()).setObjectKey(v2Output.getKey());
    }

    public AppendObjectOutput appendObject(String bucket, String objectKey, InputStream content, long offset, RequestOptionsBuilder ... builders) throws TosException {
        ParamsChecker.isValidBucketNameAndKey(bucket, objectKey);
        TosRequestFactory factory = this.objectRequestHandler.getFactory();
        RequestBuilder rb = factory.init(bucket, objectKey, null);
        for (RequestOptionsBuilder builder : builders) {
            builder.withOption(rb);
        }
        rb.withQuery("append", "").withQuery("offset", String.valueOf(offset));
        String contentType = rb.getHeaders().get("Content-Type");
        if (StringUtils.isEmpty(contentType) && rb.isAutoRecognizeContentType()) {
            contentType = MimeType.getInstance().getMimetype(objectKey);
            rb.getHeaders().put("Content-Type", contentType);
        }
        TosRequest req = factory.build(rb, "POST", content).setEnableCrcCheck(false).setRetryableOnServerException(false).setRetryableOnClientException(false);
        AppendObjectOutput output = null;
        try (TosResponse res = this.roundTrip(req, 200);){
            long appendOffset;
            String nextOffset = res.getHeaderWithKeyIgnoreCase("X-Tos-Next-Append-Offset");
            try {
                appendOffset = Long.parseLong(nextOffset);
            }
            catch (NumberFormatException nfe) {
                throw new TosClientException("server return unexpected Next-Append-Offset header: " + nextOffset, nfe);
            }
            output = new AppendObjectOutput().setRequestInfo(res.RequestInfo()).setNextAppendOffset(appendOffset).setEtag(res.getHeaderWithKeyIgnoreCase("ETag")).setCrc64(res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma")).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id"));
        }
        catch (IOException e) {
            TosUtils.getLogger().debug("tos: close response body failed, {}", (Object)e.toString());
        }
        return output;
    }

    public SetObjectMetaOutput setObjectMeta(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        SetObjectMetaInput input = new SetObjectMetaInput().setBucket(bucket).setKey(objectKey);
        if (builders != null && builders.length > 0) {
            RequestBuilder builder = new RequestBuilder();
            for (RequestOptionsBuilder b : builders) {
                b.withOption(builder);
            }
            if (builder.getQuery() != null && builder.getQuery().containsKey("versionId")) {
                input.setVersionID(builder.getQuery().get("versionId"));
            }
            if (builder.getHeaders() != null && builder.getHeaders().size() > 0) {
                input.setOptions(new ObjectMetaRequestOptions().setHeaders(builder.getHeaders()));
            }
        }
        return this.objectRequestHandler.setObjectMeta(input);
    }

    public ListObjectsOutput listObjects(String bucket, ListObjectsInput input) throws TosException {
        int i;
        ParamsChecker.ensureNotNull(input, "ListObjectsInput");
        ListObjectsV2Input v2Input = new ListObjectsV2Input().setBucket(bucket).setPrefix(input.getPrefix()).setDelimiter(input.getDelimiter()).setEncodingType(input.getEncodingType()).setMarker(input.getMarker()).setMaxKeys(input.getMaxKeys()).setReverse(input.isReverse());
        ListObjectsV2Output v2Output = this.objectRequestHandler.listObjects(v2Input);
        ListObjectsOutput output = new ListObjectsOutput().setRequestInfo(v2Output.getRequestInfo()).setPrefix(v2Output.getPrefix()).setDelimiter(v2Output.getDelimiter()).setMarker(v2Output.getMarker()).setMaxKeys(v2Output.getMaxKeys()).setEncodingType(v2Output.getEncodingType()).setName(v2Output.getName()).setNextMarker(v2Output.getNextMarker()).setTruncated(v2Output.isTruncated());
        if (v2Output.getContents() != null) {
            ListedObject[] objects = new ListedObject[v2Output.getContents().size()];
            for (i = 0; i < v2Output.getContents().size(); ++i) {
                ListedObjectV2 objectV2 = v2Output.getContents().get(i);
                objects[i] = new ListedObject().setEtag(objectV2.getEtag()).setKey(objectV2.getKey()).setOwner(objectV2.getOwner()).setSize(objectV2.getSize()).setType(objectV2.getType()).setLastModified(DateConverter.dateToRFC1123String(objectV2.getLastModified())).setStorageClass(objectV2.getStorageClass());
            }
            output.setContents(objects);
        }
        if (v2Output.getCommonPrefixes() != null) {
            ListedCommonPrefix[] commonPrefixes = new ListedCommonPrefix[v2Output.getCommonPrefixes().size()];
            for (i = 0; i < v2Output.getCommonPrefixes().size(); ++i) {
                commonPrefixes[i] = v2Output.getCommonPrefixes().get(i);
            }
            output.setCommonPrefixes(commonPrefixes);
        }
        return output;
    }

    public ListObjectVersionsOutput listObjectVersions(String bucket, ListObjectVersionsInput input) throws TosException {
        int i;
        ParamsChecker.ensureNotNull(input, "ListObjectVersionsInput");
        ListObjectVersionsV2Input v2Input = new ListObjectVersionsV2Input().setBucket(bucket).setPrefix(input.getPrefix()).setDelimiter(input.getDelimiter()).setEncodingType(input.getEncodingType()).setMaxKeys(input.getMaxKeys()).setKeyMarker(input.getKeyMarker()).setVersionIDMarker(input.getVersionIDMarker());
        ListObjectVersionsV2Output v2Output = this.objectRequestHandler.listObjectVersions(v2Input);
        ListObjectVersionsOutput output = new ListObjectVersionsOutput().setRequestInfo(v2Output.getRequestInfo()).setPrefix(v2Output.getPrefix()).setDelimiter(v2Output.getDelimiter()).setMaxKeys(v2Output.getMaxKeys()).setKeyMarker(v2Output.getKeyMarker()).setNextKeyMarker(v2Output.getNextKeyMarker()).setEncodingType(v2Output.getEncodingType()).setName(v2Output.getName()).setTruncated(v2Output.isTruncated()).setVersionIDMarker(v2Output.getVersionIDMarker()).setNextVersionIDMarker(v2Output.getNextVersionIDMarker());
        if (v2Output.getDeleteMarkers() != null) {
            ListedDeleteMarkerEntry[] deleteMarkerEntries = new ListedDeleteMarkerEntry[v2Output.getDeleteMarkers().size()];
            for (i = 0; i < v2Output.getDeleteMarkers().size(); ++i) {
                deleteMarkerEntries[i] = v2Output.getDeleteMarkers().get(i);
            }
            output.setDeleteMarkers(deleteMarkerEntries);
        }
        if (v2Output.getCommonPrefixes() != null) {
            ListedCommonPrefix[] commonPrefixes = new ListedCommonPrefix[v2Output.getCommonPrefixes().size()];
            for (i = 0; i < v2Output.getCommonPrefixes().size(); ++i) {
                commonPrefixes[i] = v2Output.getCommonPrefixes().get(i);
            }
            output.setCommonPrefixes(commonPrefixes);
        }
        if (v2Output.getVersions() != null) {
            ListedObjectVersion[] versions = new ListedObjectVersion[v2Output.getVersions().size()];
            for (i = 0; i < v2Output.getVersions().size(); ++i) {
                versions[i] = v2Output.getVersions().get(i);
            }
            output.setVersions(versions);
        }
        return output;
    }

    private CopyObjectOutput copyObject(CopyObjectV2Input v2Input, RequestOptionsBuilder ... builders) {
        ParamsChecker.ensureNotNull(v2Input, "CopyObjectV2Input");
        if (builders != null && builders.length > 0) {
            RequestBuilder builder = new RequestBuilder();
            for (RequestOptionsBuilder b : builders) {
                b.withOption(builder);
            }
            if (builder.getHeaders() != null && builder.getHeaders().size() > 0) {
                v2Input.setOptions(new ObjectMetaRequestOptions().setHeaders(builder.getHeaders()));
            }
        }
        CopyObjectV2Output v2Output = this.objectRequestHandler.copyObject(v2Input);
        return new CopyObjectOutput().setRequestInfo(v2Output.getRequestInfo()).setEtag(v2Output.getEtag()).setCrc64(v2Output.getHashCrc64ecma()).setVersionID(v2Output.getVersionID()).setLastModified(v2Output.getLastModified()).setSourceVersionID(v2Output.getSourceVersionID());
    }

    public CopyObjectOutput copyObject(String bucket, String srcObjectKey, String dstObjectKey, RequestOptionsBuilder ... builders) throws TosException {
        CopyObjectV2Input v2Input = new CopyObjectV2Input().setBucket(bucket).setKey(dstObjectKey).setSrcKey(srcObjectKey).setSrcBucket(bucket);
        return this.copyObject(v2Input, builders);
    }

    public CopyObjectOutput copyObjectTo(String bucket, String dstBucket, String dstObjectKey, String srcObjectKey, RequestOptionsBuilder ... builders) throws TosException {
        CopyObjectV2Input v2Input = new CopyObjectV2Input().setBucket(dstBucket).setKey(dstObjectKey).setSrcKey(srcObjectKey).setSrcBucket(bucket);
        return this.copyObject(v2Input, builders);
    }

    public CopyObjectOutput copyObjectFrom(String bucket, String srcBucket, String srcObjectKey, String dstObjectKey, RequestOptionsBuilder ... builders) throws TosException {
        CopyObjectV2Input v2Input = new CopyObjectV2Input().setBucket(bucket).setKey(dstObjectKey).setSrcKey(srcObjectKey).setSrcBucket(srcBucket);
        return this.copyObject(v2Input, builders);
    }

    public UploadPartCopyOutput uploadPartCopy(String bucket, UploadPartCopyInput input, RequestOptionsBuilder ... builders) throws TosException {
        ParamsChecker.ensureNotNull(input, "UploadPartCopyInput");
        UploadPartCopyV2Input v2Input = new UploadPartCopyV2Input().setBucket(bucket).setKey(input.getDestinationKey()).setSourceBucket(input.getSourceBucket()).setSourceKey(input.getSourceKey()).setSourceVersionID(input.getSourceVersionID()).setPartNumber(input.getPartNumber()).setUploadID(input.getUploadID()).setCopySourceRange(input.getStartOffset(), input.getStartOffset() + input.getPartSize() - 1L);
        if (builders != null && builders.length > 0) {
            RequestBuilder builder = new RequestBuilder();
            for (RequestOptionsBuilder b : builders) {
                b.withOption(builder);
            }
            if (builder.getHeaders() != null && builder.getHeaders().size() > 0) {
                v2Input.setOptions(new ObjectMetaRequestOptions().setHeaders(builder.getHeaders()));
            }
        }
        UploadPartCopyV2Output v2Output = this.objectRequestHandler.uploadPartCopy(v2Input);
        return new UploadPartCopyOutput().setPartNumber(v2Output.getPartNumber()).setEtag(v2Output.getEtag()).setSourceVersionID(v2Output.getCopySourceVersionID()).setRequestInfo(v2Output.getRequestInfo()).setLastModified(DateConverter.dateToRFC1123String(v2Output.getLastModified()));
    }

    public PutObjectAclOutput putObjectAcl(String bucket, PutObjectAclInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutObjectAclInput");
        PutObjectACLInput aclInput = new PutObjectACLInput().setBucket(bucket).setKey(input.getKey()).setVersionID(input.getVersionId());
        if (input.getAclGrant() != null) {
            aclInput.setAcl(TypeConverter.convertACLType(input.getAclGrant().getAcl()));
            aclInput.setGrantFullControl(input.getAclGrant().getGrantFullControl());
            aclInput.setGrantRead(input.getAclGrant().getGrantRead());
            aclInput.setGrantReadAcp(input.getAclGrant().getGrantReadAcp());
            aclInput.setGrantWriteAcp(input.getAclGrant().getGrantWriteAcp());
        }
        if (input.getAclRules() != null) {
            ObjectAclRulesV2 aclRulesV2 = new ObjectAclRulesV2().setOwner(input.getAclRules().getOwner());
            if (input.getAclRules().getGrants() != null) {
                aclRulesV2.setGrants(this.getGrantV2List(input.getAclRules().getGrants()));
            }
            aclInput.setObjectAclRules(aclRulesV2);
        }
        PutObjectACLOutput aclOutput = this.objectRequestHandler.putObjectAcl(aclInput);
        return new PutObjectAclOutput().setRequestInfo(aclOutput.getRequestInfo());
    }

    private List<GrantV2> getGrantV2List(Grant[] input) {
        if (input == null) {
            return null;
        }
        ArrayList<GrantV2> grantV2s = new ArrayList<GrantV2>(input.length);
        for (Grant grant : input) {
            GrantV2 grantV2 = new GrantV2().setPermission(TypeConverter.convertPermissionType(grant.getPermission()));
            if (grant.getGrantee() != null) {
                Grantee grantee = grant.getGrantee();
                grantV2.setGrantee(new GranteeV2().setCanned(TypeConverter.convertCannedType(grantee.getUri())).setId(grantee.getId()).setDisplayName(grantee.getDisplayName()).setType(TypeConverter.convertGranteeType(grantee.getType())));
            }
            grantV2s.add(grantV2);
        }
        return grantV2s;
    }

    public GetObjectAclOutput getObjectAcl(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        GetObjectACLV2Input aclv2Input = new GetObjectACLV2Input().setBucket(bucket).setKey(objectKey);
        if (builders != null && builders.length > 0) {
            RequestBuilder builder = new RequestBuilder();
            for (RequestOptionsBuilder b : builders) {
                b.withOption(builder);
            }
            if (builder.getQuery() != null && builder.getQuery().containsKey("versionId")) {
                aclv2Input.setVersionID(builder.getQuery().get("versionId"));
            }
        }
        GetObjectACLV2Output aclv2Output = this.objectRequestHandler.getObjectAcl(aclv2Input);
        GetObjectAclOutput output = new GetObjectAclOutput().setRequestInfo(aclv2Output.getRequestInfo()).setVersionId(aclv2Output.getVersionID()).setOwner(aclv2Output.getOwner());
        if (aclv2Output.getGrants() != null) {
            output.setGrants(this.getGrants(aclv2Output.getGrants()));
        }
        return output;
    }

    private Grant[] getGrants(List<GrantV2> grantV2s) {
        if (grantV2s == null) {
            return null;
        }
        Grant[] grants = new Grant[grantV2s.size()];
        for (int i = 0; i < grantV2s.size(); ++i) {
            GrantV2 grantV2 = grantV2s.get(i);
            String permission = grantV2.getPermission() == null ? null : grantV2.getPermission().toString();
            Grant grant = new Grant().setPermission(permission);
            if (grantV2.getGrantee() != null) {
                GranteeV2 grantee = grantV2.getGrantee();
                String uri = grantee.getCanned() == null ? null : grantee.getCanned().toString();
                String type = grantee.getType() == null ? null : grantee.getType().toString();
                grant.setGrantee(new Grantee().setUri(uri).setType(type).setId(grantee.getId()).setDisplayName(grantee.getDisplayName()));
            }
            grants[i] = grant;
        }
        return grants;
    }

    public CreateMultipartUploadOutput createMultipartUpload(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        CreateMultipartUploadInput createMultipartUploadInput = new CreateMultipartUploadInput().setBucket(bucket).setKey(objectKey);
        if (builders != null && builders.length > 0) {
            RequestBuilder builder = new RequestBuilder();
            for (RequestOptionsBuilder b : builders) {
                b.withOption(builder);
            }
            if (builder.getHeaders() != null && builder.getHeaders().size() > 0) {
                createMultipartUploadInput.setOptions(new ObjectMetaRequestOptions().setHeaders(builder.getHeaders()));
            }
        }
        return this.objectRequestHandler.createMultipartUpload(createMultipartUploadInput);
    }

    public UploadPartOutput uploadPart(String bucket, UploadPartInput input, RequestOptionsBuilder ... builders) throws TosException {
        ParamsChecker.ensureNotNull(input, "UploadPartInput");
        UploadPartV2Input v2Input = new UploadPartV2Input().setBucket(bucket).setKey(input.getKey()).setPartNumber(input.getPartNumber()).setUploadID(input.getUploadID()).setContent(input.getContent()).setContentLength(input.getPartSize());
        if (builders != null && builders.length > 0) {
            RequestBuilder builder = new RequestBuilder();
            for (RequestOptionsBuilder b : builders) {
                b.withOption(builder);
            }
            if (builder.getHeaders() != null && builder.getHeaders().size() > 0) {
                v2Input.setOptions(new ObjectMetaRequestOptions().setHeaders(builder.getHeaders()));
            }
        }
        UploadPartV2Output v2Output = this.objectRequestHandler.uploadPart(v2Input);
        return new UploadPartOutput().setRequestInfo(v2Output.getRequestInfo()).setEtag(v2Output.getEtag()).setPartNumber(v2Output.getPartNumber()).setSseCustomerAlgorithm(v2Output.getSsecAlgorithm()).setSseCustomerMD5(v2Output.getSsecKeyMD5());
    }

    public CompleteMultipartUploadOutput completeMultipartUpload(String bucket, CompleteMultipartUploadInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "CompleteMultipartUploadInput");
        CompleteMultipartUploadV2Input v2Input = new CompleteMultipartUploadV2Input().setBucket(bucket).setUploadID(input.getUploadID()).setKey(input.getKey()).setUploadedParts(this.getUploadedParts(input));
        CompleteMultipartUploadV2Output v2Output = this.objectRequestHandler.completeMultipartUpload(v2Input);
        return new CompleteMultipartUploadOutput().setRequestInfo(v2Output.getRequestInfo()).setVersionID(v2Output.getVersionID()).setCrc64(v2Output.getHashCrc64ecma());
    }

    private List<UploadedPartV2> getUploadedParts(CompleteMultipartUploadInput input) {
        if (input == null) {
            return null;
        }
        if (input.getMultiUploadedParts() != null) {
            ArrayList<UploadedPartV2> uploadedPartV2s = new ArrayList<UploadedPartV2>(input.getMultiUploadedParts().size());
            for (MultipartUploadedPart part : input.getUploadedParts()) {
                uploadedPartV2s.add(this.getUploadedPart(part));
            }
            return uploadedPartV2s;
        }
        if (input.getUploadedParts() != null) {
            ArrayList<UploadedPartV2> uploadedPartV2s = new ArrayList<UploadedPartV2>(input.getMultiUploadedParts().size());
            for (MultipartUploadedPart part : input.getUploadedParts()) {
                uploadedPartV2s.add(this.getUploadedPart(part));
            }
            return uploadedPartV2s;
        }
        return null;
    }

    private UploadedPartV2 getUploadedPart(MultipartUploadedPart part) {
        if (part == null) {
            return null;
        }
        InnerUploadedPart innerUploadedPart = part.uploadedPart();
        if (innerUploadedPart != null) {
            return new UploadedPartV2().setEtag(innerUploadedPart.getEtag()).setPartNumber(innerUploadedPart.getPartNumber());
        }
        return null;
    }

    public AbortMultipartUploadOutput abortMultipartUpload(String bucket, AbortMultipartUploadInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "AbortMultipartUploadInput");
        return this.objectRequestHandler.abortMultipartUpload(input.setBucket(bucket).setKey(input.getKey()).setUploadID(input.getUploadID()));
    }

    public ListUploadedPartsOutput listUploadedParts(String bucket, ListUploadedPartsInput input, RequestOptionsBuilder ... builders) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListUploadedPartsInput");
        ListPartsInput listPartsInput = new ListPartsInput().setBucket(bucket).setKey(input.getKey()).setMaxParts(input.getMaxParts()).setUploadID(input.getUploadID()).setPartNumberMarker(input.getPartNumberMarker());
        ListPartsOutput listPartsOutput = this.objectRequestHandler.listParts(listPartsInput);
        String storageClass = listPartsOutput.getStorageClass() == null ? null : listPartsOutput.getStorageClass().toString();
        ListUploadedPartsOutput output = new ListUploadedPartsOutput().setRequestInfo(listPartsOutput.getRequestInfo()).setBucket(listPartsOutput.getBucket()).setKey(listPartsOutput.getKey()).setMaxParts(listPartsOutput.getMaxParts()).setPartNumberMarker(listPartsOutput.getPartNumberMarker()).setOwner(listPartsOutput.getOwner()).setNextPartNumberMarker(listPartsOutput.getNextPartNumberMarker()).setStorageClass(storageClass).setTruncated(listPartsOutput.isTruncated()).setUploadID(listPartsOutput.getUploadID());
        if (listPartsOutput.getUploadedParts() != null) {
            UploadedPart[] uploadedParts = new UploadedPart[listPartsOutput.getUploadedParts().size()];
            for (int i = 0; i < listPartsOutput.getUploadedParts().size(); ++i) {
                UploadedPart part;
                UploadedPartV2 partV2 = listPartsOutput.getUploadedParts().get(i);
                uploadedParts[i] = part = new UploadedPart().setPartNumber(partV2.getPartNumber()).setEtag(partV2.getEtag()).setSize(partV2.getSize()).setLastModified(DateConverter.dateToRFC1123String(partV2.getLastModified()));
            }
            output.setUploadedParts(uploadedParts);
        }
        return output;
    }

    public ListMultipartUploadsOutput listMultipartUploads(String bucket, ListMultipartUploadsInput input) throws TosException {
        int i;
        ParamsChecker.ensureNotNull(input, "ListMultipartUploadsInput");
        ListMultipartUploadsV2Input v2Input = new ListMultipartUploadsV2Input().setBucket(bucket).setMaxUploads(input.getMaxUploads()).setDelimiter(input.getDelimiter()).setPrefix(input.getPrefix()).setKeyMarker(input.getKeyMarker()).setUploadIDMarker(input.getUploadIDMarker());
        ListMultipartUploadsV2Output v2Output = this.objectRequestHandler.listMultipartUploads(v2Input);
        ListMultipartUploadsOutput output = new ListMultipartUploadsOutput().setMaxUploads(v2Output.getMaxUploads()).setRequestInfo(v2Output.getRequestInfo()).setBucket(v2Output.getBucket()).setDelimiter(v2Output.getDelimiter()).setKeyMarker(v2Output.getKeyMarker()).setNextKeyMarker(v2Output.getNextKeyMarker()).setTruncated(v2Output.isTruncated()).setUploadIDMarker(v2Output.getUploadIDMarker()).setNextUploadIdMarker(v2Output.getNextUploadIdMarker());
        if (v2Output.getUploads() != null) {
            UploadInfo[] uploadInfos = new UploadInfo[v2Output.getUploads().size()];
            for (i = 0; i < v2Output.getUploads().size(); ++i) {
                UploadInfo uploadInfo;
                ListedUpload listedUpload = v2Output.getUploads().get(i);
                String storageClass = listedUpload.getStorageClass() == null ? null : listedUpload.getStorageClass().toString();
                uploadInfos[i] = uploadInfo = new UploadInfo().setUploadID(listedUpload.getUploadID()).setInitiated(DateConverter.dateToRFC1123String(listedUpload.getInitiated())).setKey(listedUpload.getKey()).setOwner(listedUpload.getOwner()).setStorageClass(storageClass);
            }
            output.setUpload(uploadInfos);
        }
        if (v2Output.getCommonPrefixes() != null) {
            UploadCommonPrefix[] commonPrefixes = new UploadCommonPrefix[v2Output.getCommonPrefixes().size()];
            for (i = 0; i < v2Output.getCommonPrefixes().size(); ++i) {
                commonPrefixes[i] = new UploadCommonPrefix().setPrefix(v2Output.getCommonPrefixes().get(i).getPrefix());
            }
            output.setCommonPrefixes(commonPrefixes);
        }
        return output;
    }

    public String preSignedURL(String httpMethod, String bucket, String objectKey, Duration ttl, RequestOptionsBuilder ... builders) throws TosException {
        PreSignedURLInput input = new PreSignedURLInput().setBucket(bucket).setKey(objectKey).setHttpMethod(httpMethod);
        if (ttl != null) {
            input.setExpires(ttl.getSeconds());
        }
        if (builders != null && builders.length > 0) {
            RequestBuilder builder = new RequestBuilder();
            for (RequestOptionsBuilder b : builders) {
                b.withOption(builder);
            }
            input.setQuery(builder.getQuery());
            input.setHeader(builder.getHeaders());
        }
        PreSignedURLOutput output = this.preSignedRequestHandler.preSignedURL(input);
        return output.getSignedUrl();
    }

    TosResponse roundTrip(TosRequest request, int expectedCode) throws TosException {
        TosResponse res;
        try {
            res = this.objectRequestHandler.getTransport().roundTrip(request);
        }
        catch (IOException e) {
            throw new TosClientException("request exception", e);
        }
        finally {
            if (request.getContent() != null) {
                try {
                    request.getContent().close();
                }
                catch (IOException e) {
                    TosUtils.getLogger().debug("tos: close request body failed, {}", (Object)e.toString());
                }
            }
        }
        if (res.getStatusCode() == expectedCode) {
            return res;
        }
        if (res.getStatusCode() >= 400) {
            String s = StringUtils.toString(res.getInputStream(), "response body");
            if (s.length() > 0) {
                try {
                    ServerExceptionJson se = (ServerExceptionJson)TosUtils.getJsonMapper().readValue(s, (TypeReference)new TypeReference<ServerExceptionJson>(){});
                    throw new TosServerException(res.getStatusCode(), se.getCode(), se.getMessage(), se.getRequestID(), se.getHostID()).setEc(se.getEc());
                }
                catch (JsonProcessingException e) {
                    if (res.getStatusCode() == 400) {
                        throw new TosClientException("bad request, " + s, null);
                    }
                    throw new TosClientException("parse server exception failed", (Exception)((Object)e));
                }
            }
            if (res.getStatusCode() == 404) {
                throw new TosServerException(res.getStatusCode(), "NotFound", "", res.getRequesID(), "");
            }
            if (res.getStatusCode() == 403) {
                throw new TosServerException(res.getStatusCode(), "Forbidden", "", res.getRequesID(), "");
            }
        }
        throw new UnexpectedStatusCodeException(res.getStatusCode(), expectedCode, res.getRequesID());
    }
}

