/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.auth.Signer;
import com.volcengine.tos.internal.RequestBuilder;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.TosUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class TosRequestFactory {
    private Signer signer;
    private String scheme;
    private String host;
    private int port;
    private int urlMode = 0;
    private boolean isCustomDomain;
    private boolean disableEncodingMeta;

    public TosRequestFactory(Signer signer, String endpoint) {
        this.signer = signer;
        this.parseEndpoint(endpoint);
    }

    private void parseEndpoint(String endpoint) {
        List<String> schemeAndHost = ParamsChecker.parseFromEndpoint(endpoint);
        this.scheme = schemeAndHost.get(0);
        this.host = schemeAndHost.get(1);
        if (ParamsChecker.isLocalhostOrIpAddress(this.host)) {
            this.urlMode = 1;
            this.port = ParamsChecker.parsePort(this.host);
            if (this.port != 0) {
                int lastIdx = this.host.length() - String.valueOf(this.port).length() - 1;
                this.host = this.host.substring(0, lastIdx);
            }
        }
    }

    public Signer getSigner() {
        return this.signer;
    }

    public TosRequestFactory setSigner(Signer signer) {
        this.signer = signer;
        return this;
    }

    public TosRequestFactory setEndpoint(String endpoint) {
        this.parseEndpoint(endpoint);
        return this;
    }

    public int getUrlMode() {
        return this.urlMode;
    }

    public TosRequestFactory setUrlMode(int urlMode) {
        this.urlMode = urlMode;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public TosRequestFactory setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public TosRequestFactory setHost(String host) {
        this.host = host;
        return this;
    }

    public boolean isCustomDomain() {
        return this.isCustomDomain;
    }

    public TosRequestFactory setIsCustomDomain(boolean isCustomDomain) {
        this.isCustomDomain = isCustomDomain;
        if (this.isCustomDomain) {
            this.urlMode = 2;
        }
        return this;
    }

    public TosRequestFactory setDisableEncodingMeta(boolean disableEncodingMeta) {
        this.disableEncodingMeta = disableEncodingMeta;
        return this;
    }

    public RequestBuilder init(String bucket, String object, Map<String, String> headers) {
        return this.newBuilder(bucket, object, headers).setUrlMode(this.urlMode).setPort(this.port);
    }

    public TosRequest build(RequestBuilder builder, String method, InputStream content) {
        return builder.buildRequest(method, content);
    }

    public TosRequest build(RequestBuilder builder, String method, long ttl) {
        return builder.buildPreSignedUrlRequest(method, ttl);
    }

    public TosRequest buildWithCopy(RequestBuilder builder, String method, String srcBucket, String srcObject) {
        return builder.buildRequestWithCopySource(method, srcBucket, srcObject);
    }

    private RequestBuilder newBuilder(String bucket, String object) {
        RequestBuilder rb = new RequestBuilder(bucket, object, this.scheme, this.host, this.signer).setDisableEncodingMeta(this.disableEncodingMeta);
        rb.withHeader("User-Agent", TosUtils.getUserAgent());
        return rb;
    }

    private RequestBuilder newBuilder(String bucket, String object, Map<String, String> headers) {
        RequestBuilder rb = this.newBuilder(bucket, object);
        if (headers != null) {
            headers.forEach(rb::withHeader);
        }
        return rb;
    }
}

