/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos;

import com.volcengine.tos.TOSClientConfiguration;
import com.volcengine.tos.TOSV2;
import com.volcengine.tos.TOSV2Builder;
import com.volcengine.tos.TOSV2Client;
import com.volcengine.tos.auth.Credentials;
import com.volcengine.tos.credential.CredentialsProvider;
import com.volcengine.tos.credential.StaticCredentialsProvider;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.transport.TransportConfig;

public class TOSV2ClientBuilder
implements TOSV2Builder {
    @Override
    public TOSV2 build(String region, String endpoint, String accessKey, String secretKey) {
        StaticCredentialsProvider cred = null;
        if (StringUtils.isNotEmpty(accessKey) && StringUtils.isNotEmpty(secretKey)) {
            cred = new StaticCredentialsProvider(accessKey, secretKey);
        }
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentialsProvider(cred).build();
        return this.build(clientConfiguration);
    }

    @Override
    public TOSV2 build(String region, String endpoint, String accessKey, String secretKey, String securityToken) {
        StaticCredentialsProvider cred = null;
        if (StringUtils.isNotEmpty(accessKey) && StringUtils.isNotEmpty(secretKey) && StringUtils.isNotEmpty(securityToken)) {
            cred = new StaticCredentialsProvider(accessKey, secretKey, securityToken);
        }
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentialsProvider(cred).build();
        return this.build(clientConfiguration);
    }

    @Override
    @Deprecated
    public TOSV2 build(String region, String endpoint, Credentials credentials) {
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentials(credentials).build();
        return this.build(clientConfiguration);
    }

    @Override
    public TOSV2 build(String region, String endpoint, CredentialsProvider credentialsProvider) {
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentialsProvider(credentialsProvider).build();
        return this.build(clientConfiguration);
    }

    @Override
    public TOSV2 build(String region, String endpoint, String accessKey, String secretKey, TransportConfig conf) {
        StaticCredentialsProvider cred = null;
        if (StringUtils.isNotEmpty(accessKey) && StringUtils.isNotEmpty(secretKey)) {
            cred = new StaticCredentialsProvider(accessKey, secretKey);
        }
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentialsProvider(cred).transportConfig(conf).build();
        return this.build(clientConfiguration);
    }

    @Override
    @Deprecated
    public TOSV2 build(String region, String endpoint, Credentials credentials, TransportConfig conf) {
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentials(credentials).transportConfig(conf).build();
        return this.build(clientConfiguration);
    }

    @Override
    public TOSV2 build(String region, String endpoint, CredentialsProvider credentialsProvider, TransportConfig conf) {
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentialsProvider(credentialsProvider).transportConfig(conf).build();
        return this.build(clientConfiguration);
    }

    @Override
    public TOSV2 build(String region, String endpoint, String accessKey, String secretKey, String securityToken, TransportConfig conf) {
        StaticCredentialsProvider cred = null;
        if (StringUtils.isNotEmpty(accessKey) && StringUtils.isNotEmpty(secretKey) && StringUtils.isNotEmpty(securityToken)) {
            cred = new StaticCredentialsProvider(accessKey, secretKey, securityToken);
        }
        TOSClientConfiguration clientConfiguration = TOSClientConfiguration.builder().region(region).endpoint(endpoint).credentialsProvider(cred).transportConfig(conf).build();
        return this.build(clientConfiguration);
    }

    @Override
    public TOSV2 build(TOSClientConfiguration conf) {
        return new TOSV2Client(conf);
    }
}

