/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.TosServerException;
import com.volcengine.tos.UnexpectedStatusCodeException;
import com.volcengine.tos.internal.Action;
import com.volcengine.tos.internal.ServerExceptionJson;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;

class RequestHandler {
    private Transport transport;

    RequestHandler(Transport transport) {
        this.transport = transport;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public RequestHandler setTransport(Transport transport) {
        this.transport = transport;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doRequest(TosRequest request, int expectedCode, Action<TosResponse, T> action) {
        try (TosResponse res = this.doRequest(request);){
            if (this.containExpectedCode(res.getStatusCode(), expectedCode)) {
                TosResponse tosResponse = action.apply(res);
                return (T)tosResponse;
            }
            this.checkException(res);
            throw new UnexpectedStatusCodeException(res.getStatusCode(), expectedCode, res.getRequesID());
        }
        catch (IOException e) {
            throw new TosClientException("tos: close body failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doRequest(TosRequest request, int expectedCode, List<Integer> unexpectedCodes, Action<TosResponse, T> action) {
        try (TosResponse res = this.doRequest(request);){
            if (this.containExpectedCode(res.getStatusCode(), expectedCode)) {
                TosResponse tosResponse = action.apply(res);
                return (T)tosResponse;
            }
            boolean containUnexpectedCode = false;
            for (int code : unexpectedCodes) {
                if (!this.containUnexpectedCode(res.getStatusCode(), code)) continue;
                containUnexpectedCode = true;
                break;
            }
            if (containUnexpectedCode) {
                String s = StringUtils.toString(res.getInputStream(), "response body");
                RequestHandler.checkException(s, res.getStatusCode(), res.getRequesID(), res.getHeaders());
                throw new UnexpectedStatusCodeException(res.getStatusCode(), expectedCode, res.getRequesID());
            }
            this.checkException(res);
            throw new UnexpectedStatusCodeException(res.getStatusCode(), expectedCode, res.getRequesID());
        }
        catch (IOException e) {
            throw new TosClientException("tos: close body failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doRequest(TosRequest request, List<Integer> expectedCodes, Action<TosResponse, T> action) {
        try (TosResponse res = this.doRequest(request, expectedCodes);){
            TosResponse tosResponse = action.apply(res);
            return (T)tosResponse;
        }
        catch (IOException e) {
            throw new TosClientException("tos: close body failed", e).setRequestUrl(request.toURL().toString());
        }
        catch (TosException e) {
            throw e.setRequestUrl(request.toURL().toString());
        }
    }

    protected TosResponse doRequest(TosRequest request, List<Integer> expectedCodes) {
        TosResponse response = this.doRequest(request);
        for (int code : expectedCodes) {
            if (!this.containExpectedCode(response.getStatusCode(), code)) continue;
            return response;
        }
        try {
            this.checkException(response);
            throw new UnexpectedStatusCodeException(response.getStatusCode(), expectedCodes, response.getRequesID());
        }
        catch (Throwable throwable) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private TosResponse doRequest(TosRequest request) {
        TosResponse res;
        try {
            res = this.transport.roundTrip(request);
        }
        catch (IOException e) {
            throw new TosClientException("tos: request exception", e);
        }
        catch (IllegalArgumentException e) {
            throw new TosClientException("tos: request exception", e);
        }
        finally {
            if (request.getContent() != null) {
                try {
                    request.getContent().close();
                }
                catch (IOException e) {
                    TosUtils.getLogger().debug("tos: close request body failed, {}", (Object)e.toString());
                }
            }
        }
        return res;
    }

    protected boolean containExpectedCode(int statusCode, int expectedCode) {
        return statusCode == expectedCode;
    }

    protected boolean containUnexpectedCode(int statusCode, int unexpectedCode) {
        return statusCode == unexpectedCode;
    }

    protected void checkException(TosResponse res) {
        if (res.getStatusCode() < 300) {
            return;
        }
        String s = StringUtils.toString(res.getInputStream(), "response body");
        RequestHandler.checkException(s, res.getStatusCode(), res.getRequesID(), res.getHeaders());
    }

    private static void checkException(String rspBody, int statusCode, String reqId, Map<String, String> headers) {
        if (StringUtils.isNotEmpty(rspBody)) {
            ServerExceptionJson se = null;
            try {
                se = (ServerExceptionJson)TosUtils.getJsonMapper().readValue(rspBody, (TypeReference)new TypeReference<ServerExceptionJson>(){});
            }
            catch (JsonProcessingException e) {
                if (statusCode == 400) {
                    throw new TosClientException("tos: bad request" + rspBody, null);
                }
                throw new TosClientException("tos: parse server exception failed" + rspBody, null);
            }
            throw new TosServerException(statusCode, se.getCode(), se.getMessage(), se.getRequestID(), se.getHostID()).setEc(se.getEc()).setKey(se.getKey());
        }
        String ec = headers.get("X-Tos-Ec".toLowerCase());
        if (statusCode == 404) {
            throw new TosServerException(statusCode, "NotFound", "", reqId, "").setEc(ec);
        }
        if (statusCode == 403) {
            throw new TosServerException(statusCode, "Forbidden", "", reqId, "").setEc(ec);
        }
        throw new TosServerException(statusCode, "", "", reqId, "").setEc(ec);
    }
}

