/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.comm.io.Retryable;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.TosUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

class WrappedTransportRequestBody
extends RequestBody
implements Closeable {
    private InputStream content;
    private final MediaType contentType;
    private long contentLength;
    private volatile long totalBytesRead = 0L;

    WrappedTransportRequestBody(MediaType contentType, InputStream content, long contentLength) {
        ParamsChecker.ensureNotNull(content, "Content");
        this.content = content;
        this.contentType = contentType;
        this.contentLength = contentLength;
        if (this.contentLength < 0L) {
            this.contentLength = -1L;
        }
    }

    public MediaType contentType() {
        return this.contentType;
    }

    public long contentLength() {
        return this.contentLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        this.reset();
        if (this.contentLength < 0L) {
            this.writeAllWithChunked(sink);
        } else {
            this.writeAll(sink);
        }
    }

    void reset() throws IOException {
        if (this.totalBytesRead > 0L && this.content != null) {
            if (this.content.markSupported()) {
                TosUtils.getLogger().debug("tos: okhttp writeTo call reset");
                this.content.reset();
                this.totalBytesRead = 0L;
            } else if (this.content instanceof Retryable) {
                TosUtils.getLogger().debug("tos: okhttp writeTo call reset");
                ((Retryable)((Object)this.content)).reset();
                this.totalBytesRead = 0L;
            }
        }
    }

    private void writeAll(BufferedSink sink) throws IOException {
        int maxToRead;
        int bytesRead = 0;
        byte[] tmp = new byte[8192];
        for (long remaining = this.contentLength; remaining > 0L && (bytesRead = this.content.read(tmp, 0, maxToRead = (long)tmp.length < remaining ? tmp.length : (int)remaining)) != -1; remaining -= (long)bytesRead) {
            sink.write(tmp, 0, bytesRead);
            this.totalBytesRead += (long)bytesRead;
        }
    }

    private void writeAllWithChunked(BufferedSink sink) throws IOException {
        int bytesRead = 0;
        byte[] tmp = new byte[8192];
        bytesRead = this.content.read(tmp);
        while (bytesRead != -1) {
            sink.write(tmp, 0, bytesRead);
            this.totalBytesRead += (long)bytesRead;
            bytesRead = this.content.read(tmp);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.content != null) {
            this.content.close();
        }
    }

    protected InputStream getContent() {
        return this.content;
    }

    protected long getTotalBytesRead() {
        return this.totalBytesRead;
    }
}

