/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.taskman;

import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.comm.event.CopyEventType;
import com.volcengine.tos.internal.TosObjectRequestHandler;
import com.volcengine.tos.internal.taskman.AbortTaskHook;
import com.volcengine.tos.internal.taskman.ResumableCopyObjectTask;
import com.volcengine.tos.internal.taskman.ResumableCopyObjectTaskCanceler;
import com.volcengine.tos.internal.taskman.TaskManager;
import com.volcengine.tos.internal.taskman.TaskManagerImpl;
import com.volcengine.tos.internal.taskman.TaskOutput;
import com.volcengine.tos.internal.taskman.Util;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Input;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Output;
import com.volcengine.tos.model.object.CopyEvent;
import com.volcengine.tos.model.object.CopyPartInfo;
import com.volcengine.tos.model.object.CopySourceObjectInfo;
import com.volcengine.tos.model.object.CreateMultipartUploadInput;
import com.volcengine.tos.model.object.CreateMultipartUploadOutput;
import com.volcengine.tos.model.object.GetObjectBasicOutput;
import com.volcengine.tos.model.object.HeadObjectV2Input;
import com.volcengine.tos.model.object.HeadObjectV2Output;
import com.volcengine.tos.model.object.ResumableCopyObjectCheckpoint;
import com.volcengine.tos.model.object.ResumableCopyObjectInput;
import com.volcengine.tos.model.object.ResumableCopyObjectOutput;
import com.volcengine.tos.model.object.UploadPartCopyV2Output;
import com.volcengine.tos.model.object.UploadedPartV2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ResumableCopyObjectTaskHandler {
    private final ResumableCopyObjectInput input;
    private final TosObjectRequestHandler handler;
    private ResumableCopyObjectCheckpoint checkpoint;
    private boolean enableCrcCheck;
    private TaskManager taskMan;
    private List<UploadedPartV2> copiedPartInfos;
    private AbortTaskHook abortTaskHook;

    public ResumableCopyObjectTaskHandler(ResumableCopyObjectInput input, TosObjectRequestHandler handler, boolean enableCrcCheck) {
        ParamsChecker.ensureNotNull(input, "ResumableCopyObjectInput");
        ParamsChecker.isValidBucketNameAndKey(input.getSrcBucket(), input.getSrcKey());
        ParamsChecker.ensureNotNull(handler, "TosObjectRequestHandler");
        this.input = input;
        this.handler = handler;
        this.enableCrcCheck = enableCrcCheck;
    }

    public boolean initTask() {
        CopySourceObjectInfo copySourceObjectInfo;
        this.validateInput();
        if (this.input.isEnableCheckpoint()) {
            this.validateCheckpointPath();
        }
        if ((copySourceObjectInfo = this.getCopySourceObjectInfo(this.input.getSrcBucket(), this.input.getSrcKey())).isSymlink()) {
            return true;
        }
        this.setCheckpoint(copySourceObjectInfo);
        int partsNum = this.checkpoint.getCopyPartInfoList().size();
        this.abortTaskHook = new ResumableCopyObjectTaskCanceler(this.handler, this.taskMan, this.checkpoint.getBucket(), this.checkpoint.getKey(), this.checkpoint.getUploadID(), this.input.getCheckpointFile(), this.input.isEnableCheckpoint());
        this.taskMan = new TaskManagerImpl(this.input.getTaskNum(), partsNum, null, this.abortTaskHook);
        if (this.input.getCancelHook() != null && this.input.getCancelHook() instanceof ResumableCopyObjectTaskCanceler) {
            ((ResumableCopyObjectTaskCanceler)this.input.getCancelHook()).setHandler(this.handler).setTaskMan(this.taskMan).setBucket(this.checkpoint.getBucket()).setKey(this.checkpoint.getKey()).setUploadID(this.checkpoint.getUploadID()).setEnableCheckpoint(this.input.isEnableCheckpoint()).setCheckpointFilePath(this.input.getCheckpointFile());
        }
        this.copiedPartInfos = new ArrayList<UploadedPartV2>(partsNum);
        return false;
    }

    public void dispatch() {
        for (int i = 0; i < this.checkpoint.getCopyPartInfoList().size(); ++i) {
            if (!this.checkpoint.getCopyPartInfoList().get(i).isCompleted()) {
                this.taskMan.dispatch(new ResumableCopyObjectTask(this.checkpoint, i).setEnableCheckpoint(this.input.isEnableCheckpoint()).setCheckpointFile(this.input.getCheckpointFile()).setCopyEventListener(this.input.getCopyEventListener()).setOptions(this.input.getOptions()).setCopySourceSSECKey(this.input.getCopySourceSSECKey()).setHandler(this.handler).setTrafficLimit(this.input.getTrafficLimit()));
                continue;
            }
            CopyPartInfo partInfo = this.checkpoint.getCopyPartInfoList().get(i);
            this.copiedPartInfos.add(new UploadedPartV2().setPartNumber(partInfo.getPartNumber()).setEtag(partInfo.getEtag()));
        }
    }

    public ResumableCopyObjectOutput handle() {
        this.taskMan.handle();
        List<TaskOutput<?>> outputs = this.taskMan.get();
        for (TaskOutput<?> output : outputs) {
            UploadPartCopyV2Output tmp = (UploadPartCopyV2Output)output.getOutput();
            if (tmp == null) continue;
            this.copiedPartInfos.add(new UploadedPartV2().setPartNumber(tmp.getPartNumber()).setEtag(tmp.getEtag()));
        }
        if (!this.readyForComplete()) {
            String message = "tos: some copy tasks failed. bucket is " + this.input.getBucket() + ", dest key is " + this.input.getKey() + ", source key is " + this.input.getSrcKey();
            throw new TosClientException(message, null);
        }
        return this.completeResumableCopyObjectTask();
    }

    private ResumableCopyObjectOutput completeResumableCopyObjectTask() {
        CompleteMultipartUploadV2Output comp;
        CompleteMultipartUploadV2Input input = new CompleteMultipartUploadV2Input().setBucket(this.checkpoint.getBucket()).setKey(this.checkpoint.getKey()).setUploadID(this.checkpoint.getUploadID()).setUploadedParts(this.copiedPartInfos);
        CopyEvent event = new CopyEvent().setUploadID(this.checkpoint.getUploadID()).setBucket(this.checkpoint.getBucket()).setKey(this.checkpoint.getKey()).setCheckpointFile(this.input.getCheckpointFile()).setSrcBucket(this.input.getSrcBucket()).setSrcKey(this.input.getSrcKey()).setSrcVersionID(this.input.getSrcVersionID());
        try {
            String dstCrc64;
            String srcCrc64;
            comp = this.handler.completeMultipartUpload(input);
            if (this.enableCrcCheck && !StringUtils.equals(srcCrc64 = this.checkpoint.getCopySourceObjectInfo().getHashCrc64ecma(), dstCrc64 = comp.getHashCrc64ecma())) {
                throw new TosClientException("tos: expect crc64 " + srcCrc64 + ", actual crc64 " + dstCrc64, null);
            }
            Util.postCopyEvent(this.input.getCopyEventListener(), event.setType(CopyEventType.CopyEventCompleteMultipartUploadSucceed));
        }
        catch (TosException e) {
            Util.postCopyEvent(this.input.getCopyEventListener(), event.setException(e).setType(CopyEventType.CopyEventCompleteMultipartUploadFailed));
            throw e;
        }
        if (this.input.isEnableCheckpoint()) {
            Util.deleteCheckpointFile(this.input.getCheckpointFile());
        }
        return new ResumableCopyObjectOutput().setRequestInfo(comp.getRequestInfo()).setBucket(comp.getBucket()).setKey(comp.getKey()).setUploadID(this.checkpoint.getUploadID()).setEtag(comp.getEtag()).setLocation(comp.getLocation()).setHashCrc64ecma(comp.getHashCrc64ecma()).setVersionID(comp.getVersionID()).setSsecAlgorithm(this.checkpoint.getSsecAlgorithm()).setSsecKeyMD5(this.checkpoint.getSsecKeyMD5()).setEncodingType(this.checkpoint.getEncodingType());
    }

    private boolean readyForComplete() {
        if (this.checkpoint == null || this.checkpoint.getBucket() == null || this.checkpoint.getKey() == null || this.checkpoint.getUploadID() == null || this.checkpoint.getCopyPartInfoList() == null || this.copiedPartInfos == null || this.checkpoint.getCopySourceObjectInfo() == null) {
            return false;
        }
        if (this.copiedPartInfos.size() != this.checkpoint.getCopyPartInfoList().size()) {
            return false;
        }
        for (CopyPartInfo part : this.checkpoint.getCopyPartInfoList()) {
            if (part.isCompleted()) continue;
            return false;
        }
        return true;
    }

    private void validateInput() {
        if (this.input.getPartSize() == 0L) {
            this.input.setPartSize(0x1400000L);
        }
        Util.validatePartSize(this.input.getPartSize());
        this.input.setTaskNum(Util.determineTaskNum(this.input.getTaskNum()));
    }

    private void validateCheckpointPath() {
        String checkpointFileSuffix = Util.checkpointPathMd5(this.input.getBucket(), this.input.getKey(), "") + ".copy";
        if (StringUtils.isEmpty(this.input.getCheckpointFile())) {
            throw new TosClientException("tos: ResumableCopyObject enable checkpoint but checkpoint file path is not set.", null);
        }
        File ufcf = new File(this.input.getCheckpointFile());
        if (ufcf.isDirectory()) {
            this.input.setCheckpointFile(this.input.getCheckpointFile() + File.separator + checkpointFileSuffix);
        }
        ParamsChecker.ensureNotNull(this.input.getCheckpointFile(), "checkpointFilePath");
    }

    private void setCheckpoint(CopySourceObjectInfo copySourceObjectInfo) {
        ResumableCopyObjectCheckpoint checkpoint = null;
        if (this.input.isEnableCheckpoint()) {
            try {
                checkpoint = this.loadCheckpointFromFile(this.input.getCheckpointFile());
            }
            catch (IOException | ClassNotFoundException e) {
                Util.deleteCheckpointFile(this.input.getCheckpointFile());
            }
        }
        boolean valid = false;
        if (checkpoint != null) {
            valid = checkpoint.isValid(copySourceObjectInfo, this.input.getBucket(), this.input.getKey(), this.input.getSrcBucket(), this.input.getSrcKey(), this.input.getSrcVersionID());
        }
        if (!valid) {
            Util.deleteCheckpointFile(this.input.getCheckpointFile());
        }
        if (checkpoint == null || !valid) {
            checkpoint = this.initCheckpoint(copySourceObjectInfo);
            if (this.input.isEnableCheckpoint()) {
                try {
                    checkpoint.writeToFile(this.input.getCheckpointFile());
                }
                catch (IOException e) {
                    throw new TosClientException("tos: record to checkpoint file failed", e);
                }
            }
        }
        this.checkpoint = checkpoint;
    }

    private CopySourceObjectInfo getCopySourceObjectInfo(String bucket, String key) {
        try {
            HeadObjectV2Output head = this.handler.headObject(new HeadObjectV2Input().setBucket(bucket).setKey(key));
            GetObjectBasicOutput basicOutput = head.getHeadObjectBasicOutput();
            return new CopySourceObjectInfo().setObjectSize(head.getContentLength()).setHashCrc64ecma(basicOutput.getHashCrc64ecma()).setEtag(basicOutput.getEtag()).setLastModified(basicOutput.getLastModifiedInDate()).setSymlink("Symlink".equals(head.getObjectType()));
        }
        catch (TosException e) {
            throw new TosClientException("tos: ResumableCopyObject get copySourceObject info failed", e);
        }
    }

    private ResumableCopyObjectCheckpoint initCheckpoint(CopySourceObjectInfo info) throws TosException {
        String ssecAlgorithm = null;
        String ssecKeyMD5 = null;
        if (this.input.getOptions() != null) {
            ssecAlgorithm = this.input.getOptions().getSsecAlgorithm();
            ssecKeyMD5 = this.input.getOptions().getSsecKeyMD5();
        }
        ResumableCopyObjectCheckpoint checkpoint = new ResumableCopyObjectCheckpoint().setBucket(this.input.getBucket()).setKey(this.input.getKey()).setSrcBucket(this.input.getSrcBucket()).setSrcKey(this.input.getSrcKey()).setCopyPartInfoList(this.getPartsFromSourceObject(info.getObjectSize(), this.input.getPartSize())).setCopySourceObjectInfo(info).setPartSize(this.input.getPartSize()).setCopySourceIfMatch(this.input.getCopySourceIfMatch() == null ? info.getEtag() : this.input.getCopySourceIfMatch()).setCopySourceIfModifiedSince(this.input.getCopySourceIfModifiedSince()).setCopySourceIfNoneMatch(this.input.getCopySourceIfNoneMatch()).setCopySourceIfUnModifiedSince(this.input.getCopySourceIfUnModifiedSince()).setCopySourceSSECAlgorithm(this.input.getCopySourceSSECAlgorithm()).setCopySourceSSECKeyMD5(this.input.getCopySourceSSECKeyMD5()).setSsecAlgorithm(ssecAlgorithm).setSsecKeyMD5(ssecKeyMD5);
        CopyEvent createMultipart = new CopyEvent().setBucket(this.input.getBucket()).setKey(this.input.getKey()).setCheckpointFile(this.input.getCheckpointFile()).setSrcBucket(this.input.getSrcBucket()).setSrcKey(this.input.getSrcKey()).setSrcVersionID(this.input.getSrcVersionID());
        try {
            CreateMultipartUploadOutput output = this.handler.createMultipartUpload(new CreateMultipartUploadInput().setBucket(this.input.getBucket()).setKey(this.input.getKey()).setOptions(this.input.getOptions()).setEncodingType(this.input.getEncodingType()));
            Util.postCopyEvent(this.input.getCopyEventListener(), createMultipart.setUploadID(output.getUploadID()).setType(CopyEventType.CopyEventCreateMultipartUploadSucceed));
            checkpoint.setUploadID(output.getUploadID()).setEncodingType(output.getEncodingType());
        }
        catch (TosException e) {
            Util.postCopyEvent(this.input.getCopyEventListener(), createMultipart.setException(e).setType(CopyEventType.CopyEventCreateMultipartUploadFailed));
            throw e;
        }
        return checkpoint;
    }

    private List<CopyPartInfo> getPartsFromSourceObject(long copySourceObjectSize, long partSize) {
        long partNum = copySourceObjectSize / partSize;
        long lastPartSize = copySourceObjectSize % partSize;
        if (lastPartSize != 0L) {
            ++partNum;
        }
        if (partNum > 10000L) {
            throw new TosClientException("unsupported part number, the maximum is 10000", null);
        }
        ArrayList<CopyPartInfo> partInfoList = new ArrayList<CopyPartInfo>((int)partNum);
        int i = 0;
        while ((long)i < partNum) {
            if ((long)i < partNum - 1L) {
                partInfoList.add(new CopyPartInfo().setPartNumber(i + 1).setCopySourceRangeStart((long)i * partSize).setCopySourceRangeEnd((long)(i + 1) * partSize - 1L));
            } else {
                partInfoList.add(new CopyPartInfo().setPartNumber(i + 1).setCopySourceRangeStart((long)i * partSize).setCopySourceRangeEnd((partNum - 1L) * partSize + lastPartSize - 1L));
            }
            ++i;
        }
        if (partNum == 0L) {
            partInfoList.add(new CopyPartInfo().setPartNumber(1).setCopySourceRangeStart(0L).setCopySourceRangeEnd(0L));
        }
        return partInfoList;
    }

    private ResumableCopyObjectCheckpoint loadCheckpointFromFile(String checkpointFilePath) throws IOException, ClassNotFoundException {
        ParamsChecker.ensureNotNull(checkpointFilePath, "checkpointFilePath is null");
        File f = new File(checkpointFilePath);
        try (FileInputStream checkpointFile = new FileInputStream(f);){
            byte[] data = new byte[(int)f.length()];
            checkpointFile.read(data);
            ResumableCopyObjectCheckpoint resumableCopyObjectCheckpoint = (ResumableCopyObjectCheckpoint)TosUtils.getJsonMapper().readValue(data, (TypeReference)new TypeReference<ResumableCopyObjectCheckpoint>(){});
            return resumableCopyObjectCheckpoint;
        }
    }
}

