/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.model.object;

import com.volcengine.tos.comm.common.ReplicationStatusType;
import com.volcengine.tos.comm.common.StorageClassType;
import com.volcengine.tos.comm.common.TierType;
import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.internal.util.DateConverter;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TypeConverter;
import com.volcengine.tos.model.RequestInfo;
import com.volcengine.tos.model.object.RestoreInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class GetObjectBasicOutput {
    private RequestInfo requestInfo;
    private String contentRange;
    private String etag;
    private String lastModified;
    private boolean deleteMarker;
    private String ssecAlgorithm;
    private String ssecKeyMD5;
    private String versionID;
    private String websiteRedirectLocation;
    private String objectType;
    private String hashCrc64ecma;
    private String storageClass;
    private Map<String, String> customMetadata;
    private long contentLength;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;
    private String expires;
    private String contentMD5;
    private RestoreInfo restoreInfo;
    private ReplicationStatusType replicationStatus;
    private boolean isDirectory;
    private int taggingCount;

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public GetObjectBasicOutput setRequestInfo(RequestInfo info) {
        this.requestInfo = info;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public Date getLastModifiedInDate() {
        return DateConverter.rfc1123StringToDate(this.lastModified);
    }

    public boolean isDeleteMarker() {
        return this.deleteMarker;
    }

    public String getSsecAlgorithm() {
        return this.ssecAlgorithm;
    }

    public String getSsecKeyMD5() {
        return this.ssecKeyMD5;
    }

    public String getVersionID() {
        return this.versionID;
    }

    public String getWebsiteRedirectLocation() {
        return this.websiteRedirectLocation;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getHashCrc64ecma() {
        return this.hashCrc64ecma;
    }

    public StorageClassType getStorageClass() {
        return TypeConverter.convertStorageClassType(this.storageClass);
    }

    public Map<String, String> getCustomMetadata() {
        return this.customMetadata;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getExpires() {
        return this.expires;
    }

    public Date getExpiresInDate() {
        return DateConverter.rfc1123StringToDate(this.expires);
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public RestoreInfo getRestoreInfo() {
        return this.restoreInfo;
    }

    public ReplicationStatusType getReplicationStatus() {
        return this.replicationStatus;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public int getTaggingCount() {
        return this.taggingCount;
    }

    public GetObjectBasicOutput parseFromTosResponse(TosResponse response) {
        String restore;
        this.contentLength = response.getContentLength();
        this.contentType = response.getHeaderWithKeyIgnoreCase("Content-Type");
        this.contentMD5 = response.getHeaderWithKeyIgnoreCase("Content-MD5");
        this.contentLanguage = response.getHeaderWithKeyIgnoreCase("Content-Language");
        this.contentEncoding = response.getHeaderWithKeyIgnoreCase("Content-Encoding");
        this.contentDisposition = response.getHeaderWithKeyIgnoreCase("Content-Disposition");
        this.lastModified = response.getHeaderWithKeyIgnoreCase("Last-Modified");
        this.cacheControl = response.getHeaderWithKeyIgnoreCase("Cache-Control");
        this.expires = response.getHeaderWithKeyIgnoreCase("Expires");
        this.etag = response.getHeaderWithKeyIgnoreCase("ETag");
        this.versionID = response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id");
        this.deleteMarker = Boolean.parseBoolean(response.getHeaderWithKeyIgnoreCase("X-Tos-Delete-Marker"));
        this.objectType = response.getHeaderWithKeyIgnoreCase("X-Tos-Object-Type");
        this.storageClass = response.getHeaderWithKeyIgnoreCase("X-Tos-Storage-Class");
        this.customMetadata = this.parseCustomMetadata(response.getHeaders());
        this.ssecAlgorithm = response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm");
        this.ssecKeyMD5 = response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5");
        this.websiteRedirectLocation = response.getHeaderWithKeyIgnoreCase("X-Tos-Website-Redirect-Location");
        this.hashCrc64ecma = response.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma");
        this.storageClass = response.getHeaderWithKeyIgnoreCase("X-Tos-Storage-Class");
        this.contentRange = response.getHeaderWithKeyIgnoreCase("Content-Range");
        this.replicationStatus = ReplicationStatusType.parse(response.getHeaderWithKeyIgnoreCase("x-tos-replication-status"));
        this.isDirectory = Boolean.parseBoolean(response.getHeaderWithKeyIgnoreCase("x-tos-directory"));
        String taggingCount = response.getHeaderWithKeyIgnoreCase("x-tos-tagging-count");
        if (StringUtils.isNotEmpty(taggingCount)) {
            try {
                this.taggingCount = Integer.parseInt(taggingCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.isNotEmpty(restore = response.getHeaderWithKeyIgnoreCase("X-Tos-Restore"))) {
            if ((restore = restore.trim()).equals("ongoing-request=\"true\"")) {
                RestoreInfo restoreInfo = new RestoreInfo();
                RestoreInfo.RestoreStatus status = new RestoreInfo.RestoreStatus();
                status.setOngoingRequest(true);
                restoreInfo.setRestoreStatus(status);
                RestoreInfo.RestoreParam param = new RestoreInfo.RestoreParam();
                param.setRequestDate(DateConverter.rfc1123StringToDate(response.getHeaderWithKeyIgnoreCase("x-tos-restore-expiry-date")));
                param.setExpiryDays(Integer.valueOf(response.getHeaderWithKeyIgnoreCase("x-tos-restore-expiry-days")));
                param.setTier(TierType.parse(response.getHeaderWithKeyIgnoreCase("x-tos-restore-tier")));
                restoreInfo.setRestoreParam(param);
                this.restoreInfo = restoreInfo;
            } else {
                String pattern = "ongoing-request=\"false\", expiry-date=\"";
                int idx = restore.indexOf(pattern);
                if (idx >= 0) {
                    String expiryDate = restore.substring(idx);
                    if (expiryDate.length() > 0 && expiryDate.charAt(expiryDate.length() - 1) == '\\') {
                        expiryDate = expiryDate.substring(0, expiryDate.length() - 1);
                    }
                    RestoreInfo restoreInfo = new RestoreInfo();
                    RestoreInfo.RestoreStatus status = new RestoreInfo.RestoreStatus();
                    status.setExpiryDate(DateConverter.rfc1123StringToDate(expiryDate));
                    restoreInfo.setRestoreStatus(status);
                    this.restoreInfo = restoreInfo;
                }
            }
        }
        return this;
    }

    private Map<String, String> parseCustomMetadata(Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        HashMap<String, String> meta = null;
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("X-Tos-Meta-".toLowerCase())) continue;
            if (meta == null) {
                meta = new HashMap<String, String>();
            }
            String kk = key.substring("X-Tos-Meta-".length());
            meta.put(kk, headers.get(key));
        }
        return meta;
    }

    public String toString() {
        return "GetObjectBasicOutput{requestInfo=" + this.requestInfo + ", contentRange='" + this.contentRange + '\'' + ", etag='" + this.etag + '\'' + ", lastModified=" + this.lastModified + ", deleteMarker=" + this.deleteMarker + ", ssecAlgorithm='" + this.ssecAlgorithm + '\'' + ", ssecKeyMD5='" + this.ssecKeyMD5 + '\'' + ", versionID='" + this.versionID + '\'' + ", websiteRedirectLocation='" + this.websiteRedirectLocation + '\'' + ", objectType='" + this.objectType + '\'' + ", hashCrc64ecma=" + this.hashCrc64ecma + ", storageClass=" + this.storageClass + ", metadata=" + this.customMetadata + ", cacheControl='" + this.cacheControl + '\'' + ", contentDisposition='" + this.contentDisposition + '\'' + ", contentEncoding='" + this.contentEncoding + '\'' + ", contentLanguage='" + this.contentLanguage + '\'' + ", contentType='" + this.contentType + '\'' + ", expires=" + this.expires + '\'' + ", isDirectory=" + this.isDirectory + '\'' + ", taggingCount=" + this.taggingCount + '\'' + '}';
    }
}

