/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos;

import com.volcengine.tos.internal.RequestOptionsBuilder;
import com.volcengine.tos.internal.model.HttpRange;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

@Deprecated
public class RequestOptions {
    public static RequestOptionsBuilder withContentLength(long length) {
        return builder -> builder.withContentLength(length);
    }

    public static RequestOptionsBuilder withContentType(String contentType) {
        return builder -> builder.withHeader("Content-Type", contentType);
    }

    public static RequestOptionsBuilder withAutoRecognizeContentType(boolean autoRecognized) {
        return builder -> builder.setAutoRecognizeContentType(autoRecognized);
    }

    public static RequestOptionsBuilder withCacheControl(String cacheControl) {
        return builder -> builder.withHeader("Cache-Control", cacheControl);
    }

    public static RequestOptionsBuilder withContentDisposition(String contentDisposition) {
        return builder -> builder.withHeader("Content-Disposition", contentDisposition);
    }

    public static RequestOptionsBuilder withContentEncoding(String contentEncoding) {
        return builder -> builder.withHeader("Content-Encoding", contentEncoding);
    }

    public static RequestOptionsBuilder withContentLanguage(String contentLanguage) {
        return builder -> builder.withHeader("Content-Language", contentLanguage);
    }

    public static RequestOptionsBuilder withContentMD5(String contentMD5) {
        return builder -> builder.withHeader("Content-MD5", contentMD5);
    }

    public static RequestOptionsBuilder withContentSHA256(String contentSHA256) {
        return builder -> builder.withHeader("X-Tos-Content-Sha256", contentSHA256);
    }

    public static RequestOptionsBuilder withExpires(Duration expires) {
        return builder -> builder.withHeader("Expires", expires.toString());
    }

    public static RequestOptionsBuilder withServerSideEncryptionCustomer(String ssecAlgorithm, String ssecKey, String ssecKeyMD5) {
        return builder -> {
            builder.withHeader("X-Tos-Server-Side-Encryption-Customer-Algorithm", ssecAlgorithm);
            builder.withHeader("X-Tos-Server-Side-Encryption-Customer-Key", ssecKey);
            builder.withHeader("X-Tos-Server-Side-Encryption-Customer-Key-MD5", ssecKeyMD5);
        };
    }

    public static RequestOptionsBuilder withServerSideEncryption(String serverSideEncryption) {
        return builder -> builder.withHeader("x-tos-server-side-encryption", serverSideEncryption);
    }

    public static RequestOptionsBuilder withIfModifiedSince(ZonedDateTime since) {
        return builder -> builder.withHeader("If-Modified-Since", DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.of("GMT")).format(since));
    }

    public static RequestOptionsBuilder withIfUnmodifiedSince(ZonedDateTime since) {
        return builder -> builder.withHeader("If-Unmodified-Since", DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.of("GMT")).format(since));
    }

    public static RequestOptionsBuilder withIfMatch(String ifMatch) {
        return builder -> builder.withHeader("If-Match", ifMatch);
    }

    public static RequestOptionsBuilder withIfNoneMatch(String ifNoneMatch) {
        return builder -> builder.withHeader("If-None-Match", ifNoneMatch);
    }

    public static RequestOptionsBuilder withCopySourceIfMatch(String ifMatch) {
        return builder -> builder.withHeader("X-Tos-Copy-Source-If-Match", ifMatch);
    }

    public static RequestOptionsBuilder withCopySourceIfNoneMatch(String ifNoneMatch) {
        return builder -> builder.withHeader("X-Tos-Copy-Source-If-None-Match", ifNoneMatch);
    }

    public static RequestOptionsBuilder withCopySourceIfModifiedSince(String ifModifiedSince) {
        return builder -> builder.withHeader("X-Tos-Copy-Source-If-Modified-Since", ifModifiedSince);
    }

    public static RequestOptionsBuilder withCopySourceIfUnmodifiedSince(String ifUnmodifiedSince) {
        return builder -> builder.withHeader("X-Tos-Copy-Source-If-Unmodified-Since", ifUnmodifiedSince);
    }

    public static RequestOptionsBuilder withMeta(String key, String value) {
        return builder -> builder.withHeader("X-Tos-Meta-" + key, value);
    }

    public static RequestOptionsBuilder withRange(long start, long end) {
        return builder -> builder.withHeader("Range", new HttpRange().setStart(start).setEnd(end).toString());
    }

    public static RequestOptionsBuilder withVersionID(String versionID) {
        return builder -> builder.withQuery("versionId", versionID);
    }

    public static RequestOptionsBuilder withStorageClass(String storageClass) {
        return builder -> builder.withHeader("X-Tos-Storage-Class", storageClass);
    }

    public static RequestOptionsBuilder withMetadataDirective(String directive) {
        return builder -> builder.withHeader("X-Tos-Metadata-Directive", directive);
    }

    public static RequestOptionsBuilder withACL(String acl) {
        return builder -> builder.withHeader("X-Tos-Acl", acl);
    }

    public static RequestOptionsBuilder withACLGrantFullControl(String grantFullControl) {
        return builder -> builder.withHeader("X-Tos-Grant-Full-Control", grantFullControl);
    }

    public static RequestOptionsBuilder withACLGrantRead(String grantRead) {
        return builder -> builder.withHeader("X-Tos-Grant-Read", grantRead);
    }

    public static RequestOptionsBuilder withACLGrantReadAcp(String grantReadAcp) {
        return builder -> builder.withHeader("X-Tos-Grant-Read-Acp", grantReadAcp);
    }

    public static RequestOptionsBuilder withACLGrantWrite(String grantWrite) {
        return builder -> builder.withHeader("X-Tos-Grant-Write", grantWrite);
    }

    public static RequestOptionsBuilder withACLGrantWriteAcp(String grantWriteAcp) {
        return builder -> builder.withHeader("X-Tos-Grant-Write-Acp", grantWriteAcp);
    }

    public static RequestOptionsBuilder withWebsiteRedirectLocation(String redirectLocation) {
        return builder -> builder.withHeader("X-Tos-Website-Redirect-Location", redirectLocation);
    }

    public static RequestOptionsBuilder withPreHashCrc64ecma(String preHashCrc64ecma) {
        return builder -> builder.setPreHashCrc64ecma(preHashCrc64ecma);
    }

    public static RequestOptionsBuilder withHeader(String key, String value) {
        return builder -> builder.withHeader(key, value);
    }

    public static RequestOptionsBuilder withQuery(String key, String value) {
        return builder -> builder.withQuery(key, value);
    }
}

