/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos;

import com.volcengine.tos.TOSClientConfiguration;
import com.volcengine.tos.TOSV2;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.auth.Credentials;
import com.volcengine.tos.auth.SignV4;
import com.volcengine.tos.auth.Signer;
import com.volcengine.tos.credential.StaticCredentialsProvider;
import com.volcengine.tos.internal.RequestOptionsBuilder;
import com.volcengine.tos.internal.RequestTransport;
import com.volcengine.tos.internal.TosBucketRequestHandler;
import com.volcengine.tos.internal.TosClientV1Adapter;
import com.volcengine.tos.internal.TosFileRequestHandler;
import com.volcengine.tos.internal.TosObjectRequestHandler;
import com.volcengine.tos.internal.TosPreSignedRequestHandler;
import com.volcengine.tos.internal.TosRequestFactory;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.model.acl.GetObjectAclOutput;
import com.volcengine.tos.model.acl.PutObjectAclInput;
import com.volcengine.tos.model.acl.PutObjectAclOutput;
import com.volcengine.tos.model.bucket.CreateBucketInput;
import com.volcengine.tos.model.bucket.CreateBucketOutput;
import com.volcengine.tos.model.bucket.CreateBucketV2Input;
import com.volcengine.tos.model.bucket.CreateBucketV2Output;
import com.volcengine.tos.model.bucket.DeleteBucketCORSInput;
import com.volcengine.tos.model.bucket.DeleteBucketCORSOutput;
import com.volcengine.tos.model.bucket.DeleteBucketCustomDomainInput;
import com.volcengine.tos.model.bucket.DeleteBucketCustomDomainOutput;
import com.volcengine.tos.model.bucket.DeleteBucketEncryptionInput;
import com.volcengine.tos.model.bucket.DeleteBucketEncryptionOutput;
import com.volcengine.tos.model.bucket.DeleteBucketInput;
import com.volcengine.tos.model.bucket.DeleteBucketInventoryInput;
import com.volcengine.tos.model.bucket.DeleteBucketInventoryOutput;
import com.volcengine.tos.model.bucket.DeleteBucketLifecycleInput;
import com.volcengine.tos.model.bucket.DeleteBucketLifecycleOutput;
import com.volcengine.tos.model.bucket.DeleteBucketMirrorBackInput;
import com.volcengine.tos.model.bucket.DeleteBucketMirrorBackOutput;
import com.volcengine.tos.model.bucket.DeleteBucketOutput;
import com.volcengine.tos.model.bucket.DeleteBucketPolicyInput;
import com.volcengine.tos.model.bucket.DeleteBucketPolicyOutput;
import com.volcengine.tos.model.bucket.DeleteBucketRealTimeLogInput;
import com.volcengine.tos.model.bucket.DeleteBucketRealTimeLogOutput;
import com.volcengine.tos.model.bucket.DeleteBucketRenameInput;
import com.volcengine.tos.model.bucket.DeleteBucketRenameOutput;
import com.volcengine.tos.model.bucket.DeleteBucketReplicationInput;
import com.volcengine.tos.model.bucket.DeleteBucketReplicationOutput;
import com.volcengine.tos.model.bucket.DeleteBucketTaggingInput;
import com.volcengine.tos.model.bucket.DeleteBucketTaggingOutput;
import com.volcengine.tos.model.bucket.DeleteBucketWebsiteInput;
import com.volcengine.tos.model.bucket.DeleteBucketWebsiteOutput;
import com.volcengine.tos.model.bucket.DoesBucketExistInput;
import com.volcengine.tos.model.bucket.GetBucketACLInput;
import com.volcengine.tos.model.bucket.GetBucketACLOutput;
import com.volcengine.tos.model.bucket.GetBucketCORSInput;
import com.volcengine.tos.model.bucket.GetBucketCORSOutput;
import com.volcengine.tos.model.bucket.GetBucketEncryptionInput;
import com.volcengine.tos.model.bucket.GetBucketEncryptionOutput;
import com.volcengine.tos.model.bucket.GetBucketInventoryInput;
import com.volcengine.tos.model.bucket.GetBucketInventoryOutput;
import com.volcengine.tos.model.bucket.GetBucketLifecycleInput;
import com.volcengine.tos.model.bucket.GetBucketLifecycleOutput;
import com.volcengine.tos.model.bucket.GetBucketLocationInput;
import com.volcengine.tos.model.bucket.GetBucketLocationOutput;
import com.volcengine.tos.model.bucket.GetBucketMirrorBackInput;
import com.volcengine.tos.model.bucket.GetBucketMirrorBackOutput;
import com.volcengine.tos.model.bucket.GetBucketNotificationInput;
import com.volcengine.tos.model.bucket.GetBucketNotificationOutput;
import com.volcengine.tos.model.bucket.GetBucketNotificationType2Input;
import com.volcengine.tos.model.bucket.GetBucketNotificationType2Output;
import com.volcengine.tos.model.bucket.GetBucketPolicyInput;
import com.volcengine.tos.model.bucket.GetBucketPolicyOutput;
import com.volcengine.tos.model.bucket.GetBucketRealTimeLogInput;
import com.volcengine.tos.model.bucket.GetBucketRealTimeLogOutput;
import com.volcengine.tos.model.bucket.GetBucketRenameInput;
import com.volcengine.tos.model.bucket.GetBucketRenameOutput;
import com.volcengine.tos.model.bucket.GetBucketReplicationInput;
import com.volcengine.tos.model.bucket.GetBucketReplicationOutput;
import com.volcengine.tos.model.bucket.GetBucketTaggingInput;
import com.volcengine.tos.model.bucket.GetBucketTaggingOutput;
import com.volcengine.tos.model.bucket.GetBucketTypeInput;
import com.volcengine.tos.model.bucket.GetBucketTypeOutput;
import com.volcengine.tos.model.bucket.GetBucketVersioningInput;
import com.volcengine.tos.model.bucket.GetBucketVersioningOutput;
import com.volcengine.tos.model.bucket.GetBucketWebsiteInput;
import com.volcengine.tos.model.bucket.GetBucketWebsiteOutput;
import com.volcengine.tos.model.bucket.HeadBucketOutput;
import com.volcengine.tos.model.bucket.HeadBucketV2Input;
import com.volcengine.tos.model.bucket.HeadBucketV2Output;
import com.volcengine.tos.model.bucket.ListBucketCustomDomainInput;
import com.volcengine.tos.model.bucket.ListBucketCustomDomainOutput;
import com.volcengine.tos.model.bucket.ListBucketInventoryInput;
import com.volcengine.tos.model.bucket.ListBucketInventoryOutput;
import com.volcengine.tos.model.bucket.ListBucketsInput;
import com.volcengine.tos.model.bucket.ListBucketsOutput;
import com.volcengine.tos.model.bucket.ListBucketsV2Input;
import com.volcengine.tos.model.bucket.ListBucketsV2Output;
import com.volcengine.tos.model.bucket.PutBucketACLInput;
import com.volcengine.tos.model.bucket.PutBucketACLOutput;
import com.volcengine.tos.model.bucket.PutBucketCORSInput;
import com.volcengine.tos.model.bucket.PutBucketCORSOutput;
import com.volcengine.tos.model.bucket.PutBucketCustomDomainInput;
import com.volcengine.tos.model.bucket.PutBucketCustomDomainOutput;
import com.volcengine.tos.model.bucket.PutBucketEncryptionInput;
import com.volcengine.tos.model.bucket.PutBucketEncryptionOutput;
import com.volcengine.tos.model.bucket.PutBucketInventoryInput;
import com.volcengine.tos.model.bucket.PutBucketInventoryOutput;
import com.volcengine.tos.model.bucket.PutBucketLifecycleInput;
import com.volcengine.tos.model.bucket.PutBucketLifecycleOutput;
import com.volcengine.tos.model.bucket.PutBucketMirrorBackInput;
import com.volcengine.tos.model.bucket.PutBucketMirrorBackOutput;
import com.volcengine.tos.model.bucket.PutBucketNotificationInput;
import com.volcengine.tos.model.bucket.PutBucketNotificationOutput;
import com.volcengine.tos.model.bucket.PutBucketNotificationType2Input;
import com.volcengine.tos.model.bucket.PutBucketNotificationType2Output;
import com.volcengine.tos.model.bucket.PutBucketPolicyInput;
import com.volcengine.tos.model.bucket.PutBucketPolicyOutput;
import com.volcengine.tos.model.bucket.PutBucketRealTimeLogInput;
import com.volcengine.tos.model.bucket.PutBucketRealTimeLogOutput;
import com.volcengine.tos.model.bucket.PutBucketRenameInput;
import com.volcengine.tos.model.bucket.PutBucketRenameOutput;
import com.volcengine.tos.model.bucket.PutBucketReplicationInput;
import com.volcengine.tos.model.bucket.PutBucketReplicationOutput;
import com.volcengine.tos.model.bucket.PutBucketStorageClassInput;
import com.volcengine.tos.model.bucket.PutBucketStorageClassOutput;
import com.volcengine.tos.model.bucket.PutBucketTaggingInput;
import com.volcengine.tos.model.bucket.PutBucketTaggingOutput;
import com.volcengine.tos.model.bucket.PutBucketVersioningInput;
import com.volcengine.tos.model.bucket.PutBucketVersioningOutput;
import com.volcengine.tos.model.bucket.PutBucketWebsiteInput;
import com.volcengine.tos.model.bucket.PutBucketWebsiteOutput;
import com.volcengine.tos.model.object.AbortMultipartUploadInput;
import com.volcengine.tos.model.object.AbortMultipartUploadOutput;
import com.volcengine.tos.model.object.AppendObjectInput;
import com.volcengine.tos.model.object.AppendObjectOutput;
import com.volcengine.tos.model.object.CompleteMultipartUploadInput;
import com.volcengine.tos.model.object.CompleteMultipartUploadOutput;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Input;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Output;
import com.volcengine.tos.model.object.CopyObjectOutput;
import com.volcengine.tos.model.object.CopyObjectV2Input;
import com.volcengine.tos.model.object.CopyObjectV2Output;
import com.volcengine.tos.model.object.CreateMultipartUploadInput;
import com.volcengine.tos.model.object.CreateMultipartUploadOutput;
import com.volcengine.tos.model.object.DeleteMultiObjectsInput;
import com.volcengine.tos.model.object.DeleteMultiObjectsOutput;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Input;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Output;
import com.volcengine.tos.model.object.DeleteObjectInput;
import com.volcengine.tos.model.object.DeleteObjectOutput;
import com.volcengine.tos.model.object.DeleteObjectTaggingInput;
import com.volcengine.tos.model.object.DeleteObjectTaggingOutput;
import com.volcengine.tos.model.object.DoesObjectExistInput;
import com.volcengine.tos.model.object.DownloadFileInput;
import com.volcengine.tos.model.object.DownloadFileOutput;
import com.volcengine.tos.model.object.FetchObjectInput;
import com.volcengine.tos.model.object.FetchObjectOutput;
import com.volcengine.tos.model.object.GetFetchTaskInput;
import com.volcengine.tos.model.object.GetFetchTaskOutput;
import com.volcengine.tos.model.object.GetFileStatusInput;
import com.volcengine.tos.model.object.GetFileStatusOutput;
import com.volcengine.tos.model.object.GetObjectACLV2Input;
import com.volcengine.tos.model.object.GetObjectACLV2Output;
import com.volcengine.tos.model.object.GetObjectOutput;
import com.volcengine.tos.model.object.GetObjectTaggingInput;
import com.volcengine.tos.model.object.GetObjectTaggingOutput;
import com.volcengine.tos.model.object.GetObjectToFileInput;
import com.volcengine.tos.model.object.GetObjectToFileOutput;
import com.volcengine.tos.model.object.GetObjectV2Input;
import com.volcengine.tos.model.object.GetObjectV2Output;
import com.volcengine.tos.model.object.GetSymlinkInput;
import com.volcengine.tos.model.object.GetSymlinkOutput;
import com.volcengine.tos.model.object.HeadObjectOutput;
import com.volcengine.tos.model.object.HeadObjectV2Input;
import com.volcengine.tos.model.object.HeadObjectV2Output;
import com.volcengine.tos.model.object.ListMultipartUploadsInput;
import com.volcengine.tos.model.object.ListMultipartUploadsOutput;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Input;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Output;
import com.volcengine.tos.model.object.ListObjectVersionsInput;
import com.volcengine.tos.model.object.ListObjectVersionsOutput;
import com.volcengine.tos.model.object.ListObjectVersionsV2Input;
import com.volcengine.tos.model.object.ListObjectVersionsV2Output;
import com.volcengine.tos.model.object.ListObjectsInput;
import com.volcengine.tos.model.object.ListObjectsOutput;
import com.volcengine.tos.model.object.ListObjectsType2Input;
import com.volcengine.tos.model.object.ListObjectsType2Output;
import com.volcengine.tos.model.object.ListObjectsV2Input;
import com.volcengine.tos.model.object.ListObjectsV2Output;
import com.volcengine.tos.model.object.ListPartsInput;
import com.volcengine.tos.model.object.ListPartsOutput;
import com.volcengine.tos.model.object.ListUploadedPartsInput;
import com.volcengine.tos.model.object.ListUploadedPartsOutput;
import com.volcengine.tos.model.object.ModifyObjectInput;
import com.volcengine.tos.model.object.ModifyObjectOutput;
import com.volcengine.tos.model.object.PreSignedPolicyURLInput;
import com.volcengine.tos.model.object.PreSignedPolicyURLOutput;
import com.volcengine.tos.model.object.PreSignedPostSignatureInput;
import com.volcengine.tos.model.object.PreSignedPostSignatureOutput;
import com.volcengine.tos.model.object.PreSignedURLInput;
import com.volcengine.tos.model.object.PreSignedURLOutput;
import com.volcengine.tos.model.object.PreSingedPolicyURLInput;
import com.volcengine.tos.model.object.PreSingedPolicyURLOutput;
import com.volcengine.tos.model.object.PutFetchTaskInput;
import com.volcengine.tos.model.object.PutFetchTaskOutput;
import com.volcengine.tos.model.object.PutObjectACLInput;
import com.volcengine.tos.model.object.PutObjectACLOutput;
import com.volcengine.tos.model.object.PutObjectFromFileInput;
import com.volcengine.tos.model.object.PutObjectFromFileOutput;
import com.volcengine.tos.model.object.PutObjectInput;
import com.volcengine.tos.model.object.PutObjectOutput;
import com.volcengine.tos.model.object.PutObjectTaggingInput;
import com.volcengine.tos.model.object.PutObjectTaggingOutput;
import com.volcengine.tos.model.object.PutSymlinkInput;
import com.volcengine.tos.model.object.PutSymlinkOutput;
import com.volcengine.tos.model.object.RenameObjectInput;
import com.volcengine.tos.model.object.RenameObjectOutput;
import com.volcengine.tos.model.object.RestoreObjectInput;
import com.volcengine.tos.model.object.RestoreObjectOutput;
import com.volcengine.tos.model.object.ResumableCopyObjectInput;
import com.volcengine.tos.model.object.ResumableCopyObjectOutput;
import com.volcengine.tos.model.object.SetObjectMetaInput;
import com.volcengine.tos.model.object.SetObjectMetaOutput;
import com.volcengine.tos.model.object.SetObjectTimeInput;
import com.volcengine.tos.model.object.SetObjectTimeOutput;
import com.volcengine.tos.model.object.UploadFileInput;
import com.volcengine.tos.model.object.UploadFileOutput;
import com.volcengine.tos.model.object.UploadFileV2Input;
import com.volcengine.tos.model.object.UploadFileV2Output;
import com.volcengine.tos.model.object.UploadPartCopyInput;
import com.volcengine.tos.model.object.UploadPartCopyOutput;
import com.volcengine.tos.model.object.UploadPartCopyV2Input;
import com.volcengine.tos.model.object.UploadPartCopyV2Output;
import com.volcengine.tos.model.object.UploadPartFromFileInput;
import com.volcengine.tos.model.object.UploadPartFromFileOutput;
import com.volcengine.tos.model.object.UploadPartInput;
import com.volcengine.tos.model.object.UploadPartOutput;
import com.volcengine.tos.model.object.UploadPartV2Input;
import com.volcengine.tos.model.object.UploadPartV2Output;
import com.volcengine.tos.transport.TransportConfig;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;

public class TOSV2Client
implements TOSV2 {
    private TOSClientConfiguration config;
    private TosBucketRequestHandler bucketRequestHandler;
    private TosObjectRequestHandler objectRequestHandler;
    private TosFileRequestHandler fileRequestHandler;
    private TosPreSignedRequestHandler preSignedRequestHandler;
    private TosClientV1Adapter clientV1Adapter;
    private Transport transport;
    private Signer signer;
    private TosRequestFactory factory;

    protected TOSV2Client(TOSClientConfiguration conf) {
        this.validateAndInitConfig(conf);
        this.initRequestHandler();
        this.initV1ClientAdapter();
    }

    private void validateAndInitConfig(TOSClientConfiguration conf) {
        ParamsChecker.ensureNotNull(conf, "TOSClientConfiguration");
        ParamsChecker.ensureNotNull(conf.getRegion(), "region");
        this.config = conf;
        this.config.setEndpoint(this.validateEndpoint(this.config.getEndpoint(), this.config.getRegion()));
    }

    private String validateEndpoint(String endpoint, String region) {
        if (StringUtils.isEmpty(endpoint)) {
            if (TosUtils.getSupportedRegion().containsKey(region)) {
                return TosUtils.getSupportedRegion().get(region).get(0);
            }
            throw new TosClientException("endpoint is null and region is invalid", null);
        }
        return endpoint;
    }

    private void initRequestHandler() {
        if (this.factory == null) {
            if (this.transport == null) {
                this.setIsHttpByEndpoint(this.config.getEndpoint());
                this.transport = new RequestTransport(this.config.getTransportConfig()).setDisableEncodingMeta(this.config.isDisableEncodingMeta());
            }
            if (this.signer == null) {
                if (this.config.getCredentialsProvider() != null) {
                    this.signer = new SignV4(this.config.getCredentialsProvider(), this.config.getRegion());
                } else if (this.config.getCredentials() != null) {
                    this.signer = new SignV4(this.config.getCredentials(), this.config.getRegion());
                }
            }
            this.factory = new TosRequestFactory(this.signer, this.config.getEndpoint()).setIsCustomDomain(this.config.isCustomDomain()).setDisableEncodingMeta(this.config.isDisableEncodingMeta()).setUserAgent(this.buildUserAgent());
        }
        this.bucketRequestHandler = new TosBucketRequestHandler(this.transport, this.factory);
        this.objectRequestHandler = new TosObjectRequestHandler(this.transport, this.factory, this.bucketRequestHandler).setClientAutoRecognizeContentType(this.config.isClientAutoRecognizeContentType()).setEnableCrcCheck(this.config.isEnableCrc()).setUseTrailerHeader(!this.config.isDisableTrailerHeader()).setDisableEncodingMeta(this.config.isDisableEncodingMeta());
        this.fileRequestHandler = new TosFileRequestHandler(this.objectRequestHandler, this.transport, this.factory).setEnableCrcCheck(this.config.isEnableCrc());
        this.preSignedRequestHandler = new TosPreSignedRequestHandler(this.factory, this.signer);
    }

    private String buildUserAgent() {
        if (StringUtils.isEmpty(this.config.getUserAgentProductName()) && StringUtils.isEmpty(this.config.getUserAgentSoftName()) && StringUtils.isEmpty(this.config.getUserAgentSoftVersion()) && (this.config.getUserAgentCustomizedKeyValues() == null || this.config.getUserAgentCustomizedKeyValues().isEmpty())) {
            return TosUtils.getUserAgent();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TosUtils.getUserAgent());
        sb.append(" -- ");
        if (StringUtils.isEmpty(this.config.getUserAgentProductName())) {
            sb.append("undefined");
        } else {
            sb.append(this.config.getUserAgentProductName());
        }
        sb.append("/");
        if (StringUtils.isEmpty(this.config.getUserAgentSoftName())) {
            sb.append("undefined");
        } else {
            sb.append(this.config.getUserAgentSoftName());
        }
        sb.append("/");
        if (StringUtils.isEmpty(this.config.getUserAgentSoftVersion())) {
            sb.append("undefined");
        } else {
            sb.append(this.config.getUserAgentSoftVersion());
        }
        if (this.config.getUserAgentCustomizedKeyValues() != null && !this.config.getUserAgentCustomizedKeyValues().isEmpty()) {
            sb.append(" (");
            int index = 0;
            for (Map.Entry<String, String> e : this.config.getUserAgentCustomizedKeyValues().entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                sb.append(e.getKey());
                sb.append("/");
                sb.append(e.getValue());
                if (index != this.config.getUserAgentCustomizedKeyValues().size() - 1) {
                    sb.append(";");
                }
                ++index;
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private void setIsHttpByEndpoint(String endpoint) {
        if (this.config == null || this.config.getTransportConfig() == null || StringUtils.isEmpty(endpoint)) {
            return;
        }
        boolean isHttp = endpoint.startsWith("http");
        this.config.getTransportConfig().setHttp(isHttp);
    }

    private void initV1ClientAdapter() {
        this.clientV1Adapter = new TosClientV1Adapter(this.bucketRequestHandler, this.objectRequestHandler, this.fileRequestHandler, this.preSignedRequestHandler);
    }

    @Override
    @Deprecated
    public void changeCredentials(Credentials credentials) {
        this.config.setCredentials(credentials);
        this.signer = credentials == null ? null : new SignV4(credentials, this.config.getRegion());
        this.factory.setSigner(this.signer);
        this.cascadeUpdateRequestFactory();
    }

    @Override
    public boolean refreshCredentials(String accessKey, String secretKey, String securityToken) {
        if (this.config.getCredentialsProvider() != null && !(this.config.getCredentialsProvider() instanceof StaticCredentialsProvider)) {
            return false;
        }
        StaticCredentialsProvider cred = null;
        if (StringUtils.isNotEmpty(accessKey) && StringUtils.isNotEmpty(secretKey)) {
            cred = new StaticCredentialsProvider(accessKey, secretKey, securityToken);
        }
        this.config.setCredentials(null);
        this.config.setCredentialsProvider(cred);
        this.signer = cred == null ? null : new SignV4(cred, this.config.getRegion());
        return true;
    }

    private void cascadeUpdateRequestFactory() {
        this.bucketRequestHandler.setFactory(this.factory);
        this.objectRequestHandler.setFactory(this.factory);
        this.fileRequestHandler.setObjectHandler(this.objectRequestHandler);
        this.fileRequestHandler.setFactory(this.factory);
        this.preSignedRequestHandler.setSigner(this.signer);
        this.preSignedRequestHandler.setFactory(this.factory);
    }

    private void cascadeUpdateTransport() {
        this.bucketRequestHandler.setTransport(this.transport);
        this.objectRequestHandler.setTransport(this.transport);
        this.fileRequestHandler.setObjectHandler(this.objectRequestHandler);
        this.fileRequestHandler.setTransport(this.transport);
    }

    protected TOSClientConfiguration getConfig() {
        return this.config;
    }

    protected TosRequestFactory getFactory() {
        return this.factory;
    }

    @Override
    public void changeRegionAndEndpoint(String region, String endpoint) {
        endpoint = this.validateEndpoint(endpoint, region);
        this.config.setRegion(region);
        this.config.setEndpoint(endpoint);
        this.factory.setEndpoint(endpoint);
        this.cascadeUpdateRequestFactory();
    }

    @Override
    public boolean refreshEndpointRegion(String endpoint, String region) {
        try {
            endpoint = this.validateEndpoint(endpoint, region);
        }
        catch (Exception ex) {
            return false;
        }
        this.config.setRegion(region);
        this.config.setEndpoint(endpoint);
        this.factory.setEndpoint(endpoint);
        this.cascadeUpdateRequestFactory();
        return true;
    }

    @Override
    public void changeTransportConfig(TransportConfig config) {
        this.config.setTransportConfig(config);
        this.transport.switchConfig(this.config.getTransportConfig());
        this.cascadeUpdateTransport();
    }

    @Override
    public CreateBucketV2Output createBucket(String bucket) throws TosException {
        return this.createBucket(CreateBucketV2Input.builder().bucket(bucket).build());
    }

    @Override
    public CreateBucketV2Output createBucket(CreateBucketV2Input input) throws TosException {
        return this.bucketRequestHandler.createBucket(input);
    }

    @Override
    public HeadBucketV2Output headBucket(HeadBucketV2Input input) throws TosException {
        return this.bucketRequestHandler.headBucket(input);
    }

    @Override
    public boolean doesBucketExist(DoesBucketExistInput input) throws TosException {
        return this.bucketRequestHandler.doesBucketExist(input);
    }

    @Override
    public DeleteBucketOutput deleteBucket(String bucket) throws TosException {
        return this.deleteBucket(DeleteBucketInput.builder().bucket(bucket).build());
    }

    @Override
    public DeleteBucketOutput deleteBucket(DeleteBucketInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucket(input);
    }

    @Override
    public ListBucketsV2Output listBuckets(ListBucketsV2Input input) throws TosException {
        return this.bucketRequestHandler.listBuckets(input);
    }

    @Override
    public PutBucketPolicyOutput putBucketPolicy(String bucket, String policy) throws TosException {
        return this.putBucketPolicy(PutBucketPolicyInput.builder().bucket(bucket).policy(policy).build());
    }

    @Override
    public PutBucketPolicyOutput putBucketPolicy(PutBucketPolicyInput input) throws TosException {
        return this.bucketRequestHandler.putBucketPolicy(input);
    }

    @Override
    public GetBucketPolicyOutput getBucketPolicy(String bucket) throws TosException {
        return this.getBucketPolicy(GetBucketPolicyInput.builder().bucket(bucket).build());
    }

    @Override
    public GetBucketPolicyOutput getBucketPolicy(GetBucketPolicyInput input) throws TosException {
        return this.bucketRequestHandler.getBucketPolicy(input);
    }

    @Override
    public DeleteBucketPolicyOutput deleteBucketPolicy(String bucket) throws TosException {
        return this.deleteBucketPolicy(DeleteBucketPolicyInput.builder().bucket(bucket).build());
    }

    @Override
    public DeleteBucketPolicyOutput deleteBucketPolicy(DeleteBucketPolicyInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucketPolicy(input);
    }

    @Override
    public PutBucketCORSOutput putBucketCORS(PutBucketCORSInput input) throws TosException {
        return this.bucketRequestHandler.putBucketCORS(input);
    }

    @Override
    public GetBucketCORSOutput getBucketCORS(GetBucketCORSInput input) throws TosException {
        return this.bucketRequestHandler.getBucketCORS(input);
    }

    @Override
    public DeleteBucketCORSOutput deleteBucketCORS(DeleteBucketCORSInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucketCORS(input);
    }

    @Override
    public PutBucketStorageClassOutput putBucketStorageClass(PutBucketStorageClassInput input) throws TosException {
        return this.bucketRequestHandler.putBucketStorageClass(input);
    }

    @Override
    public GetBucketLocationOutput getBucketLocation(GetBucketLocationInput input) throws TosException {
        return this.bucketRequestHandler.getBucketLocation(input);
    }

    @Override
    public PutBucketLifecycleOutput putBucketLifecycle(PutBucketLifecycleInput input) throws TosException {
        return this.bucketRequestHandler.putBucketLifecycle(input);
    }

    @Override
    public GetBucketLifecycleOutput getBucketLifecycle(GetBucketLifecycleInput input) throws TosException {
        return this.bucketRequestHandler.getBucketLifecycle(input);
    }

    @Override
    public DeleteBucketLifecycleOutput deleteBucketLifecycle(DeleteBucketLifecycleInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucketLifecycle(input);
    }

    @Override
    public PutBucketMirrorBackOutput putBucketMirrorBack(PutBucketMirrorBackInput input) throws TosException {
        return this.bucketRequestHandler.putBucketMirrorBack(input);
    }

    @Override
    public GetBucketMirrorBackOutput getBucketMirrorBack(GetBucketMirrorBackInput input) throws TosException {
        return this.bucketRequestHandler.getBucketMirrorBack(input);
    }

    @Override
    public DeleteBucketMirrorBackOutput deleteBucketMirrorBack(DeleteBucketMirrorBackInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucketMirrorBack(input);
    }

    @Override
    public PutBucketReplicationOutput putBucketReplication(PutBucketReplicationInput input) throws TosException {
        return this.bucketRequestHandler.putBucketReplication(input);
    }

    @Override
    public GetBucketReplicationOutput getBucketReplication(GetBucketReplicationInput input) throws TosException {
        return this.bucketRequestHandler.getBucketReplication(input);
    }

    @Override
    public DeleteBucketReplicationOutput deleteBucketReplication(DeleteBucketReplicationInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucketReplication(input);
    }

    @Override
    public PutBucketVersioningOutput putBucketVersioning(PutBucketVersioningInput input) throws TosException {
        return this.bucketRequestHandler.putBucketVersioning(input);
    }

    @Override
    public GetBucketVersioningOutput getBucketVersioning(GetBucketVersioningInput input) throws TosException {
        return this.bucketRequestHandler.getBucketVersioning(input);
    }

    @Override
    public PutBucketWebsiteOutput putBucketWebsite(PutBucketWebsiteInput input) throws TosException {
        return this.bucketRequestHandler.putBucketWebsite(input);
    }

    @Override
    public GetBucketWebsiteOutput getBucketWebsite(GetBucketWebsiteInput input) throws TosException {
        return this.bucketRequestHandler.getBucketWebsite(input);
    }

    @Override
    public DeleteBucketWebsiteOutput deleteBucketWebsite(DeleteBucketWebsiteInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucketWebsite(input);
    }

    @Override
    public PutBucketNotificationOutput putBucketNotification(PutBucketNotificationInput input) throws TosException {
        return this.bucketRequestHandler.putBucketNotification(input);
    }

    @Override
    public GetBucketNotificationOutput getBucketNotification(GetBucketNotificationInput input) throws TosException {
        return this.bucketRequestHandler.getBucketNotification(input);
    }

    @Override
    public PutBucketNotificationType2Output putBucketNotificationType2(PutBucketNotificationType2Input input) throws TosException {
        return this.bucketRequestHandler.putBucketNotificationType2(input);
    }

    @Override
    public GetBucketNotificationType2Output getBucketNotificationType2(GetBucketNotificationType2Input input) throws TosException {
        return this.bucketRequestHandler.getBucketNotificationType2(input);
    }

    @Override
    public PutBucketCustomDomainOutput putBucketCustomDomain(PutBucketCustomDomainInput input) throws TosException {
        return this.bucketRequestHandler.putBucketCustomDomain(input);
    }

    @Override
    public ListBucketCustomDomainOutput listBucketCustomDomain(ListBucketCustomDomainInput input) throws TosException {
        return this.bucketRequestHandler.listBucketCustomDomain(input);
    }

    @Override
    public DeleteBucketCustomDomainOutput deleteBucketCustomDomain(DeleteBucketCustomDomainInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucketCustomDomain(input);
    }

    @Override
    public PutBucketRealTimeLogOutput putBucketRealTimeLog(PutBucketRealTimeLogInput input) throws TosException {
        return this.bucketRequestHandler.putBucketRealTimeLog(input);
    }

    @Override
    public GetBucketRealTimeLogOutput getBucketRealTimeLog(GetBucketRealTimeLogInput input) throws TosException {
        return this.bucketRequestHandler.getBucketRealTimeLog(input);
    }

    @Override
    public DeleteBucketRealTimeLogOutput deleteBucketRealTimeLog(DeleteBucketRealTimeLogInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucketRealTimeLog(input);
    }

    @Override
    public PutBucketACLOutput putBucketACL(PutBucketACLInput input) throws TosException {
        return this.bucketRequestHandler.putBucketACL(input);
    }

    @Override
    public GetBucketACLOutput getBucketACL(GetBucketACLInput input) throws TosException {
        return this.bucketRequestHandler.getBucketACL(input);
    }

    @Override
    public PutBucketRenameOutput putBucketRename(PutBucketRenameInput input) throws TosException {
        return this.bucketRequestHandler.putBucketRename(input);
    }

    @Override
    public GetBucketRenameOutput getBucketRename(GetBucketRenameInput input) throws TosException {
        return this.bucketRequestHandler.getBucketRename(input);
    }

    @Override
    public DeleteBucketRenameOutput deleteBucketRename(DeleteBucketRenameInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucketRename(input);
    }

    @Override
    public PutBucketEncryptionOutput putBucketEncryption(PutBucketEncryptionInput input) throws TosException {
        return this.bucketRequestHandler.putBucketEncryption(input);
    }

    @Override
    public GetBucketEncryptionOutput getBucketEncryption(GetBucketEncryptionInput input) throws TosException {
        return this.bucketRequestHandler.getBucketEncryption(input);
    }

    @Override
    public DeleteBucketEncryptionOutput deleteBucketEncryption(DeleteBucketEncryptionInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucketEncryption(input);
    }

    @Override
    public PutBucketTaggingOutput putBucketTagging(PutBucketTaggingInput input) throws TosException {
        return this.bucketRequestHandler.putBucketTagging(input);
    }

    @Override
    public GetBucketTaggingOutput getBucketTagging(GetBucketTaggingInput input) throws TosException {
        return this.bucketRequestHandler.getBucketTagging(input);
    }

    @Override
    public DeleteBucketTaggingOutput deleteBucketTagging(DeleteBucketTaggingInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucketTagging(input);
    }

    @Override
    public PutBucketInventoryOutput putBucketInventory(PutBucketInventoryInput input) throws TosException {
        return this.bucketRequestHandler.putBucketInventory(input);
    }

    @Override
    public GetBucketInventoryOutput getBucketInventory(GetBucketInventoryInput input) throws TosException {
        return this.bucketRequestHandler.getBucketInventory(input);
    }

    @Override
    public ListBucketInventoryOutput listBucketInventory(ListBucketInventoryInput input) throws TosException {
        return this.bucketRequestHandler.listBucketInventory(input);
    }

    @Override
    public DeleteBucketInventoryOutput deleteBucketInventory(DeleteBucketInventoryInput input) throws TosException {
        return this.bucketRequestHandler.deleteBucketInventory(input);
    }

    @Override
    public GetObjectV2Output getObject(GetObjectV2Input input) throws TosException {
        return this.objectRequestHandler.getObject(input);
    }

    @Override
    public GetObjectToFileOutput getObjectToFile(GetObjectToFileInput input) throws TosException {
        return this.fileRequestHandler.getObjectToFile(input);
    }

    @Override
    public GetFileStatusOutput getFileStatus(GetFileStatusInput input) throws TosException {
        return this.objectRequestHandler.getFileStatus(input);
    }

    @Override
    public UploadFileV2Output uploadFile(UploadFileV2Input input) throws TosException {
        return this.fileRequestHandler.uploadFile(input);
    }

    @Override
    public DownloadFileOutput downloadFile(DownloadFileInput input) throws TosException {
        return this.fileRequestHandler.downloadFile(input);
    }

    @Override
    public ResumableCopyObjectOutput resumableCopyObject(ResumableCopyObjectInput input) throws TosException {
        return this.fileRequestHandler.resumableCopyObject(input);
    }

    @Override
    public HeadObjectV2Output headObject(HeadObjectV2Input input) throws TosException {
        return this.objectRequestHandler.headObject(input);
    }

    @Override
    public boolean doesObjectExist(DoesObjectExistInput input) throws TosException {
        return this.objectRequestHandler.doesObjectExist(input);
    }

    @Override
    public DeleteObjectOutput deleteObject(DeleteObjectInput input) throws TosException {
        return this.objectRequestHandler.deleteObject(input);
    }

    @Override
    public DeleteMultiObjectsV2Output deleteMultiObjects(DeleteMultiObjectsV2Input input) throws TosException {
        return this.objectRequestHandler.deleteMultiObjects(input);
    }

    @Override
    public PutObjectOutput putObject(PutObjectInput input) throws TosException {
        return this.objectRequestHandler.putObject(input);
    }

    @Override
    public PutObjectFromFileOutput putObjectFromFile(PutObjectFromFileInput input) throws TosException {
        return this.fileRequestHandler.putObjectFromFile(input);
    }

    @Override
    public AppendObjectOutput appendObject(AppendObjectInput input) throws TosException {
        return this.objectRequestHandler.appendObject(input);
    }

    @Override
    public SetObjectMetaOutput setObjectMeta(SetObjectMetaInput input) throws TosException {
        return this.objectRequestHandler.setObjectMeta(input);
    }

    @Override
    public SetObjectTimeOutput setObjectTime(SetObjectTimeInput input) throws TosException {
        return this.objectRequestHandler.setObjectTime(input);
    }

    @Override
    public ListObjectsV2Output listObjects(ListObjectsV2Input input) throws TosException {
        return this.objectRequestHandler.listObjects(input);
    }

    @Override
    public ListObjectsType2Output listObjectsType2(ListObjectsType2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListObjectsType2Input");
        if (input.isListOnlyOnce()) {
            return this.objectRequestHandler.listObjectsType2(input);
        }
        return this.objectRequestHandler.listObjectsType2UntilFinished(input);
    }

    @Override
    public ListObjectVersionsV2Output listObjectVersions(ListObjectVersionsV2Input input) throws TosException {
        return this.objectRequestHandler.listObjectVersions(input);
    }

    @Override
    public CopyObjectV2Output copyObject(CopyObjectV2Input input) throws TosException {
        return this.objectRequestHandler.copyObject(input);
    }

    @Override
    public UploadPartCopyV2Output uploadPartCopy(UploadPartCopyV2Input input) throws TosException {
        return this.objectRequestHandler.uploadPartCopy(input);
    }

    @Override
    public PutObjectACLOutput putObjectAcl(PutObjectACLInput input) throws TosException {
        return this.objectRequestHandler.putObjectAcl(input);
    }

    @Override
    public GetObjectACLV2Output getObjectAcl(GetObjectACLV2Input input) throws TosException {
        return this.objectRequestHandler.getObjectAcl(input);
    }

    @Override
    public PutObjectTaggingOutput putObjectTagging(PutObjectTaggingInput input) throws TosException {
        return this.objectRequestHandler.putObjectTagging(input);
    }

    @Override
    public GetObjectTaggingOutput getObjectTagging(GetObjectTaggingInput input) throws TosException {
        return this.objectRequestHandler.getObjectTagging(input);
    }

    @Override
    public DeleteObjectTaggingOutput deleteObjectTagging(DeleteObjectTaggingInput input) throws TosException {
        return this.objectRequestHandler.deleteObjectTagging(input);
    }

    @Override
    public FetchObjectOutput fetchObject(FetchObjectInput input) throws TosException {
        return this.objectRequestHandler.fetchObject(input);
    }

    @Override
    public PutFetchTaskOutput putFetchTask(PutFetchTaskInput input) throws TosException {
        return this.objectRequestHandler.putFetchTask(input);
    }

    @Override
    public GetFetchTaskOutput getFetchTask(GetFetchTaskInput input) throws TosException {
        return this.objectRequestHandler.getFetchTask(input);
    }

    @Override
    public CreateMultipartUploadOutput createMultipartUpload(CreateMultipartUploadInput input) throws TosException {
        return this.objectRequestHandler.createMultipartUpload(input);
    }

    @Override
    public UploadPartV2Output uploadPart(UploadPartV2Input input) throws TosException {
        return this.objectRequestHandler.uploadPart(input);
    }

    @Override
    public UploadPartFromFileOutput uploadPartFromFile(UploadPartFromFileInput input) throws TosException {
        return this.fileRequestHandler.uploadPartFromFile(input);
    }

    @Override
    public CompleteMultipartUploadV2Output completeMultipartUpload(CompleteMultipartUploadV2Input input) throws TosException {
        return this.objectRequestHandler.completeMultipartUpload(input);
    }

    @Override
    public AbortMultipartUploadOutput abortMultipartUpload(AbortMultipartUploadInput input) throws TosException {
        return this.objectRequestHandler.abortMultipartUpload(input);
    }

    @Override
    public ListPartsOutput listParts(ListPartsInput input) throws TosException {
        return this.objectRequestHandler.listParts(input);
    }

    @Override
    public ListMultipartUploadsV2Output listMultipartUploads(ListMultipartUploadsV2Input input) throws TosException {
        return this.objectRequestHandler.listMultipartUploads(input);
    }

    @Override
    public RenameObjectOutput renameObject(RenameObjectInput input) throws TosException {
        return this.objectRequestHandler.renameObject(input);
    }

    @Override
    public RestoreObjectOutput restoreObject(RestoreObjectInput input) throws TosException {
        return this.objectRequestHandler.restoreObject(input);
    }

    @Override
    public PutSymlinkOutput putSymlink(PutSymlinkInput input) throws TosException {
        return this.objectRequestHandler.putSymlink(input);
    }

    @Override
    public GetSymlinkOutput getSymlink(GetSymlinkInput input) throws TosException {
        return this.objectRequestHandler.getSymlink(input);
    }

    protected ModifyObjectOutput modifyObject(ModifyObjectInput input) throws TosException {
        return this.objectRequestHandler.modifyObject(input, "0", false);
    }

    @Override
    public PreSignedURLOutput preSignedURL(PreSignedURLInput input) throws TosException {
        return this.preSignedRequestHandler.preSignedURL(input);
    }

    @Override
    public PreSignedPostSignatureOutput preSignedPostSignature(PreSignedPostSignatureInput input) throws TosException {
        return this.preSignedRequestHandler.preSignedPostSignature(input);
    }

    @Override
    @Deprecated
    public PreSingedPolicyURLOutput preSingedPolicyURL(PreSingedPolicyURLInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PreSingedPolicyURLInput");
        PreSignedPolicyURLOutput out = this.preSignedRequestHandler.preSignedPolicyURL(new PreSignedPolicyURLInput().setBucket(input.getBucket()).setExpires(input.getExpires()).setConditions(input.getConditions()).setAlternativeEndpoint(input.getAlternativeEndpoint()).setCustomDomain(input.isCustomDomain()));
        return new PreSingedPolicyURLOutput().setPreSignedPolicyURLGenerator(out.getPreSignedPolicyURLGenerator()).setSignatureQuery(out.getSignatureQuery()).setHost(out.getHost()).setScheme(out.getScheme());
    }

    @Override
    public PreSignedPolicyURLOutput preSignedPolicyURL(PreSignedPolicyURLInput input) throws TosException {
        return this.preSignedRequestHandler.preSignedPolicyURL(input);
    }

    @Override
    public GetBucketTypeOutput getBucketType(GetBucketTypeInput bucket) throws TosException {
        return this.objectRequestHandler.getBucketType(bucket);
    }

    @Override
    public CreateBucketOutput createBucket(CreateBucketInput input) throws TosException {
        return this.clientV1Adapter.createBucket(input);
    }

    @Override
    public HeadBucketOutput headBucket(String bucket) throws TosException {
        return this.clientV1Adapter.headBucket(bucket);
    }

    @Override
    public ListBucketsOutput listBuckets(ListBucketsInput input) throws TosException {
        return this.clientV1Adapter.listBuckets(input);
    }

    @Override
    public GetObjectOutput getObject(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.getObject(bucket, objectKey, builders);
    }

    @Override
    public HeadObjectOutput headObject(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.headObject(bucket, objectKey, builders);
    }

    @Override
    public DeleteObjectOutput deleteObject(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.deleteObject(bucket, objectKey, builders);
    }

    @Override
    public DeleteMultiObjectsOutput deleteMultiObjects(String bucket, DeleteMultiObjectsInput input, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.deleteMultiObjects(bucket, input, builders);
    }

    @Override
    public PutObjectOutput putObject(String bucket, String objectKey, InputStream inputStream, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.putObject(bucket, objectKey, inputStream, builders);
    }

    @Override
    public UploadFileOutput uploadFile(String bucket, UploadFileInput input, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.uploadFile(bucket, input, builders);
    }

    @Override
    public AppendObjectOutput appendObject(String bucket, String objectKey, InputStream content, long offset, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.appendObject(bucket, objectKey, content, offset, builders);
    }

    @Override
    public SetObjectMetaOutput setObjectMeta(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.setObjectMeta(bucket, objectKey, builders);
    }

    @Override
    public ListObjectsOutput listObjects(String bucket, ListObjectsInput input) throws TosException {
        return this.clientV1Adapter.listObjects(bucket, input);
    }

    @Override
    public ListObjectVersionsOutput listObjectVersions(String bucket, ListObjectVersionsInput input) throws TosException {
        return this.clientV1Adapter.listObjectVersions(bucket, input);
    }

    @Override
    public CopyObjectOutput copyObject(String bucket, String srcObjectKey, String dstObjectKey, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.copyObject(bucket, srcObjectKey, dstObjectKey, builders);
    }

    @Override
    public CopyObjectOutput copyObjectTo(String bucket, String dstBucket, String dstObjectKey, String srcObjectKey, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.copyObjectTo(bucket, dstBucket, dstObjectKey, srcObjectKey, builders);
    }

    @Override
    public CopyObjectOutput copyObjectFrom(String bucket, String srcBucket, String srcObjectKey, String dstObjectKey, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.copyObjectFrom(bucket, srcBucket, srcObjectKey, dstObjectKey, builders);
    }

    @Override
    public UploadPartCopyOutput uploadPartCopy(String bucket, UploadPartCopyInput input, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.uploadPartCopy(bucket, input, builders);
    }

    @Override
    public PutObjectAclOutput putObjectAcl(String bucket, PutObjectAclInput input) throws TosException {
        return this.clientV1Adapter.putObjectAcl(bucket, input);
    }

    @Override
    public GetObjectAclOutput getObjectAcl(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.getObjectAcl(bucket, objectKey, builders);
    }

    @Override
    public CreateMultipartUploadOutput createMultipartUpload(String bucket, String objectKey, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.createMultipartUpload(bucket, objectKey, builders);
    }

    @Override
    public UploadPartOutput uploadPart(String bucket, UploadPartInput input, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.uploadPart(bucket, input, builders);
    }

    @Override
    public CompleteMultipartUploadOutput completeMultipartUpload(String bucket, CompleteMultipartUploadInput input) throws TosException {
        return this.clientV1Adapter.completeMultipartUpload(bucket, input);
    }

    @Override
    public AbortMultipartUploadOutput abortMultipartUpload(String bucket, AbortMultipartUploadInput input) throws TosException {
        return this.clientV1Adapter.abortMultipartUpload(bucket, input);
    }

    @Override
    public ListUploadedPartsOutput listUploadedParts(String bucket, ListUploadedPartsInput input, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.listUploadedParts(bucket, input, builders);
    }

    @Override
    public ListMultipartUploadsOutput listMultipartUploads(String bucket, ListMultipartUploadsInput input) throws TosException {
        return this.clientV1Adapter.listMultipartUploads(bucket, input);
    }

    @Override
    public String preSignedURL(String httpMethod, String bucket, String objectKey, Duration ttl, RequestOptionsBuilder ... builders) throws TosException {
        return this.clientV1Adapter.preSignedURL(httpMethod, bucket, objectKey, ttl, builders);
    }

    @Override
    public void close() throws IOException {
        if (this.transport != null && this.transport instanceof Closeable) {
            try {
                ((Closeable)((Object)this.transport)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.config != null && this.config.getCredentialsProvider() != null && this.config.getCredentialsProvider() instanceof Closeable) {
            try {
                ((Closeable)((Object)this.config.getCredentialsProvider())).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

