/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.TosServerException;
import com.volcengine.tos.comm.MimeType;
import com.volcengine.tos.comm.common.BucketType;
import com.volcengine.tos.comm.event.DataTransferListener;
import com.volcengine.tos.comm.ratelimit.RateLimiter;
import com.volcengine.tos.internal.RecursiveDeleter;
import com.volcengine.tos.internal.RequestBuilder;
import com.volcengine.tos.internal.RequestHandler;
import com.volcengine.tos.internal.ServerExceptionJson;
import com.volcengine.tos.internal.TosBucketRequestHandler;
import com.volcengine.tos.internal.TosMarshalResult;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.TosRequestFactory;
import com.volcengine.tos.internal.TosResponse;
import com.volcengine.tos.internal.Transport;
import com.volcengine.tos.internal.model.CRC64Checksum;
import com.volcengine.tos.internal.model.CheckCrc64AutoInputStream;
import com.volcengine.tos.internal.model.CreateMultipartUploadOutputJson;
import com.volcengine.tos.internal.model.SimpleDataTransferListenInputStream;
import com.volcengine.tos.internal.model.TosRawTrailerInputStream;
import com.volcengine.tos.internal.model.UploadPartCopyOutputJson;
import com.volcengine.tos.internal.util.CRC64Utils;
import com.volcengine.tos.internal.util.DateConverter;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.PayloadConverter;
import com.volcengine.tos.internal.util.SigningUtils;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import com.volcengine.tos.internal.util.aborthook.DefaultAbortTosObjectInputStreamHook;
import com.volcengine.tos.internal.util.ratelimit.RateLimitedInputStream;
import com.volcengine.tos.model.GenericInput;
import com.volcengine.tos.model.bucket.HeadBucketV2Input;
import com.volcengine.tos.model.bucket.HeadBucketV2Output;
import com.volcengine.tos.model.object.AbortMultipartUploadInput;
import com.volcengine.tos.model.object.AbortMultipartUploadOutput;
import com.volcengine.tos.model.object.AppendObjectInput;
import com.volcengine.tos.model.object.AppendObjectOutput;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Input;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Output;
import com.volcengine.tos.model.object.CopyObjectV2Input;
import com.volcengine.tos.model.object.CopyObjectV2Output;
import com.volcengine.tos.model.object.CreateMultipartUploadInput;
import com.volcengine.tos.model.object.CreateMultipartUploadOutput;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Input;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Output;
import com.volcengine.tos.model.object.DeleteObjectInput;
import com.volcengine.tos.model.object.DeleteObjectOutput;
import com.volcengine.tos.model.object.DeleteObjectTaggingInput;
import com.volcengine.tos.model.object.DeleteObjectTaggingOutput;
import com.volcengine.tos.model.object.FetchObjectInput;
import com.volcengine.tos.model.object.FetchObjectOutput;
import com.volcengine.tos.model.object.GetFetchTaskInput;
import com.volcengine.tos.model.object.GetFetchTaskOutput;
import com.volcengine.tos.model.object.GetFileStatusInput;
import com.volcengine.tos.model.object.GetFileStatusOutput;
import com.volcengine.tos.model.object.GetObjectACLV2Input;
import com.volcengine.tos.model.object.GetObjectACLV2Output;
import com.volcengine.tos.model.object.GetObjectBasicOutput;
import com.volcengine.tos.model.object.GetObjectTaggingInput;
import com.volcengine.tos.model.object.GetObjectTaggingOutput;
import com.volcengine.tos.model.object.GetObjectV2Input;
import com.volcengine.tos.model.object.GetObjectV2Output;
import com.volcengine.tos.model.object.GetSymlinkInput;
import com.volcengine.tos.model.object.GetSymlinkOutput;
import com.volcengine.tos.model.object.HeadObjectV2Input;
import com.volcengine.tos.model.object.HeadObjectV2Output;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Input;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Output;
import com.volcengine.tos.model.object.ListObjectVersionsV2Input;
import com.volcengine.tos.model.object.ListObjectVersionsV2Output;
import com.volcengine.tos.model.object.ListObjectsType2Input;
import com.volcengine.tos.model.object.ListObjectsType2Output;
import com.volcengine.tos.model.object.ListObjectsV2Input;
import com.volcengine.tos.model.object.ListObjectsV2Output;
import com.volcengine.tos.model.object.ListPartsInput;
import com.volcengine.tos.model.object.ListPartsOutput;
import com.volcengine.tos.model.object.ListedCommonPrefix;
import com.volcengine.tos.model.object.ListedObjectV2;
import com.volcengine.tos.model.object.ModifyObjectInput;
import com.volcengine.tos.model.object.ModifyObjectOutput;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import com.volcengine.tos.model.object.ObjectTobeDeleted;
import com.volcengine.tos.model.object.PutFetchTaskInput;
import com.volcengine.tos.model.object.PutFetchTaskOutput;
import com.volcengine.tos.model.object.PutObjectACLInput;
import com.volcengine.tos.model.object.PutObjectACLOutput;
import com.volcengine.tos.model.object.PutObjectBasicInput;
import com.volcengine.tos.model.object.PutObjectInput;
import com.volcengine.tos.model.object.PutObjectOutput;
import com.volcengine.tos.model.object.PutObjectTaggingInput;
import com.volcengine.tos.model.object.PutObjectTaggingOutput;
import com.volcengine.tos.model.object.PutSymlinkInput;
import com.volcengine.tos.model.object.PutSymlinkOutput;
import com.volcengine.tos.model.object.RenameObjectInput;
import com.volcengine.tos.model.object.RenameObjectOutput;
import com.volcengine.tos.model.object.RestoreObjectInput;
import com.volcengine.tos.model.object.RestoreObjectOutput;
import com.volcengine.tos.model.object.SetObjectMetaInput;
import com.volcengine.tos.model.object.SetObjectMetaOutput;
import com.volcengine.tos.model.object.TosObjectInputStream;
import com.volcengine.tos.model.object.UploadPartBasicInput;
import com.volcengine.tos.model.object.UploadPartCopyV2Input;
import com.volcengine.tos.model.object.UploadPartCopyV2Output;
import com.volcengine.tos.model.object.UploadPartV2Input;
import com.volcengine.tos.model.object.UploadPartV2Output;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TosObjectRequestHandler {
    private TosBucketRequestHandler bucketRequestHandler;
    private RequestHandler objectHandler;
    private TosRequestFactory factory;
    private boolean clientAutoRecognizeContentType;
    private boolean enableCrcCheck;
    private boolean useTrailerHeader;
    private boolean disableEncodingMeta;
    private final BucketCacheLock[] bucketCacheLocks;

    public TosObjectRequestHandler(Transport transport, TosRequestFactory factory) {
        this(transport, factory, null);
    }

    public TosObjectRequestHandler(Transport transport, TosRequestFactory factory, TosBucketRequestHandler bucketRequestHandler) {
        this.objectHandler = new RequestHandler(transport);
        this.factory = factory;
        this.bucketRequestHandler = bucketRequestHandler;
        this.bucketCacheLocks = new BucketCacheLock[16];
        for (int i = 0; i < this.bucketCacheLocks.length; ++i) {
            BucketCacheLock bucketCacheLock = new BucketCacheLock();
            bucketCacheLock.bucketTypes = new HashMap<String, BucketCache>();
            bucketCacheLock.lock = new ReentrantReadWriteLock();
            this.bucketCacheLocks[i] = bucketCacheLock;
        }
    }

    public TosObjectRequestHandler setTransport(Transport transport) {
        if (this.objectHandler == null) {
            this.objectHandler = new RequestHandler(transport);
        } else {
            this.objectHandler.setTransport(transport);
        }
        return this;
    }

    public Transport getTransport() {
        if (this.objectHandler != null) {
            return this.objectHandler.getTransport();
        }
        return null;
    }

    public TosRequestFactory getFactory() {
        return this.factory;
    }

    public TosObjectRequestHandler setFactory(TosRequestFactory factory) {
        this.factory = factory;
        return this;
    }

    public boolean isClientAutoRecognizeContentType() {
        return this.clientAutoRecognizeContentType;
    }

    public boolean isEnableCrcCheck() {
        return this.enableCrcCheck;
    }

    public TosObjectRequestHandler setClientAutoRecognizeContentType(boolean clientAutoRecognizeContentType) {
        this.clientAutoRecognizeContentType = clientAutoRecognizeContentType;
        return this;
    }

    public TosObjectRequestHandler setEnableCrcCheck(boolean enableCrcCheck) {
        this.enableCrcCheck = enableCrcCheck;
        return this;
    }

    public TosObjectRequestHandler setUseTrailerHeader(boolean useTrailerHeader) {
        this.useTrailerHeader = useTrailerHeader;
        return this;
    }

    public TosObjectRequestHandler setDisableEncodingMeta(boolean disableEncodingMeta) {
        this.disableEncodingMeta = disableEncodingMeta;
        return this;
    }

    private RequestBuilder handleGenericInput(RequestBuilder builder, GenericInput input) {
        if (StringUtils.isNotEmpty(input.getRequestHost())) {
            builder = builder.withHeader("Host", input.getRequestHost());
        }
        if (input.getRequestDate() != null) {
            builder = builder.withHeader("X-Tos-Date", SigningUtils.iso8601Layout.format(input.getRequestDate().toInstant().atOffset(ZoneOffset.UTC)));
        }
        return builder;
    }

    private BucketType getBucketType(String bucket) {
        if (this.bucketRequestHandler == null) {
            return null;
        }
        BucketCacheLock bcl = this.bucketCacheLocks[Math.abs(bucket.hashCode()) % this.bucketCacheLocks.length];
        bcl.lock.readLock().lock();
        BucketCache bc = bcl.bucketTypes.get(bucket);
        bcl.lock.readLock().unlock();
        if (bc != null && (double)(System.nanoTime() - bc.lastUpdateTimeNanos) < bc.timeout) {
            return bc.bucketType;
        }
        bcl.lock.writeLock().lock();
        try {
            bc = bcl.bucketTypes.get(bucket);
            if (bc != null && (double)(System.nanoTime() - bc.lastUpdateTimeNanos) < bc.timeout) {
                BucketType bucketType = bc.bucketType;
                return bucketType;
            }
            HeadBucketV2Output output = this.bucketRequestHandler.headBucket(new HeadBucketV2Input().setBucket(bucket));
            bc = new BucketCache();
            bc.bucketType = output.getBucketType();
            bc.lastUpdateTimeNanos = System.nanoTime();
            bc.timeout = 9.0E11;
            bcl.bucketTypes.put(bucket, bc);
            BucketType bucketType = bc.bucketType;
            return bucketType;
        }
        catch (TosServerException ex) {
            if (bc != null) {
                bcl.bucketTypes.remove(bucket);
            }
            TosUtils.getLogger().warn("try to get bucket type failed", (Throwable)ex);
            throw ex;
        }
        finally {
            bcl.lock.writeLock().unlock();
        }
    }

    public GetFileStatusOutput getFileStatus(GetFileStatusInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetFileStatusInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        BucketType bucketType = this.getBucketType(input.getBucket());
        if (bucketType != null && bucketType.getType().equals(BucketType.BUCKET_TYPE_HNS.getType())) {
            HeadObjectV2Input hinput = new HeadObjectV2Input().setBucket(input.getBucket()).setKey(input.getKey());
            hinput.setRequestDate(input.getRequestDate());
            hinput.setRequestHost(input.getRequestHost());
            HeadObjectV2Output output = this.headObject(hinput);
            GetFileStatusOutput goutput = new GetFileStatusOutput();
            goutput.setRequestInfo(output.getRequestInfo());
            goutput.setKey(input.getKey());
            goutput.setLastModified(output.getLastModified());
            goutput.setCrc64(output.getHashCrc64ecma());
            if (output.getRequestInfo().getHeader() != null) {
                goutput.setCrc32(output.getRequestInfo().getHeader().get("x-tos-hash-crc32c".toLowerCase()));
            }
            goutput.setSize(output.getContentLength());
            return goutput;
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("stat", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, this::buildGetFileStatusOutput);
    }

    private GetFileStatusOutput buildGetFileStatusOutput(TosResponse response) {
        return PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<GetFileStatusOutput>(){}).setRequestInfo(response.RequestInfo());
    }

    public GetObjectV2Output getObject(GetObjectV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetObjectV2Input");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("versionId", input.getVersionID()).withQuery("response-cache-control", input.getResponseCacheControl()).withQuery("response-content-disposition", input.getResponseContentDisposition()).withQuery("response-content-encoding", input.getResponseContentEncoding()).withQuery("response-content-type", input.getResponseContentType()).withQuery("response-content-language", input.getResponseContentLanguage()).withQuery("response-expires", DateConverter.dateToRFC1123String(input.getResponseExpires())).withQuery("x-tos-process", input.getProcess()).withQuery("x-tos-save-bucket", input.getSaveBucket()).withQuery("x-tos-save-object", input.getSaveObject());
        if (input.getDocPage() > 0) {
            builder = builder.withQuery("x-tos-doc-page", Integer.toString(input.getDocPage()));
        }
        if (input.getSrcType() != null) {
            builder = builder.withQuery("x-tos-doc-src-type", input.getSrcType().toString());
        }
        if (input.getDstType() != null) {
            builder = builder.withQuery("x-tos-doc-dst-type", input.getDstType().toString());
        }
        builder = this.handleGenericInput(builder, input);
        boolean useTrailerHeader = this.useTrailerHeader;
        if (StringUtils.isEmpty(input.getRange()) && (input.getOptions() == null || StringUtils.isEmpty(input.getOptions().getRange()))) {
            useTrailerHeader = false;
        }
        if (useTrailerHeader) {
            builder.withHeader("Accept-Encoding", "tos-raw-trailer");
            builder.withHeader("x-tos-trailer", "x-tos-hash-range-crc64ecma");
        }
        TosRequest req = this.factory.build(builder, "GET", null);
        try {
            TosResponse response = this.objectHandler.doRequest(req, TosObjectRequestHandler.getExpectedCodes(input.getAllSettedHeaders()));
            return this.buildGetObjectV2Output(response, input.getRateLimiter(), input.getDataTransferListener(), useTrailerHeader);
        }
        catch (TosException ex) {
            throw ex.setRequestUrl(req.toURL().toString());
        }
    }

    private static List<Integer> getExpectedCodes(Map<String, String> headers) {
        ArrayList<Integer> codes = new ArrayList<Integer>(1);
        if (headers == null) {
            codes.add(200);
            return codes;
        }
        codes.add(200);
        if (headers.get("Range") != null) {
            codes.add(206);
        }
        return codes;
    }

    private GetObjectV2Output buildGetObjectV2Output(TosResponse response, RateLimiter rateLimiter, DataTransferListener dataTransferListener, boolean useTrailerHeader) {
        String serverCrc64ecma;
        GetObjectBasicOutput basicOutput = new GetObjectBasicOutput().setRequestInfo(response.RequestInfo()).parseFromTosResponse(response);
        InputStream content = response.getInputStream();
        if (rateLimiter != null) {
            content = new RateLimitedInputStream(content, rateLimiter);
        }
        if (dataTransferListener != null) {
            content = new SimpleDataTransferListenInputStream(content, dataTransferListener, response.getContentLength());
        }
        if (useTrailerHeader && this.checkTrailerHeaderFromServer(response)) {
            content = new TosRawTrailerInputStream(content, basicOutput.getContentLength(), response.getHeaderWithKeyIgnoreCase("x-tos-trailer"));
        } else if (this.enableCrcCheck && response.getStatusCode() != 206 && StringUtils.isNotEmpty(serverCrc64ecma = response.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"))) {
            content = new CheckCrc64AutoInputStream(content, new CRC64Checksum(), serverCrc64ecma);
        }
        return new GetObjectV2Output(basicOutput, new TosObjectInputStream(content)).setHook(new DefaultAbortTosObjectInputStreamHook(content, response.getSource()));
    }

    private boolean checkTrailerHeaderFromServer(TosResponse response) {
        String contentEncoding = response.getHeaderWithKeyIgnoreCase("Content-Encoding");
        return StringUtils.isNotEmpty(contentEncoding) && contentEncoding.startsWith("tos-raw-trailer");
    }

    public HeadObjectV2Output headObject(HeadObjectV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "HeadObjectV2Input");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("versionId", input.getVersionID());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "HEAD", null);
        return this.objectHandler.doRequest(req, TosObjectRequestHandler.getExpectedCodes(input.getAllSettedHeaders()), response -> {
            HeadObjectV2Output output = new HeadObjectV2Output(new GetObjectBasicOutput().setRequestInfo(response.RequestInfo()).parseFromTosResponse((TosResponse)response));
            String symlinkTargetSize = response.getHeaderWithKeyIgnoreCase("x-tos-symlink-target-size");
            return StringUtils.isNotEmpty(symlinkTargetSize) ? output.setSymlinkTargetSize(Long.parseLong(symlinkTargetSize)) : output;
        });
    }

    public DeleteObjectOutput deleteObject(DeleteObjectInput input) throws TosException {
        boolean hns;
        ParamsChecker.ensureNotNull(input, "DeleteObjectInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        if (!input.isRecursive()) {
            RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("versionId", input.getVersionID());
            builder = this.handleGenericInput(builder, input);
            TosRequest req = this.factory.build(builder, "DELETE", null);
            return this.objectHandler.doRequest(req, 204, response -> new DeleteObjectOutput().setRequestInfo(response.RequestInfo()).setDeleteMarker(Boolean.parseBoolean(response.getHeaderWithKeyIgnoreCase("X-Tos-Delete-Marker"))).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")));
        }
        BucketType bucketType = this.getBucketType(input.getBucket());
        boolean bl = hns = bucketType != null && bucketType.getType().equals(BucketType.BUCKET_TYPE_HNS.getType());
        if (hns && this.isRecursiveByServer(input)) {
            RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("versionId", input.getVersionID()).withQuery("recursive", "true");
            builder = this.handleGenericInput(builder, input);
            TosRequest req = this.factory.build(builder, "DELETE", null);
            return this.objectHandler.doRequest(req, 204, response -> new DeleteObjectOutput().setRequestInfo(response.RequestInfo()));
        }
        return new RecursiveDeleter(input, hns, this).deleteRecursive();
    }

    private boolean isRecursiveByServer(DeleteObjectInput input) {
        try {
            Field f = input.getClass().getDeclaredField("recursiveByServer");
            f.setAccessible(true);
            return f.getBoolean(input);
        }
        catch (Exception e) {
            return false;
        }
    }

    public DeleteMultiObjectsV2Output deleteMultiObjects(DeleteMultiObjectsV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteMultiObjectsV2Input");
        ParamsChecker.ensureNotNull(input.getObjects(), "objects to be deleted");
        this.ensureValidBucketName(input.getBucket());
        for (ObjectTobeDeleted objectTobeDeleted : input.getObjects()) {
            this.ensureValidKey(objectTobeDeleted.getKey());
        }
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withHeader("Content-MD5", marshalResult.getContentMD5()).withQuery("delete", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "POST", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<DeleteMultiObjectsV2Output>(){}).requestInfo(response.RequestInfo()));
    }

    private PutObjectOutput putObject(PutObjectBasicInput input, InputStream content) {
        ParamsChecker.ensureNotNull(input, "PutObjectBasicInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        content = this.ensureNotNullContent(content);
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withHeader("x-tos-callback", input.getCallback()).withHeader("x-tos-callback-var", input.getCallbackVar()).withHeader("x-tos-if-match", input.getIfMatch()).withHeader("x-tos-tagging", input.getTagging());
        if (input.isForbidOverwrite()) {
            builder = builder.withHeader("x-tos-forbid-overwrite", "true");
        }
        if (input.getObjectExpires() >= 0L) {
            builder = builder.withHeader("x-tos-object-expires", Long.toString(input.getObjectExpires()));
        }
        this.addContentType(builder, input.getKey());
        builder = this.handleGenericInput(builder, input);
        boolean useTrailerHeader = this.prepareTrailerHeader(builder, input.getOptions(), input.getContentLength(), content);
        TosRequest req = this.factory.build(builder, "PUT", content).setEnableCrcCheck(this.enableCrcCheck).setRateLimiter(input.getRateLimiter()).setDataTransferListener(input.getDataTransferListener()).setReadLimit(input.getReadLimit()).setUseTrailerHeader(useTrailerHeader);
        TosObjectRequestHandler.setRetryStrategy(req, content);
        return this.objectHandler.doRequest(req, 200, this::buildPutObjectOutput);
    }

    private boolean prepareTrailerHeader(RequestBuilder builder, ObjectMetaRequestOptions options, long contentLength, InputStream content) {
        if (contentLength >= 0L) {
            builder.withContentLength(contentLength);
        } else if (StringUtils.isNotEmpty(builder.getHeaders().get("Content-Length"))) {
            try {
                long cl = Long.parseLong(builder.getHeaders().get("Content-Length"));
                builder.withContentLength(cl >= 0L ? cl : -1L);
            }
            catch (NumberFormatException e) {
                TosUtils.getLogger().debug("tos: try to get content length from header failed, ", (Throwable)e);
            }
        }
        if (content instanceof FileInputStream && contentLength < 0L) {
            try {
                FileChannel channel = ((FileInputStream)content).getChannel();
                builder.withContentLength(channel.size());
            }
            catch (IOException e) {
                TosUtils.getLogger().debug("tos: try to get content length from file failed, ", (Throwable)e);
            }
        }
        builder.setSkipTryResolveContentLength(true);
        if (!this.checkUseTrailerHeader(options, builder.getContentLength())) {
            return false;
        }
        builder.withHeader("X-Tos-Content-Sha256", "STREAMING-UNSIGNED-PAYLOAD-TRAILER");
        builder.withHeader("x-tos-trailer", "x-tos-hash-crc64ecma");
        if (options == null || StringUtils.isEmpty(options.getContentEncoding())) {
            builder.withHeader("Content-Encoding", "tos-chunked");
        } else {
            builder.withHeader("Content-Encoding", "tos-chunked," + options.getContentEncoding());
        }
        if (builder.getContentLength() > 0L) {
            builder.withHeader("x-tos-decoded-content-length", String.valueOf(builder.getContentLength()));
            builder.getHeaders().remove("Content-Length");
            builder.withContentLength(builder.getContentLength() + (long)Long.toHexString(builder.getContentLength()).length() + 1L + (long)"x-tos-hash-crc64ecma".length() + 1L + 12L + 10L);
        }
        return true;
    }

    private boolean checkUseTrailerHeader(ObjectMetaRequestOptions options, long contentLength) {
        if (contentLength == 0L) {
            return false;
        }
        boolean useTrailerHeader = this.useTrailerHeader;
        if (options != null && (StringUtils.isNotEmpty(options.getContentMD5()) || StringUtils.isNotEmpty(options.getContentSHA256()))) {
            useTrailerHeader = false;
        }
        return useTrailerHeader;
    }

    private InputStream ensureNotNullContent(InputStream content) {
        if (content == null) {
            content = new ByteArrayInputStream("".getBytes());
        }
        return content;
    }

    private static void setRetryStrategy(TosRequest request, InputStream stream) {
        boolean canRetry = stream.markSupported() || stream instanceof FileInputStream;
        request.setRetryableOnServerException(canRetry);
        request.setRetryableOnClientException(canRetry);
    }

    private PutObjectOutput buildPutObjectOutput(TosResponse res) {
        String callbackResult = StringUtils.toString(res.getInputStream(), "callbackResult");
        return new PutObjectOutput().setRequestInfo(res.RequestInfo()).setEtag(res.getHeaderWithKeyIgnoreCase("ETag")).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setHashCrc64ecma(res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma")).setSseCustomerAlgorithm(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSseCustomerKeyMD5(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")).setSseCustomerKey(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key")).setServerSideEncryption(res.getHeaderWithKeyIgnoreCase("x-tos-server-side-encryption")).setServerSideEncryptionKeyID(res.getHeaderWithKeyIgnoreCase("x-tos-server-side-encryption-kms-key-id")).setCallbackResult(callbackResult);
    }

    public PutObjectOutput putObject(PutObjectInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutObjectInput");
        if (input.getPutObjectBasicInput() != null) {
            input.getPutObjectBasicInput().setRequestHost(input.getRequestHost());
            input.getPutObjectBasicInput().setRequestDate(input.getRequestDate());
        }
        return this.putObject(input.getPutObjectBasicInput(), input.getContent());
    }

    public AppendObjectOutput appendObject(AppendObjectInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "AppendObjectInput");
        if (this.enableCrcCheck && input.getOffset() > 0L && StringUtils.isEmpty(input.getPreHashCrc64ecma())) {
            throw new TosClientException("tos: client enable crc64 check but preHashCrc64ecma is not set", null);
        }
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        BucketType bucketType = this.getBucketType(input.getBucket());
        if (bucketType != null && bucketType.getType().equals(BucketType.BUCKET_TYPE_HNS.getType())) {
            long trafficLimit;
            if (input.getOffset() == 0L && input.getContentLength() >= 0L) {
                try {
                    HeadObjectV2Input headInput = new HeadObjectV2Input().setBucket(input.getBucket()).setKey(input.getKey());
                    headInput.setRequestDate(input.getRequestDate());
                    headInput.setRequestHost(input.getRequestHost());
                    HeadObjectV2Output headOutput = this.headObject(headInput);
                    if (headOutput.getContentLength() > 0L) {
                        throw new TosClientException("tos: The object offset of this modify not matched.", null);
                    }
                    if (StringUtils.isEmpty(input.getIfMatch())) {
                        input.setIfMatch(headOutput.getEtag());
                    }
                }
                catch (TosServerException e) {
                    if (e.getStatusCode() == 404 && "0017-00000003".equals(e.getEc())) {
                        PutObjectInput pinput = new PutObjectInput().setBucket(input.getBucket()).setKey(input.getKey()).setContent(input.getContent()).setContentLength(input.getContentLength()).setDataTransferListener(input.getDataTransferListener()).setRateLimiter(input.getRateLimiter()).setIfMatch(input.getIfMatch()).setOptions(input.getOptions()).setForbidOverwrite(true);
                        pinput.setRequestDate(input.getRequestDate());
                        pinput.setRequestHost(input.getRequestHost());
                        PutObjectOutput poutput = this.putObject(pinput);
                        AppendObjectOutput aoutput = new AppendObjectOutput().setRequestInfo(poutput.getRequestInfo()).setHashCrc64ecma(poutput.getHashCrc64ecma());
                        aoutput.setNextAppendOffset(input.getContentLength());
                        return aoutput;
                    }
                    throw e;
                }
            }
            ModifyObjectInput minput = new ModifyObjectInput().setBucket(input.getBucket()).setKey(input.getKey()).setOffset(input.getOffset()).setContent(input.getContent()).setContentLength(input.getContentLength()).setDataTransferListener(input.getDataTransferListener()).setRateLimiter(input.getRateLimiter());
            minput.setRequestDate(input.getRequestDate());
            minput.setRequestHost(input.getRequestHost());
            if (input.getOptions() != null && (trafficLimit = input.getOptions().getTrafficLimit()) > 0L) {
                minput.setTrafficLimit(trafficLimit);
            }
            ModifyObjectOutput output = this.modifyObject(minput, input.getPreHashCrc64ecma(), this.enableCrcCheck);
            return new AppendObjectOutput().setRequestInfo(output.getRequestInfo()).setNextAppendOffset(output.getNextModifyOffset()).setHashCrc64ecma(output.getHashCrc64ecma());
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("append", "").withQuery("offset", String.valueOf(input.getOffset())).withContentLength(input.getContentLength()).withHeader("x-tos-if-match", input.getIfMatch());
        if (input.getObjectExpires() >= 0L) {
            builder = builder.withHeader("x-tos-object-expires", Long.toString(input.getObjectExpires()));
        }
        this.addContentType(builder, input.getKey());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "POST", input.getContent()).setRetryableOnServerException(false).setRetryableOnClientException(false).setEnableCrcCheck(this.enableCrcCheck).setCrc64InitValue(CRC64Utils.unsignedLongStringToLong(input.getPreHashCrc64ecma())).setRateLimiter(input.getRateLimiter()).setDataTransferListener(input.getDataTransferListener());
        return this.objectHandler.doRequest(req, 200, this::buildAppendObjectOutput);
    }

    private AppendObjectOutput buildAppendObjectOutput(TosResponse response) {
        long appendOffset;
        String nextOffset = response.getHeaderWithKeyIgnoreCase("X-Tos-Next-Append-Offset");
        try {
            appendOffset = Long.parseLong(nextOffset);
        }
        catch (NumberFormatException nfe) {
            throw new TosClientException("tos: server return unexpected Next-Append-Offset header: " + nextOffset, nfe);
        }
        return new AppendObjectOutput().setRequestInfo(response.RequestInfo()).setNextAppendOffset(appendOffset).setHashCrc64ecma(response.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    public SetObjectMetaOutput setObjectMeta(SetObjectMetaInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "SetObjectMetaInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("metadata", "").withQuery("versionId", input.getVersionID());
        if (input.getObjectExpires() >= 0L) {
            builder = builder.withHeader("x-tos-object-expires", Long.toString(input.getObjectExpires()));
        }
        this.addContentType(builder, input.getKey());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "POST", null);
        return this.objectHandler.doRequest(req, 200, response -> new SetObjectMetaOutput().setRequestInfo(response.RequestInfo()));
    }

    public ListObjectsV2Output listObjects(ListObjectsV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListObjectsV2Input");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("marker", input.getMarker()).withQuery("max-keys", TosUtils.convertInteger(input.getMaxKeys())).withQuery("reverse", String.valueOf(input.isReverse())).withQuery("encoding-type", input.getEncodingType());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListObjectsV2Output>(){}).setRequestInfo(response.RequestInfo()));
    }

    public ListObjectsType2Output listObjectsType2(ListObjectsType2Input input) throws TosException {
        TosRequest req;
        ListObjectsType2Output output;
        ParamsChecker.ensureNotNull(input, "ListObjectsType2Input");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("list-type", "2").withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("start-after", input.getStartAfter()).withQuery("continuation-token", input.getContinuationToken()).withQuery("max-keys", TosUtils.convertInteger(input.getMaxKeys())).withQuery("encoding-type", input.getEncodingType()).withQuery("fetch-owner", "true");
        if (input.isFetchMeta()) {
            builder = builder.withQuery("fetch-meta", "true");
        }
        if ((output = this.objectHandler.doRequest(req = this.factory.build(builder = this.handleGenericInput(builder, input), "GET", null), 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListObjectsType2Output>(){}).setRequestInfo(response.RequestInfo()))).getContents() != null && output.getContents().size() > 0 && this.disableEncodingMeta) {
            for (ListedObjectV2 obj : output.getContents()) {
                try {
                    Field f = obj.getClass().getDeclaredField("disableEncodingMeta");
                    f.setAccessible(true);
                    f.set(obj, true);
                }
                catch (Exception exception) {}
            }
        }
        return output;
    }

    public ListObjectsType2Output listObjectsType2UntilFinished(ListObjectsType2Input input) {
        ParamsChecker.ensureNotNull(input, "ListObjectsType2Input");
        if (input.isListOnlyOnce()) {
            return this.listObjectsType2(input);
        }
        int mk = input.getMaxKeys() > 0 ? input.getMaxKeys() : 1000;
        int totalRecords = 0;
        List<ListedCommonPrefix> commonPrefixes = null;
        List<ListedObjectV2> contents = null;
        ListObjectsType2Output tmp = null;
        String continuationToken = input.getContinuationToken();
        boolean listFinished = false;
        while (!listFinished) {
            tmp = this.listObjectsType2(input.setContinuationToken(continuationToken));
            if (tmp.getCommonPrefixes() != null) {
                if (commonPrefixes == null) {
                    commonPrefixes = tmp.getCommonPrefixes();
                } else {
                    commonPrefixes.addAll(tmp.getCommonPrefixes());
                }
            }
            if (tmp.getContents() != null) {
                if (contents == null) {
                    contents = tmp.getContents();
                } else {
                    contents.addAll(tmp.getContents());
                }
            }
            continuationToken = tmp.getNextContinuationToken();
            listFinished = this.isListFinished(tmp.isTruncated(), mk, totalRecords += tmp.getKeyCount());
        }
        return tmp.setCommonPrefixes(commonPrefixes).setContents(contents).setKeyCount(totalRecords);
    }

    private boolean isListFinished(boolean isTruncated, int mk, int totalRecords) {
        boolean returnMaxKeysRecord = mk == totalRecords;
        return returnMaxKeysRecord || !isTruncated;
    }

    public ListObjectVersionsV2Output listObjectVersions(ListObjectVersionsV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListObjectVersionsV2Input");
        this.ensureValidBucketName(input.getBucket());
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("key-marker", input.getKeyMarker()).withQuery("max-keys", TosUtils.convertInteger(input.getMaxKeys())).withQuery("encoding-type", input.getEncodingType()).withQuery("version-id-marker", input.getVersionIDMarker()).withQuery("versions", "");
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListObjectVersionsV2Output>(){}).setRequestInfo(response.RequestInfo()));
    }

    public CopyObjectV2Output copyObject(CopyObjectV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "CopyObjectV2Input");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        this.ensureValidBucketName(input.getSrcBucket());
        this.ensureValidKey(input.getSrcKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("versionId", input.getSrcVersionID());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.buildWithCopy(builder, "PUT", input.getSrcBucket(), input.getSrcKey());
        return this.objectHandler.doRequest(req, 200, this::buildCopyObjectV2Output);
    }

    private CopyObjectV2Output buildCopyObjectV2Output(TosResponse response) {
        String rspMsg = StringUtils.toString(response.getInputStream(), "copy result");
        try {
            CopyObjectV2Output output = PayloadConverter.parsePayload(rspMsg, new TypeReference<CopyObjectV2Output>(){});
            return output.setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setSourceVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Copy-Source-Version-Id")).setHashCrc64ecma(response.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma")).setSsecAlgorithm(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSsecKeyMD5(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")).setServerSideEncryption(response.getHeaderWithKeyIgnoreCase("x-tos-server-side-encryption")).setServerSideEncryptionKeyID(response.getHeaderWithKeyIgnoreCase("x-tos-server-side-encryption-kms-key-id"));
        }
        catch (TosClientException e) {
            ServerExceptionJson errMsg = PayloadConverter.parsePayload(rspMsg, new TypeReference<ServerExceptionJson>(){});
            throw new TosServerException(response.getStatusCode(), errMsg.getCode(), errMsg.getMessage(), errMsg.getRequestID(), errMsg.getHostID()).setEc(errMsg.getEc()).setKey(errMsg.getKey());
        }
    }

    public UploadPartCopyV2Output uploadPartCopy(UploadPartCopyV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "UploadPartCopyV2Input");
        ParamsChecker.ensureNotNull(input.getUploadID(), "UploadID");
        ParamsChecker.isValidPartNumber(input.getPartNumber());
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        this.ensureValidBucketName(input.getSourceBucket());
        this.ensureValidKey(input.getSourceKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("partNumber", TosUtils.convertInteger(input.getPartNumber())).withQuery("uploadId", input.getUploadID()).withQuery("versionId", input.getSourceVersionID());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.buildWithCopy(builder, "PUT", input.getSourceBucket(), input.getSourceKey());
        return this.objectHandler.doRequest(req, 200, response -> this.buildUploadPartCopyV2Output(input, (TosResponse)response));
    }

    private UploadPartCopyV2Output buildUploadPartCopyV2Output(UploadPartCopyV2Input input, TosResponse response) {
        String rspMsg = StringUtils.toString(response.getInputStream(), "copy result");
        try {
            UploadPartCopyOutputJson out = PayloadConverter.parsePayload(rspMsg, new TypeReference<UploadPartCopyOutputJson>(){});
            return new UploadPartCopyV2Output().requestInfo(response.RequestInfo()).copySourceVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Copy-Source-Version-Id")).setServerSideEncryptionKeyID(response.getHeaderWithKeyIgnoreCase("x-tos-server-side-encryption")).setServerSideEncryptionKeyID(response.getHeaderWithKeyIgnoreCase("x-tos-server-side-encryption-kms-key-id")).setSsecAlgorithm(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSsecKeyMD5(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")).partNumber(input.getPartNumber()).etag(out.getEtag()).lastModified(out.getLastModified());
        }
        catch (TosClientException e) {
            ServerExceptionJson errMsg = PayloadConverter.parsePayload(rspMsg, new TypeReference<ServerExceptionJson>(){});
            throw new TosServerException(response.getStatusCode(), errMsg.getCode(), errMsg.getMessage(), errMsg.getRequestID(), errMsg.getHostID()).setEc(errMsg.getEc()).setKey(errMsg.getKey());
        }
    }

    public PutObjectACLOutput putObjectAcl(PutObjectACLInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutObjectACLInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("acl", "").withQuery("versionId", input.getVersionID()).withHeader("X-Tos-Acl", input.getAcl() == null ? null : input.getAcl().toString()).withHeader("X-Tos-Grant-Full-Control", input.getGrantFullControl()).withHeader("X-Tos-Grant-Read", input.getGrantRead()).withHeader("X-Tos-Grant-Read-Acp", input.getGrantReadAcp()).withHeader("X-Tos-Grant-Write-Acp", input.getGrantWriteAcp());
        byte[] content = new byte[]{};
        if (input.getObjectAclRules() != null) {
            TosMarshalResult res = PayloadConverter.serializePayloadAndComputeMD5(input.getObjectAclRules());
            content = res.getData();
            builder.withHeader("Content-MD5", res.getContentMD5());
        }
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(content)).setContentLength(content.length);
        return this.objectHandler.doRequest(req, 200, response -> new PutObjectACLOutput().requestInfo(response.RequestInfo()));
    }

    public GetObjectACLV2Output getObjectAcl(GetObjectACLV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetObjectACLV2Input");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("acl", "").withQuery("versionId", input.getVersionID());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, this::buildGetObjectACLV2Output);
    }

    private GetObjectACLV2Output buildGetObjectACLV2Output(TosResponse response) {
        return PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<GetObjectACLV2Output>(){}).setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id"));
    }

    public PutObjectTaggingOutput putObjectTagging(PutObjectTaggingInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutObjectTaggingInput");
        ParamsChecker.ensureNotNull(input.getTagSet(), "TagSet");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("tagging", "").withQuery("versionId", input.getVersionID()).withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.objectHandler.doRequest(req, 200, response -> new PutObjectTaggingOutput().setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")));
    }

    public GetObjectTaggingOutput getObjectTagging(GetObjectTaggingInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetObjectTaggingInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("tagging", "").withQuery("versionId", input.getVersionID());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, res -> PayloadConverter.parsePayload(res.getInputStream(), new TypeReference<GetObjectTaggingOutput>(){}).setRequestInfo(res.RequestInfo()).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")));
    }

    public DeleteObjectTaggingOutput deleteObjectTagging(DeleteObjectTaggingInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "DeleteObjectTaggingInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("tagging", "").withQuery("versionId", input.getVersionID());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null);
        return this.objectHandler.doRequest(req, 204, res -> new DeleteObjectTaggingOutput().setRequestInfo(res.RequestInfo()).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")));
    }

    public FetchObjectOutput fetchObject(FetchObjectInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "FetchObjectInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        ParamsChecker.ensureNotNull(input.getUrl(), "URL");
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("fetch", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "POST", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<FetchObjectOutput>(){}).setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setSsecAlgorithm(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSsecKeyMD5(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")));
    }

    public PutFetchTaskOutput putFetchTask(PutFetchTaskInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutFetchTaskInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        ParamsChecker.ensureNotNull(input.getUrl(), "URL");
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), "", input.getAllSettedHeaders()).withQuery("fetchTask", "").withHeader("Content-MD5", marshalResult.getContentMD5());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "POST", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<PutFetchTaskOutput>(){}).setRequestInfo(response.RequestInfo()));
    }

    public GetFetchTaskOutput getFetchTask(GetFetchTaskInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetFetchTaskInput");
        this.ensureValidBucketName(input.getBucket());
        if (StringUtils.isEmpty(input.getTaskId())) {
            throw new TosClientException("empty task id", null);
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("fetchTask", "").withQuery("taskId", input.getTaskId());
        TosRequest req = this.factory.build(builder = this.handleGenericInput(builder, input), "GET", null);
        GetFetchTaskOutput output = this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<GetFetchTaskOutput>(){}).setRequestInfo(response.RequestInfo()));
        if (output.getTask() != null && output.getTask().getMeta() != null && output.getTask().getMeta().size() > 0 && this.disableEncodingMeta) {
            try {
                Field f = output.getTask().getClass().getDeclaredField("disableEncodingMeta");
                f.setAccessible(true);
                f.set(output.getTask(), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return output;
    }

    public CreateMultipartUploadOutput createMultipartUpload(CreateMultipartUploadInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "CreateMultipartUploadInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("uploads", "").withHeader("x-tos-tagging", input.getTagging());
        if (input.getObjectExpires() >= 0L) {
            builder = builder.withHeader("x-tos-object-expires", String.valueOf(input.getObjectExpires()));
        }
        this.addContentType(builder, input.getKey());
        if (input.isForbidOverwrite()) {
            builder = builder.withHeader("x-tos-forbid-overwrite", "true");
        }
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "POST", null).setRetryableOnClientException(false);
        return this.objectHandler.doRequest(req, 200, this::buildCreateMultipartUploadOutput);
    }

    private CreateMultipartUploadOutput buildCreateMultipartUploadOutput(TosResponse response) {
        CreateMultipartUploadOutputJson upload = PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<CreateMultipartUploadOutputJson>(){});
        return new CreateMultipartUploadOutput().setRequestInfo(response.RequestInfo()).setBucket(upload.getBucket()).setKey(upload.getKey()).setUploadID(upload.getUploadID()).setEncodingType(upload.getEncodingType()).setSseCustomerAlgorithm(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSseCustomerMD5(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")).setSseCustomerKey(response.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key")).setServerSideEncryption(response.getHeaderWithKeyIgnoreCase("x-tos-server-side-encryption")).setServerSideEncryptionKeyID(response.getHeaderWithKeyIgnoreCase("x-tos-server-side-encryption-kms-key-id"));
    }

    private UploadPartV2Output buildUploadPartV2Output(TosResponse res, int partNumber) {
        return new UploadPartV2Output().setRequestInfo(res.RequestInfo()).setPartNumber(partNumber).setEtag(res.getHeaderWithKeyIgnoreCase("ETag")).setSsecAlgorithm(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Algorithm")).setSsecKeyMD5(res.getHeaderWithKeyIgnoreCase("X-Tos-Server-Side-Encryption-Customer-Key-MD5")).setServerSideEncryption(res.getHeaderWithKeyIgnoreCase("x-tos-server-side-encryption")).setServerSideEncryptionKeyID(res.getHeaderWithKeyIgnoreCase("x-tos-server-side-encryption-kms-key-id")).setHashCrc64ecma(res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    private UploadPartV2Output uploadPart(UploadPartBasicInput input, long contentLength, InputStream content) {
        ParamsChecker.ensureNotNull(input, "UploadPartBasicInput");
        ParamsChecker.ensureNotNull(input.getUploadID(), "uploadID");
        ParamsChecker.ensureNotNull(content, "InputStream");
        ParamsChecker.isValidPartNumber(input.getPartNumber());
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), input.getAllSettedHeaders()).withQuery("uploadId", input.getUploadID()).withQuery("partNumber", TosUtils.convertInteger(input.getPartNumber()));
        builder = this.handleGenericInput(builder, input);
        boolean useTrailerHeader = this.prepareTrailerHeader(builder, input.getOptions(), contentLength, content);
        TosRequest req = this.factory.build(builder, "PUT", content).setEnableCrcCheck(this.enableCrcCheck).setRateLimiter(input.getRateLimiter()).setDataTransferListener(input.getDataTransferListener()).setReadLimit(input.getReadLimit()).setUseTrailerHeader(useTrailerHeader);
        TosObjectRequestHandler.setRetryStrategy(req, content);
        return this.objectHandler.doRequest(req, 200, response -> this.buildUploadPartV2Output((TosResponse)response, input.getPartNumber()));
    }

    public UploadPartV2Output uploadPart(UploadPartV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "UploadPartV2Input");
        if (input.getUploadPartBasicInput() != null) {
            input.getUploadPartBasicInput().setRequestDate(input.getRequestDate());
            input.getUploadPartBasicInput().setRequestHost(input.getRequestHost());
        }
        return this.uploadPart(input.getUploadPartBasicInput(), input.getContentLength(), input.getContent());
    }

    public CompleteMultipartUploadV2Output completeMultipartUpload(CompleteMultipartUploadV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "CompleteMultipartUploadV2Input");
        ParamsChecker.ensureNotNull(input.getUploadID(), "uploadID");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("uploadId", input.getUploadID()).withHeader("x-tos-callback", input.getCallback()).withHeader("x-tos-callback-var", input.getCallbackVar());
        if (input.isForbidOverwrite()) {
            builder = builder.withHeader("x-tos-forbid-overwrite", "true");
        }
        String contentMd5 = null;
        byte[] data = new byte[]{};
        if (!input.isCompleteAll()) {
            this.ensureUploadedPartsNotNull(input);
            TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
            contentMd5 = marshalResult.getContentMD5();
            data = marshalResult.getData();
        } else {
            this.ensureUploadedPartsNull(input);
            builder.withHeader("x-tos-complete-all", "yes");
        }
        builder.withHeader("Content-MD5", contentMd5);
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "POST", new ByteArrayInputStream(data)).setContentLength(data.length).setRetryableOnClientException(false);
        ArrayList<Integer> unexpectedCodes = new ArrayList<Integer>();
        unexpectedCodes.add(203);
        return this.objectHandler.doRequest(req, 200, unexpectedCodes, response -> {
            boolean hasCallbackResult = StringUtils.isNotEmpty(input.getCallback());
            return this.buildCompleteMultipartUploadOutput((TosResponse)response, hasCallbackResult);
        });
    }

    private void ensureUploadedPartsNull(CompleteMultipartUploadV2Input input) {
        if (input != null && input.getUploadedParts() != null && input.getUploadedParts().size() != 0) {
            throw new TosClientException("tos: you should not set uploadedParts while using completeAll.", null);
        }
    }

    private void ensureUploadedPartsNotNull(CompleteMultipartUploadV2Input input) {
        if (input == null || input.getUploadedParts() == null || input.getUploadedParts().size() == 0) {
            throw new TosClientException("tos: you must specify at least one part.", null);
        }
    }

    private CompleteMultipartUploadV2Output buildCompleteMultipartUploadOutput(TosResponse response, boolean hasCallbackResult) {
        String respBody = StringUtils.toString(response.getInputStream(), "response body");
        CompleteMultipartUploadV2Output output = new CompleteMultipartUploadV2Output();
        if (hasCallbackResult) {
            output.setCallbackResult(respBody);
            output.setEtag(response.getHeaderWithKeyIgnoreCase("ETag"));
            output.setLocation(response.getHeaderWithKeyIgnoreCase("Location"));
        } else {
            output = PayloadConverter.parsePayload(respBody, new TypeReference<CompleteMultipartUploadV2Output>(){});
        }
        return output.setRequestInfo(response.RequestInfo()).setVersionID(response.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setServerSideEncryption("x-tos-server-side-encryption").setServerSideEncryptionKeyID("x-tos-server-side-encryption-kms-key-id").setHashCrc64ecma(response.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
    }

    public AbortMultipartUploadOutput abortMultipartUpload(AbortMultipartUploadInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "AbortMultipartUploadInput");
        ParamsChecker.ensureNotNull(input.getUploadID(), "uploadID");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("uploadId", input.getUploadID());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "DELETE", null).setRetryableOnClientException(false);
        return this.objectHandler.doRequest(req, 204, response -> new AbortMultipartUploadOutput().setRequestInfo(response.RequestInfo()));
    }

    public ListPartsOutput listParts(ListPartsInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListPartsInput");
        ParamsChecker.ensureNotNull(input.getUploadID(), "uploadID");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        if (input.getMaxParts() < 0 || input.getPartNumberMarker() < 0) {
            throw new TosClientException("ListPartsInput maxParts or partNumberMarker is small than 0", null);
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("uploadId", input.getUploadID()).withQuery("max-parts", TosUtils.convertInteger(input.getMaxParts())).withQuery("part-number-marker", TosUtils.convertInteger(input.getPartNumberMarker())).withQuery("encoding-type", input.getEncodingType());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListPartsOutput>(){}).setRequestInfo(response.RequestInfo()));
    }

    public ListMultipartUploadsV2Output listMultipartUploads(ListMultipartUploadsV2Input input) throws TosException {
        ParamsChecker.ensureNotNull(input, "ListMultipartUploadsV2Input");
        this.ensureValidBucketName(input.getBucket());
        if (input.getMaxUploads() < 0) {
            throw new TosClientException("ListMultipartUploadsV2Input maxUploads is small than 0", null);
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), "", null).withQuery("uploads", "").withQuery("prefix", input.getPrefix()).withQuery("delimiter", input.getDelimiter()).withQuery("key-marker", input.getKeyMarker()).withQuery("upload-id-marker", input.getUploadIDMarker()).withQuery("max-uploads", TosUtils.convertInteger(input.getMaxUploads())).withQuery("encoding-type", input.getEncodingType());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, response -> PayloadConverter.parsePayload(response.getInputStream(), new TypeReference<ListMultipartUploadsV2Output>(){}).setRequestInfo(response.RequestInfo()));
    }

    public RenameObjectOutput renameObject(RenameObjectInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "RenameObjectInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        this.ensureValidKey(input.getNewKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("name", input.getNewKey()).withQuery("rename", "");
        if (input.isForbidOverwrite()) {
            builder = builder.withHeader("x-tos-forbid-overwrite", "true");
        }
        if (input.isRecursiveMkdir()) {
            builder = builder.withHeader("x-tos-recursive-mkdir", "true");
        }
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "PUT", null);
        return this.objectHandler.doRequest(req, 204, response -> new RenameObjectOutput().setRequestInfo(response.RequestInfo()));
    }

    public RestoreObjectOutput restoreObject(RestoreObjectInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "RestoreObjectInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        TosMarshalResult marshalResult = PayloadConverter.serializePayloadAndComputeMD5(input);
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withHeader("Content-MD5", marshalResult.getContentMD5()).withQuery("restore", "").withQuery("versionId", input.getVersionID());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "POST", new ByteArrayInputStream(marshalResult.getData())).setContentLength(marshalResult.getData().length);
        return this.objectHandler.doRequest(req, this.restoreObjectExceptedCodes(), response -> new RestoreObjectOutput().setRequestInfo(response.RequestInfo()));
    }

    public PutSymlinkOutput putSymlink(PutSymlinkInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "PutSymlinkInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        if (StringUtils.isEmpty(input.getSymlinkTargetKey())) {
            throw new TosClientException("empty symlink target key", null);
        }
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("symlink", "").withHeader("x-tos-symlink-bucket", input.getSymlinkTargetBucket()).withHeader("X-Tos-Acl", input.getAcl() == null ? null : input.getAcl().toString()).withHeader("X-Tos-Storage-Class", input.getStorageClass() == null ? null : input.getStorageClass().toString());
        try {
            builder = builder.withHeader("x-tos-symlink-target", URLEncoder.encode(input.getSymlinkTargetKey(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new TosClientException("encoding symlink target key failed", e);
        }
        if (input.isForbidOverwrite()) {
            builder = builder.withHeader("x-tos-forbid-overwrite", "true");
        }
        if (input.getMeta() != null) {
            for (Map.Entry<String, String> entry : input.getMeta().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!StringUtils.isNotEmpty(value)) continue;
                builder = builder.withHeader("X-Tos-Meta-" + key, value);
            }
        }
        builder = builder.withHeader("Cache-Control", input.getCacheControl()).withHeader("Content-Disposition", input.getContentDisposition()).withHeader("Content-Encoding", input.getContentEncoding()).withHeader("Content-Language", input.getContentLanguage()).withHeader("Content-Type", input.getContentType()).withHeader("Expires", DateConverter.dateToRFC1123String(input.getExpires())).withHeader("x-tos-tagging", input.getTagging());
        builder = this.handleGenericInput(builder, input);
        this.addContentType(builder, input.getKey());
        TosRequest req = this.factory.build(builder, "PUT", null).setContentLength(0L);
        return this.objectHandler.doRequest(req, 200, res -> new PutSymlinkOutput().setRequestInfo(res.RequestInfo()).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")));
    }

    public GetSymlinkOutput getSymlink(GetSymlinkInput input) throws TosException {
        ParamsChecker.ensureNotNull(input, "GetSymlinkInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("symlink", "").withQuery("versionId", input.getVersionID());
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "GET", null);
        return this.objectHandler.doRequest(req, 200, res -> {
            String symlinkTargetKey = null;
            try {
                symlinkTargetKey = URLDecoder.decode(res.getHeaderWithKeyIgnoreCase("x-tos-symlink-target"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new TosClientException("decode symlink target key failed", e);
            }
            return new GetSymlinkOutput().setRequestInfo(res.RequestInfo()).setVersionID(res.getHeaderWithKeyIgnoreCase("X-Tos-Version-Id")).setSymlinkTargetKey(symlinkTargetKey).setSymlinkTargetBucket(res.getHeaderWithKeyIgnoreCase("x-tos-symlink-bucket")).setLastModified(DateConverter.rfc1123StringToDate(res.getHeaderWithKeyIgnoreCase("Last-Modified")));
        });
    }

    public ModifyObjectOutput modifyObject(ModifyObjectInput input, String preHashCrc64ecma, boolean enableCrcCheck) {
        ParamsChecker.ensureNotNull(input, "ModifyObjectInput");
        this.ensureValidBucketName(input.getBucket());
        this.ensureValidKey(input.getKey());
        InputStream content = this.ensureNotNullContent(input.getContent());
        RequestBuilder builder = this.factory.init(input.getBucket(), input.getKey(), null).withQuery("modify", "").withQuery("offset", String.valueOf(input.getOffset())).withContentLength(input.getContentLength());
        if (input.getTrafficLimit() > 0L) {
            builder = builder.withHeader("x-tos-traffic-limit", String.valueOf(input.getTrafficLimit()));
        }
        builder = this.handleGenericInput(builder, input);
        TosRequest req = this.factory.build(builder, "POST", content).setRetryableOnServerException(false).setRetryableOnClientException(false).setRateLimiter(input.getRateLimiter()).setEnableCrcCheck(enableCrcCheck).setCrc64InitValue(CRC64Utils.unsignedLongStringToLong(preHashCrc64ecma)).setDataTransferListener(input.getDataTransferListener());
        return this.objectHandler.doRequest(req, 200, res -> {
            String nextModifyOffset = res.getHeaderWithKeyIgnoreCase("x-tos-next-modify-offset");
            try {
                return new ModifyObjectOutput().setRequestInfo(res.RequestInfo()).setNextModifyOffset(Long.parseLong(nextModifyOffset)).setHashCrc64ecma(res.getHeaderWithKeyIgnoreCase("x-tos-hash-crc64ecma"));
            }
            catch (NumberFormatException nfe) {
                throw new TosClientException("tos: server return unexpected Next-Modify-Offset header: " + nextModifyOffset, nfe);
            }
        });
    }

    private List<Integer> restoreObjectExceptedCodes() {
        ArrayList<Integer> expectedCodes = new ArrayList<Integer>();
        expectedCodes.add(200);
        expectedCodes.add(202);
        return expectedCodes;
    }

    private void addContentType(RequestBuilder rb, String objectKey) throws TosClientException {
        String contentType = rb.getHeaders().get("Content-Type");
        if (StringUtils.isEmpty(contentType) && this.clientAutoRecognizeContentType && rb.isAutoRecognizeContentType()) {
            contentType = MimeType.getInstance().getMimetype(objectKey);
            rb.withHeader("Content-Type", contentType);
        }
    }

    private void ensureValidBucketName(String bucket) {
        if (this.factory.isCustomDomain()) {
            return;
        }
        ParamsChecker.isValidBucketName(bucket);
    }

    private void ensureValidKey(String key) {
        ParamsChecker.isValidKey(key);
    }

    private static class BucketCacheLock {
        Map<String, BucketCache> bucketTypes;
        ReadWriteLock lock;

        private BucketCacheLock() {
        }
    }

    private static class BucketCache {
        BucketType bucketType;
        long lastUpdateTimeNanos;
        double timeout;

        private BucketCache() {
        }
    }
}

