/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal.util;

import com.volcengine.tos.internal.util.IWaitGroup;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class WaitGroup
implements IWaitGroup {
    private final AtomicLong al = new AtomicLong(0L);
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();

    @Override
    public void addUninterruptibly() {
        this.addUninterruptibly(1);
    }

    @Override
    public void addUninterruptibly(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Count must be greater than 0");
        }
        this.al.addAndGet(n);
    }

    @Override
    public void awaitUninterruptibly() {
        this.lock.lock();
        try {
            while (this.al.get() != 0L) {
                this.cond.awaitUninterruptibly();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void add() throws InterruptedException {
        this.add(1);
    }

    @Override
    public void add(int n) throws InterruptedException {
        if (n <= 0) {
            throw new IllegalArgumentException("Count must be greater than 0");
        }
        this.al.addAndGet(n);
    }

    @Override
    public void await() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.al.get() != 0L) {
                this.cond.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void done() {
        this.done(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Count must be greater than 0");
        }
        long newValue = this.al.addAndGet(-n);
        if (newValue < 0L) {
            throw new IllegalStateException("Count has gone negative");
        }
        if (newValue == 0L) {
            this.lock.lock();
            try {
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

