/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.model.object;

import com.volcengine.tos.TosException;
import com.volcengine.tos.model.GenericInput;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Output;

public class DeleteObjectInput
extends GenericInput {
    private String bucket;
    private String key;
    private String versionID;
    private boolean recursive;
    private boolean recursiveByServer;
    private boolean skipTrash;
    private DeleteObjectRecursiveOption recursiveOption;

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getVersionID() {
        return this.versionID;
    }

    public DeleteObjectInput setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public DeleteObjectInput setKey(String key) {
        this.key = key;
        return this;
    }

    public DeleteObjectInput setVersionID(String versionID) {
        this.versionID = versionID;
        return this;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public DeleteObjectInput setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public boolean isSkipTrash() {
        return this.skipTrash;
    }

    public DeleteObjectInput setSkipTrash(boolean skipTrash) {
        this.skipTrash = skipTrash;
        return this;
    }

    public DeleteObjectRecursiveOption getRecursiveOption() {
        return this.recursiveOption;
    }

    public DeleteObjectInput setRecursiveOption(DeleteObjectRecursiveOption recursiveOption) {
        this.recursiveOption = recursiveOption;
        return this;
    }

    public String toString() {
        return "DeleteObjectInput{bucket='" + this.bucket + '\'' + ", key='" + this.key + '\'' + ", versionID='" + this.versionID + '\'' + ", recursive=" + this.recursive + ", skipTrash=" + this.skipTrash + ", recursiveOption=" + this.recursiveOption + ", skipTrash=" + this.skipTrash + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static interface DeleteMultiObjectsEventListener {
        public void eventChange(DeleteMultiObjectsEvent var1);
    }

    public static class DeleteMultiObjectsEvent {
        private final String bucket;
        private final DeleteMultiObjectsV2Output output;
        private final TosException err;

        public DeleteMultiObjectsEvent(String bucket, DeleteMultiObjectsV2Output output, TosException err) {
            this.bucket = bucket;
            this.output = output;
            this.err = err;
        }

        public String getBucket() {
            return this.bucket;
        }

        public DeleteMultiObjectsV2Output getOutput() {
            return this.output;
        }

        public TosException getErr() {
            return this.err;
        }

        public String toString() {
            return "DeleteMultiObjectsEvent{bucket='" + this.bucket + '\'' + ", output=" + this.output + ", err=" + this.err + '}';
        }
    }

    public static class DeleteObjectRecursiveOption {
        private int batchDeleteSize = 100;
        private int batchDeleteTaskNum = 1;
        private DeleteMultiObjectsEventListener eventListener = event -> {};
        private int deleteFailedRetryCount;
        private boolean forceUseHns;

        public int getBatchDeleteSize() {
            return this.batchDeleteSize;
        }

        public DeleteObjectRecursiveOption setBatchDeleteSize(int batchDeleteSize) {
            this.batchDeleteSize = batchDeleteSize;
            return this;
        }

        public int getBatchDeleteTaskNum() {
            return this.batchDeleteTaskNum;
        }

        public DeleteObjectRecursiveOption setBatchDeleteTaskNum(int batchDeleteTaskNum) {
            this.batchDeleteTaskNum = batchDeleteTaskNum;
            return this;
        }

        public DeleteMultiObjectsEventListener getEventListener() {
            return this.eventListener;
        }

        public DeleteObjectRecursiveOption setEventListener(DeleteMultiObjectsEventListener eventListener) {
            this.eventListener = eventListener;
            return this;
        }

        public int getDeleteFailedRetryCount() {
            return this.deleteFailedRetryCount;
        }

        public DeleteObjectRecursiveOption setDeleteFailedRetryCount(int deleteFailedRetryCount) {
            this.deleteFailedRetryCount = deleteFailedRetryCount;
            return this;
        }

        public String toString() {
            return "DeleteObjectRecursiveOption{batchDeleteSize=" + this.batchDeleteSize + ", batchDeleteTaskNum=" + this.batchDeleteTaskNum + ", eventListener=" + this.eventListener + ", deleteFailedRetryCount=" + this.deleteFailedRetryCount + '}';
        }
    }

    public static final class Builder {
        private String bucket;
        private String key;
        private String versionID;
        private boolean recursive;
        private boolean skipTrash;
        private DeleteObjectRecursiveOption recursiveOption;

        private Builder() {
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder versionID(String versionID) {
            this.versionID = versionID;
            return this;
        }

        public Builder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public Builder skipTrash(boolean skipTrash) {
            this.skipTrash = skipTrash;
            return this;
        }

        public Builder RecursiveOption(DeleteObjectRecursiveOption recursiveOption) {
            this.recursiveOption = recursiveOption;
            return this;
        }

        public DeleteObjectInput build() {
            DeleteObjectInput deleteObjectInput = new DeleteObjectInput();
            deleteObjectInput.bucket = this.bucket;
            deleteObjectInput.versionID = this.versionID;
            deleteObjectInput.key = this.key;
            deleteObjectInput.recursive = this.recursive;
            deleteObjectInput.skipTrash = this.skipTrash;
            deleteObjectInput.recursiveOption = this.recursiveOption;
            return deleteObjectInput;
        }
    }
}

