/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.internal;

import com.volcengine.tos.auth.Signer;
import com.volcengine.tos.internal.RequestBuilder;
import com.volcengine.tos.internal.TosRequest;
import com.volcengine.tos.internal.util.ParamsChecker;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.internal.util.TosUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class TosRequestFactory {
    private Signer signer;
    private String scheme;
    private String host;
    private int port;
    private String controlScheme;
    private String controlHost;
    private int urlMode = 0;
    private boolean isCustomDomain;
    private boolean disableEncodingMeta;
    private String userAgent;

    public TosRequestFactory(Signer signer, String endpoint) {
        this.signer = signer;
        this.parseEndpoint(endpoint);
    }

    private void parseEndpoint(String endpoint) {
        List<String> schemeAndHost = ParamsChecker.parseFromEndpoint(endpoint);
        this.scheme = schemeAndHost.get(0);
        this.host = schemeAndHost.get(1);
        if (ParamsChecker.isLocalhostOrIpAddress(this.host)) {
            this.urlMode = 1;
            this.port = ParamsChecker.parsePort(this.host);
            if (this.port != 0) {
                int lastIdx = this.host.length() - String.valueOf(this.port).length() - 1;
                this.host = this.host.substring(0, lastIdx);
            }
        }
    }

    private void parseControlEndpoint(String controlEndpoint) {
        List<String> schemeAndHost = ParamsChecker.parseFromEndpoint(controlEndpoint);
        this.controlScheme = schemeAndHost.get(0);
        this.controlHost = schemeAndHost.get(1);
    }

    public Signer getSigner() {
        return this.signer;
    }

    public TosRequestFactory setSigner(Signer signer) {
        this.signer = signer;
        return this;
    }

    public TosRequestFactory setEndpoint(String endpoint) {
        this.parseEndpoint(endpoint);
        return this;
    }

    public TosRequestFactory setControlEndpoint(String controlEndpoint) {
        if (StringUtils.isNotEmpty(controlEndpoint)) {
            this.parseControlEndpoint(controlEndpoint);
        }
        return this;
    }

    public int getUrlMode() {
        return this.urlMode;
    }

    public TosRequestFactory setUrlMode(int urlMode) {
        this.urlMode = urlMode;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public TosRequestFactory setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public TosRequestFactory setHost(String host) {
        this.host = host;
        return this;
    }

    public String getControlScheme() {
        return this.controlScheme;
    }

    public TosRequestFactory setControlScheme(String controlScheme) {
        this.controlScheme = controlScheme;
        return this;
    }

    public String getControlHost() {
        return this.controlHost;
    }

    public TosRequestFactory setControlHost(String controlHost) {
        this.controlHost = controlHost;
        return this;
    }

    public boolean isCustomDomain() {
        return this.isCustomDomain;
    }

    public TosRequestFactory setIsCustomDomain(boolean isCustomDomain) {
        this.isCustomDomain = isCustomDomain;
        if (this.isCustomDomain) {
            this.urlMode = 2;
        }
        return this;
    }

    public TosRequestFactory setDisableEncodingMeta(boolean disableEncodingMeta) {
        this.disableEncodingMeta = disableEncodingMeta;
        return this;
    }

    public TosRequestFactory setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public RequestBuilder init(String bucket, String object, Map<String, String> headers) {
        return this.newBuilder(bucket, object, headers).setUrlMode(this.urlMode).setPort(this.port);
    }

    public RequestBuilder initControlReq(String accountId, String controlApiPath, Map<String, String> headers) {
        return this.newControlReqBuilder(accountId, controlApiPath, headers).setUrlMode(3).setPort(this.port);
    }

    public TosRequest build(RequestBuilder builder, String method, InputStream content) {
        return builder.buildRequest(method, content);
    }

    public TosRequest build(RequestBuilder builder, String method, boolean isSignedAllHeaders, long ttl) {
        return builder.buildPreSignedUrlRequest(method, isSignedAllHeaders, ttl);
    }

    public TosRequest buildWithCopy(RequestBuilder builder, String method, String srcBucket, String srcObject) {
        return builder.buildRequestWithCopySource(method, srcBucket, srcObject);
    }

    private RequestBuilder newBuilder(String bucket, String object) {
        RequestBuilder rb = new RequestBuilder(bucket, object, this.scheme, this.host, this.signer).setDisableEncodingMeta(this.disableEncodingMeta);
        if (StringUtils.isEmpty(this.userAgent)) {
            rb.withHeader("User-Agent", TosUtils.getUserAgent());
        } else {
            rb.withHeader("User-Agent", this.userAgent);
        }
        return rb;
    }

    private RequestBuilder newBuilder(String bucket, String object, Map<String, String> headers) {
        RequestBuilder rb = this.newBuilder(bucket, object);
        if (headers != null) {
            headers.forEach(rb::withHeader);
        }
        return rb;
    }

    private RequestBuilder newControlReqBuilder(String accountId, String controlApiPath, Map<String, String> headers) {
        String controlHost = accountId + "." + this.controlHost;
        RequestBuilder rb = new RequestBuilder(controlApiPath, this.controlScheme, controlHost, this.signer).setDisableEncodingMeta(this.disableEncodingMeta);
        if (StringUtils.isEmpty(this.userAgent)) {
            rb.withHeader("User-Agent", TosUtils.getUserAgent());
        } else {
            rb.withHeader("User-Agent", this.userAgent);
        }
        rb.withHeader("x-tos-account-id", accountId);
        if (headers != null) {
            headers.forEach(rb::withHeader);
        }
        return rb;
    }
}

