/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.tos.model.object;

import com.volcengine.tos.TosClientException;
import com.volcengine.tos.comm.common.MetadataDirectiveType;
import com.volcengine.tos.comm.common.TaggingDirectiveType;
import com.volcengine.tos.internal.Consts;
import com.volcengine.tos.internal.util.DateConverter;
import com.volcengine.tos.internal.util.StringUtils;
import com.volcengine.tos.model.GenericInput;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CopyObjectV2Input
extends GenericInput {
    private String bucket;
    private String key;
    private String srcBucket;
    private String srcKey;
    private String srcVersionID;
    private String copySourceIfMatch;
    private Date copySourceIfModifiedSince;
    private String copySourceIfNoneMatch;
    private Date copySourceIfUnmodifiedSince;
    private String copySourceSSECAlgorithm;
    private String copySourceSSECKey;
    private String copySourceSSECKeyMD5;
    private MetadataDirectiveType metadataDirective;
    private ObjectMetaRequestOptions options;
    private boolean forbidOverwrite;
    private String ifMatch;
    private String tagging;
    private TaggingDirectiveType taggingDirective;
    private long objectExpires = -1L;
    private Map<String, String> headers;

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getSrcBucket() {
        return this.srcBucket;
    }

    public String getSrcKey() {
        return this.srcKey;
    }

    public String getSrcVersionID() {
        return this.srcVersionID;
    }

    public ObjectMetaRequestOptions getOptions() {
        return this.options;
    }

    public Map<String, String> getAllSettedHeaders() {
        this.withHeader("X-Tos-Copy-Source-If-Match", this.copySourceIfMatch);
        this.withHeader("X-Tos-Copy-Source-If-None-Match", this.copySourceIfNoneMatch);
        if (StringUtils.isNotEmpty(this.copySourceSSECAlgorithm)) {
            if (Consts.CUSTOM_SERVER_SIDE_ENCRYPTION_ALGORITHM_LIST.contains(this.copySourceSSECAlgorithm)) {
                this.withHeader("X-Tos-Server-Side-Encryption-Customer-Algorithm", this.copySourceSSECAlgorithm);
            } else {
                throw new TosClientException("invalid copySourceSSECAlgorithm input, only support AES256", null);
            }
        }
        this.withHeader("x-tos-copy-source-server-side-encryption-customer-key", this.copySourceSSECKey);
        this.withHeader("x-tos-copy-source-server-side-encryption-customer-key-MD5", this.copySourceSSECKeyMD5);
        this.withHeader("X-Tos-Metadata-Directive", this.metadataDirective == null ? null : this.metadataDirective.toString());
        if (this.copySourceIfModifiedSince != null) {
            this.withHeader(this.key, DateConverter.dateToRFC1123String(this.copySourceIfModifiedSince));
        }
        if (this.copySourceIfUnmodifiedSince != null) {
            this.withHeader(this.key, DateConverter.dateToRFC1123String(this.copySourceIfUnmodifiedSince));
        }
        if (this.options != null) {
            this.headers.putAll(this.options.headers());
        }
        this.withHeader("x-tos-if-match", this.ifMatch);
        if (this.forbidOverwrite) {
            this.withHeader("x-tos-forbid-overwrite", "true");
        }
        this.withHeader("x-tos-tagging", this.tagging);
        this.withHeader("x-tos-tagging-directive", this.taggingDirective == null ? null : this.taggingDirective.getType());
        if (this.objectExpires >= 0L) {
            this.withHeader("x-tos-object-expires", Long.toString(this.objectExpires));
        }
        return this.headers;
    }

    private void withHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        if (value != null && value.length() != 0) {
            this.headers.put(key, value);
        }
    }

    public CopyObjectV2Input setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public CopyObjectV2Input setKey(String key) {
        this.key = key;
        return this;
    }

    public CopyObjectV2Input setSrcBucket(String srcBucket) {
        this.srcBucket = srcBucket;
        return this;
    }

    public CopyObjectV2Input setSrcKey(String srcKey) {
        this.srcKey = srcKey;
        return this;
    }

    public CopyObjectV2Input setSrcVersionID(String srcVersionID) {
        this.srcVersionID = srcVersionID;
        return this;
    }

    public CopyObjectV2Input setOptions(ObjectMetaRequestOptions options) {
        this.options = options;
        return this;
    }

    public String getCopySourceIfMatch() {
        return this.copySourceIfMatch;
    }

    public CopyObjectV2Input setCopySourceIfMatch(String copySourceIfMatch) {
        this.copySourceIfMatch = copySourceIfMatch;
        return this;
    }

    public Date getCopySourceIfModifiedSince() {
        return this.copySourceIfModifiedSince;
    }

    public CopyObjectV2Input setCopySourceIfModifiedSince(Date copySourceIfModifiedSince) {
        this.copySourceIfModifiedSince = copySourceIfModifiedSince;
        return this;
    }

    public String getCopySourceIfNoneMatch() {
        return this.copySourceIfNoneMatch;
    }

    public CopyObjectV2Input setCopySourceIfNoneMatch(String copySourceIfNoneMatch) {
        this.copySourceIfNoneMatch = copySourceIfNoneMatch;
        return this;
    }

    public Date getCopySourceIfUnmodifiedSince() {
        return this.copySourceIfUnmodifiedSince;
    }

    public CopyObjectV2Input setCopySourceIfUnmodifiedSince(Date copySourceIfUnmodifiedSince) {
        this.copySourceIfUnmodifiedSince = copySourceIfUnmodifiedSince;
        return this;
    }

    public String getCopySourceSSECAlgorithm() {
        return this.copySourceSSECAlgorithm;
    }

    public CopyObjectV2Input setCopySourceSSECAlgorithm(String copySourceSSECAlgorithm) {
        this.copySourceSSECAlgorithm = copySourceSSECAlgorithm;
        return this;
    }

    public String getCopySourceSSECKey() {
        return this.copySourceSSECKey;
    }

    public CopyObjectV2Input setCopySourceSSECKey(String copySourceSSECKey) {
        this.copySourceSSECKey = copySourceSSECKey;
        return this;
    }

    public String getCopySourceSSECKeyMD5() {
        return this.copySourceSSECKeyMD5;
    }

    public CopyObjectV2Input setCopySourceSSECKeyMD5(String copySourceSSECKeyMD5) {
        this.copySourceSSECKeyMD5 = copySourceSSECKeyMD5;
        return this;
    }

    public MetadataDirectiveType getMetadataDirective() {
        return this.metadataDirective;
    }

    public CopyObjectV2Input setMetadataDirective(MetadataDirectiveType metadataDirective) {
        this.metadataDirective = metadataDirective;
        return this;
    }

    public boolean isForbidOverwrite() {
        return this.forbidOverwrite;
    }

    public CopyObjectV2Input setForbidOverwrite(boolean forbidOverwrite) {
        this.forbidOverwrite = forbidOverwrite;
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public CopyObjectV2Input setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    public String getTagging() {
        return this.tagging;
    }

    public CopyObjectV2Input setTagging(String tagging) {
        this.tagging = tagging;
        return this;
    }

    public TaggingDirectiveType getTaggingDirective() {
        return this.taggingDirective;
    }

    public CopyObjectV2Input setTaggingDirective(TaggingDirectiveType taggingDirective) {
        this.taggingDirective = taggingDirective;
        return this;
    }

    public long getObjectExpires() {
        return this.objectExpires;
    }

    public CopyObjectV2Input setObjectExpires(long objectExpires) {
        this.objectExpires = objectExpires;
        return this;
    }

    public static CopyObjectV2InputBuilder builder() {
        return new CopyObjectV2InputBuilder();
    }

    public String toString() {
        return "CopyObjectV2Input{bucket='" + this.bucket + '\'' + ", key='" + this.key + '\'' + ", srcBucket='" + this.srcBucket + '\'' + ", srcKey='" + this.srcKey + '\'' + ", srcVersionID='" + this.srcVersionID + '\'' + ", copySourceIfMatch='" + this.copySourceIfMatch + '\'' + ", copySourceIfModifiedSince=" + this.copySourceIfModifiedSince + ", copySourceIfNoneMatch='" + this.copySourceIfNoneMatch + '\'' + ", copySourceIfUnmodifiedSince=" + this.copySourceIfUnmodifiedSince + ", copySourceSSECAlgorithm='" + this.copySourceSSECAlgorithm + '\'' + ", copySourceSSECKey='" + this.copySourceSSECKey + '\'' + ", copySourceSSECKeyMD5='" + this.copySourceSSECKeyMD5 + '\'' + ", metadataDirective=" + (Object)((Object)this.metadataDirective) + ", options=" + this.options + ", forbidOverwrite=" + this.forbidOverwrite + ", ifMatch='" + this.ifMatch + '\'' + ", tagging='" + this.tagging + '\'' + ", taggingDirective=" + (Object)((Object)this.taggingDirective) + ", objectExpires=" + this.objectExpires + '}';
    }

    public static final class CopyObjectV2InputBuilder {
        private String bucket;
        private String key;
        private String srcBucket;
        private String srcKey;
        private String srcVersionID;
        private String copySourceIfMatch;
        private Date copySourceIfModifiedSince;
        private String copySourceIfNoneMatch;
        private Date copySourceIfUnmodifiedSince;
        private String copySourceSSECAlgorithm;
        private String copySourceSSECKey;
        private String copySourceSSECKeyMD5;
        private MetadataDirectiveType metadataDirective;
        private ObjectMetaRequestOptions options;
        private boolean forbidOverwrite;
        private String ifMatch;
        private String tagging;
        private TaggingDirectiveType taggingDirective;
        private long objectExpires = -1L;

        private CopyObjectV2InputBuilder() {
        }

        public CopyObjectV2InputBuilder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public CopyObjectV2InputBuilder key(String key) {
            this.key = key;
            return this;
        }

        public CopyObjectV2InputBuilder srcBucket(String srcBucket) {
            this.srcBucket = srcBucket;
            return this;
        }

        public CopyObjectV2InputBuilder srcKey(String srcKey) {
            this.srcKey = srcKey;
            return this;
        }

        public CopyObjectV2InputBuilder srcVersionID(String srcVersionID) {
            this.srcVersionID = srcVersionID;
            return this;
        }

        public CopyObjectV2InputBuilder copySourceIfMatch(String copySourceIfMatch) {
            this.copySourceIfMatch = copySourceIfMatch;
            return this;
        }

        public CopyObjectV2InputBuilder copySourceIfModifiedSince(Date copySourceIfModifiedSince) {
            this.copySourceIfModifiedSince = copySourceIfModifiedSince;
            return this;
        }

        public CopyObjectV2InputBuilder copySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
            return this;
        }

        public CopyObjectV2InputBuilder copySourceIfUnmodifiedSince(Date copySourceIfUnmodifiedSince) {
            this.copySourceIfUnmodifiedSince = copySourceIfUnmodifiedSince;
            return this;
        }

        public CopyObjectV2InputBuilder copySourceSSECAlgorithm(String copySourceSSECAlgorithm) {
            this.copySourceSSECAlgorithm = copySourceSSECAlgorithm;
            return this;
        }

        public CopyObjectV2InputBuilder copySourceSSECKey(String copySourceSSECKey) {
            this.copySourceSSECKey = copySourceSSECKey;
            return this;
        }

        public CopyObjectV2InputBuilder copySourceSSECKeyMD5(String copySourceSSECKeyMD5) {
            this.copySourceSSECKeyMD5 = copySourceSSECKeyMD5;
            return this;
        }

        public CopyObjectV2InputBuilder metadataDirective(MetadataDirectiveType metadataDirective) {
            this.metadataDirective = metadataDirective;
            return this;
        }

        public CopyObjectV2InputBuilder options(ObjectMetaRequestOptions options) {
            this.options = options;
            return this;
        }

        public CopyObjectV2InputBuilder forbidOverwrite(boolean forbidOverwrite) {
            this.forbidOverwrite = forbidOverwrite;
            return this;
        }

        public CopyObjectV2InputBuilder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public CopyObjectV2InputBuilder tagging(String tagging) {
            this.tagging = tagging;
            return this;
        }

        public CopyObjectV2InputBuilder taggingDirective(TaggingDirectiveType taggingDirective) {
            this.taggingDirective = taggingDirective;
            return this;
        }

        public CopyObjectV2InputBuilder objectExpires(long objectExpires) {
            this.objectExpires = objectExpires;
            return this;
        }

        public CopyObjectV2Input build() {
            CopyObjectV2Input copyObjectV2Input = new CopyObjectV2Input();
            copyObjectV2Input.setBucket(this.bucket);
            copyObjectV2Input.setKey(this.key);
            copyObjectV2Input.setSrcBucket(this.srcBucket);
            copyObjectV2Input.setSrcKey(this.srcKey);
            copyObjectV2Input.setSrcVersionID(this.srcVersionID);
            copyObjectV2Input.setCopySourceIfMatch(this.copySourceIfMatch);
            copyObjectV2Input.setCopySourceIfModifiedSince(this.copySourceIfModifiedSince);
            copyObjectV2Input.setCopySourceIfNoneMatch(this.copySourceIfNoneMatch);
            copyObjectV2Input.setCopySourceIfUnmodifiedSince(this.copySourceIfUnmodifiedSince);
            copyObjectV2Input.setCopySourceSSECAlgorithm(this.copySourceSSECAlgorithm);
            copyObjectV2Input.setCopySourceSSECKey(this.copySourceSSECKey);
            copyObjectV2Input.setCopySourceSSECKeyMD5(this.copySourceSSECKeyMD5);
            copyObjectV2Input.setMetadataDirective(this.metadataDirective);
            copyObjectV2Input.setOptions(this.options);
            copyObjectV2Input.setIfMatch(this.ifMatch);
            copyObjectV2Input.setForbidOverwrite(this.forbidOverwrite);
            copyObjectV2Input.setTagging(this.tagging);
            copyObjectV2Input.setTaggingDirective(this.taggingDirective);
            copyObjectV2Input.setObjectExpires(this.objectExpires);
            return copyObjectV2Input;
        }
    }
}

