/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vikingdb.runtime;

import com.volcengine.vikingdb.runtime.exception.ParamEmptyException;
import com.volcengine.vikingdb.runtime.exception.VectorSizeMismatchException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.http.Header;

public class Util {
    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static void requiresNonEmpty(String paramName, String paramValue) {
        if (Util.isEmpty(paramValue)) {
            throw new ParamEmptyException(paramName);
        }
    }

    public static String trimHostPrefix(String host) {
        if (host.startsWith("http://")) {
            host = host.substring("http://".length());
        } else if (host.startsWith("https://")) {
            host = host.substring("https://".length());
        }
        return host;
    }

    public static Map<String, String> getHeadersMap(Header[] headers) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (Header header : headers) {
            headersMap.put(header.getName(), header.getValue());
        }
        return headersMap;
    }

    public static List<Float> generateRandomVector(int n) {
        ArrayList<Float> randomList = new ArrayList<Float>();
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            float randomFloat = random.nextFloat() * 2.0f - 1.0f;
            randomList.add(Float.valueOf(randomFloat));
        }
        return randomList;
    }

    public static float getCosineDistance(List<Float> vec1, List<Float> vec2) {
        if (vec1.size() != vec2.size()) {
            throw new VectorSizeMismatchException(vec1.size(), vec2.size());
        }
        float dotProduct = 0.0f;
        float norm1 = 0.0f;
        float norm2 = 0.0f;
        for (int i = 0; i < vec1.size(); ++i) {
            float a = vec1.get(i).floatValue();
            float b = vec2.get(i).floatValue();
            dotProduct += a * b;
            norm1 += a * a;
            norm2 += b * b;
        }
        return dotProduct / ((float)Math.sqrt(norm1) * (float)Math.sqrt(norm2));
    }

    public static float getInnerProductDistance(List<Float> vec1, List<Float> vec2) {
        if (vec1.size() != vec2.size()) {
            throw new VectorSizeMismatchException(vec1.size(), vec2.size());
        }
        float dotProduct = 0.0f;
        for (int i = 0; i < vec1.size(); ++i) {
            dotProduct += vec1.get(i).floatValue() * vec2.get(i).floatValue();
        }
        return dotProduct;
    }

    public static float getL2Distance(List<Float> vec1, List<Float> vec2) {
        if (vec1.size() != vec2.size()) {
            throw new VectorSizeMismatchException(vec1.size(), vec2.size());
        }
        float sum = 0.0f;
        for (int i = 0; i < vec1.size(); ++i) {
            float diff = vec1.get(i).floatValue() - vec2.get(i).floatValue();
            sum += diff * diff;
        }
        return (float)Math.sqrt(sum);
    }
}

