/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vikingdb.runtime.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.volcengine.vikingdb.runtime.Util;
import com.volcengine.vikingdb.runtime.Version;
import com.volcengine.vikingdb.runtime.core.ClientConfig;
import com.volcengine.vikingdb.runtime.core.RequestAddition;
import com.volcengine.vikingdb.runtime.core.RequestExecutor;
import com.volcengine.vikingdb.runtime.core.ResponseContext;
import com.volcengine.vikingdb.runtime.core.auth.Auth;
import com.volcengine.vikingdb.runtime.enums.Method;
import com.volcengine.vikingdb.runtime.enums.Scheme;
import java.util.HashMap;
import java.util.Map;

public class ApiClient {
    public static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final Auth auth;
    private final Scheme scheme;
    private final String host;
    private final String region;
    private final ClientConfig clientConfig;
    private final RequestExecutor requestExecutor;

    public ApiClient(String host, Auth auth) {
        this(null, host, "", auth, null);
    }

    public ApiClient(Scheme scheme, String host, String region, Auth auth) {
        this(scheme, host, region, auth, null);
    }

    public ApiClient(Scheme scheme, String host, String region, Auth auth, ClientConfig clientConfig) {
        this.auth = auth;
        if (scheme == null) {
            scheme = Scheme.DEFAULT;
        }
        this.scheme = scheme;
        Util.requiresNonEmpty("host", host);
        this.host = Util.trimHostPrefix(host);
        if (Util.isEmpty(region)) {
            region = "cn-beijing";
        }
        this.region = region;
        if (clientConfig == null) {
            clientConfig = new ClientConfig();
        }
        this.clientConfig = clientConfig;
        this.requestExecutor = RequestExecutor.create(this, auth);
    }

    public ResponseContext doRequest(Method method, String path, String body) {
        return this.doRequest(method, path, body, null, null);
    }

    public ResponseContext doRequest(Method method, String path, String body, RequestAddition requestAddition) {
        if (requestAddition == null) {
            return this.doRequest(method, path, body, null, null);
        }
        return this.doRequest(method, path, body, requestAddition.getHeaders(), requestAddition.getParams());
    }

    private ResponseContext doRequest(Method method, String path, String body, Map<String, String> headers, Map<String, String> params) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("User-Agent", String.format("vikingdb-java-sdk/%s", Version.getVersion()));
        if (body == null) {
            body = "";
        }
        return this.requestExecutor.execute(method, path, headers, params, body);
    }

    public Auth getAuth() {
        return this.auth;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public String getRegion() {
        return this.region;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public RequestExecutor getRequestExecutor() {
        return this.requestExecutor;
    }
}

