/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vikingdb.runtime.core;

import com.volcengine.service.SignableRequest;
import com.volcengine.vikingdb.runtime.core.ApiClient;
import com.volcengine.vikingdb.runtime.core.RequestExecutor;
import com.volcengine.vikingdb.runtime.core.ResponseContext;
import com.volcengine.vikingdb.runtime.core.auth.Sign;
import com.volcengine.vikingdb.runtime.enums.Method;
import com.volcengine.vikingdb.runtime.exception.BuildUriException;
import com.volcengine.vikingdb.runtime.exception.SignRequestException;
import java.net.URI;
import java.util.Map;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;

public class RequestExecutorWithAkSk
implements RequestExecutor {
    private final ApiClient apiClient;
    private final String ak;
    private final String sk;

    public RequestExecutorWithAkSk(ApiClient apiClient, String ak, String sk) {
        this.apiClient = apiClient;
        this.ak = ak;
        this.sk = sk;
    }

    @Override
    public ResponseContext execute(Method method, String path, Map<String, String> headers, Map<String, String> params, String body) {
        URI uri;
        SignableRequest signableRequest;
        long startTime = System.currentTimeMillis();
        try {
            signableRequest = Sign.prepareRequest(this.apiClient.getScheme(), this.apiClient.getHost(), path, method, params, headers, body, this.ak, this.sk, this.apiClient.getRegion());
        }
        catch (Exception e) {
            throw new SignRequestException(e.getMessage(), e);
        }
        try {
            uri = new URIBuilder().setScheme(this.apiClient.getScheme().toString()).setHost(this.apiClient.getHost()).setPath(path).build();
        }
        catch (Exception e) {
            throw new BuildUriException(e.getMessage(), e);
        }
        HttpRequestBase request = RequestExecutor.buildRequest(method, uri, body);
        request.setConfig(signableRequest.getConfig());
        RequestExecutor.setHeaders(request, signableRequest.getAllHeaders());
        return RequestExecutor.getResponse(request, this.apiClient, startTime);
    }
}

