/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vikingdb.runtime.core;

import com.volcengine.vikingdb.runtime.core.ApiClient;
import com.volcengine.vikingdb.runtime.core.RequestExecutor;
import com.volcengine.vikingdb.runtime.core.ResponseContext;
import com.volcengine.vikingdb.runtime.enums.Method;
import com.volcengine.vikingdb.runtime.exception.BuildUriException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;

public class RequestExecutorWithNoAuth
implements RequestExecutor {
    private final ApiClient apiClient;

    public RequestExecutorWithNoAuth(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ResponseContext execute(Method method, String path, Map<String, String> headers, Map<String, String> params, String body) {
        URI uri;
        long startTime = System.currentTimeMillis();
        URIBuilder uriBuilder = new URIBuilder().setScheme(this.apiClient.getScheme().toString()).setHost(this.apiClient.getHost()).setPath(path);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                uriBuilder.addParameter(entry.getKey(), entry.getValue());
            }
        }
        try {
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new BuildUriException(e.getMessage(), e);
        }
        HttpRequestBase request = RequestExecutor.buildRequest(method, uri, body);
        RequestExecutor.setHeaders(request, headers);
        return RequestExecutor.getResponse(request, this.apiClient, startTime);
    }
}

