/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vikingdb.runtime.core.retry;

import com.volcengine.vikingdb.runtime.core.Const;
import com.volcengine.vikingdb.runtime.core.retry.RetryStrategy;
import com.volcengine.vikingdb.runtime.exception.ExecuteHttpRequestException;
import com.volcengine.vikingdb.runtime.exception.RetryFailedException;
import com.volcengine.vikingdb.runtime.exception.TooManyRequestException;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;

public class ExpBackoffStrategy
implements RetryStrategy {
    private final int maxRetries;
    private final long initialDelayMillis;
    private final long maxDelayMillis;
    private final Boolean withJitter;
    private static final double MULTIPLIER = 2.0;

    public ExpBackoffStrategy() {
        this(Const.DEFAULT_MAX_RETRY_TIMES, Const.DEFAULT_RETRY_INITIAL_DELAY_MS.intValue(), Const.DEFAULT_RETRY_MAX_DELAY_MS.intValue(), true);
    }

    public ExpBackoffStrategy(int maxRetries, long initialDelayMillis, long maxDelayMillis, boolean withJitter) {
        this.maxRetries = Math.max(0, maxRetries);
        this.initialDelayMillis = Math.max(1L, initialDelayMillis);
        this.maxDelayMillis = Math.max(this.initialDelayMillis, maxDelayMillis);
        this.withJitter = withJitter;
    }

    @Override
    public <T> T execute(Callable<T> action) throws Exception {
        long currentDelay = this.initialDelayMillis;
        int attempt = 0;
        while (true) {
            try {
                return action.call();
            }
            catch (ExecuteHttpRequestException | TooManyRequestException e) {
                RuntimeException lastException = e;
                if (attempt >= this.maxRetries) {
                    throw new RetryFailedException(attempt, (Throwable)lastException);
                }
                long jitterDelay = this.withJitter != false ? ThreadLocalRandom.current().nextLong(currentDelay) : 0L;
                try {
                    Thread.sleep(Math.min(jitterDelay + currentDelay, this.maxDelayMillis));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Retry interrupted", interruptedException);
                }
                currentDelay = (long)Math.min((double)currentDelay * 2.0, (double)this.maxDelayMillis);
                ++attempt;
                continue;
            }
            break;
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getInitialDelayMillis() {
        return this.initialDelayMillis;
    }

    public long getMaxDelayMillis() {
        return this.maxDelayMillis;
    }

    public Boolean getWithJitter() {
        return this.withJitter;
    }
}

