/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vikingdb.runtime.core.retry;

import com.volcengine.vikingdb.runtime.core.Const;
import com.volcengine.vikingdb.runtime.core.retry.RetryStrategy;
import com.volcengine.vikingdb.runtime.exception.ExecuteHttpRequestException;
import com.volcengine.vikingdb.runtime.exception.RetryFailedException;
import com.volcengine.vikingdb.runtime.exception.TooManyRequestException;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;

public class LinearBackoffStrategy
implements RetryStrategy {
    private final int maxRetries;
    private final long delayMillis;
    private final Boolean withJitter;

    public LinearBackoffStrategy() {
        this(Const.DEFAULT_MAX_RETRY_TIMES, Const.DEFAULT_RETRY_INITIAL_DELAY_MS.intValue(), true);
    }

    public LinearBackoffStrategy(int maxRetries, long delayMillis, boolean withJitter) {
        this.maxRetries = Math.max(0, maxRetries);
        this.delayMillis = Math.max(1L, delayMillis);
        this.withJitter = withJitter;
    }

    @Override
    public <T> T execute(Callable<T> action) throws Exception {
        int attempt = 0;
        while (true) {
            try {
                return action.call();
            }
            catch (ExecuteHttpRequestException | TooManyRequestException e) {
                RuntimeException lastException = e;
                if (attempt >= this.maxRetries) {
                    throw new RetryFailedException(attempt, (Throwable)lastException);
                }
                long jitterDelay = this.withJitter != false ? ThreadLocalRandom.current().nextLong(this.delayMillis) : 0L;
                try {
                    Thread.sleep(Math.min(jitterDelay + this.delayMillis, this.delayMillis));
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Retry interrupted", interruptedException);
                }
                ++attempt;
                continue;
            }
            break;
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getDelayMillis() {
        return this.delayMillis;
    }

    public Boolean getWithJitter() {
        return this.withJitter;
    }
}

