/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vikingdb.runtime.vector.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.vikingdb.runtime.core.ApiClient;
import com.volcengine.vikingdb.runtime.core.RequestAddition;
import com.volcengine.vikingdb.runtime.core.ResponseContext;
import com.volcengine.vikingdb.runtime.exception.ApiClientException;
import com.volcengine.vikingdb.runtime.exception.DeserializeResponseException;
import com.volcengine.vikingdb.runtime.exception.SerializeRequestException;
import com.volcengine.vikingdb.runtime.exception.TooManyRequestException;
import com.volcengine.vikingdb.runtime.exception.VectorApiException;
import com.volcengine.vikingdb.runtime.vector.api.ApiInfo;
import com.volcengine.vikingdb.runtime.vector.model.response.DataApiResponse;

public class ApiRequestBinding<Request, Response extends DataApiResponse<Result>, Result> {
    private static final ApiInfo PING_API_INFO = ApiInfo.PING;
    private final ApiInfo apiInfo;
    private final Request request;
    private final TypeReference<Response> responseRef;

    public Response callApi(ApiClient apiClient) throws ApiClientException, VectorApiException {
        return this.callApi(apiClient, null);
    }

    public Response callApi(ApiClient apiClient, RequestAddition requestAddition) throws ApiClientException, VectorApiException {
        DataApiResponse response;
        ResponseContext rc;
        String body;
        try {
            body = ApiClient.objectMapper.writeValueAsString(this.request);
        }
        catch (JsonProcessingException e) {
            throw new SerializeRequestException(e.getMessage(), e.getCause());
        }
        try {
            rc = apiClient.getClientConfig().getRetryStrategy().execute(() -> {
                ResponseContext result = apiClient.doRequest(this.apiInfo.getMethod(), this.apiInfo.getPath(), body, requestAddition);
                if (result != null && result.getHttpStatusCode() == 429) {
                    throw new TooManyRequestException(result);
                }
                return result;
            });
        }
        catch (Exception e) {
            throw new ApiClientException(e.getMessage(), e);
        }
        try {
            response = (DataApiResponse)ApiClient.objectMapper.readValue(rc.getBody(), this.getResponseRef());
        }
        catch (JsonProcessingException e) {
            throw new DeserializeResponseException(e.getMessage(), e.getCause());
        }
        if (rc.getHttpStatusCode() < 200 || rc.getHttpStatusCode() >= 300) {
            throw new VectorApiException(rc.getHttpStatusCode(), this.apiInfo.getName(), response.getCode(), response.getMessage(), response.getRequestId(), rc);
        }
        return (Response)response;
    }

    public static ResponseContext ping(ApiClient apiClient, RequestAddition requestAddition) throws ApiClientException, VectorApiException {
        ResponseContext rc;
        try {
            rc = apiClient.doRequest(PING_API_INFO.getMethod(), PING_API_INFO.getPath(), "", requestAddition);
        }
        catch (Exception e) {
            throw new ApiClientException(e.getMessage(), e);
        }
        if (rc.getHttpStatusCode() < 200 || rc.getHttpStatusCode() >= 300) {
            throw new VectorApiException(rc.getHttpStatusCode(), ApiInfo.PING.getName(), "", "", "", rc);
        }
        return rc;
    }

    public ApiRequestBinding(ApiInfo apiInfo, Request request, TypeReference<Response> responseRef) {
        this.apiInfo = apiInfo;
        this.request = request;
        this.responseRef = responseRef;
    }

    public ApiInfo getApiInfo() {
        return this.apiInfo;
    }

    public Request getRequest() {
        return this.request;
    }

    public TypeReference<Response> getResponseRef() {
        return this.responseRef;
    }
}

