/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.vikingdb.runtime.vector.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.volcengine.vikingdb.runtime.core.ApiClient;
import com.volcengine.vikingdb.runtime.core.ClientConfig;
import com.volcengine.vikingdb.runtime.core.RequestAddition;
import com.volcengine.vikingdb.runtime.core.ResponseContext;
import com.volcengine.vikingdb.runtime.core.auth.Auth;
import com.volcengine.vikingdb.runtime.enums.Scheme;
import com.volcengine.vikingdb.runtime.exception.ApiClientException;
import com.volcengine.vikingdb.runtime.exception.VectorApiException;
import com.volcengine.vikingdb.runtime.vector.api.ApiInfo;
import com.volcengine.vikingdb.runtime.vector.api.ApiRequestBinding;
import com.volcengine.vikingdb.runtime.vector.model.request.AggregateRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.DeleteDataRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.EmbeddingRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.FetchDataInCollectionRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.FetchDataInIndexRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.SearchByIdRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.SearchByKeywordsRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.SearchByMultiModalRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.SearchByRandomRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.SearchByScalarRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.SearchByVectorRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.SortRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.UpdateDataRequest;
import com.volcengine.vikingdb.runtime.vector.model.request.UpsertDataRequest;
import com.volcengine.vikingdb.runtime.vector.model.response.AggregateResult;
import com.volcengine.vikingdb.runtime.vector.model.response.DataApiResponse;
import com.volcengine.vikingdb.runtime.vector.model.response.DeleteDataResult;
import com.volcengine.vikingdb.runtime.vector.model.response.EmbeddingResult;
import com.volcengine.vikingdb.runtime.vector.model.response.FetchDataInCollectionResult;
import com.volcengine.vikingdb.runtime.vector.model.response.FetchDataInIndexResult;
import com.volcengine.vikingdb.runtime.vector.model.response.SearchResult;
import com.volcengine.vikingdb.runtime.vector.model.response.SortResult;
import com.volcengine.vikingdb.runtime.vector.model.response.UpdateDataResult;
import com.volcengine.vikingdb.runtime.vector.model.response.UpsertDataResult;

public class VectorService {
    protected final ApiClient apiClient;

    public VectorService(String host, Auth auth) throws ApiClientException, VectorApiException {
        this.apiClient = new ApiClient(host, auth);
        this.ping();
    }

    public VectorService(Scheme scheme, String host, Auth auth) throws ApiClientException, VectorApiException {
        this.apiClient = new ApiClient(scheme, host, null, auth);
        this.ping();
    }

    public VectorService(Scheme scheme, String host, String region, Auth auth) throws ApiClientException, VectorApiException {
        this.apiClient = new ApiClient(scheme, host, region, auth);
        this.ping();
    }

    public VectorService(Scheme scheme, String host, String region, Auth auth, ClientConfig clientConfig) throws ApiClientException, VectorApiException {
        this.apiClient = new ApiClient(scheme, host, region, auth, clientConfig);
        this.ping();
    }

    public ResponseContext ping() throws ApiClientException, VectorApiException {
        return this.ping(null);
    }

    public ResponseContext ping(RequestAddition addition) throws ApiClientException, VectorApiException {
        return ApiRequestBinding.ping(this.apiClient, addition);
    }

    public DataApiResponse<UpsertDataResult> upsertData(UpsertDataRequest request) throws ApiClientException, VectorApiException {
        return this.upsertData(request, null);
    }

    public DataApiResponse<UpsertDataResult> upsertData(UpsertDataRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.UPSERT_DATA, request, new TypeReference<DataApiResponse<UpsertDataResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<UpdateDataResult> updateData(UpdateDataRequest request) throws ApiClientException, VectorApiException {
        return this.updateData(request, null);
    }

    public DataApiResponse<UpdateDataResult> updateData(UpdateDataRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.UPDATE_DATA, request, new TypeReference<DataApiResponse<UpdateDataResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<FetchDataInCollectionResult> fetchDataInCollection(FetchDataInCollectionRequest request) throws ApiClientException, VectorApiException {
        return this.fetchDataInCollection(request, null);
    }

    public DataApiResponse<FetchDataInCollectionResult> fetchDataInCollection(FetchDataInCollectionRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.FETCH_DATA_IN_COLLECTION, request, new TypeReference<DataApiResponse<FetchDataInCollectionResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<DeleteDataResult> deleteData(DeleteDataRequest request) throws ApiClientException, VectorApiException {
        return this.deleteData(request, null);
    }

    public DataApiResponse<DeleteDataResult> deleteData(DeleteDataRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.DELETE_DATA, request, new TypeReference<DataApiResponse<DeleteDataResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<FetchDataInIndexResult> fetchDataInIndex(FetchDataInIndexRequest request) throws ApiClientException, VectorApiException {
        return this.fetchDataInIndex(request, null);
    }

    public DataApiResponse<FetchDataInIndexResult> fetchDataInIndex(FetchDataInIndexRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.FETCH_DATA_IN_INDEX, request, new TypeReference<DataApiResponse<FetchDataInIndexResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<SearchResult> searchByVector(SearchByVectorRequest request) throws ApiClientException, VectorApiException {
        return this.searchByVector(request, null);
    }

    public DataApiResponse<SearchResult> searchByVector(SearchByVectorRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.SEARCH_BY_VECTOR, request, new TypeReference<DataApiResponse<SearchResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<SearchResult> searchByMultiModal(SearchByMultiModalRequest request) throws ApiClientException, VectorApiException {
        return this.searchByMultiModal(request, null);
    }

    public DataApiResponse<SearchResult> searchByMultiModal(SearchByMultiModalRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.SEARCH_BY_MULTIMODAL, request, new TypeReference<DataApiResponse<SearchResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<SearchResult> searchById(SearchByIdRequest request) throws ApiClientException, VectorApiException {
        return this.searchById(request, null);
    }

    public DataApiResponse<SearchResult> searchById(SearchByIdRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.SEARCH_BY_ID, request, new TypeReference<DataApiResponse<SearchResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<SearchResult> searchByScalar(SearchByScalarRequest request) throws ApiClientException, VectorApiException {
        return this.searchByScalar(request, null);
    }

    public DataApiResponse<SearchResult> searchByScalar(SearchByScalarRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.SEARCH_BY_SCALAR, request, new TypeReference<DataApiResponse<SearchResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<SearchResult> searchByKeywords(SearchByKeywordsRequest request) throws ApiClientException, VectorApiException {
        return this.searchByKeywords(request, null);
    }

    public DataApiResponse<SearchResult> searchByKeywords(SearchByKeywordsRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.SEARCH_BY_KEYWORDS, request, new TypeReference<DataApiResponse<SearchResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<SearchResult> searchByRandom(SearchByRandomRequest request) throws ApiClientException, VectorApiException {
        return this.searchByRandom(request, null);
    }

    public DataApiResponse<SearchResult> searchByRandom(SearchByRandomRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.SEARCH_BY_RANDOM, request, new TypeReference<DataApiResponse<SearchResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<AggregateResult> aggregate(AggregateRequest request) throws ApiClientException, VectorApiException {
        return this.aggregate(request, null);
    }

    public DataApiResponse<AggregateResult> aggregate(AggregateRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.AGGREGATE, request, new TypeReference<DataApiResponse<AggregateResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<SortResult> sort(SortRequest request) throws ApiClientException, VectorApiException {
        return this.sort(request, null);
    }

    public DataApiResponse<SortResult> sort(SortRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.SORT, request, new TypeReference<DataApiResponse<SortResult>>(){}).callApi(this.apiClient, addition);
    }

    public DataApiResponse<EmbeddingResult> embedding(EmbeddingRequest request) throws ApiClientException, VectorApiException {
        return this.embedding(request, null);
    }

    public DataApiResponse<EmbeddingResult> embedding(EmbeddingRequest request, RequestAddition addition) throws ApiClientException, VectorApiException {
        return new ApiRequestBinding(ApiInfo.Embedding, request, new TypeReference<DataApiResponse<EmbeddingResult>>(){}).callApi(this.apiClient, addition);
    }
}

