/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.volcengine.helper.IVodUploadStrategy;
import com.volcengine.helper.VodUploadByBytesArray;
import com.volcengine.helper.VodUploadByStream;
import com.volcengine.model.beans.PartInputStream;
import com.volcengine.model.beans.ReUseFileInputStream;
import com.volcengine.model.beans.ReUsePartFileInputStream;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.zip.CRC32;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Utils {
    public static List<NameValuePair> mapToPairList(Map<String, String> params) {
        ArrayList<NameValuePair> res = new ArrayList<NameValuePair>();
        if (params != null) {
            for (String key : params.keySet()) {
                res.add((NameValuePair)new BasicNameValuePair(key, params.get(key)));
            }
        }
        return res;
    }

    public static String hashSHA256(byte[] content) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return Hex.encodeHexString((byte[])md.digest(content));
        }
        catch (Exception e) {
            throw new Exception("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    public static byte[] hmacSHA256(byte[] key, String content) throws Exception {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(content.getBytes());
        }
        catch (Exception e) {
            throw new Exception("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    public static byte[] hmacSHA1(byte[] key, String content) throws Exception {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key, "HmacSHA1"));
            return mac.doFinal(content.getBytes());
        }
        catch (Exception e) {
            throw new Exception("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    public static String randWeights(Map<String, Integer> weightsMap, String excludeDomain) {
        int weightSum = 0;
        for (Map.Entry<String, Integer> entry : weightsMap.entrySet()) {
            if (entry.getKey().equals(excludeDomain)) continue;
            weightSum += entry.getValue().intValue();
        }
        if (weightSum <= 0) {
            return "";
        }
        Random random = new Random();
        int r = random.nextInt(weightSum) + 1;
        for (Map.Entry<String, Integer> entry : weightsMap.entrySet()) {
            if (entry.getKey().equals(excludeDomain) || (r -= entry.getValue().intValue()) > 0) continue;
            return entry.getKey();
        }
        return "";
    }

    public static String encode(Map<String, List<String>> v) {
        if (v == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
        treeMap.putAll(v);
        try {
            for (Map.Entry entry : treeMap.entrySet()) {
                String keyEscaped = URLEncoder.encode((String)entry.getKey(), "UTF-8");
                for (String s : (List)entry.getValue()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("&");
                    }
                    stringBuilder.append(keyEscaped);
                    stringBuilder.append("=");
                    stringBuilder.append(URLEncoder.encode(s, "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
        return stringBuilder.toString();
    }

    public static long crc32(byte[] bytes) throws Exception {
        CRC32 crc = new CRC32();
        crc.update(bytes, 0, bytes.length);
        return crc.getValue();
    }

    public static long crc32(InputStream inputStream) throws Exception {
        byte[] buffer = new byte[4096];
        CRC32 crc = new CRC32();
        crc.reset();
        int n = 0;
        while (-1 != (n = inputStream.read(buffer))) {
            crc.update(buffer, 0, n);
        }
        return crc.getValue();
    }

    public static InputStream newRepeatableInputStream(PartInputStream original) throws IOException {
        InputStream repeatable = null;
        repeatable = !original.markSupported() ? (original.getWrappedInputStream() instanceof FileInputStream ? new ReUsePartFileInputStream(original) : new BufferedInputStream(original, 524288)) : original;
        return repeatable;
    }

    public static InputStream newRepeatableInputStream(InputStream original) throws IOException {
        InputStream repeatable = null;
        repeatable = !original.markSupported() ? (original instanceof FileInputStream ? new ReUseFileInputStream((FileInputStream)original) : new BufferedInputStream(original, 524288)) : original;
        return repeatable;
    }

    public static IVodUploadStrategy getVodUploadCoreInstance(int uploadStrategy) {
        if (uploadStrategy == 1) {
            return new VodUploadByStream();
        }
        return new VodUploadByBytesArray();
    }

    public static Map<String, String> paramsToMap(Object obj) {
        Map map = (Map)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)JSON.toJSONString((Object)obj)), Map.class);
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            Class<?> valueType;
            if (entry.getValue() == null || (valueType = entry.getValue().getClass()) == null) continue;
            if (entry.getValue().getClass() == Integer.class) {
                params.put((String)entry.getKey(), ((Integer)entry.getValue()).toString());
                continue;
            }
            if (entry.getValue().getClass() == String.class) {
                params.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (entry.getValue().getClass() == Boolean.class) {
                params.put((String)entry.getKey(), ((Boolean)entry.getValue()).toString());
                continue;
            }
            if (entry.getValue().getClass() != JSONArray.class) continue;
            List list = (List)entry.getValue();
            try {
                params.put((String)entry.getKey(), URLEncoder.encode(StringUtils.join((Iterable)list, (String)","), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                params.put((String)entry.getKey(), "");
            }
        }
        return params;
    }

    public static List<NameValuePair> paramsToPair(Object obj) {
        Map map = (Map)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)JSON.toJSONString((Object)obj)), Map.class);
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (Map.Entry entry : map.entrySet()) {
            Class<?> valueType;
            if (entry.getValue() == null || (valueType = entry.getValue().getClass()) == null) continue;
            if (entry.getValue().getClass() == Integer.class) {
                pairs.add((NameValuePair)new BasicNameValuePair((String)entry.getKey(), ((Integer)entry.getValue()).toString()));
                continue;
            }
            if (entry.getValue().getClass() == String.class) {
                pairs.add((NameValuePair)new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
                continue;
            }
            if (entry.getValue().getClass() == Long.class) {
                pairs.add((NameValuePair)new BasicNameValuePair((String)entry.getKey(), ((Long)entry.getValue()).toString()));
                continue;
            }
            if (entry.getValue().getClass() == Boolean.class) {
                pairs.add((NameValuePair)new BasicNameValuePair((String)entry.getKey(), ((Boolean)entry.getValue()).toString()));
                continue;
            }
            if (entry.getValue().getClass() != JSONArray.class) continue;
            List list = (List)entry.getValue();
            for (String item : list) {
                pairs.add((NameValuePair)new BasicNameValuePair((String)entry.getKey(), item));
            }
        }
        return pairs;
    }

    public static Map<String, String> protoBufferToMap(MessageOrBuilder obj, boolean needDefaultValueFields) throws InvalidProtocolBufferException {
        JsonFormat.Printer printer = JsonFormat.printer();
        if (needDefaultValueFields) {
            printer = printer.includingDefaultValueFields();
        }
        Map map = (Map)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)printer.print(obj)), Map.class);
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue().getClass() == Integer.class) {
                params.put((String)entry.getKey(), ((Integer)entry.getValue()).toString());
                continue;
            }
            if (entry.getValue().getClass() == String.class) {
                params.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (entry.getValue().getClass() == Boolean.class) {
                params.put((String)entry.getKey(), ((Boolean)entry.getValue()).toString());
                continue;
            }
            if (entry.getValue().getClass() == Float.class) {
                params.put((String)entry.getKey(), ((Float)entry.getValue()).toString());
                continue;
            }
            if (entry.getValue().getClass() == Double.class) {
                params.put((String)entry.getKey(), ((Double)entry.getValue()).toString());
                continue;
            }
            if (entry.getValue().getClass() == Byte.class) {
                params.put((String)entry.getKey(), ((Byte)entry.getValue()).toString());
                continue;
            }
            params.put((String)entry.getKey(), JSONObject.toJSONString(entry.getValue()));
        }
        return params;
    }
}

