/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.helper;

import com.github.rholder.retry.Retryer;
import com.volcengine.helper.Utils;
import com.volcengine.helper.VodUploadAbstractStrategy;
import com.volcengine.helper.VodUploadProgressEventType;
import com.volcengine.helper.VodUploadProgressListener;
import com.volcengine.helper.VodUploadProgressListenerHelper;
import com.volcengine.service.vod.impl.VodServiceImpl;
import com.volcengine.service.vod.model.business.VodHeaderPair;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;

public class VodUploadByBytesArray
extends VodUploadAbstractStrategy {
    @Override
    public void directUpload(VodServiceImpl vodService, String host, String oid, String auth, List<VodHeaderPair> uploadHeaderList, File file, Retryer retryer, int storageClass, VodUploadProgressListener listener) throws Exception {
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("https://%s/%s", host, oidEncode);
        byte[] bytes = Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
        long crc32 = Utils.crc32(bytes);
        String checkSum = String.format("%08x", crc32);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.fillDirectUploadCommonHeaders(headers, uploadHeaderList, auth, checkSum, storageClass);
        retryer.call(() -> vodService.putData(url, bytes, (Map<String, String>)headers));
        VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, file.length() - 1L);
    }

    @Override
    public void chunkUpload(VodServiceImpl vodService, String host, String oid, String auth, List<VodHeaderPair> uploadHeaderList, File file, boolean isLargeFile, Retryer retryer, int storageClass, VodUploadProgressListener listener) throws Exception {
        String uploadID = vodService.initUploadPart(host, oid, auth, isLargeFile, uploadHeaderList, retryer, storageClass);
        byte[] data = new byte[0x1400000];
        ArrayList<String> parts = new ArrayList<String>();
        long num = file.length() / 0x1400000L;
        long lastNum = num - 1L;
        String objectContentType = "";
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            long partNumber;
            for (long i = 0L; i < lastNum; ++i) {
                bis.read(data);
                partNumber = isLargeFile ? i + 1L : i;
                VodServiceImpl.UploadPartResponse uploadPartResponse = this.uploadPart(vodService, host, oid, auth, uploadID, partNumber, data, isLargeFile, retryer, storageClass);
                parts.add(uploadPartResponse.getCheckSum());
                if (partNumber == 1L) {
                    objectContentType = uploadPartResponse.getObjectContentType();
                }
                VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, data.length);
            }
            long readCount = 0x1400000L * lastNum;
            int len = (int)(file.length() - readCount);
            byte[] lastPart = new byte[len];
            bis.read(lastPart);
            partNumber = isLargeFile ? lastNum + 1L : lastNum;
            VodServiceImpl.UploadPartResponse uploadPartResponse = this.uploadPart(vodService, host, oid, auth, uploadID, partNumber, lastPart, isLargeFile, retryer, storageClass);
            parts.add(uploadPartResponse.getCheckSum());
            if (partNumber == 1L) {
                objectContentType = uploadPartResponse.getObjectContentType();
            }
            VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, lastPart.length - 1);
        }
        vodService.uploadMergePart(host, oid, auth, uploadID, (String[])parts.stream().toArray(String[]::new), isLargeFile, retryer, storageClass, objectContentType);
    }

    private VodServiceImpl.UploadPartResponse uploadPart(VodServiceImpl vodService, String host, String oid, String auth, String uploadID, long partNumber, byte[] data, boolean isLargeFile, Retryer retryer, int storageClass) throws Exception {
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("http://%s/%s?partNumber=%d&uploadID=%s", host, oidEncode, partNumber, uploadID);
        HashMap<String, String> headers = new HashMap<String, String>();
        long crc32 = Utils.crc32(data);
        String checkSum = String.format("%08x", crc32);
        this.fillPartUploadCommonHeaders(headers, auth, checkSum, isLargeFile, storageClass);
        HttpResponse httpResponse = (HttpResponse)retryer.call(() -> vodService.putDataWithResponse(url, data, (Map<String, String>)headers));
        return this.getUploadPartResponse(isLargeFile, checkSum, httpResponse);
    }
}

