/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.tls.response;

import com.google.protobuf.InvalidProtocolBufferException;
import com.volcengine.model.tls.exception.LogException;
import com.volcengine.model.tls.pb.PutLogRequest;
import com.volcengine.model.tls.response.CommonResponse;
import com.volcengine.util.EncodeUtil;
import org.apache.http.Header;

public class ConsumeLogsResponse
extends CommonResponse {
    PutLogRequest.LogGroupList logGroupList;
    String xTlsCursor;
    int xTlsCount;
    String decompress;

    public ConsumeLogsResponse(Header[] headers, String decompress) {
        super(headers);
        this.decompress = decompress;
    }

    @Override
    public ConsumeLogsResponse deSerialize(byte[] data, Class clazz) throws LogException {
        byte[] decompressBytes = data;
        if (this.getDecompress() != null && this.getDecompress().equalsIgnoreCase("lz4") && data != null) {
            decompressBytes = EncodeUtil.lz4Decompress(data);
        }
        if (decompressBytes != null) {
            try {
                this.setLogGroupList(PutLogRequest.LogGroupList.parseFrom(decompressBytes));
            }
            catch (InvalidProtocolBufferException e) {
                throw new LogException("Lz4 decompress error", "RequestId is:" + this.getRequestId(), this.getRequestId());
            }
        }
        this.setXTlsCursor(this.getFirstHeader("X-Tls-Cursor"));
        this.setXTlsCount(Integer.valueOf(this.getFirstHeader("X-Tls-Count")));
        return this;
    }

    public PutLogRequest.LogGroupList getLogGroupList() {
        return this.logGroupList;
    }

    public String getXTlsCursor() {
        return this.xTlsCursor;
    }

    public int getXTlsCount() {
        return this.xTlsCount;
    }

    public String getDecompress() {
        return this.decompress;
    }

    public void setLogGroupList(PutLogRequest.LogGroupList logGroupList) {
        this.logGroupList = logGroupList;
    }

    public void setXTlsCursor(String xTlsCursor) {
        this.xTlsCursor = xTlsCursor;
    }

    public void setXTlsCount(int xTlsCount) {
        this.xTlsCount = xTlsCount;
    }

    public void setDecompress(String decompress) {
        this.decompress = decompress;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumeLogsResponse)) {
            return false;
        }
        ConsumeLogsResponse other = (ConsumeLogsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getXTlsCount() != other.getXTlsCount()) {
            return false;
        }
        PutLogRequest.LogGroupList this$logGroupList = this.getLogGroupList();
        PutLogRequest.LogGroupList other$logGroupList = other.getLogGroupList();
        if (this$logGroupList == null ? other$logGroupList != null : !((Object)this$logGroupList).equals(other$logGroupList)) {
            return false;
        }
        String this$xTlsCursor = this.getXTlsCursor();
        String other$xTlsCursor = other.getXTlsCursor();
        if (this$xTlsCursor == null ? other$xTlsCursor != null : !this$xTlsCursor.equals(other$xTlsCursor)) {
            return false;
        }
        String this$decompress = this.getDecompress();
        String other$decompress = other.getDecompress();
        return !(this$decompress == null ? other$decompress != null : !this$decompress.equals(other$decompress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConsumeLogsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getXTlsCount();
        PutLogRequest.LogGroupList $logGroupList = this.getLogGroupList();
        result = result * 59 + ($logGroupList == null ? 43 : ((Object)$logGroupList).hashCode());
        String $xTlsCursor = this.getXTlsCursor();
        result = result * 59 + ($xTlsCursor == null ? 43 : $xTlsCursor.hashCode());
        String $decompress = this.getDecompress();
        result = result * 59 + ($decompress == null ? 43 : $decompress.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ConsumeLogsResponse(super=" + super.toString() + ", logGroupList=" + this.getLogGroupList() + ", xTlsCursor=" + this.getXTlsCursor() + ", xTlsCount=" + this.getXTlsCount() + ", decompress=" + this.getDecompress() + ")";
    }

    public ConsumeLogsResponse() {
    }
}

