/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.imagex.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.imagex.CreateImageContentTaskReq;
import com.volcengine.model.imagex.CreateImageContentTaskResp;
import com.volcengine.model.imagex.CreateImageMigrateTaskReq;
import com.volcengine.model.imagex.CreateImageMigrateTaskResp;
import com.volcengine.model.imagex.CreateImageTranscodeTaskReq;
import com.volcengine.model.imagex.CreateImageTranscodeTaskResp;
import com.volcengine.model.imagex.DescribeImageVolcCdnAccessLogReq;
import com.volcengine.model.imagex.DescribeImageVolcCdnAccessLogResp;
import com.volcengine.model.imagex.GetImageContentBlockListReq;
import com.volcengine.model.imagex.GetImageContentBlockListResp;
import com.volcengine.model.imagex.GetImageContentTaskDetailReq;
import com.volcengine.model.imagex.GetImageContentTaskDetailResp;
import com.volcengine.model.imagex.GetImageMigrateTasksReq;
import com.volcengine.model.imagex.GetImageMigrateTasksResp;
import com.volcengine.model.imagex.GetImageOCRResponse;
import com.volcengine.model.imagex.GetUrlFetchTaskRequest;
import com.volcengine.model.imagex.GetUrlFetchTaskResponse;
import com.volcengine.model.imagex.UpdateImageStorageTTLRequest;
import com.volcengine.model.imagex.UpdateImageStorageTTLResponse;
import com.volcengine.model.imagex.data.DescribeImageXBaseOpUsageReq;
import com.volcengine.model.imagex.data.DescribeImageXBaseOpUsageResp;
import com.volcengine.model.imagex.data.DescribeImageXBucketUsageReq;
import com.volcengine.model.imagex.data.DescribeImageXBucketUsageResp;
import com.volcengine.model.imagex.data.DescribeImageXCDNTopRequestDataReq;
import com.volcengine.model.imagex.data.DescribeImageXCDNTopRequestDataResp;
import com.volcengine.model.imagex.data.DescribeImageXCdnDurationAllReq;
import com.volcengine.model.imagex.data.DescribeImageXCdnDurationAllResp;
import com.volcengine.model.imagex.data.DescribeImageXCdnDurationDetailByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXCdnDurationDetailByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXCdnErrorCodeAllReq;
import com.volcengine.model.imagex.data.DescribeImageXCdnErrorCodeAllResp;
import com.volcengine.model.imagex.data.DescribeImageXCdnErrorCodeByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXCdnErrorCodeByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXCdnProtocolRateByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXCdnProtocolRateByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXCdnReuseRateAllReq;
import com.volcengine.model.imagex.data.DescribeImageXCdnReuseRateAllResp;
import com.volcengine.model.imagex.data.DescribeImageXCdnReuseRateByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXCdnReuseRateByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXCdnSuccessRateAllReq;
import com.volcengine.model.imagex.data.DescribeImageXCdnSuccessRateAllResp;
import com.volcengine.model.imagex.data.DescribeImageXCdnSuccessRateByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXCdnSuccessRateByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXClientCountByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXClientCountByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXClientDecodeDurationByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXClientDecodeDurationByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXClientDecodeSuccessRateByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXClientDecodeSuccessRateByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXClientDemotionRateByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXClientDemotionRateByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXClientErrorCodeAllReq;
import com.volcengine.model.imagex.data.DescribeImageXClientErrorCodeAllResp;
import com.volcengine.model.imagex.data.DescribeImageXClientErrorCodeByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXClientErrorCodeByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXClientFailureRateReq;
import com.volcengine.model.imagex.data.DescribeImageXClientFailureRateResp;
import com.volcengine.model.imagex.data.DescribeImageXClientFileSizeReq;
import com.volcengine.model.imagex.data.DescribeImageXClientFileSizeResp;
import com.volcengine.model.imagex.data.DescribeImageXClientLoadDurationAllReq;
import com.volcengine.model.imagex.data.DescribeImageXClientLoadDurationAllResp;
import com.volcengine.model.imagex.data.DescribeImageXClientLoadDurationReq;
import com.volcengine.model.imagex.data.DescribeImageXClientLoadDurationResp;
import com.volcengine.model.imagex.data.DescribeImageXClientQualityRateByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXClientQualityRateByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXClientQueueDurationByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXClientQueueDurationByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXClientScoreByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXClientScoreByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXClientSdkVerByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXClientSdkVerByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXClientTopDemotionURLReq;
import com.volcengine.model.imagex.data.DescribeImageXClientTopDemotionURLResp;
import com.volcengine.model.imagex.data.DescribeImageXClientTopFileSizeReq;
import com.volcengine.model.imagex.data.DescribeImageXClientTopFileSizeResp;
import com.volcengine.model.imagex.data.DescribeImageXClientTopQualityURLReq;
import com.volcengine.model.imagex.data.DescribeImageXClientTopQualityURLResp;
import com.volcengine.model.imagex.data.DescribeImageXCompressUsageReq;
import com.volcengine.model.imagex.data.DescribeImageXCompressUsageResp;
import com.volcengine.model.imagex.data.DescribeImageXDomainBandwidthDataReq;
import com.volcengine.model.imagex.data.DescribeImageXDomainBandwidthDataResp;
import com.volcengine.model.imagex.data.DescribeImageXDomainTrafficDataReq;
import com.volcengine.model.imagex.data.DescribeImageXDomainTrafficDataResp;
import com.volcengine.model.imagex.data.DescribeImageXEdgeRequestBandwidthReq;
import com.volcengine.model.imagex.data.DescribeImageXEdgeRequestBandwidthResp;
import com.volcengine.model.imagex.data.DescribeImageXEdgeRequestRegionsReq;
import com.volcengine.model.imagex.data.DescribeImageXEdgeRequestRegionsResp;
import com.volcengine.model.imagex.data.DescribeImageXEdgeRequestReq;
import com.volcengine.model.imagex.data.DescribeImageXEdgeRequestResp;
import com.volcengine.model.imagex.data.DescribeImageXEdgeRequestTrafficReq;
import com.volcengine.model.imagex.data.DescribeImageXEdgeRequestTrafficResp;
import com.volcengine.model.imagex.data.DescribeImageXHitRateRequestDataReq;
import com.volcengine.model.imagex.data.DescribeImageXHitRateRequestDataResp;
import com.volcengine.model.imagex.data.DescribeImageXHitRateTrafficDataReq;
import com.volcengine.model.imagex.data.DescribeImageXHitRateTrafficDataResp;
import com.volcengine.model.imagex.data.DescribeImageXMirrorRequestBandwidthReq;
import com.volcengine.model.imagex.data.DescribeImageXMirrorRequestBandwidthResp;
import com.volcengine.model.imagex.data.DescribeImageXMirrorRequestHttpCodeByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXMirrorRequestHttpCodeByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXMirrorRequestHttpCodeOverviewReq;
import com.volcengine.model.imagex.data.DescribeImageXMirrorRequestHttpCodeOverviewResp;
import com.volcengine.model.imagex.data.DescribeImageXMirrorRequestTrafficReq;
import com.volcengine.model.imagex.data.DescribeImageXMirrorRequestTrafficResp;
import com.volcengine.model.imagex.data.DescribeImageXRequestCntUsageReq;
import com.volcengine.model.imagex.data.DescribeImageXRequestCntUsageResp;
import com.volcengine.model.imagex.data.DescribeImageXSensibleCacheHitRateByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXSensibleCacheHitRateByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXSensibleCountByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXSensibleCountByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXSensibleTopRamURLReq;
import com.volcengine.model.imagex.data.DescribeImageXSensibleTopRamURLResp;
import com.volcengine.model.imagex.data.DescribeImageXSensibleTopResolutionURLReq;
import com.volcengine.model.imagex.data.DescribeImageXSensibleTopResolutionURLResp;
import com.volcengine.model.imagex.data.DescribeImageXSensibleTopSizeURLReq;
import com.volcengine.model.imagex.data.DescribeImageXSensibleTopSizeURLResp;
import com.volcengine.model.imagex.data.DescribeImageXSensibleTopUnknownURLReq;
import com.volcengine.model.imagex.data.DescribeImageXSensibleTopUnknownURLResp;
import com.volcengine.model.imagex.data.DescribeImageXServiceQualityReq;
import com.volcengine.model.imagex.data.DescribeImageXServiceQualityResp;
import com.volcengine.model.imagex.data.DescribeImageXSummaryReq;
import com.volcengine.model.imagex.data.DescribeImageXSummaryResp;
import com.volcengine.model.imagex.data.DescribeImageXUploadCountByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXUploadCountByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXUploadDurationReq;
import com.volcengine.model.imagex.data.DescribeImageXUploadDurationResp;
import com.volcengine.model.imagex.data.DescribeImageXUploadErrorCodeAllReq;
import com.volcengine.model.imagex.data.DescribeImageXUploadErrorCodeAllResp;
import com.volcengine.model.imagex.data.DescribeImageXUploadErrorCodeByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXUploadErrorCodeByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXUploadFileSizeReq;
import com.volcengine.model.imagex.data.DescribeImageXUploadFileSizeResp;
import com.volcengine.model.imagex.data.DescribeImageXUploadSegmentSpeedByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXUploadSegmentSpeedByTimeResp;
import com.volcengine.model.imagex.data.DescribeImageXUploadSpeedReq;
import com.volcengine.model.imagex.data.DescribeImageXUploadSpeedResp;
import com.volcengine.model.imagex.data.DescribeImageXUploadSuccessRateByTimeReq;
import com.volcengine.model.imagex.data.DescribeImageXUploadSuccessRateByTimeResp;
import com.volcengine.model.imagex.data.GetImageXQueryAppsReq;
import com.volcengine.model.imagex.data.GetImageXQueryAppsResp;
import com.volcengine.model.imagex.data.GetImageXQueryDimsReq;
import com.volcengine.model.imagex.data.GetImageXQueryDimsResp;
import com.volcengine.model.imagex.data.GetImageXQueryRegionsReq;
import com.volcengine.model.imagex.data.GetImageXQueryRegionsResp;
import com.volcengine.model.imagex.data.GetImageXQueryValsReq;
import com.volcengine.model.imagex.data.GetImageXQueryValsResp;
import com.volcengine.model.request.ApplyImageUploadRequest;
import com.volcengine.model.request.CommitImageUploadRequest;
import com.volcengine.model.request.CommitImageUploadRequestBody;
import com.volcengine.model.request.DeleteImageReq;
import com.volcengine.model.request.EmbedImageHmRequest;
import com.volcengine.model.request.ExtractImageHmRequest;
import com.volcengine.model.request.FetchImageUrlRequest;
import com.volcengine.model.request.GetDeduplicateTaskStatusRequest;
import com.volcengine.model.request.GetDenoisingImageRequest;
import com.volcengine.model.request.GetImageBgFillResultRequest;
import com.volcengine.model.request.GetImageComicResultRequest;
import com.volcengine.model.request.GetImageDuplicateDetectionAsyncRequest;
import com.volcengine.model.request.GetImageDuplicateDetectionSyncRequest;
import com.volcengine.model.request.GetImageEnhanceResultRequest;
import com.volcengine.model.request.GetImageEraseModelsRequest;
import com.volcengine.model.request.GetImageEraseResultRequest;
import com.volcengine.model.request.GetImageOCRRequest;
import com.volcengine.model.request.GetImagePSDetectionRequest;
import com.volcengine.model.request.GetImageQualityRequest;
import com.volcengine.model.request.GetImageSegmentRequest;
import com.volcengine.model.request.GetImageSmartCropResultRequest;
import com.volcengine.model.request.GetImageStyleResultRequest;
import com.volcengine.model.request.GetImageSuperResolutionResultRequest;
import com.volcengine.model.request.GetImageUploadFileRequest;
import com.volcengine.model.request.GetImageUploadFilesRequest;
import com.volcengine.model.request.GetLicensePlateDetectionRequest;
import com.volcengine.model.request.GetPrivateImageTypeRequest;
import com.volcengine.model.response.ApplyImageUploadResponse;
import com.volcengine.model.response.CommitImageUploadResponse;
import com.volcengine.model.response.CommonResponse;
import com.volcengine.model.response.DeleteImageResp;
import com.volcengine.model.response.EmbedImageHmResponse;
import com.volcengine.model.response.ExtractImageHmResponse;
import com.volcengine.model.response.FetchImageUrlResponse;
import com.volcengine.model.response.GenericCommonResponse;
import com.volcengine.model.response.GetDeduplicateTaskStatusResponse;
import com.volcengine.model.response.GetDenoisingImageResponse;
import com.volcengine.model.response.GetImageBgFillResultResponse;
import com.volcengine.model.response.GetImageComicResultResponse;
import com.volcengine.model.response.GetImageDuplicateDetectionAsyncResponse;
import com.volcengine.model.response.GetImageDuplicateDetectionSyncResponse;
import com.volcengine.model.response.GetImageEnhanceResultResponse;
import com.volcengine.model.response.GetImageEraseModelsResponse;
import com.volcengine.model.response.GetImageEraseResultResponse;
import com.volcengine.model.response.GetImagePSDetectionResponse;
import com.volcengine.model.response.GetImageQualityResponse;
import com.volcengine.model.response.GetImageSegmentResponse;
import com.volcengine.model.response.GetImageSmartCropResultResponse;
import com.volcengine.model.response.GetImageStyleResultResponse;
import com.volcengine.model.response.GetImageSuperResolutionResultResponse;
import com.volcengine.model.response.GetImageUploadFileResponse;
import com.volcengine.model.response.GetImageUploadFilesResponse;
import com.volcengine.model.response.GetLicensePlateDetectionResponse;
import com.volcengine.model.response.GetPrivateImageTypeResponse;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.ResponseMetadata;
import com.volcengine.model.sts2.Policy;
import com.volcengine.model.sts2.SecurityToken2;
import com.volcengine.model.sts2.Statement;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.imagex.IImageXService;
import com.volcengine.service.imagex.ImageXConfig;
import com.volcengine.util.Sts2Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.util.EntityUtils;

public class ImageXServiceImpl
extends BaseServiceImpl
implements IImageXService {
    public static final Map<String, String> EMPTY_STRING_STRING_MAP = Collections.emptyMap();
    private static Logger LOG = Logger.getLogger("ImageXLogger");
    private final Retryer<Boolean> uploadRetryer = ImageXServiceImpl.createUploadDefaultRetryer();
    private final Retryer<HttpResponse> httpRetryer = ImageXServiceImpl.createUploadDefaultRetryer();

    private ImageXServiceImpl() {
        super(ImageXConfig.serviceInfoMap.get("cn-north-1"), ImageXConfig.apiInfoList);
    }

    private ImageXServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, ImageXConfig.apiInfoList);
    }

    public static IImageXService getInstance() {
        return new ImageXServiceImpl();
    }

    public static IImageXService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = ImageXConfig.serviceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("ImageX not support region " + region);
        }
        return new ImageXServiceImpl(serviceInfo);
    }

    private static <R> Retryer<R> createUploadDefaultRetryer() {
        return RetryerBuilder.newBuilder().retryIfException().retryIfResult(it -> Objects.equals(it, false)).retryIfResult(Objects::isNull).withWaitStrategy(WaitStrategies.exponentialWait()).withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).build();
    }

    @Override
    public ApplyImageUploadResponse applyImageUpload(ApplyImageUploadRequest req) throws Exception {
        RawResponse response = this.query("ApplyImageUpload", Utils.paramsToPair(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ApplyImageUploadResponse res = (ApplyImageUploadResponse)JSON.parseObject((byte[])response.getData(), ApplyImageUploadResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public CommitImageUploadResponse commitImageUpload(CommitImageUploadRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        Boolean skipMeta = req.getSkipMeta();
        if (Objects.equals(skipMeta, Boolean.TRUE)) {
            params.put("SkipMeta", "true");
        } else if (Objects.equals(skipMeta, Boolean.FALSE)) {
            params.put("SkipMeta", "false");
        }
        CommitImageUploadRequestBody reqBody = new CommitImageUploadRequestBody();
        reqBody.setSessionKey(req.getSessionKey());
        reqBody.setOptionInfos(req.getOptionInfos());
        RawResponse response = this.json("CommitImageUpload", Utils.mapToPairList(params), JSON.toJSONString((Object)reqBody));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        CommitImageUploadResponse res = (CommitImageUploadResponse)JSON.parseObject((byte[])response.getData(), CommitImageUploadResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    private void doUpload(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, InputStream imageData) throws Exception {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = imageData.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        this.doUpload(host, storeInfo, buffer.toByteArray());
    }

    private void doUpload(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, byte[] imageData) throws Exception {
        long crc32 = Utils.crc32(imageData);
        String checkSum = String.format("%08x", crc32);
        String url = String.format("https://%s/%s", host, storeInfo.getStoreUri());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-CRC32", checkSum);
        headers.put("Authorization", storeInfo.getAuth());
        long startTime = System.currentTimeMillis();
        this.uploadRetryer.call(() -> this.putData(url, imageData, (Map<String, String>)headers));
        long endTime = System.currentTimeMillis();
        long cost = endTime - startTime;
        float avgSpeed = (float)imageData.length / (float)cost;
        System.out.printf("upload image cost {%d} ms, avgSpeed: {%f} KB/s%n", cost, Float.valueOf(avgSpeed));
    }

    private void chunkUpload(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, InputStream content, Long size, boolean isLargeFile) throws Exception {
        String uploadID = this.initUploadPart(host, storeInfo, isLargeFile);
        byte[] data = new byte[0x1400000];
        ArrayList<String> parts = new ArrayList<String>();
        long num = size / 0x1400000L;
        long lastNum = num - 1L;
        try (BufferedInputStream bis = new BufferedInputStream(content);){
            long partNumber;
            for (long i = 0L; i < lastNum; ++i) {
                int readSize = bis.read(data);
                if (readSize != 0x1400000) {
                    throw new IllegalStateException(String.format("can not read a full chunk from content, %s expected but %s read", 0x1400000, readSize));
                }
                partNumber = isLargeFile ? i + 1L : i;
                parts.add(this.uploadPart(host, storeInfo, uploadID, partNumber, data, isLargeFile));
            }
            long readCount = 0x1400000L * lastNum;
            int len = (int)(size - readCount);
            byte[] lastPart = new byte[len];
            int readSize = bis.read(lastPart);
            if (readSize != len) {
                throw new IllegalStateException(String.format("can not read a full chunk from content, %s expected but %s read", len, readSize));
            }
            partNumber = isLargeFile ? lastNum + 1L : lastNum;
            parts.add(this.uploadPart(host, storeInfo, uploadID, partNumber, lastPart, isLargeFile));
        }
        this.uploadMergePart(host, storeInfo, uploadID, parts.toArray(new String[0]), isLargeFile);
    }

    private String initUploadPart(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, boolean isLargeFile) throws Exception {
        HttpResponse httpResponse;
        String url = new URI("https", null, host, -1, "/" + storeInfo.getStoreUri(), "uploads", null).toASCIIString();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", storeInfo.getAuth());
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        if ((httpResponse = (HttpResponse)this.httpRetryer.call(() -> this.putDataWithResponse(url, new byte[0], (Map<String, String>)headers))) == null) {
            throw new RuntimeException("init part error, response is empty");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("http code is " + httpResponse.getStatusLine().getStatusCode());
        }
        String entity = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        JSONObject result = JSONObject.parseObject((String)entity);
        return result.getJSONObject("payload").getInnerMap().get("uploadID").toString();
    }

    private String uploadPart(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, String uploadID, long partNumber, byte[] data, boolean isLargeFile) throws Exception {
        String query = String.format("partNumber=%d&uploadID=%s", partNumber, uploadID);
        String url = new URI("https", null, host, -1, "/" + storeInfo.getStoreUri(), query, null).toASCIIString();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", storeInfo.getAuth());
        long crc32 = Utils.crc32(data);
        String checkSum = String.format("%08x", crc32);
        headers.put("Content-CRC32", checkSum);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        this.uploadRetryer.call(() -> this.putData(url, data, (Map<String, String>)headers));
        return checkSum;
    }

    private void uploadMergePart(String host, ApplyImageUploadResponse.StoreInfosBean storeInfo, String uploadID, String[] checkSum, boolean isLargeFile) throws Exception {
        String query = String.format("uploadID=%s", uploadID);
        String url = new URI("https", null, host, -1, "/" + storeInfo.getStoreUri(), query, null).toASCIIString();
        String body = IntStream.range(0, checkSum.length).mapToObj(i -> String.format("%d:%s", i, checkSum[i])).collect(Collectors.joining(",", "", ""));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", storeInfo.getAuth());
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        this.uploadRetryer.call(() -> this.putData(url, body.getBytes(), (Map<String, String>)headers));
    }

    private CommitImageUploadResponse generateSkipCommitResponse(List<ApplyImageUploadResponse.StoreInfosBean> storeInfos, List<String> successOids) {
        ArrayList<CommitImageUploadResponse.UploadImageResultBean> imageResults = new ArrayList<CommitImageUploadResponse.UploadImageResultBean>();
        for (ApplyImageUploadResponse.StoreInfosBean item : storeInfos) {
            CommitImageUploadResponse.UploadImageResultBean itemResult = new CommitImageUploadResponse.UploadImageResultBean();
            itemResult.setUri(item.getStoreUri());
            if (successOids.stream().anyMatch(it -> it.equals(item.getStoreUri()))) {
                itemResult.setUriStatus(2000);
            } else {
                itemResult.setUriStatus(2001);
            }
            imageResults.add(itemResult);
        }
        CommitImageUploadResponse.CommitImageUploadResultBean result = new CommitImageUploadResponse.CommitImageUploadResultBean();
        result.setResults(imageResults);
        CommitImageUploadResponse ret = new CommitImageUploadResponse();
        ret.setResponseMetadata(new ResponseMetadata());
        ret.setResult(result);
        return ret;
    }

    @Override
    public CommitImageUploadResponse uploadImages(ApplyImageUploadRequest request, List<byte[]> imageDatas) throws Exception {
        if (imageDatas.size() == 0) {
            throw new Exception("empty image data");
        }
        request.setUploadNum(imageDatas.size());
        ApplyImageUploadResponse applyResp = this.applyImageUpload(request);
        this.applyRespGuard(applyResp, imageDatas.size());
        ApplyImageUploadResponse.UploadAddressBean uploadAddr = applyResp.getResult().getUploadAddress();
        List<ApplyImageUploadResponse.StoreInfosBean> storeInfos = uploadAddr.getStoreInfos();
        String uploadHost = uploadAddr.getUploadHosts().get(0);
        String sessionKey = uploadAddr.getSessionKey();
        ArrayList<String> successOids = new ArrayList<String>();
        for (int i = 0; i < imageDatas.size(); ++i) {
            try {
                ApplyImageUploadResponse.StoreInfosBean storeInfo = storeInfos.get(i);
                this.doUpload(uploadHost, storeInfo, imageDatas.get(i));
                successOids.add(storeInfo.getStoreUri());
                continue;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, e, e::getMessage);
            }
        }
        if (Objects.equals(Boolean.TRUE, request.getSkipCommit())) {
            return this.generateSkipCommitResponse(storeInfos, successOids);
        }
        CommitImageUploadRequest commitRequest = new CommitImageUploadRequest();
        commitRequest.setServiceId(request.getServiceId());
        commitRequest.setSessionKey(sessionKey);
        commitRequest.setSuccessOids(successOids);
        commitRequest.setSkipMeta(request.getSkipMeta());
        if (request.getCommitParam() != null) {
            commitRequest.setFunctions(request.getCommitParam().getFunctions());
            commitRequest.setOptionInfos(request.getCommitParam().getOptionInfos());
        }
        return this.commitImageUpload(commitRequest);
    }

    @Override
    public CommitImageUploadResponse uploadImages(ApplyImageUploadRequest request, List<InputStream> content, List<Long> size) throws Exception {
        if (size.size() != content.size()) {
            throw new IllegalArgumentException(String.format("expect size.size() == content.size() but  size.size() = %d, content.size() = %d", size.size(), content.size()));
        }
        request.setUploadNum(size.size());
        if (size.stream().anyMatch(it -> it == null || it <= 0L)) {
            throw new IllegalArgumentException("please ensure all elements in `size` is greater than 0");
        }
        if (content.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("please ensure all elements in `content` not null");
        }
        ApplyImageUploadResponse applyResp = this.applyImageUpload(request);
        this.applyRespGuard(applyResp, size.size());
        ApplyImageUploadResponse.UploadAddressBean uploadAddr = applyResp.getResult().getUploadAddress();
        List<ApplyImageUploadResponse.StoreInfosBean> storeInfos = uploadAddr.getStoreInfos();
        String uploadHost = uploadAddr.getUploadHosts().get(0);
        String sessionKey = uploadAddr.getSessionKey();
        ArrayList<String> successOids = new ArrayList<String>();
        for (int i = 0; i < size.size(); ++i) {
            long fileSize = size.get(i);
            InputStream fileContent = content.get(i);
            ApplyImageUploadResponse.StoreInfosBean storeInfo = storeInfos.get(i);
            try {
                if (fileSize <= 0x1400000L) {
                    this.doUpload(uploadHost, storeInfo, fileContent);
                } else {
                    boolean isLargeFile = fileSize > 0x40000000L;
                    this.chunkUpload(uploadHost, storeInfo, fileContent, fileSize, isLargeFile);
                }
                successOids.add(storeInfo.getStoreUri());
                continue;
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, e, e::getMessage);
            }
        }
        if (Objects.equals(Boolean.TRUE, request.getSkipCommit())) {
            return this.generateSkipCommitResponse(storeInfos, successOids);
        }
        CommitImageUploadRequest commitRequest = new CommitImageUploadRequest();
        commitRequest.setServiceId(request.getServiceId());
        commitRequest.setSessionKey(sessionKey);
        commitRequest.setSuccessOids(successOids);
        commitRequest.setSkipMeta(request.getSkipMeta());
        if (request.getCommitParam() != null) {
            commitRequest.setFunctions(request.getCommitParam().getFunctions());
            commitRequest.setOptionInfos(request.getCommitParam().getOptionInfos());
        }
        return this.commitImageUpload(commitRequest);
    }

    private void applyRespGuard(ApplyImageUploadResponse applyResp, int expectSize) {
        if (applyResp.getResult() == null) {
            throw new IllegalStateException("apply upload result is null");
        }
        ApplyImageUploadResponse.UploadAddressBean uploadAddr = applyResp.getResult().getUploadAddress();
        if (uploadAddr == null || uploadAddr.getUploadHosts() == null || uploadAddr.getUploadHosts().size() == 0) {
            throw new IllegalStateException("apply upload address is null");
        }
        List<ApplyImageUploadResponse.StoreInfosBean> storeInfos = uploadAddr.getStoreInfos();
        if (storeInfos.size() != expectSize) {
            throw new IllegalStateException("apply upload get wrong store infos");
        }
    }

    @Override
    public String getUploadToken(Map<String, String> params) throws Exception {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Version", "v1");
        List<NameValuePair> pairs = Utils.mapToPairList(params);
        String applyUploadToken = this.getSignUrl("ApplyImageUpload", pairs);
        ret.put("ApplyUploadToken", applyUploadToken);
        String commitUploadToken = this.getSignUrl("CommitImageUpload", pairs);
        ret.put("CommitUploadToken", commitUploadToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public SecurityToken2 getUploadSts2(List<String> serviceIds) throws Exception {
        return this.getUploadSts2WithKeyPtn(serviceIds, 3600000L, "");
    }

    @Override
    public SecurityToken2 getUploadSts2WithExpire(List<String> serviceIds, long expire) throws Exception {
        return this.getUploadSts2WithKeyPtn(serviceIds, expire, "");
    }

    @Override
    public SecurityToken2 getUploadSts2WithKeyPtn(List<String> serviceIds, long expire, String keyPtn) throws Exception {
        ArrayList<String> applyRes = new ArrayList<String>();
        ArrayList<String> commitRes = new ArrayList<String>();
        if (serviceIds.size() == 0) {
            applyRes.add(String.format("trn:ImageX:*:*:ServiceId/%s", "*"));
            commitRes.add(String.format("trn:ImageX:*:*:ServiceId/%s", "*"));
        } else {
            for (String serviceId : serviceIds) {
                applyRes.add(String.format("trn:ImageX:*:*:ServiceId/%s", serviceId));
                commitRes.add(String.format("trn:ImageX:*:*:ServiceId/%s", serviceId));
            }
        }
        applyRes.add(String.format("trn:ImageX:*:*:StoreKeys/%s", keyPtn));
        Policy inlinePolicy = new Policy();
        Statement applyStatement = Sts2Utils.newAllowStatement(Collections.singletonList("ImageX:ApplyImageUpload"), applyRes);
        Statement commitStatement = Sts2Utils.newAllowStatement(Collections.singletonList("ImageX:CommitImageUpload"), commitRes);
        inlinePolicy.addStatement(applyStatement);
        inlinePolicy.addStatement(commitStatement);
        return this.signSts2(inlinePolicy, expire);
    }

    @Override
    public DeleteImageResp deleteImages(DeleteImageReq req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("DeleteImageUploadFiles", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DeleteImageResp res = (DeleteImageResp)JSON.parseObject((byte[])response.getData(), DeleteImageResp.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public GetImageUploadFileResponse getImageUploadFile(GetImageUploadFileRequest req) throws Exception {
        RawResponse response = this.query("GetImageUploadFile", Utils.paramsToPair(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageUploadFileResponse res = (GetImageUploadFileResponse)JSON.parseObject((byte[])response.getData(), GetImageUploadFileResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public GetImageUploadFilesResponse getImageUploadFiles(GetImageUploadFilesRequest req) throws Exception {
        RawResponse response = this.query("GetImageUploadFiles", Utils.paramsToPair(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageUploadFilesResponse res = (GetImageUploadFilesResponse)JSON.parseObject((byte[])response.getData(), GetImageUploadFilesResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public UpdateImageStorageTTLResponse updateImageStorageTTL(UpdateImageStorageTTLRequest req) throws Exception {
        return this.postImageX("UpdateImageStorageTTL", EMPTY_STRING_STRING_MAP, req, UpdateImageStorageTTLResponse.class).getResult();
    }

    @Override
    public CreateImageContentTaskResp createImageContentTask(CreateImageContentTaskReq req) throws Exception {
        return this.postImageX("CreateImageContentTask", Collections.singletonMap("ServiceId", req.getServiceId()), req, CreateImageContentTaskResp.class).getResult();
    }

    @Override
    public GetImageContentTaskDetailResp getImageContentTaskDetail(GetImageContentTaskDetailReq req) throws Exception {
        return this.postImageX("GetImageContentTaskDetail", Collections.singletonMap("ServiceId", req.getServiceId()), req, GetImageContentTaskDetailResp.class).getResult();
    }

    @Override
    public GetImageContentBlockListResp getImageContentBlockList(GetImageContentBlockListReq req) throws Exception {
        return this.postImageX("GetImageContentBlockList", Collections.singletonMap("ServiceId", req.getServiceId()), req, GetImageContentBlockListResp.class).getResult();
    }

    @Override
    public CommonResponse getImageX(String action, Map<String, String> param) throws Exception {
        RawResponse response = this.query(action, Utils.mapToPairList(param));
        return this.parseRawRes(response);
    }

    @Override
    public CommonResponse postImageX(String action, Map<String, String> param, Object req) throws Exception {
        RawResponse response = this.json(action, Utils.mapToPairList(param), JSON.toJSONString((Object)req));
        return this.parseRawRes(response);
    }

    private CommonResponse parseRawRes(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        CommonResponse res = (CommonResponse)JSON.parseObject((byte[])response.getData(), CommonResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public <T> GenericCommonResponse<T> getImageX(String action, Map<String, String> param, Class<T> respType) throws Exception {
        RawResponse response = this.query(action, Utils.mapToPairList(param));
        return this.parseRawResToGeneric(response, respType);
    }

    @Override
    public <T> GenericCommonResponse<T> postImageX(String action, Map<String, String> param, Object req, Class<T> respType) throws Exception {
        RawResponse response = this.json(action, Utils.mapToPairList(param), JSON.toJSONString((Object)req));
        return this.parseRawResToGeneric(response, respType);
    }

    private <T> GenericCommonResponse<T> parseRawResToGeneric(RawResponse response, Class<T> respType) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ParameterizedTypeImpl type = new ParameterizedTypeImpl(new Type[]{respType}, null, GenericCommonResponse.class);
        GenericCommonResponse res = (GenericCommonResponse)JSON.parseObject((byte[])response.getData(), (Type)type, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("ImageX");
        return res;
    }

    @Override
    public FetchImageUrlResponse fetchImageUrl(FetchImageUrlRequest request) throws Exception {
        RawResponse response = this.json("FetchImageUrl", null, JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        FetchImageUrlResponse res = (FetchImageUrlResponse)JSON.parseObject((byte[])response.getData(), FetchImageUrlResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetUrlFetchTaskResponse getUrlFetchTask(GetUrlFetchTaskRequest req) throws Exception {
        return this.getImageX("GetUrlFetchTask", Utils.paramsToMap(req), GetUrlFetchTaskResponse.class).getResult();
    }

    @Override
    public GetImageOCRResponse getImageOCRV2(GetImageOCRRequest param) throws Exception {
        RawResponse response = this.json("GetImageOCRV2", Utils.paramsToPair(param), JSON.toJSONString((Object)param));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageOCRResponse res = (GetImageOCRResponse)JSON.parseObject((byte[])response.getData(), GetImageOCRResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public EmbedImageHmResponse embedImageHm(EmbedImageHmRequest req) throws Exception {
        RawResponse response = this.json("CreateImageHmEmbed", null, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        EmbedImageHmResponse res = (EmbedImageHmResponse)JSON.parseObject((byte[])response.getData(), EmbedImageHmResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public ExtractImageHmResponse extractImageHm(ExtractImageHmRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        params.put("StoreUri", req.getStoreUri());
        params.put("Algorithm", req.getAlgorithm());
        RawResponse response = this.query("CreateImageHmExtract", Utils.mapToPairList(params));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ExtractImageHmResponse res = (ExtractImageHmResponse)JSON.parseObject((byte[])response.getData(), ExtractImageHmResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageSegmentResponse getImageSegment(GetImageSegmentRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetSegmentImage", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageSegmentResponse res = (GetImageSegmentResponse)JSON.parseObject((byte[])response.getData(), GetImageSegmentResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageEraseModelsResponse getImageEraseModels(GetImageEraseModelsRequest req) throws Exception {
        RawResponse response = this.query("GetImageEraseModels", Utils.paramsToPair(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageEraseModelsResponse res = (GetImageEraseModelsResponse)JSON.parseObject((byte[])response.getData(), GetImageEraseModelsResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageEraseResultResponse getImageEraseResult(GetImageEraseResultRequest req) throws Exception {
        RawResponse response = this.json("GetImageEraseResult", null, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageEraseResultResponse res = (GetImageEraseResultResponse)JSON.parseObject((byte[])response.getData(), GetImageEraseResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageQualityResponse getImageQuality(GetImageQualityRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetImageQuality", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageQualityResponse res = (GetImageQualityResponse)JSON.parseObject((byte[])response.getData(), GetImageQualityResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageBgFillResultResponse getImageBgFillResult(GetImageBgFillResultRequest req) throws Exception {
        RawResponse response = this.json("GetImageBgFillResult", Collections.EMPTY_LIST, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageBgFillResultResponse res = (GetImageBgFillResultResponse)JSON.parseObject((byte[])response.getData(), GetImageBgFillResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageDuplicateDetectionSyncResponse getImageDuplicateDetectionSync(GetImageDuplicateDetectionSyncRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetImageDuplicateDetection", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageDuplicateDetectionSyncResponse res = (GetImageDuplicateDetectionSyncResponse)JSON.parseObject((byte[])response.getData(), GetImageDuplicateDetectionSyncResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageDuplicateDetectionAsyncResponse getImageDuplicateDetectionAsync(GetImageDuplicateDetectionAsyncRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetImageDuplicateDetection", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageDuplicateDetectionAsyncResponse res = (GetImageDuplicateDetectionAsyncResponse)JSON.parseObject((byte[])response.getData(), GetImageDuplicateDetectionAsyncResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetDeduplicateTaskStatusResponse getDeduplicateTaskStatus(GetDeduplicateTaskStatusRequest req) throws Exception {
        RawResponse response = this.query("GetDedupTaskStatus", Utils.paramsToPair(req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetDeduplicateTaskStatusResponse res = (GetDeduplicateTaskStatusResponse)JSON.parseObject((byte[])response.getData(), GetDeduplicateTaskStatusResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetDenoisingImageResponse getDenoisingImage(GetDenoisingImageRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetDenoisingImage", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetDenoisingImageResponse res = (GetDenoisingImageResponse)JSON.parseObject((byte[])response.getData(), GetDenoisingImageResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageComicResultResponse getImageComicResult(GetImageComicResultRequest req) throws Exception {
        RawResponse response = this.json("GetImageComicResult", Collections.EMPTY_LIST, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageComicResultResponse res = (GetImageComicResultResponse)JSON.parseObject((byte[])response.getData(), GetImageComicResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageSuperResolutionResultResponse getImageSuperResolutionResult(GetImageSuperResolutionResultRequest req) throws Exception {
        RawResponse response = this.json("GetImageSuperResolutionResult", Collections.EMPTY_LIST, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageSuperResolutionResultResponse res = (GetImageSuperResolutionResultResponse)JSON.parseObject((byte[])response.getData(), GetImageSuperResolutionResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageSmartCropResultResponse getImageSmartCropResult(GetImageSmartCropResultRequest req) throws Exception {
        RawResponse response = this.json("GetImageSmartCropResult", Collections.EMPTY_LIST, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageSmartCropResultResponse res = (GetImageSmartCropResultResponse)JSON.parseObject((byte[])response.getData(), GetImageSmartCropResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetLicensePlateDetectionResponse getLicensePlateDetection(GetLicensePlateDetectionRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetLicensePlateDetection", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetLicensePlateDetectionResponse res = (GetLicensePlateDetectionResponse)JSON.parseObject((byte[])response.getData(), GetLicensePlateDetectionResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImagePSDetectionResponse getImagePSDetection(GetImagePSDetectionRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetImagePSDetection", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImagePSDetectionResponse res = (GetImagePSDetectionResponse)JSON.parseObject((byte[])response.getData(), GetImagePSDetectionResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetPrivateImageTypeResponse getPrivateImageType(GetPrivateImageTypeRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetPrivateImageType", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetPrivateImageTypeResponse res = (GetPrivateImageTypeResponse)JSON.parseObject((byte[])response.getData(), GetPrivateImageTypeResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageEnhanceResultResponse getImageEnhanceResult(GetImageEnhanceResultRequest req) throws Exception {
        RawResponse response = this.json("GetImageEnhanceResult", Collections.EMPTY_LIST, JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageEnhanceResultResponse res = (GetImageEnhanceResultResponse)JSON.parseObject((byte[])response.getData(), GetImageEnhanceResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public GetImageStyleResultResponse getImageStyleResult(GetImageStyleResultRequest req) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ServiceId", req.getServiceId());
        RawResponse response = this.json("GetImageStyleResult", Utils.mapToPairList(params), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetImageStyleResultResponse res = (GetImageStyleResultResponse)JSON.parseObject((byte[])response.getData(), GetImageStyleResultResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + " error: " + meta.getError().getMessage());
        }
        return res;
    }

    @Override
    public CreateImageMigrateTaskResp createImageMigrateTask(CreateImageMigrateTaskReq req) throws Exception {
        return this.postImageX("CreateImageMigrateTask", EMPTY_STRING_STRING_MAP, req, CreateImageMigrateTaskResp.class).getResult();
    }

    @Override
    public GetImageMigrateTasksResp getImageMigrateTask(GetImageMigrateTasksReq req) throws Exception {
        return this.getImageX("GetImageMigrateTasks", Utils.paramsToMap(req), GetImageMigrateTasksResp.class).getResult();
    }

    @Override
    public CreateImageTranscodeTaskResp createImageTranscodeTask(CreateImageTranscodeTaskReq req) throws Exception {
        return this.postImageX("CreateImageTranscodeTask", EMPTY_STRING_STRING_MAP, req, CreateImageTranscodeTaskResp.class).getResult();
    }

    @Override
    public DescribeImageXDomainTrafficDataResp describeImageXDomainTrafficData(DescribeImageXDomainTrafficDataReq req) throws Exception {
        return this.getImageX("DescribeImageXDomainTrafficData", Utils.paramsToMap(req), DescribeImageXDomainTrafficDataResp.class).getResult();
    }

    @Override
    public DescribeImageXDomainBandwidthDataResp describeImageXDomainBandwidthData(DescribeImageXDomainBandwidthDataReq req) throws Exception {
        return this.getImageX("DescribeImageXDomainBandwidthData", Utils.paramsToMap(req), DescribeImageXDomainBandwidthDataResp.class).getResult();
    }

    @Override
    public DescribeImageXBucketUsageResp describeImageXBucketUsage(DescribeImageXBucketUsageReq req) throws Exception {
        return this.getImageX("DescribeImageXBucketUsage", Utils.paramsToMap(req), DescribeImageXBucketUsageResp.class).getResult();
    }

    @Override
    public DescribeImageXRequestCntUsageResp describeImageXRequestCntUsage(DescribeImageXRequestCntUsageReq req) throws Exception {
        return this.getImageX("DescribeImageXRequestCntUsage", Utils.paramsToMap(req), DescribeImageXRequestCntUsageResp.class).getResult();
    }

    @Override
    public DescribeImageXBaseOpUsageResp describeImageXBaseOpUsage(DescribeImageXBaseOpUsageReq req) throws Exception {
        return this.getImageX("DescribeImageXBaseOpUsage", Utils.paramsToMap(req), DescribeImageXBaseOpUsageResp.class).getResult();
    }

    @Override
    public DescribeImageXCompressUsageResp describeImageXCompressUsage(DescribeImageXCompressUsageReq req) throws Exception {
        return this.getImageX("DescribeImageXCompressUsage", Utils.paramsToMap(req), DescribeImageXCompressUsageResp.class).getResult();
    }

    @Override
    public DescribeImageXEdgeRequestResp describeImageXEdgeRequest(DescribeImageXEdgeRequestReq req) throws Exception {
        return this.getImageX("DescribeImageXEdgeRequest", Utils.paramsToMap(req), DescribeImageXEdgeRequestResp.class).getResult();
    }

    @Override
    public DescribeImageXHitRateTrafficDataResp describeImageXHitRateTrafficData(DescribeImageXHitRateTrafficDataReq req) throws Exception {
        return this.getImageX("DescribeImageXHitRateTrafficData", Utils.paramsToMap(req), DescribeImageXHitRateTrafficDataResp.class).getResult();
    }

    @Override
    public DescribeImageXHitRateRequestDataResp describeImageXHitRateRequestData(DescribeImageXHitRateRequestDataReq req) throws Exception {
        return this.getImageX("DescribeImageXHitRateRequestData", Utils.paramsToMap(req), DescribeImageXHitRateRequestDataResp.class).getResult();
    }

    @Override
    public DescribeImageXCDNTopRequestDataResp describeImageXCDNTopRequestData(DescribeImageXCDNTopRequestDataReq req) throws Exception {
        return this.getImageX("DescribeImageXCDNTopRequestData", Utils.paramsToMap(req), DescribeImageXCDNTopRequestDataResp.class).getResult();
    }

    @Override
    public DescribeImageXSummaryResp describeImageXSummary(DescribeImageXSummaryReq req) throws Exception {
        return this.getImageX("DescribeImageXSummary", Utils.paramsToMap(req), DescribeImageXSummaryResp.class).getResult();
    }

    @Override
    public DescribeImageXEdgeRequestBandwidthResp describeImageXEdgeRequestBandwidth(DescribeImageXEdgeRequestBandwidthReq req) throws Exception {
        return this.getImageX("DescribeImageXEdgeRequestBandwidth", Utils.paramsToMap(req), DescribeImageXEdgeRequestBandwidthResp.class).getResult();
    }

    @Override
    public DescribeImageXEdgeRequestTrafficResp describeImageXEdgeRequestTraffic(DescribeImageXEdgeRequestTrafficReq req) throws Exception {
        return this.getImageX("DescribeImageXEdgeRequestTraffic", Utils.paramsToMap(req), DescribeImageXEdgeRequestTrafficResp.class).getResult();
    }

    @Override
    public DescribeImageXEdgeRequestRegionsResp describeImageXEdgeRequestRegions(DescribeImageXEdgeRequestRegionsReq req) throws Exception {
        return this.getImageX("DescribeImageXEdgeRequestRegions", Utils.paramsToMap(req), DescribeImageXEdgeRequestRegionsResp.class).getResult();
    }

    @Override
    public DescribeImageXServiceQualityResp describeImageXServiceQuality(DescribeImageXServiceQualityReq req) throws Exception {
        return this.getImageX("DescribeImageXServiceQuality", Utils.paramsToMap(req), DescribeImageXServiceQualityResp.class).getResult();
    }

    @Override
    public GetImageXQueryAppsResp getImageXQueryApps(GetImageXQueryAppsReq req) throws Exception {
        return this.getImageX("GetImageXQueryApps", Utils.paramsToMap(req), GetImageXQueryAppsResp.class).getResult();
    }

    @Override
    public GetImageXQueryRegionsResp getImageXQueryRegions(GetImageXQueryRegionsReq req) throws Exception {
        return this.getImageX("GetImageXQueryRegions", Utils.paramsToMap(req), GetImageXQueryRegionsResp.class).getResult();
    }

    @Override
    public GetImageXQueryDimsResp getImageXQueryDims(GetImageXQueryDimsReq req) throws Exception {
        return this.getImageX("GetImageXQueryDims", Utils.paramsToMap(req), GetImageXQueryDimsResp.class).getResult();
    }

    @Override
    public GetImageXQueryValsResp getImageXQueryVals(GetImageXQueryValsReq req) throws Exception {
        return this.getImageX("GetImageXQueryVals", Utils.paramsToMap(req), GetImageXQueryValsResp.class).getResult();
    }

    @Override
    public DescribeImageXMirrorRequestTrafficResp describeImageXMirrorRequestTraffic(DescribeImageXMirrorRequestTrafficReq req) throws Exception {
        return this.postImageX("DescribeImageXMirrorRequestTraffic", EMPTY_STRING_STRING_MAP, req, DescribeImageXMirrorRequestTrafficResp.class).getResult();
    }

    @Override
    public DescribeImageXMirrorRequestBandwidthResp describeImageXMirrorRequestBandwidth(DescribeImageXMirrorRequestBandwidthReq req) throws Exception {
        return this.postImageX("DescribeImageXMirrorRequestBandwidth", EMPTY_STRING_STRING_MAP, req, DescribeImageXMirrorRequestBandwidthResp.class).getResult();
    }

    @Override
    public DescribeImageXMirrorRequestHttpCodeByTimeResp describeImageXMirrorRequestHttpCodeByTime(DescribeImageXMirrorRequestHttpCodeByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXMirrorRequestHttpCodeByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXMirrorRequestHttpCodeByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXMirrorRequestHttpCodeOverviewResp describeImageXMirrorRequestHttpCodeOverview(DescribeImageXMirrorRequestHttpCodeOverviewReq req) throws Exception {
        return this.postImageX("DescribeImageXMirrorRequestHttpCodeOverview", EMPTY_STRING_STRING_MAP, req, DescribeImageXMirrorRequestHttpCodeOverviewResp.class).getResult();
    }

    @Override
    public DescribeImageXUploadSuccessRateByTimeResp describeImageXUploadSuccessRateByTime(DescribeImageXUploadSuccessRateByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXUploadSuccessRateByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXUploadSuccessRateByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXUploadErrorCodeAllResp describeImageXUploadErrorCodeAll(DescribeImageXUploadErrorCodeAllReq req) throws Exception {
        return this.postImageX("DescribeImageXUploadErrorCodeAll", EMPTY_STRING_STRING_MAP, req, DescribeImageXUploadErrorCodeAllResp.class).getResult();
    }

    @Override
    public DescribeImageXUploadErrorCodeByTimeResp describeImageXUploadErrorCodeByTime(DescribeImageXUploadErrorCodeByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXUploadErrorCodeByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXUploadErrorCodeByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXUploadCountByTimeResp describeImageXUploadCountByTime(DescribeImageXUploadCountByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXUploadCountByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXUploadCountByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXUploadFileSizeResp describeImageXUploadFileSize(DescribeImageXUploadFileSizeReq req) throws Exception {
        return this.postImageX("DescribeImageXUploadFileSize", EMPTY_STRING_STRING_MAP, req, DescribeImageXUploadFileSizeResp.class).getResult();
    }

    @Override
    public DescribeImageXUploadSpeedResp describeImageXUploadSpeed(DescribeImageXUploadSpeedReq req) throws Exception {
        return this.postImageX("DescribeImageXUploadSpeed", EMPTY_STRING_STRING_MAP, req, DescribeImageXUploadSpeedResp.class).getResult();
    }

    @Override
    public DescribeImageXUploadDurationResp describeImageXUploadDuration(DescribeImageXUploadDurationReq req) throws Exception {
        return this.postImageX("DescribeImageXUploadDuration", EMPTY_STRING_STRING_MAP, req, DescribeImageXUploadDurationResp.class).getResult();
    }

    @Override
    public DescribeImageXUploadSegmentSpeedByTimeResp describeImageXUploadSegmentSpeedByTime(DescribeImageXUploadSegmentSpeedByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXUploadSegmentSpeedByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXUploadSegmentSpeedByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXCdnSuccessRateByTimeResp describeImageXCdnSuccessRateByTime(DescribeImageXCdnSuccessRateByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXCdnSuccessRateByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXCdnSuccessRateByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXCdnSuccessRateAllResp describeImageXCdnSuccessRateAll(DescribeImageXCdnSuccessRateAllReq req) throws Exception {
        return this.postImageX("DescribeImageXCdnSuccessRateAll", EMPTY_STRING_STRING_MAP, req, DescribeImageXCdnSuccessRateAllResp.class).getResult();
    }

    @Override
    public DescribeImageXCdnErrorCodeByTimeResp describeImageXCdnErrorCodeByTime(DescribeImageXCdnErrorCodeByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXCdnErrorCodeByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXCdnErrorCodeByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXCdnErrorCodeAllResp describeImageXCdnErrorCodeAll(DescribeImageXCdnErrorCodeAllReq req) throws Exception {
        return this.postImageX("DescribeImageXCdnErrorCodeAll", EMPTY_STRING_STRING_MAP, req, DescribeImageXCdnErrorCodeAllResp.class).getResult();
    }

    @Override
    public DescribeImageXCdnDurationDetailByTimeResp describeImageXCdnDurationDetailByTime(DescribeImageXCdnDurationDetailByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXCdnDurationDetailByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXCdnDurationDetailByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXCdnDurationAllResp describeImageXCdnDurationAll(DescribeImageXCdnDurationAllReq req) throws Exception {
        return this.postImageX("DescribeImageXCdnDurationAll", EMPTY_STRING_STRING_MAP, req, DescribeImageXCdnDurationAllResp.class).getResult();
    }

    @Override
    public DescribeImageXCdnReuseRateByTimeResp describeImageXCdnReuseRateByTime(DescribeImageXCdnReuseRateByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXCdnReuseRateByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXCdnReuseRateByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXCdnReuseRateAllResp describeImageXCdnReuseRateAll(DescribeImageXCdnReuseRateAllReq req) throws Exception {
        return this.postImageX("DescribeImageXCdnReuseRateAll", EMPTY_STRING_STRING_MAP, req, DescribeImageXCdnReuseRateAllResp.class).getResult();
    }

    @Override
    public DescribeImageXCdnProtocolRateByTimeResp describeImageXCdnProtocolRateByTime(DescribeImageXCdnProtocolRateByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXCdnProtocolRateByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXCdnProtocolRateByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXClientErrorCodeAllResp describeImageXClientErrorCodeAll(DescribeImageXClientErrorCodeAllReq req) throws Exception {
        return this.postImageX("DescribeImageXClientErrorCodeAll", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientErrorCodeAllResp.class).getResult();
    }

    @Override
    public DescribeImageXClientErrorCodeByTimeResp describeImageXClientErrorCodeByTime(DescribeImageXClientErrorCodeByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXClientErrorCodeByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientErrorCodeByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXClientDecodeSuccessRateByTimeResp describeImageXClientDecodeSuccessRateByTime(DescribeImageXClientDecodeSuccessRateByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXClientDecodeSuccessRateByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientDecodeSuccessRateByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXClientDecodeDurationByTimeResp describeImageXClientDecodeDurationByTime(DescribeImageXClientDecodeDurationByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXClientDecodeDurationByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientDecodeDurationByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXClientQueueDurationByTimeResp describeImageXClientQueueDurationByTime(DescribeImageXClientQueueDurationByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXClientQueueDurationByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientQueueDurationByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXClientLoadDurationAllResp describeImageXClientLoadDurationAll(DescribeImageXClientLoadDurationAllReq req) throws Exception {
        return this.postImageX("DescribeImageXClientLoadDurationAll", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientLoadDurationAllResp.class).getResult();
    }

    @Override
    public DescribeImageXClientLoadDurationResp describeImageXClientLoadDuration(DescribeImageXClientLoadDurationReq req) throws Exception {
        return this.postImageX("DescribeImageXClientLoadDuration", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientLoadDurationResp.class).getResult();
    }

    @Override
    public DescribeImageXClientFailureRateResp describeImageXClientFailureRate(DescribeImageXClientFailureRateReq req) throws Exception {
        return this.postImageX("DescribeImageXClientFailureRate", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientFailureRateResp.class).getResult();
    }

    @Override
    public DescribeImageXClientSdkVerByTimeResp describeImageXClientSdkVerByTime(DescribeImageXClientSdkVerByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXClientSdkVerByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientSdkVerByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXClientFileSizeResp describeImageXClientFileSize(DescribeImageXClientFileSizeReq req) throws Exception {
        return this.postImageX("DescribeImageXClientFileSize", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientFileSizeResp.class).getResult();
    }

    @Override
    public DescribeImageXClientTopFileSizeResp describeImageXClientTopFileSize(DescribeImageXClientTopFileSizeReq req) throws Exception {
        return this.postImageX("DescribeImageXClientTopFileSize", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientTopFileSizeResp.class).getResult();
    }

    @Override
    public DescribeImageXClientCountByTimeResp describeImageXClientCountByTime(DescribeImageXClientCountByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXClientCountByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientCountByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXClientScoreByTimeResp describeImageXClientScoreByTime(DescribeImageXClientScoreByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXClientScoreByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientScoreByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXClientDemotionRateByTimeResp describeImageXClientDemotionRateByTime(DescribeImageXClientDemotionRateByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXClientDemotionRateByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientDemotionRateByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXClientTopDemotionURLResp describeImageXClientTopDemotionURL(DescribeImageXClientTopDemotionURLReq req) throws Exception {
        return this.postImageX("DescribeImageXClientTopDemotionURL", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientTopDemotionURLResp.class).getResult();
    }

    @Override
    public DescribeImageXClientQualityRateByTimeResp describeImageXClientQualityRateByTime(DescribeImageXClientQualityRateByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXClientQualityRateByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientQualityRateByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXClientTopQualityURLResp describeImageXClientTopQualityURL(DescribeImageXClientTopQualityURLReq req) throws Exception {
        return this.postImageX("DescribeImageXClientTopQualityURL", EMPTY_STRING_STRING_MAP, req, DescribeImageXClientTopQualityURLResp.class).getResult();
    }

    @Override
    public DescribeImageXSensibleCountByTimeResp describeImageXSensibleCountByTime(DescribeImageXSensibleCountByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXSensibleCountByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXSensibleCountByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXSensibleCacheHitRateByTimeResp describeImageXSensibleCacheHitRateByTime(DescribeImageXSensibleCacheHitRateByTimeReq req) throws Exception {
        return this.postImageX("DescribeImageXSensibleCacheHitRateByTime", EMPTY_STRING_STRING_MAP, req, DescribeImageXSensibleCacheHitRateByTimeResp.class).getResult();
    }

    @Override
    public DescribeImageXSensibleTopSizeURLResp describeImageXSensibleTopSizeURL(DescribeImageXSensibleTopSizeURLReq req) throws Exception {
        return this.postImageX("DescribeImageXSensibleTopSizeURL", EMPTY_STRING_STRING_MAP, req, DescribeImageXSensibleTopSizeURLResp.class).getResult();
    }

    @Override
    public DescribeImageXSensibleTopRamURLResp describeImageXSensibleTopRamURL(DescribeImageXSensibleTopRamURLReq req) throws Exception {
        return this.postImageX("DescribeImageXSensibleTopRamURL", EMPTY_STRING_STRING_MAP, req, DescribeImageXSensibleTopRamURLResp.class).getResult();
    }

    @Override
    public DescribeImageXSensibleTopResolutionURLResp describeImageXSensibleTopResolutionURL(DescribeImageXSensibleTopResolutionURLReq req) throws Exception {
        return this.postImageX("DescribeImageXSensibleTopResolutionURL", EMPTY_STRING_STRING_MAP, req, DescribeImageXSensibleTopResolutionURLResp.class).getResult();
    }

    @Override
    public DescribeImageXSensibleTopUnknownURLResp describeImageXSensibleTopUnknownURL(DescribeImageXSensibleTopUnknownURLReq req) throws Exception {
        return this.postImageX("DescribeImageXSensibleTopUnknownURL", EMPTY_STRING_STRING_MAP, req, DescribeImageXSensibleTopUnknownURLResp.class).getResult();
    }

    @Override
    public DescribeImageVolcCdnAccessLogResp describeImageVolcCdnAccessLog(DescribeImageVolcCdnAccessLogReq req) throws Exception {
        return this.postImageX("DescribeImageVolcCdnAccessLog", Utils.paramsToMap(req), req, DescribeImageVolcCdnAccessLogResp.class).getResult();
    }
}

