/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.sms;

import com.volcengine.model.Credentials;
import com.volcengine.model.ServiceInfo;
import com.volcengine.service.sms.SmsServiceInfoConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;

public class SmsServiceInfo {
    private int connectionTimeout;
    private int socketTimeout;
    private String scheme;
    private String host;
    private List<Header> header;
    private Credentials credentials;
    private String ak;
    private String sk;
    private HttpHost proxy;

    public SmsServiceInfo(SmsServiceInfoConfig config) {
        this.connectionTimeout = config.getConnectionTimeout();
        this.socketTimeout = config.getSocketTimeout();
        this.scheme = Objects.equals(config.getScheme(), "") ? "http" : this.scheme;
        this.host = config.getHost();
        this.header = new ArrayList<Header>(){
            {
                this.add(new BasicHeader("Accept", "application/json"));
            }
        };
        this.credentials = new Credentials(config.getRegion(), "volcSMS");
        this.credentials.setSecretAccessKey(config.getSecretAccessKey());
        this.credentials.setAccessKeyID(config.getAccessKey());
        this.proxy = config.getProxy();
        this.ak = config.getAccessKey();
        this.sk = config.getSecretAccessKey();
    }

    public ServiceInfo GetServiceInfo() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ConnectionTimeout", this.getConnectionTimeout());
        param.put("SocketTimeout", this.getSocketTimeout());
        param.put("Scheme", this.getScheme());
        param.put("Host", this.getHost());
        param.put("Header", this.getHeader());
        param.put("Credentials", this.getCredentials());
        return new ServiceInfo(param);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public List<Header> getHeader() {
        return this.header;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getAk() {
        return this.ak;
    }

    public String getSk() {
        return this.sk;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setHeader(List<Header> header) {
        this.header = header;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setAk(String ak) {
        this.ak = ak;
    }

    public void setSk(String sk) {
        this.sk = sk;
    }

    public void setProxy(HttpHost proxy) {
        this.proxy = proxy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmsServiceInfo)) {
            return false;
        }
        SmsServiceInfo other = (SmsServiceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getSocketTimeout() != other.getSocketTimeout()) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        List<Header> this$header = this.getHeader();
        List<Header> other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        Credentials this$credentials = this.getCredentials();
        Credentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        String this$ak = this.getAk();
        String other$ak = other.getAk();
        if (this$ak == null ? other$ak != null : !this$ak.equals(other$ak)) {
            return false;
        }
        String this$sk = this.getSk();
        String other$sk = other.getSk();
        if (this$sk == null ? other$sk != null : !this$sk.equals(other$sk)) {
            return false;
        }
        HttpHost this$proxy = this.getProxy();
        HttpHost other$proxy = other.getProxy();
        return !(this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmsServiceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getSocketTimeout();
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        List<Header> $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        Credentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        String $ak = this.getAk();
        result = result * 59 + ($ak == null ? 43 : $ak.hashCode());
        String $sk = this.getSk();
        result = result * 59 + ($sk == null ? 43 : $sk.hashCode());
        HttpHost $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        return result;
    }

    public String toString() {
        return "SmsServiceInfo(connectionTimeout=" + this.getConnectionTimeout() + ", socketTimeout=" + this.getSocketTimeout() + ", scheme=" + this.getScheme() + ", host=" + this.getHost() + ", header=" + this.getHeader() + ", credentials=" + this.getCredentials() + ", ak=" + this.getAk() + ", sk=" + this.getSk() + ", proxy=" + this.getProxy() + ")";
    }
}

