/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.tls;

import com.volcengine.model.tls.producer.BatchLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RetryManager {
    private final AtomicInteger retryLock;
    private boolean closed = false;
    private static final Log LOG = LogFactory.getLog(RetryManager.class);
    private final DelayQueue<BatchLog> retryBatches = new DelayQueue();

    public RetryManager() {
        this.retryLock = new AtomicInteger(0);
    }

    public void put(BatchLog batchLog) {
        this.retryLock.incrementAndGet();
        if (!this.closed) {
            this.retryBatches.put(batchLog);
        }
        this.retryLock.decrementAndGet();
    }

    public List<BatchLog> handleTimeoutBatch(long remains) {
        long deadline = System.currentTimeMillis() + remains;
        ArrayList<BatchLog> expiredBatches = new ArrayList<BatchLog>();
        this.retryBatches.drainTo(expiredBatches);
        if (!expiredBatches.isEmpty()) {
            return expiredBatches;
        }
        while (remains >= 0L) {
            BatchLog batch;
            try {
                batch = (BatchLog)this.retryBatches.poll(remains, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Interrupted when poll batch from the retry batches");
                break;
            }
            if (batch == null) break;
            expiredBatches.add(batch);
            this.retryBatches.drainTo(expiredBatches);
            if (!expiredBatches.isEmpty()) break;
            remains = deadline - System.currentTimeMillis();
        }
        return expiredBatches;
    }

    public void close() {
        this.closed = true;
    }
}

