/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.tls;

import com.volcengine.model.Credentials;
import com.volcengine.model.ServiceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class ClientConfig {
    String endpoint;
    String accessKeyId;
    String accessKeySecret;
    String securityToken;
    String region;
    String apiVersion;

    public ClientConfig(String endPoint, String region, String accessKeyId, String accessKeySecret, String securityToken) {
        this(endPoint, region, accessKeyId, accessKeySecret, securityToken, "0.3.0");
    }

    public ClientConfig(String endPoint, String region, String accessKeyId, String accessKeySecret) {
        this(endPoint, region, accessKeyId, accessKeySecret, null);
    }

    public ClientConfig(String endPoint, String region, String accessKeyId, String accessKeySecret, String securityToken, String apiVersion) {
        this.endpoint = endPoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.securityToken = securityToken;
        this.region = region;
        this.apiVersion = apiVersion;
    }

    public static ServiceInfo initServiceInfo(final ClientConfig config) {
        String endPoint = config.getEndpoint().toLowerCase();
        final String[] url = endPoint.split("\\/\\/");
        final String schema = endPoint.startsWith("https") ? "https" : "http";
        return new ServiceInfo((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("ConnectionTimeout", 5000);
                this.put("SocketTimeout", 5000);
                this.put("Scheme", schema);
                this.put("Host", url[1]);
                this.put("Header", new ArrayList<Header>(){
                    {
                        this.add(new BasicHeader("Accept", "*/*"));
                        this.add(new BasicHeader("Accept-Encoding", "gzip, deflate, br"));
                        this.add(new BasicHeader("Region", config.getRegion()));
                    }
                });
                this.put("Credentials", new Credentials(config.getRegion(), "TLS"));
            }
        });
    }

    public void resetAccessKeyToken(String accessKey, String secretKey, String securityToken) {
        this.setAccessKeyId(accessKey);
        this.setAccessKeySecret(secretKey);
        this.setSecurityToken(securityToken);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getRegion() {
        return this.region;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfig)) {
            return false;
        }
        ClientConfig other = (ClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$accessKeyId = this.getAccessKeyId();
        String other$accessKeyId = other.getAccessKeyId();
        if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
            return false;
        }
        String this$accessKeySecret = this.getAccessKeySecret();
        String other$accessKeySecret = other.getAccessKeySecret();
        if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
            return false;
        }
        String this$securityToken = this.getSecurityToken();
        String other$securityToken = other.getSecurityToken();
        if (this$securityToken == null ? other$securityToken != null : !this$securityToken.equals(other$securityToken)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        return !(this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $accessKeyId = this.getAccessKeyId();
        result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
        String $accessKeySecret = this.getAccessKeySecret();
        result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
        String $securityToken = this.getSecurityToken();
        result = result * 59 + ($securityToken == null ? 43 : $securityToken.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        return result;
    }

    public String toString() {
        return "ClientConfig(endpoint=" + this.getEndpoint() + ", accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", securityToken=" + this.getSecurityToken() + ", region=" + this.getRegion() + ", apiVersion=" + this.getApiVersion() + ")";
    }
}

