/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.maas.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import com.volcengine.error.SdkError;
import com.volcengine.model.maas.api.Api;
import com.volcengine.model.response.RawResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.SignableRequest;
import com.volcengine.service.maas.MaasConfig;
import com.volcengine.service.maas.MaasException;
import com.volcengine.service.maas.MaasService;
import com.volcengine.service.maas.impl.SseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;

public class MaasServiceImpl
extends BaseServiceImpl
implements MaasService {
    private static final String CHAT_TERMINATOR = "[DONE]";

    public MaasServiceImpl(String host, String region) {
        this(host, region, 60000, 60000);
    }

    public MaasServiceImpl(String host, String region, int connectionTimeout, int socketTimeout) {
        super(MaasConfig.getServiceInfo(host, region, connectionTimeout, socketTimeout), MaasConfig.getApiInfoList());
    }

    @Override
    public Api.ChatResp chat(Api.ChatReq req) throws MaasException {
        RawResponse response = this.proto("chat", null, null, (req = req.toBuilder().setStream(false).build()).toByteArray(), null);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            Api.ChatResp resp;
            try {
                resp = MaasServiceImpl.convertJsonBytesToChatResp(response.getException().getMessage().getBytes());
            }
            catch (MaasException ignored) {
                throw new MaasException(response.getException());
            }
            throw new MaasException(resp.getError());
        }
        return MaasServiceImpl.convertJsonBytesToChatResp(response.getData());
    }

    @Override
    public Stream<Api.ChatResp> streamChat(Api.ChatReq req) throws MaasException {
        InputStream is;
        HttpResponse response;
        req = req.toBuilder().setStream(true).build();
        SignableRequest request = this.prepareRequest("chat", null);
        request.setHeader("Content-Type", "application/x-protobuf");
        request.setEntity((HttpEntity)new ByteArrayEntity(req.toByteArray()));
        try {
            this.ISigner.sign(request, this.credentials);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MaasException(e);
        }
        try {
            response = this.getHttpClient().execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new MaasException(e);
        }
        try {
            is = response.getEntity().getContent();
        }
        catch (IOException e) {
            throw new MaasException(e);
        }
        return SseEvent.fromInputStream(is, StandardCharsets.UTF_8).map(event -> {
            Api.ChatResp resp;
            if (event.getData().trim().equals(CHAT_TERMINATOR)) {
                return null;
            }
            try {
                resp = MaasServiceImpl.convertJsonBytesToChatResp(event.getData().getBytes());
            }
            catch (MaasException e) {
                throw new RuntimeException(e);
            }
            if (resp.getError().getCodeN() != 0) {
                throw new RuntimeException(new MaasException(resp.getError()));
            }
            return resp;
        }).filter(Objects::nonNull);
    }

    private static Api.ChatResp convertJsonBytesToChatResp(byte[] data) throws MaasException {
        try {
            Api.ChatResp.Builder builder = Api.ChatResp.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(new String(data, StandardCharsets.UTF_8), (Message.Builder)builder);
            return builder.build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new MaasException((Exception)((Object)e));
        }
    }
}

