/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.stream.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.stream.SearchGroupResponse;
import com.volcengine.model.stream.SearchRequest;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.stream.MonitorService;
import com.volcengine.service.stream.SearchConfig;
import com.volcengine.service.stream.SearchService;
import com.volcengine.service.stream.impl.MonitorServiceImpl;
import org.apache.http.HttpHost;

public class SearchServiceImpl
extends BaseServiceImpl
implements SearchService {
    static HttpHost Mproxy;
    private static volatile SearchServiceImpl instance;
    boolean needMonitor = true;

    private SearchServiceImpl() {
        super(SearchConfig.serviceInfo, SearchConfig.apiInfoList);
    }

    private SearchServiceImpl(HttpHost proxy) {
        super(SearchConfig.serviceInfo, proxy, SearchConfig.apiInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<SearchServiceImpl> clazz = SearchServiceImpl.class;
        synchronized (SearchServiceImpl.class) {
            if (instance != null) return instance;
            instance = new SearchServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchServiceImpl getInstance(HttpHost proxy) {
        if (instance != null) return instance;
        Class<SearchServiceImpl> clazz = SearchServiceImpl.class;
        synchronized (SearchServiceImpl.class) {
            if (instance != null) return instance;
            instance = new SearchServiceImpl(proxy);
            Mproxy = proxy;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public SearchGroupResponse searchGroup(SearchRequest request) throws Exception {
        long start = System.currentTimeMillis();
        RawResponse response = this.query("Search", Utils.mapToPairList(Utils.paramsToMap(request)));
        long end = System.currentTimeMillis();
        this.sendToMonitor(instance, request.getPartner(), request.getAccessToken(), "Search", response.getHttpCode(), response.getCode(), response.getData(), end - start);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (SearchGroupResponse)JSON.parseObject((byte[])response.getData(), SearchGroupResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public void SetNeedMonitor(boolean open) {
        this.needMonitor = open;
    }

    private void sendToMonitor(SearchService searchService, String partner, String accessToken, String action, int httpCode, int topRespCode, byte[] respData, long latency) {
        if (this.needMonitor) {
            MonitorService monitorService = MonitorServiceImpl.getInstance(searchService.getAccessKey(), searchService.getSecretKey(), Mproxy);
            monitorService.monitor(partner, "search", accessToken, action, httpCode, topRespCode, respData, latency);
        }
    }

    static {
        instance = null;
    }
}

