/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.maas;

import com.volcengine.model.maas.api.Api;

public class MaasException
extends Exception {
    private final String code;
    private final int codeN;
    private final String msg;
    private final String requestId;

    public MaasException(String code, int codeN, String msg, String requestId) {
        super(msg);
        this.code = code;
        this.codeN = codeN;
        this.msg = msg;
        this.requestId = requestId;
    }

    public MaasException(Api.Error raw, String requestId) {
        this(raw.getCode(), raw.getCodeN(), raw.getMessage(), requestId);
    }

    public MaasException(Exception raw, String requestId) {
        this("ClientSDKRequestError", 1709701, "MaaS SDK request error: " + raw.getMessage(), requestId);
    }

    public String getCode() {
        return this.code;
    }

    public int getCodeN() {
        return this.codeN;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String toString() {
        return "MaasException{code=" + this.code + ", code_n='" + this.codeN + '\'' + ", message='" + this.msg + '\'' + ", request_id='" + this.requestId + '}';
    }
}

