/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.tls;

import com.volcengine.model.tls.producer.BatchLog;
import com.volcengine.model.tls.producer.ProducerConfig;
import com.volcengine.service.tls.LogDispatcher;
import com.volcengine.service.tls.RetryManager;
import com.volcengine.service.tls.SendBatchTask;
import com.volcengine.service.tls.TLSLogClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mover
extends Thread {
    private volatile boolean closed;
    private final String name;
    private final ProducerConfig producerConfig;
    private final RetryManager retryManager;
    private final BlockingQueue<BatchLog> successQueue;
    private final BlockingQueue<BatchLog> failureQueue;
    private final ExecutorService executorService;
    private final TLSLogClient client;
    private final ConcurrentHashMap<BatchLog.BatchKey, BatchLog.BatchManager> batches;
    private static final Log LOG = LogFactory.getLog(Mover.class);

    public Mover(String name, ProducerConfig producerConfig, LogDispatcher dispatcher, RetryManager retryManager, BlockingQueue<BatchLog> successQueue, BlockingQueue<BatchLog> failureQueue) {
        this.setDaemon(true);
        this.name = name;
        this.producerConfig = producerConfig;
        this.retryManager = retryManager;
        this.successQueue = successQueue;
        this.failureQueue = failureQueue;
        this.executorService = dispatcher.getExecutorService();
        this.client = dispatcher.getClient();
        this.batches = dispatcher.getBatches();
        this.closed = false;
    }

    @Override
    public void run() {
        this.handlerTimeout();
    }

    private void handlerTimeout() {
        while (!this.closed) {
            long remains = this.handleTimeoutBatch();
            this.handleRetryBatch(remains);
        }
    }

    private void handleRetryBatch(long remains) {
        List<BatchLog> batchLogs = this.retryManager.handleTimeoutBatch(remains);
        for (BatchLog log : batchLogs) {
            this.executorService.submit(new SendBatchTask(log, this.producerConfig, this.successQueue, this.failureQueue, this.client, this.retryManager));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleTimeoutBatch() {
        LOG.debug((Object)("mover" + this.name + "handler timeout batch"));
        long now = System.currentTimeMillis();
        ArrayList<BatchLog> batchLogs = new ArrayList<BatchLog>();
        long remains = this.producerConfig.getLingerMs();
        for (Map.Entry<BatchLog.BatchKey, BatchLog.BatchManager> entry : this.batches.entrySet()) {
            BatchLog.BatchManager batchManager;
            BatchLog.BatchManager batchManager2 = batchManager = entry.getValue();
            synchronized (batchManager2) {
                BatchLog batchLog = batchManager.getBatchLog();
                if (batchLog == null) {
                    continue;
                }
                long curRemains = remains + batchLog.getCreateMs() - now;
                if (curRemains <= 0L) {
                    batchManager.removeBatch(batchLogs);
                } else {
                    remains = Math.min(remains, curRemains);
                }
            }
        }
        for (BatchLog log : batchLogs) {
            this.executorService.submit(new SendBatchTask(log, this.producerConfig, this.successQueue, this.failureQueue, this.client, this.retryManager));
        }
        return remains;
    }

    public void close() {
        this.closed = true;
        super.interrupt();
    }
}

