/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.maas.v2.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.volcengine.error.SdkError;
import com.volcengine.model.ApiInfo;
import com.volcengine.model.maas.api.v2.ChatReq;
import com.volcengine.model.maas.api.v2.ChatResp;
import com.volcengine.model.maas.api.v2.ClassificationReq;
import com.volcengine.model.maas.api.v2.ClassificationResp;
import com.volcengine.model.maas.api.v2.EmbeddingsReq;
import com.volcengine.model.maas.api.v2.EmbeddingsResp;
import com.volcengine.model.maas.api.v2.TokenizeReq;
import com.volcengine.model.maas.api.v2.TokenizeResp;
import com.volcengine.model.response.RawResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.SignableRequest;
import com.volcengine.service.maas.MaasException;
import com.volcengine.service.maas.impl.SseEvent;
import com.volcengine.service.maas.v2.MaasConfig;
import com.volcengine.service.maas.v2.MaasService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;

public class MaasServiceImpl
extends BaseServiceImpl
implements MaasService {
    private static final String CHAT_TERMINATOR = "[DONE]";

    public MaasServiceImpl(String host, String region) {
        this(host, region, 60000, 60000);
    }

    public MaasServiceImpl(String host, String region, int connectionTimeout, int socketTimeout) {
        super(MaasConfig.getServiceInfo(host, region, connectionTimeout, socketTimeout), MaasConfig.getApiInfoList());
    }

    @Override
    public ChatResp chat(String endpointId, ChatReq req) throws MaasException {
        req = req.withStream(false);
        RawResponse response = null;
        try {
            response = this.json(endpointId, "chat", null, new ObjectMapper().writeValueAsString((Object)req));
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), null);
        }
        String logId = response.getFirstHeader("x-tt-logid");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            ChatResp resp;
            try {
                resp = MaasServiceImpl.convertJsonBytesToChatResp(response.getException().getMessage().getBytes());
            }
            catch (MaasException ignored) {
                throw new MaasException(response.getException(), logId);
            }
            throw new MaasException(resp.getError(), logId);
        }
        return MaasServiceImpl.convertJsonBytesToChatResp(response.getData());
    }

    @Override
    public Stream<ChatResp> streamChat(String endpointId, ChatReq req) throws MaasException {
        InputStream is;
        HttpResponse response;
        req.setStream(true);
        SignableRequest request = this.prepareRequest("chat", null);
        try {
            request.setEntity((HttpEntity)new StringEntity(new ObjectMapper().writeValueAsString((Object)req), "utf-8"));
            request.setHeader("Content-Type", "application/json");
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), null);
        }
        try {
            URIBuilder builder = request.getUriBuilder();
            builder.setPath(String.format(builder.getPath(), endpointId));
            request.setURI(builder.build());
            this.ISigner.sign(request, this.credentials);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MaasException(e, null);
        }
        String logId = null;
        try {
            response = this.getHttpClient().execute((HttpUriRequest)request);
            logId = response.getFirstHeader("x-tt-logid").getValue();
        }
        catch (IOException e) {
            throw new MaasException(e, logId);
        }
        try {
            is = response.getEntity().getContent();
        }
        catch (IOException e) {
            throw new MaasException(e, logId);
        }
        String finalLogId = logId;
        return SseEvent.fromInputStream(is, StandardCharsets.UTF_8).map(event -> {
            ChatResp resp;
            if (event.getData().trim().equals(CHAT_TERMINATOR)) {
                return null;
            }
            try {
                resp = MaasServiceImpl.convertJsonBytesToChatResp(event.getData().getBytes());
            }
            catch (MaasException e) {
                this.closeInputStream(is);
                throw new RuntimeException(e);
            }
            if (resp.getError() != null && resp.getError().getCodeN() != 0) {
                this.closeInputStream(is);
                throw new RuntimeException(new MaasException(resp.getError(), finalLogId));
            }
            return resp;
        }).filter(Objects::nonNull);
    }

    @Override
    public TokenizeResp tokenization(String endpointId, TokenizeReq req) throws MaasException {
        RawResponse response = null;
        try {
            response = this.json(endpointId, "tokenization", null, new ObjectMapper().writeValueAsString((Object)req));
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), null);
        }
        String logId = response.getFirstHeader("x-tt-logid");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            TokenizeResp resp;
            try {
                resp = MaasServiceImpl.convertJsonBytesToTokenizeResp(response.getException().getMessage().getBytes());
            }
            catch (MaasException ignored) {
                throw new MaasException(response.getException(), logId);
            }
            throw new MaasException(resp.getError(), logId);
        }
        return MaasServiceImpl.convertJsonBytesToTokenizeResp(response.getData());
    }

    @Override
    public ClassificationResp classification(String endpointId, ClassificationReq req) throws MaasException {
        RawResponse response = null;
        try {
            response = this.json(endpointId, "classification", null, new ObjectMapper().writeValueAsString((Object)req));
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), null);
        }
        String logId = response.getFirstHeader("x-tt-logid");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            ClassificationResp resp;
            try {
                resp = MaasServiceImpl.convertJsonBytesToClassificationResp(response.getException().getMessage().getBytes());
            }
            catch (MaasException ignored) {
                throw new MaasException(response.getException(), logId);
            }
            throw new MaasException(resp.getError(), logId);
        }
        return MaasServiceImpl.convertJsonBytesToClassificationResp(response.getData());
    }

    @Override
    public EmbeddingsResp embeddings(String endpointId, EmbeddingsReq req) throws MaasException {
        RawResponse response = null;
        try {
            response = this.json(endpointId, "embeddings", null, new ObjectMapper().writeValueAsString((Object)req));
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), null);
        }
        String logId = response.getFirstHeader("x-tt-logid");
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            EmbeddingsResp resp;
            try {
                resp = MaasServiceImpl.convertJsonBytesToEmbeddingsResp(response.getException().getMessage().getBytes());
            }
            catch (MaasException ignored) {
                throw new MaasException(response.getException(), logId);
            }
            throw new MaasException(resp.getError(), logId);
        }
        return MaasServiceImpl.convertJsonBytesToEmbeddingsResp(response.getData());
    }

    private static ChatResp convertJsonBytesToChatResp(byte[] data) throws MaasException {
        try {
            return (ChatResp)new ObjectMapper().readValue(new String(data, StandardCharsets.UTF_8), ChatResp.class);
        }
        catch (Exception e) {
            throw new MaasException(e, "");
        }
    }

    private static TokenizeResp convertJsonBytesToTokenizeResp(byte[] data) throws MaasException {
        try {
            return (TokenizeResp)new ObjectMapper().readValue(new String(data, StandardCharsets.UTF_8), TokenizeResp.class);
        }
        catch (Exception e) {
            throw new MaasException(e, "");
        }
    }

    private static ClassificationResp convertJsonBytesToClassificationResp(byte[] data) throws MaasException {
        try {
            return (ClassificationResp)new ObjectMapper().readValue(new String(data, StandardCharsets.UTF_8), ClassificationResp.class);
        }
        catch (Exception e) {
            throw new MaasException(e, "");
        }
    }

    private static EmbeddingsResp convertJsonBytesToEmbeddingsResp(byte[] data) throws MaasException {
        try {
            return (EmbeddingsResp)new ObjectMapper().readValue(new String(data, StandardCharsets.UTF_8), EmbeddingsResp.class);
        }
        catch (Exception e) {
            throw new MaasException(e, "");
        }
    }

    private void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private RawResponse json(String endpointId, String api, List<NameValuePair> params, String body) throws MaasException {
        ApiInfo apiInfo = (ApiInfo)this.apiInfoList.get(api);
        if (apiInfo == null) {
            return new RawResponse(null, SdkError.ENOAPI.getNumber(), new Exception(SdkError.getErrorDesc(SdkError.ENOAPI)));
        }
        SignableRequest request = this.prepareRequest(api, params);
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)new StringEntity(body, "utf-8"));
        try {
            URIBuilder builder = request.getUriBuilder();
            builder.setPath(String.format(builder.getPath(), endpointId));
            request.setURI(builder.build());
        }
        catch (URISyntaxException e) {
            throw new MaasException(e, null);
        }
        return this.makeRequest(api, request);
    }
}

