/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.vikingDB;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import com.volcengine.model.ApiInfo;
import com.volcengine.model.Credentials;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.response.RawResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.vikingDB.Collection;
import com.volcengine.service.vikingDB.Index;
import com.volcengine.service.vikingDB.ObjectTypeAdapterRewrite;
import com.volcengine.service.vikingDB.VikingDBException;
import com.volcengine.service.vikingDB.common.CreateCollectionParam;
import com.volcengine.service.vikingDB.common.CreateIndexParam;
import com.volcengine.service.vikingDB.common.EmbModel;
import com.volcengine.service.vikingDB.common.Field;
import com.volcengine.service.vikingDB.common.RawData;
import com.volcengine.service.vikingDB.common.UpdateCollectionParam;
import com.volcengine.service.vikingDB.common.UpdateIndexParam;
import com.volcengine.service.vikingDB.common.VectorIndexParams;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;

public class VikingDBService
extends BaseServiceImpl {
    public VikingDBService(String host, String region, String ak, String sk, String scheme) {
        super(VikingDBService.getServiceInfo(host, region, ak, sk, scheme), VikingDBService.getApiInfo());
    }

    public static ServiceInfo getServiceInfo(String host, String region, String ak, String sk, String scheme) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Host", host);
        params.put("ConnectionTimeout", 5000);
        params.put("SocketTimeout", 5000);
        Credentials credentials = new Credentials(region, "air");
        credentials.setAccessKeyID(ak);
        credentials.setSecretAccessKey(sk);
        params.put("Credentials", credentials);
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("Host", host));
        params.put("Header", headers);
        params.put("Scheme", scheme);
        ServiceInfo serviceInfo = new ServiceInfo(params);
        return serviceInfo;
    }

    public static Map<String, ApiInfo> getApiInfo() {
        HashMap<String, ApiInfo> apiInfo = new HashMap<String, ApiInfo>();
        HashMap<String, Object> paramsPost = new HashMap<String, Object>();
        HashMap<String, Object> paramsGet = new HashMap<String, Object>();
        paramsPost.put("Method", "POST");
        paramsGet.put("Method", "GET");
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("Accept", "application/json"));
        headers.add(new BasicHeader("Content-Type", "application/json"));
        paramsPost.put("Header", headers);
        paramsGet.put("Header", headers);
        paramsPost.put("Path", "/api/collection/create");
        apiInfo.put("CreateCollection", new ApiInfo(paramsPost));
        paramsGet.put("Path", "/api/collection/info");
        apiInfo.put("GetCollection", new ApiInfo(paramsGet));
        paramsPost.put("Path", "/api/collection/drop");
        apiInfo.put("DropCollection", new ApiInfo(paramsPost));
        paramsGet.put("Path", "/api/collection/list");
        apiInfo.put("ListCollections", new ApiInfo(paramsGet));
        paramsPost.put("Path", "/api/index/create");
        apiInfo.put("CreateIndex", new ApiInfo(paramsPost));
        paramsGet.put("Path", "/api/index/info");
        apiInfo.put("GetIndex", new ApiInfo(paramsGet));
        paramsPost.put("Path", "/api/index/drop");
        apiInfo.put("DropIndex", new ApiInfo(paramsPost));
        paramsGet.put("Path", "/api/index/list");
        apiInfo.put("ListIndexes", new ApiInfo(paramsGet));
        paramsPost.put("Path", "/api/collection/upsert_data");
        apiInfo.put("UpsertData", new ApiInfo(paramsPost));
        paramsPost.put("Path", "/api/collection/del_data");
        apiInfo.put("DeleteData", new ApiInfo(paramsPost));
        paramsGet.put("Path", "/api/collection/fetch_data");
        apiInfo.put("FetchData", new ApiInfo(paramsGet));
        paramsGet.put("Path", "/api/index/fetch_data");
        apiInfo.put("FetchIndexData", new ApiInfo(paramsGet));
        paramsPost.put("Path", "/api/index/search");
        apiInfo.put("SearchIndex", new ApiInfo(paramsPost));
        paramsPost.put("Path", "/api/data/embedding");
        apiInfo.put("Embedding", new ApiInfo(paramsPost));
        paramsPost.put("Path", "/api/collection/update");
        apiInfo.put("UpdateCollection", new ApiInfo(paramsPost));
        paramsPost.put("Path", "/api/index/update");
        apiInfo.put("UpdateIndex", new ApiInfo(paramsPost));
        paramsPost.put("Path", "/api/index/rerank");
        apiInfo.put("Rerank", new ApiInfo(paramsPost));
        paramsPost.put("Path", "/api/index/batch_rerank");
        apiInfo.put("BatchRerank", new ApiInfo(paramsPost));
        return apiInfo;
    }

    public void setHeader(HashMap<String, String> header) {
        Map apiInfo = this.apiInfoList;
        for (String key : apiInfo.keySet()) {
            List<Header> newHeader = ((ApiInfo)apiInfo.get(key)).getHeader();
            for (String item : header.keySet()) {
                newHeader.add((Header)new BasicHeader(item, header.get(item)));
            }
            ((ApiInfo)apiInfo.get(key)).setHeader(newHeader);
        }
        this.apiInfoList = apiInfo;
    }

    public LinkedTreeMap<String, Object> doRequest(String api, List<NameValuePair> params, HashMap<String, Object> body) throws Exception {
        Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<LinkedTreeMap<String, Object>>(){}.getType(), (Object)new ObjectTypeAdapterRewrite()).create();
        RawResponse res = this.json(api, params, gson.toJson(body));
        if (res.getCode() != 0) {
            try {
                throw new Exception(res.getException().getMessage());
            }
            catch (Exception e) {
                LinkedTreeMap resJson = (LinkedTreeMap)gson.fromJson(e.getMessage(), new TypeToken<LinkedTreeMap<String, Object>>(){}.getType());
                Integer code = (Integer)resJson.get((Object)"code");
                String requestId = (String)resJson.get((Object)"request_id");
                String message = (String)resJson.get((Object)"message");
                VikingDBException vikingDBException = new VikingDBException(code, requestId, message);
                throw vikingDBException.getErrorCodeException(code, requestId, message);
            }
        }
        String resData = new String(res.getData(), StandardCharsets.UTF_8);
        LinkedTreeMap data = (LinkedTreeMap)gson.fromJson(resData, new TypeToken<LinkedTreeMap<String, Object>>(){}.getType());
        return data;
    }

    public static LinkedTreeMap<String, Object> convertStringToLinkedTreeMap(String x) {
        Gson gson = new Gson();
        LinkedTreeMap data = (LinkedTreeMap)gson.fromJson(x, new TypeToken<LinkedTreeMap<String, Object>>(){}.getType());
        return data;
    }

    public HashMap<String, Object> convertLinkedTreeMapToHashMap(LinkedTreeMap<String, Object> linkedTreeMap) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String key : linkedTreeMap.keySet()) {
            Object value = linkedTreeMap.get((Object)key);
            hashMap.put(key, value);
        }
        return hashMap;
    }

    public Collection createCollection(CreateCollectionParam createCollectionParam) throws Exception {
        if (createCollectionParam.getIsBuild() == 0) {
            VikingDBException vikingDBException = new VikingDBException(1000031, null, "Param dose not build");
            throw vikingDBException.getErrorCodeException(1000031, null, "Param dose not build");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", createCollectionParam.getCollectionName());
        params.put("description", createCollectionParam.getDescription());
        String primaryKey = null;
        ArrayList fields = new ArrayList();
        for (Field field : createCollectionParam.getFields()) {
            HashMap<String, Object> _field = new HashMap<String, Object>();
            _field.put("field_name", field.getFieldName());
            _field.put("field_type", field.getFieldType());
            if (field.getIsPrimaryKey().booleanValue()) {
                if (!field.getFieldType().equals("string") && !field.getFieldType().equals("int64")) {
                    VikingDBException vikingDBException = new VikingDBException(1000032, null, "PrimaryKey must be String or Int64");
                    throw vikingDBException.getErrorCodeException(1000032, null, "PrimaryKey must be String or Int64");
                }
                if (primaryKey != null) {
                    VikingDBException vikingDBException = new VikingDBException(1000032, null, "PrimaryKey must be String or Int64");
                    throw vikingDBException.getErrorCodeException(1000032, null, "PrimaryKey must be String or Int64");
                }
                primaryKey = field.getFieldName();
            }
            if (field.getDefaultVal() != null) {
                _field.put("default_val", field.getDefaultVal());
            }
            if (field.getDim() != null) {
                _field.put("dim", field.getDim());
            }
            if (field.getPipelineName() != null) {
                _field.put("pipeline_name", field.getPipelineName());
            }
            fields.add(_field);
        }
        params.put("primary_key", primaryKey);
        params.put("fields", fields);
        this.doRequest("CreateCollection", null, params);
        Collection collection = new Collection(createCollectionParam.getCollectionName(), createCollectionParam.getFields(), this, primaryKey);
        collection.setDescription(createCollectionParam.getDescription());
        return collection;
    }

    public Collection getCollection(String collectionName) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", collectionName);
        LinkedTreeMap<String, Object> resData = this.doRequest("GetCollection", null, params);
        LinkedTreeMap res = (LinkedTreeMap)resData.get((Object)"data");
        Collection collection = new Collection();
        String primarykey = "";
        if (res.containsKey((Object)"description")) {
            collection.setDescription((String)res.get((Object)"description"));
        }
        if (res.containsKey((Object)"indexes")) {
            collection.setIndexes((List)res.get((Object)"indexes"));
        }
        if (res.containsKey((Object)"create_time")) {
            collection.setCreateTime((String)res.get((Object)"create_time"));
        }
        if (res.containsKey((Object)"update_time")) {
            collection.setUpdateTime((String)res.get((Object)"update_time"));
        }
        if (res.containsKey((Object)"update_person")) {
            collection.setUpdatePerson((String)res.get((Object)"update_person"));
        }
        if (res.containsKey((Object)"stat")) {
            HashMap<String, Object> stat = this.convertLinkedTreeMapToHashMap((LinkedTreeMap<String, Object>)((LinkedTreeMap)res.get((Object)"stat")));
            collection.setStat(stat);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        if (res.containsKey((Object)"fields")) {
            List retData = (List)res.get((Object)"fields");
            for (LinkedTreeMap item : retData) {
                String pk;
                Field field = new Field();
                if (item.containsKey((Object)"field_name")) {
                    field.setFieldName((String)item.get((Object)"field_name"));
                }
                if (item.containsKey((Object)"field_type")) {
                    field.setFieldType((String)item.get((Object)"field_type"));
                }
                if (item.containsKey((Object)"default_val")) {
                    field.setDefaultVal(item.get((Object)"default_val"));
                }
                if (item.containsKey((Object)"dim")) {
                    field.setDim((Integer)item.get((Object)"dim"));
                }
                if (item.containsKey((Object)"pipeline_name")) {
                    field.setPipelineName((String)item.get((Object)"pipeline_name"));
                }
                if (res.containsKey((Object)"primary_key") && (pk = (String)res.get((Object)"primary_key")).equals((String)item.get((Object)"field_name"))) {
                    field.setIsPrimaryKey(true);
                    primarykey = pk;
                }
                fields.add(field);
            }
        }
        collection.setCollectionName(collectionName);
        collection.setVikingDBService(this);
        collection.setFields(fields);
        collection.setPrimaryKey(primarykey);
        return collection;
    }

    public void dropCollection(String collectionName) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", collectionName);
        this.doRequest("DropCollection", null, params);
    }

    public List<Collection> listCollections() throws Exception {
        LinkedTreeMap<String, Object> resData = this.doRequest("ListCollections", null, null);
        List res = (List)resData.get((Object)"data");
        ArrayList<Collection> collections = new ArrayList<Collection>();
        String primarykey = "";
        for (LinkedTreeMap item : res) {
            Collection collection = new Collection();
            if (item.containsKey((Object)"description")) {
                collection.setDescription((String)item.get((Object)"description"));
            }
            if (item.containsKey((Object)"indexes")) {
                collection.setIndexes((List)item.get((Object)"indexes"));
            }
            if (item.containsKey((Object)"create_time")) {
                collection.setCreateTime((String)item.get((Object)"create_time"));
            }
            if (item.containsKey((Object)"update_time")) {
                collection.setUpdateTime((String)item.get((Object)"update_time"));
            }
            if (item.containsKey((Object)"update_person")) {
                collection.setUpdatePerson((String)item.get((Object)"update_person"));
            }
            if (item.containsKey((Object)"stat")) {
                HashMap<String, Object> stat = this.convertLinkedTreeMapToHashMap((LinkedTreeMap<String, Object>)((LinkedTreeMap)item.get((Object)"stat")));
                collection.setStat(stat);
            }
            ArrayList<Field> fields = new ArrayList<Field>();
            if (item.containsKey((Object)"fields")) {
                List retDatas = (List)item.get((Object)"fields");
                for (LinkedTreeMap retData : retDatas) {
                    Field field = new Field();
                    if (retData.containsKey((Object)"field_name")) {
                        field.setFieldName((String)retData.get((Object)"field_name"));
                    }
                    if (retData.containsKey((Object)"field_type")) {
                        field.setFieldType((String)retData.get((Object)"field_type"));
                    }
                    if (retData.containsKey((Object)"default_val")) {
                        field.setDefaultVal(retData.get((Object)"default_val"));
                    }
                    if (retData.containsKey((Object)"dim")) {
                        field.setDim((Integer)retData.get((Object)"dim"));
                    }
                    if (retData.containsKey((Object)"pipeline_name")) {
                        field.setPipelineName((String)retData.get((Object)"pipeline_name"));
                    }
                    if (item.containsKey((Object)"primary_key")) {
                        if (item.get((Object)"primary_key") instanceof String) {
                            String pk = (String)item.get((Object)"primary_key");
                            if (pk.equals((String)retData.get((Object)"field_name"))) {
                                field.setIsPrimaryKey(true);
                                primarykey = pk;
                            }
                        } else {
                            primarykey = null;
                        }
                    }
                    fields.add(field);
                }
            }
            if (item.containsKey((Object)"collection_name")) {
                collection.setCollectionName((String)item.get((Object)"collection_name"));
            }
            collection.setVikingDBService(this);
            collection.setFields(fields);
            collection.setPrimaryKey(primarykey);
            collections.add(collection);
        }
        return collections;
    }

    public Index createIndex(CreateIndexParam createIndexParam) throws Exception {
        if (createIndexParam.getIsBuild() == 0) {
            VikingDBException vikingDBException = new VikingDBException(1000031, null, "Param dose not build");
            throw vikingDBException.getErrorCodeException(1000031, null, "Param dose not build");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", createIndexParam.getCollectionName());
        params.put("index_name", createIndexParam.getIndexName());
        params.put("cpu_quota", createIndexParam.getCpuQuoat());
        params.put("description", createIndexParam.getDescription());
        params.put("partition_by", createIndexParam.getPartitionBy());
        if (createIndexParam.getVectorIndex() != null) {
            params.put("vector_index", createIndexParam.getVectorIndex().dict());
        }
        if (createIndexParam.getScalarIndex() != null) {
            params.put("scalar_index", createIndexParam.getScalarIndex());
        }
        if (createIndexParam.getShardCount() != null) {
            params.put("shard_count", createIndexParam.getShardCount());
        }
        this.doRequest("CreateIndex", null, params);
        Index index = new Index(createIndexParam.getCollectionName(), createIndexParam.getIndexName(), createIndexParam.getVectorIndex(), createIndexParam.getScalarIndex(), null, this);
        index.setDescription(createIndexParam.getDescription());
        index.setPartitionBy(createIndexParam.getPartitionBy());
        index.setCpuQuota(createIndexParam.getCpuQuoat());
        return index;
    }

    public Index getIndex(String collectionName, String indexName) throws Exception {
        ArrayList tmp;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", collectionName);
        params.put("index_name", indexName);
        LinkedTreeMap<String, Object> resData = this.doRequest("GetIndex", null, params);
        LinkedTreeMap res = (LinkedTreeMap)resData.get((Object)"data");
        Index index = new Index();
        index.setCollectionName(collectionName);
        index.setIndexName(indexName);
        index.setVikingDBService(this);
        if (res.containsKey((Object)"vector_index")) {
            LinkedTreeMap vectorIndexMap = (LinkedTreeMap)res.get((Object)"vector_index");
            VectorIndexParams vectorIndexParams = new VectorIndexParams();
            if (vectorIndexMap.containsKey((Object)"index_type")) {
                vectorIndexParams.setIndexType((String)vectorIndexMap.get((Object)"index_type"));
            }
            if (vectorIndexMap.containsKey((Object)"distance")) {
                vectorIndexParams.setDistance((String)vectorIndexMap.get((Object)"distance"));
            }
            if (vectorIndexMap.containsKey((Object)"quant")) {
                vectorIndexParams.setQuant((String)vectorIndexMap.get((Object)"quant"));
            }
            if (vectorIndexMap.containsKey((Object)"hnsw_m")) {
                vectorIndexParams.setHnswM((Integer)vectorIndexMap.get((Object)"hnsw_m"));
            }
            if (vectorIndexMap.containsKey((Object)"hnsw_sef")) {
                vectorIndexParams.setHnswSef((Integer)vectorIndexMap.get((Object)"hnsw_sef"));
            }
            if (vectorIndexMap.containsKey((Object)"hnsw_cef")) {
                vectorIndexParams.setHnswCef((Integer)vectorIndexMap.get((Object)"hnsw_cef"));
            }
            index.setVectorIndex(vectorIndexParams);
        }
        ArrayList scalarIndex = null;
        if (res.containsKey((Object)"range_index")) {
            scalarIndex = tmp = (ArrayList)res.get((Object)"range_index");
        }
        if (res.containsKey((Object)"enum_index")) {
            if (scalarIndex != null) {
                tmp = (List)res.get((Object)"enum_index");
                HashSet set = new HashSet();
                set.addAll(tmp);
                set.addAll(scalarIndex);
                scalarIndex = new ArrayList(set);
            } else {
                scalarIndex = tmp = (List)res.get((Object)"enum_index");
            }
        }
        index.setScalarIndex(scalarIndex);
        if (res.containsKey((Object)"description")) {
            index.setDescription((String)res.get((Object)"description"));
        }
        if (res.containsKey((Object)"cpu_quota")) {
            index.setCpuQuota((Integer)res.get((Object)"cpu_quota"));
        }
        if (res.containsKey((Object)"partition_by")) {
            index.setPartitionBy((String)res.get((Object)"partition_by"));
        }
        if (res.containsKey((Object)"status")) {
            index.setStat((String)res.get((Object)"status"));
        }
        if (res.containsKey((Object)"create_time")) {
            index.setCreateTime((String)res.get((Object)"create_time"));
        }
        if (res.containsKey((Object)"update_time")) {
            index.setUpdateTime((String)res.get((Object)"update_time"));
        }
        if (res.containsKey((Object)"update_person")) {
            index.setUpdatePerson((String)res.get((Object)"update_person"));
        }
        if (res.containsKey((Object)"shard_count")) {
            index.setShardCount((Integer)res.get((Object)"shard_count"));
        }
        if (res.containsKey((Object)"index_cost")) {
            HashMap<String, Object> indexCost = this.convertLinkedTreeMapToHashMap((LinkedTreeMap<String, Object>)((LinkedTreeMap)res.get((Object)"index_cost")));
            index.setIndexCost(indexCost);
        }
        return index;
    }

    public void dropIndex(String collectionName, String indexName) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", collectionName);
        params.put("index_name", indexName);
        this.doRequest("DropIndex", null, params);
    }

    public List<Index> listIndexes(String collectionName) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", collectionName);
        LinkedTreeMap<String, Object> resData = this.doRequest("ListIndexes", null, params);
        List res = (List)resData.get((Object)"data");
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (LinkedTreeMap item : res) {
            Index index = this.getIndex(collectionName, (String)item.get((Object)"index_name"));
            indexes.add(index);
        }
        return indexes;
    }

    public void updateCollection(UpdateCollectionParam updateCollectionParam) throws Exception {
        if (updateCollectionParam.getIsBuild() == 0) {
            VikingDBException vikingDBException = new VikingDBException(1000031, null, "Param dose not build");
            throw vikingDBException.getErrorCodeException(1000031, null, "Param dose not build");
        }
        ArrayList fields = new ArrayList();
        for (Field field : updateCollectionParam.getFields()) {
            HashMap<String, Object> _field = new HashMap<String, Object>();
            _field.put("field_name", field.getFieldName());
            _field.put("field_type", field.getFieldType());
            if (field.getDefaultVal() != null) {
                _field.put("default_val", field.getDefaultVal());
            }
            if (field.getDim() != null) {
                _field.put("dim", field.getDim());
            }
            if (field.getPipelineName() != null) {
                _field.put("pipeline_name", field.getPipelineName());
            }
            fields.add(_field);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", updateCollectionParam.getCollectionName());
        params.put("fields", fields);
        if (updateCollectionParam.getDescription() != null) {
            params.put("description", updateCollectionParam.getDescription());
        }
        this.doRequest("UpdateCollection", null, params);
    }

    public void updateIndex(UpdateIndexParam updateIndexParam) throws Exception {
        if (updateIndexParam.getIsBuild() == 0) {
            VikingDBException vikingDBException = new VikingDBException(1000031, null, "Param dose not build");
            throw vikingDBException.getErrorCodeException(1000031, null, "Param dose not build");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", updateIndexParam.getCollectionName());
        params.put("index_name", updateIndexParam.getIndexName());
        if (updateIndexParam.getCpuQuoat() != null) {
            params.put("cpu_quota", updateIndexParam.getCpuQuoat());
        }
        if (updateIndexParam.getDescription() != null) {
            params.put("description", updateIndexParam.getDescription());
        }
        if (updateIndexParam.getScalarIndex() != null) {
            params.put("scalar_index", updateIndexParam.getScalarIndex());
        }
        this.doRequest("UpdateIndex", null, params);
    }

    public List<Double> embedding(EmbModel embModel, RawData rawData) throws Exception {
        if (embModel.getIsBuild() == 0 || rawData.getIsBuild() == 0) {
            VikingDBException vikingDBException = new VikingDBException(1000031, null, "Param dose not build");
            throw vikingDBException.getErrorCodeException(1000031, null, "Param dose not build");
        }
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("model_name", embModel.getModelName());
        model.put("params", embModel.getParams());
        HashMap<String, String> param = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> data = new ArrayList<HashMap<String, String>>();
        param.put("data_type", rawData.getDataType());
        param.put("text", rawData.getText());
        data.add(param);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("model", model);
        params.put("data", data);
        LinkedTreeMap<String, Object> resData = this.doRequest("Embedding", null, params);
        List res = (List)resData.get((Object)"data");
        return (List)res.get(0);
    }

    public List<List<Double>> embedding(EmbModel embModel, List<RawData> rawDatas) throws Exception {
        for (RawData rawData : rawDatas) {
            if (embModel.getIsBuild() != 0 && rawData.getIsBuild() != 0) continue;
            VikingDBException vikingDBException = new VikingDBException(1000031, null, "Param dose not build");
            throw vikingDBException.getErrorCodeException(1000031, null, "Param dose not build");
        }
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("model_name", embModel.getModelName());
        model.put("params", embModel.getParams());
        ArrayList data = new ArrayList();
        for (RawData rawData : rawDatas) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("data_type", rawData.getDataType());
            param.put("text", rawData.getText());
            data.add(param);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("model", model);
        params.put("data", data);
        LinkedTreeMap<String, Object> resData = this.doRequest("Embedding", null, params);
        List res = (List)resData.get((Object)"data");
        return res;
    }

    public Double rerank(String query, String content, String title) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", query);
        params.put("content", content);
        params.put("title", title);
        LinkedTreeMap<String, Object> resData = this.doRequest("Rerank", null, params);
        return (Double)resData.get((Object)"data");
    }

    public List<Double> batchRerank(List<Map<String, Object>> datas) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("datas", datas);
        LinkedTreeMap<String, Object> resData = this.doRequest("BatchRerank", null, params);
        ArrayList<Double> scores = new ArrayList<Double>();
        List res = (List)resData.get((Object)"data");
        for (int i = 0; i < res.size(); ++i) {
            scores.add((Double)res.get(i));
        }
        return scores;
    }
}

