/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.maas.v2;

import com.volcengine.model.ApiInfo;
import com.volcengine.model.Credentials;
import com.volcengine.model.ServiceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public class MaasConfig {
    public static ServiceInfo getServiceInfo(final String host, final String region, final int connectionTimeout, final int socketTimeout) {
        return new ServiceInfo((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("ConnectionTimeout", connectionTimeout);
                this.put("SocketTimeout", socketTimeout);
                this.put("Scheme", "https");
                this.put("Host", host);
                this.put("Header", new ArrayList<Header>(){
                    {
                        this.add(new BasicHeader("Accept", "application/json"));
                    }
                });
                this.put("Credentials", new Credentials(region, "ml_maas"));
            }
        });
    }

    public static Map<String, ApiInfo> getApiInfoList() {
        return new HashMap<String, ApiInfo>(){
            {
                this.put("chat", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Method", "post");
                        this.put("Path", "/api/v2/endpoint/%s/chat");
                    }
                }));
                this.put("tokenization", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Method", "post");
                        this.put("Path", "/api/v2/endpoint/%s/tokenization");
                    }
                }));
                this.put("classification", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Method", "post");
                        this.put("Path", "/api/v2/endpoint/%s/classification");
                    }
                }));
                this.put("embeddings", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Method", "post");
                        this.put("Path", "/api/v2/endpoint/%s/embeddings");
                    }
                }));
                this.put("top", new ApiInfo((Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Method", "post");
                        this.put("Path", "/");
                        this.put("Query", new ArrayList<NameValuePair>(){
                            {
                                this.add(new BasicNameValuePair("Action", "CreateOrRefreshAPIKey"));
                                this.add(new BasicNameValuePair("Version", "2024-01-01"));
                            }
                        });
                    }
                }));
            }
        };
    }
}

