/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.maas.v2.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.volcengine.error.SdkError;
import com.volcengine.model.ApiInfo;
import com.volcengine.model.maas.api.v2.ChatReq;
import com.volcengine.model.maas.api.v2.ChatResp;
import com.volcengine.model.maas.api.v2.ClassificationReq;
import com.volcengine.model.maas.api.v2.ClassificationResp;
import com.volcengine.model.maas.api.v2.CreateOrRefreshAPIKeyReq;
import com.volcengine.model.maas.api.v2.CreateOrRefreshAPIKeyResp;
import com.volcengine.model.maas.api.v2.EmbeddingsReq;
import com.volcengine.model.maas.api.v2.EmbeddingsResp;
import com.volcengine.model.maas.api.v2.ErrorResp;
import com.volcengine.model.maas.api.v2.TokenizeReq;
import com.volcengine.model.maas.api.v2.TokenizeResp;
import com.volcengine.model.response.RawResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.SignableRequest;
import com.volcengine.service.maas.MaasException;
import com.volcengine.service.maas.impl.SseEvent;
import com.volcengine.service.maas.v2.MaasConfig;
import com.volcengine.service.maas.v2.MaasService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class MaasServiceImpl
extends BaseServiceImpl
implements MaasService {
    private static final String CHAT_TERMINATOR = "[DONE]";
    private static final ObjectMapper mapper = new ObjectMapper();
    private String apikey = "";
    private Integer apikeyTtl = 0;

    @Override
    public String getAPIKey() {
        return this.apikey;
    }

    @Override
    public void setApikey(String apikey) {
        this.apikey = apikey;
    }

    @Override
    public Integer getAPIKeyTtl() {
        return this.apikeyTtl;
    }

    @Override
    public void setAPIKeyTtl(Integer apikeyTtl) {
        this.apikeyTtl = apikeyTtl;
    }

    public MaasServiceImpl(String host, String region) {
        this(host, region, 60000, 60000);
    }

    public MaasServiceImpl(String host, String region, int connectionTimeout, int socketTimeout) {
        super(MaasConfig.getServiceInfo(host, region, connectionTimeout, socketTimeout), MaasConfig.getApiInfoList());
    }

    @Override
    public ChatResp chat(String endpointId, ChatReq req) throws MaasException {
        return this.request(endpointId, "chat", req.withStream(false), ChatResp.class);
    }

    @Override
    public TokenizeResp tokenization(String endpointId, TokenizeReq req) throws MaasException {
        return this.request(endpointId, "tokenization", req, TokenizeResp.class);
    }

    @Override
    public ClassificationResp classification(String endpointId, ClassificationReq req) throws MaasException {
        return this.request(endpointId, "classification", req, ClassificationResp.class);
    }

    @Override
    public EmbeddingsResp embeddings(String endpointId, EmbeddingsReq req) throws MaasException {
        return this.request(endpointId, "embeddings", req, EmbeddingsResp.class);
    }

    @Override
    public CreateOrRefreshAPIKeyResp createOrRefreshAPIKey(CreateOrRefreshAPIKeyReq req) throws Exception {
        RawResponse response = super.json("top", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)req));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CreateOrRefreshAPIKeyResp)JSON.parseObject((byte[])response.getData(), CreateOrRefreshAPIKeyResp.class, (Feature[])new Feature[0]);
    }

    @Override
    public Stream<ChatResp> streamChat(String endpointId, ChatReq req) throws MaasException {
        InputStream is;
        HttpResponse response;
        req.setStream(true);
        String reqId = this.genReqId();
        Integer apikeyTtl = this.getAPIKeyTtl();
        if (!endpointId.isEmpty() && apikeyTtl == 0) {
            this.getKey(endpointId);
        }
        SignableRequest request = this.prepareRequest("chat", null);
        try {
            request.setEntity((HttpEntity)new StringEntity(mapper.writeValueAsString((Object)req), "utf-8"));
            request.setHeader("x-tt-logid", reqId);
            request.setHeader("Content-Type", "application/json");
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), reqId);
        }
        try {
            URIBuilder builder = request.getUriBuilder();
            builder.setPath(String.format(builder.getPath(), endpointId));
            request.setURI(builder.build());
            this.ISigner.sign(request, this.credentials);
            request.setHeader("Authorization", "Bearer " + this.apikey);
        }
        catch (Exception e) {
            throw new MaasException(e, reqId);
        }
        try {
            response = this.getHttpClient().execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new MaasException(e, reqId);
        }
        try {
            is = response.getEntity().getContent();
        }
        catch (IOException e) {
            throw new MaasException(e, reqId);
        }
        return SseEvent.fromInputStream(is, StandardCharsets.UTF_8).map(event -> {
            ChatResp resp;
            if (event.getData().trim().equals(CHAT_TERMINATOR)) {
                return null;
            }
            try {
                resp = MaasServiceImpl.json_parse(event.getData().getBytes(), ChatResp.class);
            }
            catch (JsonProcessingException e) {
                this.closeInputStream(is);
                throw new RuntimeException(new MaasException((Exception)((Object)e), reqId));
            }
            if (resp.getError() != null && resp.getError().getCodeN() != 0) {
                this.closeInputStream(is);
                throw new RuntimeException(new MaasException(resp.getError(), reqId));
            }
            return resp;
        }).filter(Objects::nonNull);
    }

    private void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static <T> T json_parse(byte[] data, Class<T> valueType) throws JsonProcessingException {
        return (T)mapper.readValue(new String(data, StandardCharsets.UTF_8), valueType);
    }

    private <T> T request(String endpointId, String api, Object req, Class<T> responseType) throws MaasException {
        String reqId = this.genReqId();
        Integer apikeyTtl = this.getAPIKeyTtl();
        if (!endpointId.isEmpty() && apikeyTtl == 0 && this.apikey.isEmpty()) {
            this.getKey(endpointId);
        }
        try {
            RawResponse response = this.json(endpointId, api, reqId, mapper.writeValueAsString(req), this.apikey);
            if (response.getCode() != SdkError.SUCCESS.getNumber()) {
                try {
                    ErrorResp resp = MaasServiceImpl.json_parse(response.getException().getMessage().getBytes(), ErrorResp.class);
                    throw new MaasException(resp.getError(), reqId);
                }
                catch (JsonProcessingException ignored) {
                    throw new MaasException(response.getException(), reqId);
                }
            }
            return MaasServiceImpl.json_parse(response.getData(), responseType);
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), reqId);
        }
    }

    protected RawResponse makeReq(String api, SignableRequest request, String apikey) {
        if (apikey != null || !apikey.isEmpty()) {
            request.setHeader("Authorization", "Bearer " + apikey);
        } else {
            try {
                this.ISigner.sign(request, this.credentials);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new RawResponse(null, SdkError.ESIGN.getNumber(), e);
            }
        }
        HttpResponse response = null;
        try {
            Object client = this.getHttpClient() != null ? this.getHttpClient() : HttpClients.createDefault();
            response = client.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            Header[] responseHeaders = response.getAllHeaders();
            if (statusCode >= 300) {
                String msg = SdkError.getErrorDesc(SdkError.EHTTP);
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                if (bytes != null && bytes.length > 0) {
                    msg = new String(bytes, StandardCharsets.UTF_8);
                }
                return new RawResponse(null, SdkError.EHTTP.getNumber(), new Exception(msg), responseHeaders, statusCode);
            }
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            return new RawResponse(bytes, SdkError.SUCCESS.getNumber(), null, responseHeaders);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
            return new RawResponse(null, SdkError.EHTTP.getNumber(), new Exception(SdkError.getErrorDesc(SdkError.EHTTP), e));
        }
    }

    private RawResponse json(String endpointId, String api, String reqId, String body, String apikey) throws MaasException {
        ApiInfo apiInfo = (ApiInfo)this.apiInfoList.get(api);
        if (apiInfo == null) {
            throw new MaasException(SdkError.getErrorDesc(SdkError.ENOAPI), reqId);
        }
        SignableRequest request = this.prepareRequest(api, null);
        request.setHeader("x-tt-logid", reqId);
        request.setHeader("Content-Type", "application/json");
        request.setEntity((HttpEntity)new StringEntity(body, "utf-8"));
        try {
            URIBuilder builder = request.getUriBuilder();
            builder.setPath(String.format(builder.getPath(), endpointId));
            request.setURI(builder.build());
        }
        catch (URISyntaxException e) {
            throw new MaasException(e, reqId);
        }
        return this.makeReq(api, request, apikey);
    }

    private String genReqId() {
        int length = 34;
        StringBuilder sb = new StringBuilder();
        sb.ensureCapacity(34);
        sb.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        sb.append(String.format("%020X", new SecureRandom().nextLong()));
        return sb.toString();
    }

    public String getKey(String endpointId) {
        String apiKey = this.getAPIKey();
        if (apiKey.isEmpty()) {
            this.applyKey(endpointId, 604800, null);
        } else {
            Integer apiKeyTtl;
            int currentTime = Math.toIntExact(System.currentTimeMillis() / 1000L);
            if (currentTime + 300 > (apiKeyTtl = this.getAPIKeyTtl())) {
                this.applyKey(endpointId, 604800, null);
                return this.getAPIKey();
            }
        }
        return this.getAPIKey();
    }

    public void applyKey(String endpointId, Integer ttl, List<String> endpointIdList) {
        MaasServiceImpl inner = new MaasServiceImpl("open.volcengineapi.com", "cn-beijing");
        String ak = this.credentials.getAccessKeyID();
        String sk = this.credentials.getSecretAccessKey();
        inner.setAccessKey(ak);
        inner.setSecretKey(sk);
        if (endpointIdList == null) {
            endpointIdList = new ArrayList<String>();
        }
        endpointIdList.add(endpointId);
        CreateOrRefreshAPIKeyReq req = new CreateOrRefreshAPIKeyReq();
        endpointIdList.add(endpointId);
        req.setTtl(ttl);
        req.setEndpointIdList(endpointIdList);
        try {
            CreateOrRefreshAPIKeyResp resp = inner.createOrRefreshAPIKey(req);
            this.apikey = resp.getResult().getApiKey();
            long epochSecond = Instant.now().getEpochSecond();
            this.setAPIKeyTtl(ttl + (int)epochSecond);
            this.setApikey(this.apikey);
        }
        catch (MaasException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

