/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.vikingDB;

import com.google.gson.internal.LinkedTreeMap;
import com.volcengine.service.vikingDB.VikingDBException;
import com.volcengine.service.vikingDB.VikingDBService;
import com.volcengine.service.vikingDB.common.DataObject;
import com.volcengine.service.vikingDB.common.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Collection {
    private String collectionName;
    private List<Field> fields;
    private VikingDBService vikingDBService;
    private String primaryKey;
    private List<String> indexes = null;
    private String description = "";
    private HashMap<String, Object> stat = null;
    private String createTime = null;
    private String updateTime = null;
    private String updatePerson = null;

    public Collection(String collectionName, List<Field> fields, VikingDBService vikingDBService, String primaryKey) {
        this.collectionName = collectionName;
        this.fields = fields;
        this.vikingDBService = vikingDBService;
        this.primaryKey = primaryKey;
    }

    public Collection() {
    }

    public void upsertData(DataObject dataObject) throws Exception {
        if (dataObject.getIsBuild() == 0) {
            VikingDBException vikingDBException = new VikingDBException(1000031, null, "Param dose not build");
            throw vikingDBException.getErrorCodeException(1000031, null, "Param dose not build");
        }
        ArrayList<HashMap<String, Object>> fieldList = new ArrayList<HashMap<String, Object>>();
        fieldList.add(dataObject.getFields());
        Integer ttl = null;
        if (dataObject.getTTL() != null) {
            ttl = dataObject.getTTL();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", this.collectionName);
        params.put("fields", fieldList);
        params.put("ttl", ttl);
        this.vikingDBService.doRequest("UpsertData", null, params);
    }

    public void upsertData(List<DataObject> dataObjects) throws Exception {
        ArrayList fieldList = new ArrayList();
        HashMap<Integer, ArrayList> record = new HashMap<Integer, ArrayList>();
        for (DataObject item : dataObjects) {
            ArrayList fields;
            if (item.getIsBuild() == 0) {
                VikingDBException vikingDBException = new VikingDBException(1000031, null, "Param dose not build");
                throw vikingDBException.getErrorCodeException(1000031, null, "Param dose not build");
            }
            if (record.get(item.getTTL()) != null) {
                fields = (ArrayList)record.get(item.getTTL());
                fields.add(item.getFields());
                record.put(item.getTTL(), fields);
                continue;
            }
            fields = new ArrayList();
            fields.add(item.getFields());
            record.put(item.getTTL(), fields);
        }
        for (Integer key : record.keySet()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("collection_name", this.collectionName);
            params.put("fields", record.get(key));
            params.put("ttl", key);
            this.vikingDBService.doRequest("UpsertData", null, params);
        }
    }

    public <T> void deleteData(T id) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", this.collectionName);
        params.put("primary_keys", id);
        this.vikingDBService.doRequest("DeleteData", null, params);
    }

    public <T> DataObject fetchData(T id) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", this.collectionName);
        params.put("primary_keys", id);
        LinkedTreeMap<String, Object> resData = this.vikingDBService.doRequest("FetchData", null, params);
        ArrayList res = (ArrayList)resData.get((Object)"data");
        HashMap<String, Object> hashMap = this.vikingDBService.convertLinkedTreeMapToHashMap((LinkedTreeMap<String, Object>)((LinkedTreeMap)res.get(0)));
        DataObject dataObject = new DataObject().setFields(hashMap).setId(id);
        return dataObject;
    }

    public List<DataObject> fetchData(List<?> ids) throws Exception {
        ArrayList<DataObject> dataObjects = new ArrayList<DataObject>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", this.collectionName);
        params.put("primary_keys", ids);
        LinkedTreeMap<String, Object> resData = this.vikingDBService.doRequest("FetchData", null, params);
        ArrayList res = (ArrayList)resData.get((Object)"data");
        for (LinkedTreeMap linkedTreeMap : res) {
            HashMap<String, Object> hashMap = this.vikingDBService.convertLinkedTreeMapToHashMap((LinkedTreeMap<String, Object>)linkedTreeMap);
            DataObject dataObject = new DataObject().setFields(hashMap).setId(hashMap.get(this.primaryKey));
            dataObjects.add(dataObject);
        }
        return dataObjects;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public VikingDBService getVikingDBService() {
        return this.vikingDBService;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public List<String> getIndexes() {
        return this.indexes;
    }

    public String getDescription() {
        return this.description;
    }

    public HashMap<String, Object> getStat() {
        return this.stat;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getUpdatePerson() {
        return this.updatePerson;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void setVikingDBService(VikingDBService vikingDBService) {
        this.vikingDBService = vikingDBService;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setIndexes(List<String> indexes) {
        this.indexes = indexes;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStat(HashMap<String, Object> stat) {
        this.stat = stat;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection other = (Collection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        List<Field> this$fields = this.getFields();
        List<Field> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        VikingDBService this$vikingDBService = this.getVikingDBService();
        VikingDBService other$vikingDBService = other.getVikingDBService();
        if (this$vikingDBService == null ? other$vikingDBService != null : !this$vikingDBService.equals(other$vikingDBService)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        List<String> this$indexes = this.getIndexes();
        List<String> other$indexes = other.getIndexes();
        if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        HashMap<String, Object> this$stat = this.getStat();
        HashMap<String, Object> other$stat = other.getStat();
        if (this$stat == null ? other$stat != null : !((Object)this$stat).equals(other$stat)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        String this$updatePerson = this.getUpdatePerson();
        String other$updatePerson = other.getUpdatePerson();
        return !(this$updatePerson == null ? other$updatePerson != null : !this$updatePerson.equals(other$updatePerson));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Collection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        List<Field> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        VikingDBService $vikingDBService = this.getVikingDBService();
        result = result * 59 + ($vikingDBService == null ? 43 : $vikingDBService.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        List<String> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        HashMap<String, Object> $stat = this.getStat();
        result = result * 59 + ($stat == null ? 43 : ((Object)$stat).hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        String $updatePerson = this.getUpdatePerson();
        result = result * 59 + ($updatePerson == null ? 43 : $updatePerson.hashCode());
        return result;
    }

    public String toString() {
        return "Collection(collectionName=" + this.getCollectionName() + ", fields=" + this.getFields() + ", vikingDBService=" + this.getVikingDBService() + ", primaryKey=" + this.getPrimaryKey() + ", indexes=" + this.getIndexes() + ", description=" + this.getDescription() + ", stat=" + this.getStat() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", updatePerson=" + this.getUpdatePerson() + ")";
    }
}

