/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.sms.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.request.ApplySignatureIdentRequest;
import com.volcengine.model.request.ApplySmsSignatureRequest;
import com.volcengine.model.request.ApplySmsTemplateRequest;
import com.volcengine.model.request.ApplyVmsTemplateRequest;
import com.volcengine.model.request.BatchBindSignatureIdentRequest;
import com.volcengine.model.request.ConversionRequest;
import com.volcengine.model.request.DeleteSignatureRequest;
import com.volcengine.model.request.DeleteSmsTemplateRequest;
import com.volcengine.model.request.EditMultiReplyConfigRequest;
import com.volcengine.model.request.GetRelyConfigRequest;
import com.volcengine.model.request.GetSendStatRequest;
import com.volcengine.model.request.GetSignatureAndOrderListRequest;
import com.volcengine.model.request.GetSignatureIdentListRequest;
import com.volcengine.model.request.GetSmsSendDetailsRequest;
import com.volcengine.model.request.GetSmsTemplateAndOrderListRequest;
import com.volcengine.model.request.GetSubAccountListRequest;
import com.volcengine.model.request.GetVmsTemplateStatusRequest;
import com.volcengine.model.request.InsertSubAccountRequest;
import com.volcengine.model.request.SmsBatchSendRequest;
import com.volcengine.model.request.SmsCheckVerifyCodeRequest;
import com.volcengine.model.request.SmsSendRequest;
import com.volcengine.model.request.SmsSendVerifyCodeRequest;
import com.volcengine.model.request.SubAccountRequest;
import com.volcengine.model.request.VmsElement;
import com.volcengine.model.response.ApplySignatureIdentResponse;
import com.volcengine.model.response.ApplySmsSignatureResponse;
import com.volcengine.model.response.ApplySmsTemplateResponse;
import com.volcengine.model.response.ApplyVmsTemplateResponse;
import com.volcengine.model.response.BatchBindSignatureIdentResponse;
import com.volcengine.model.response.ConversionResponse;
import com.volcengine.model.response.DeleteSignatureResponse;
import com.volcengine.model.response.DeleteSmsTemplateResponse;
import com.volcengine.model.response.EditMultiReplyConfigResponse;
import com.volcengine.model.response.GetRelyConfigResponse;
import com.volcengine.model.response.GetSendStatResponse;
import com.volcengine.model.response.GetSignatureAndOrderListResponse;
import com.volcengine.model.response.GetSignatureIdentListResponse;
import com.volcengine.model.response.GetSmsSendDetailsResponse;
import com.volcengine.model.response.GetSmsTemplateAndOrderListResponse;
import com.volcengine.model.response.GetSubAccountDetailResponse;
import com.volcengine.model.response.GetSubAccountListResponse;
import com.volcengine.model.response.GetVmsTemplateResponse;
import com.volcengine.model.response.InsertSubAccountResponse;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.ResponseMetadata;
import com.volcengine.model.response.SmsCheckVerifyCodeResponse;
import com.volcengine.model.response.SmsSendResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.sms.SmsConfig;
import com.volcengine.service.sms.SmsService;
import com.volcengine.service.sms.SmsServiceInfo;
import com.volcengine.service.sms.SmsServiceInfoConfig;
import com.volcengine.util.ConvertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;

public class SmsServiceImpl
extends BaseServiceImpl
implements SmsService {
    private static final ConcurrentHashMap<String, SmsService> instanceMap = new ConcurrentHashMap();
    public static final String SourceTypeText = "text/string";
    public static final String DefaultErrorCode = "-1";
    public static final String DefaultErrorMsg = "\u672a\u77e5\u9519\u8bef";

    private SmsServiceImpl() {
        super(SmsConfig.serviceInfoMap.get("cn-north-1"), SmsConfig.apiInfoList);
    }

    private SmsServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, SmsConfig.apiInfoList);
    }

    private SmsServiceImpl(HttpHost proxy) {
        super(SmsConfig.serviceInfoMap.get("cn-north-1"), proxy, SmsConfig.apiInfoList);
    }

    private SmsServiceImpl(ServiceInfo serviceInfo, HttpHost proxy) {
        super(serviceInfo, proxy, SmsConfig.apiInfoList);
    }

    @Deprecated
    public static SmsService getInstance() {
        return new SmsServiceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmsService getInstance(SmsServiceInfoConfig config) {
        String key = config.getAccessKey();
        if (instanceMap.get(key) == null) {
            ServiceInfo serviceInfo = new SmsServiceInfo(config).GetServiceInfo();
            ConcurrentHashMap<String, SmsService> concurrentHashMap = instanceMap;
            synchronized (concurrentHashMap) {
                if (instanceMap.get(key) == null) {
                    if (config.getProxy() == null) {
                        SmsServiceImpl smsService = new SmsServiceImpl(serviceInfo);
                        instanceMap.putIfAbsent(key, smsService);
                    } else {
                        SmsServiceImpl smsService = new SmsServiceImpl(serviceInfo, config.getProxy());
                        instanceMap.putIfAbsent(key, smsService);
                    }
                }
            }
        }
        return instanceMap.get(key);
    }

    @Deprecated
    public static SmsService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = SmsConfig.serviceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Edit not support region " + region);
        }
        return new SmsServiceImpl(serviceInfo);
    }

    @Deprecated
    public static SmsService getInstance(HttpHost proxy) {
        return new SmsServiceImpl(proxy);
    }

    public static SmsService newSmsService(ServiceInfo serviceInfo) throws Exception {
        if (serviceInfo == null) {
            throw new Exception("ServiceInfo is null");
        }
        return new SmsServiceImpl(serviceInfo);
    }

    @Override
    public SmsSendResponse send(SmsSendRequest smsSendRequest) throws Exception {
        RawResponse response = this.json("SendSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendRequest));
        if (response.getCode() == SdkError.EHTTP.getNumber()) {
            response = this.json("SendSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendRequest));
        }
        return this.getSmsSendResponse(response);
    }

    @Override
    public SmsSendResponse sendV2(SmsSendRequest smsSendRequest) throws Exception {
        RawResponse response = this.json("SendSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendRequest));
        if (response.getCode() == SdkError.EHTTP.getNumber()) {
            response = this.json("SendSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendRequest));
        }
        return this.getSmsSendResponseV2(response);
    }

    @Override
    public SmsSendResponse sendStandard(SmsSendRequest smsSendRequest) throws Exception {
        RawResponse response = this.json("SendSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendRequest));
        if (response.getCode() == SdkError.EHTTP.getNumber()) {
            response = this.json("SendSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendRequest));
        }
        return this.getSmsSendResponseStandard(response);
    }

    @Override
    public SmsSendResponse sendVms(SmsSendRequest smsSendRequest) throws Exception {
        RawResponse response = this.json("SendSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendRequest));
        if (response.getCode() == SdkError.EHTTP.getNumber()) {
            response = this.json("SendSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendRequest));
        }
        return this.getSmsSendResponseV2(response);
    }

    @Override
    public SmsSendResponse batchSend(SmsBatchSendRequest smsBatchSendRequest) throws Exception {
        RawResponse response = this.json("SendBatchSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsBatchSendRequest));
        if (response.getCode() == SdkError.EHTTP.getNumber()) {
            response = this.json("SendBatchSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsBatchSendRequest));
        }
        return this.getSmsSendResponse(response);
    }

    @Override
    public SmsSendResponse batchSendV2(SmsBatchSendRequest smsBatchSendRequest) throws Exception {
        RawResponse response = this.json("SendBatchSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsBatchSendRequest));
        if (response.getCode() == SdkError.EHTTP.getNumber()) {
            response = this.json("SendBatchSms", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsBatchSendRequest));
        }
        return this.getSmsSendResponseV2(response);
    }

    @Override
    public SmsSendResponse sendVerifyCode(SmsSendVerifyCodeRequest smsSendVerifyCodeRequest) throws Exception {
        RawResponse response = this.json("SendSmsVerifyCode", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendVerifyCodeRequest));
        return this.getSmsSendResponse(response);
    }

    @Override
    public SmsSendResponse sendVerifyCodeV2(SmsSendVerifyCodeRequest smsSendVerifyCodeRequest) throws Exception {
        RawResponse response = this.json("SendSmsVerifyCode", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsSendVerifyCodeRequest));
        return this.getSmsSendResponseV2(response);
    }

    @Override
    public SmsCheckVerifyCodeResponse checkVerifyCode(SmsCheckVerifyCodeRequest smsCheckVerifyCodeRequest) throws Exception {
        RawResponse response = this.json("CheckSmsVerifyCode", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)smsCheckVerifyCodeRequest));
        return this.getSmsCheckResponse(response);
    }

    @Override
    public ConversionResponse conversion(ConversionRequest conversionRequest) throws Exception {
        RawResponse response = this.json("Conversion", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)conversionRequest));
        return this.getConversionResponse(response);
    }

    @Override
    public GetSubAccountListResponse getSubAccountList(GetSubAccountListRequest getSubAccountListRequest) throws Exception {
        List<NameValuePair> urlParams = ConvertUtils.convertToPair(getSubAccountListRequest);
        RawResponse response = this.json("GetSubAccountList", urlParams, "");
        return this.getSubAccountListResponse(response);
    }

    @Override
    public EditMultiReplyConfigResponse editMultiReplyConfig(EditMultiReplyConfigRequest request) throws Exception {
        RawResponse response = this.json("EditMultiReplyConfig", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        return this.editMultiReplyConfigResponse(response);
    }

    @Override
    public GetRelyConfigResponse getRelyConfig(GetRelyConfigRequest request) throws Exception {
        List<NameValuePair> urlParams = ConvertUtils.convertToPair(request);
        RawResponse response = this.json("GetRelyConfig", urlParams, "");
        return this.getRelyConfigResponse(response);
    }

    @Override
    public InsertSubAccountResponse insertSubAccount(InsertSubAccountRequest request) throws Exception {
        RawResponse response = this.json("InsertSubAccount", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        return this.insertSubAccountResponse(response);
    }

    @Override
    public GetSubAccountDetailResponse getSubAccountDetail(SubAccountRequest subAccountRequest) throws Exception {
        List<NameValuePair> urlParams = ConvertUtils.convertToPair(subAccountRequest);
        RawResponse response = this.json("GetSubAccountDetail", urlParams, "");
        return this.getSubAccountDetailResponse(response);
    }

    @Override
    public GetSmsTemplateAndOrderListResponse getSmsTemplateAndOrderList(GetSmsTemplateAndOrderListRequest getSmsTemplateAndOrderListRequest) throws Exception {
        List<NameValuePair> urlParams = ConvertUtils.convertToPair(getSmsTemplateAndOrderListRequest);
        RawResponse response = this.json("GetSmsTemplateAndOrderList", urlParams, "");
        return this.getSmsTemplateAndOrderListResponse(response);
    }

    @Override
    public ApplySmsTemplateResponse applySmsTemplate(ApplySmsTemplateRequest applySmsTemplateRequest) throws Exception {
        RawResponse response = this.json("ApplySmsTemplate", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)applySmsTemplateRequest));
        return this.applySmsTemplateResponse(response);
    }

    @Override
    public ApplyVmsTemplateResponse ApplyVmsTemplate(ApplyVmsTemplateRequest req) throws Exception {
        if (req.getContents() == null || req.getContents().size() == 0) {
            throw new Exception("should contain contents");
        }
        boolean containText = SmsServiceImpl.isContainText(req);
        if (!containText) {
            throw new Exception("should contain text in contents");
        }
        if (StringUtils.isBlank((CharSequence)req.getChannelType())) {
            req.setChannelType("CN_VMS");
        }
        RawResponse response = this.json("ApplyVmsTemplate", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)req));
        return this.applyVmsTemplateResponse(response);
    }

    private static boolean isContainText(ApplyVmsTemplateRequest req) {
        boolean containText = false;
        for (VmsElement element : req.getContents()) {
            if (element.getSourceType() != SourceTypeText) continue;
            containText = true;
        }
        return containText;
    }

    @Override
    public GetVmsTemplateResponse GetVmsTemplateStatus(GetVmsTemplateStatusRequest req) throws Exception {
        RawResponse response = this.json("GetVmsTemplateStatus", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)req));
        return this.getVmsTemplateResponse(response);
    }

    @Override
    public DeleteSmsTemplateResponse deleteSmsTemplate(DeleteSmsTemplateRequest deleteSmsTemplateRequest) throws Exception {
        RawResponse response = this.json("DeleteSmsTemplate", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)deleteSmsTemplateRequest));
        return this.deleteSmsTemplateResponse(response);
    }

    @Override
    public GetSignatureAndOrderListResponse getSmsSignatureAndOrderList(GetSignatureAndOrderListRequest getSignatureAndOrderListRequest) throws Exception {
        List<NameValuePair> urlParams = ConvertUtils.convertToPair(getSignatureAndOrderListRequest);
        RawResponse response = this.json("GetSignatureAndOrderList", urlParams, "");
        return this.getSignatureAndOrderListResponse(response);
    }

    @Override
    public ApplySmsSignatureResponse applySmsSignature(ApplySmsSignatureRequest applySmsSignatureRequest) throws Exception {
        RawResponse response = this.json("ApplySmsSignature", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)applySmsSignatureRequest));
        return this.applySmsSignatureResponse(response);
    }

    @Override
    public DeleteSignatureResponse deleteSmsSignature(DeleteSignatureRequest deleteSignatureRequest) throws Exception {
        RawResponse response = this.json("DeleteSignature", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)deleteSignatureRequest));
        return this.deleteSignatureResponse(response);
    }

    @Override
    @Deprecated
    public GetSendStatResponse getSendStat(GetSendStatRequest getSendStatRequest) throws Exception {
        RawResponse response = this.json("GetTotalSendCountStatV5", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)getSendStatRequest));
        return this.getGetSendStatResponse(response);
    }

    @Override
    public GetSmsSendDetailsResponse getSmsSendDetails(GetSmsSendDetailsRequest getSmsSendDetailsRequest) throws Exception {
        RawResponse response = this.json("GetSmsSendDetails", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)getSmsSendDetailsRequest));
        return this.getSmsSendDetailsResponse(response);
    }

    private SmsSendResponse getSmsSendResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        SmsSendResponse res = (SmsSendResponse)JSON.parseObject((byte[])response.getData(), SmsSendResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error: " + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private SmsSendResponse getSmsSendResponseV2(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            if (response.getException() != null) {
                return new SmsSendResponse(String.valueOf(response.getCode()), response.getException().getMessage());
            }
            return new SmsSendResponse(String.valueOf(response.getCode()), Arrays.toString(response.getData()));
        }
        SmsSendResponse res = (SmsSendResponse)JSON.parseObject((byte[])response.getData(), SmsSendResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            return new SmsSendResponse(meta.getError().getCode(), meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private GetSendStatResponse getGetSendStatResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            if (response.getException() != null) {
                return new GetSendStatResponse(DefaultErrorCode, response.getException().getMessage());
            }
            return new GetSendStatResponse(String.valueOf(response.getCode()), Arrays.toString(response.getData()));
        }
        GetSendStatResponse res = (GetSendStatResponse)JSON.parseObject((byte[])response.getData(), GetSendStatResponse.class, (Feature[])new Feature[0]);
        if (res == null) {
            return new GetSendStatResponse(DefaultErrorCode, DefaultErrorMsg);
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private SmsSendResponse getSmsSendResponseStandard(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            if (response.getException() != null) {
                return new SmsSendResponse(DefaultErrorCode, response.getException().getMessage());
            }
            return new SmsSendResponse(String.valueOf(response.getCode()), Arrays.toString(response.getData()));
        }
        SmsSendResponse res = (SmsSendResponse)JSON.parseObject((byte[])response.getData(), SmsSendResponse.class, (Feature[])new Feature[0]);
        if (res == null) {
            return new SmsSendResponse(DefaultErrorCode, DefaultErrorMsg);
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private static ResponseMetadata GetResponseData(String code, String msg) {
        ResponseMetadata resp = new ResponseMetadata();
        ResponseMetadata.Error defaultErr = new ResponseMetadata.Error();
        defaultErr.setMessage(msg);
        defaultErr.setCode(code);
        resp.setError(defaultErr);
        return resp;
    }

    private SmsCheckVerifyCodeResponse getSmsCheckResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        SmsCheckVerifyCodeResponse res = (SmsCheckVerifyCodeResponse)JSON.parseObject((byte[])response.getData(), SmsCheckVerifyCodeResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private ConversionResponse getConversionResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ConversionResponse res = (ConversionResponse)JSON.parseObject((byte[])response.getData(), ConversionResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private GetSubAccountListResponse getSubAccountListResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetSubAccountListResponse res = (GetSubAccountListResponse)JSON.parseObject((byte[])response.getData(), GetSubAccountListResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private GetSubAccountDetailResponse getSubAccountDetailResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetSubAccountDetailResponse res = (GetSubAccountDetailResponse)JSON.parseObject((byte[])response.getData(), GetSubAccountDetailResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private GetSmsTemplateAndOrderListResponse getSmsTemplateAndOrderListResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetSmsTemplateAndOrderListResponse res = (GetSmsTemplateAndOrderListResponse)JSON.parseObject((byte[])response.getData(), GetSmsTemplateAndOrderListResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private ApplySmsTemplateResponse applySmsTemplateResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ApplySmsTemplateResponse res = (ApplySmsTemplateResponse)JSON.parseObject((byte[])response.getData(), ApplySmsTemplateResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private ApplyVmsTemplateResponse applyVmsTemplateResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ApplyVmsTemplateResponse res = (ApplyVmsTemplateResponse)JSON.parseObject((byte[])response.getData(), ApplyVmsTemplateResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private GetVmsTemplateResponse getVmsTemplateResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetVmsTemplateResponse res = (GetVmsTemplateResponse)JSON.parseObject((byte[])response.getData(), GetVmsTemplateResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private DeleteSmsTemplateResponse deleteSmsTemplateResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DeleteSmsTemplateResponse res = (DeleteSmsTemplateResponse)JSON.parseObject((byte[])response.getData(), DeleteSmsTemplateResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private GetSignatureAndOrderListResponse getSignatureAndOrderListResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetSignatureAndOrderListResponse res = (GetSignatureAndOrderListResponse)JSON.parseObject((byte[])response.getData(), GetSignatureAndOrderListResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private ApplySmsSignatureResponse applySmsSignatureResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ApplySmsSignatureResponse res = (ApplySmsSignatureResponse)JSON.parseObject((byte[])response.getData(), ApplySmsSignatureResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private DeleteSignatureResponse deleteSignatureResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DeleteSignatureResponse res = (DeleteSignatureResponse)JSON.parseObject((byte[])response.getData(), DeleteSignatureResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private EditMultiReplyConfigResponse editMultiReplyConfigResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        EditMultiReplyConfigResponse res = (EditMultiReplyConfigResponse)JSON.parseObject((byte[])response.getData(), EditMultiReplyConfigResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private InsertSubAccountResponse insertSubAccountResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        InsertSubAccountResponse res = (InsertSubAccountResponse)JSON.parseObject((byte[])response.getData(), InsertSubAccountResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private GetRelyConfigResponse getRelyConfigResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetRelyConfigResponse res = (GetRelyConfigResponse)JSON.parseObject((byte[])response.getData(), GetRelyConfigResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    private GetSmsSendDetailsResponse getSmsSendDetailsResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetSmsSendDetailsResponse res = (GetSmsSendDetailsResponse)JSON.parseObject((byte[])response.getData(), GetSmsSendDetailsResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    @Override
    public ApplySignatureIdentResponse applySignatureIdent(ApplySignatureIdentRequest applySignatureIdentRequest) throws Exception {
        RawResponse response = this.json("ApplySmsSignature", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)applySignatureIdentRequest));
        return this.applySignatureIdentResponse(response);
    }

    public ApplySignatureIdentResponse applySignatureIdentResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ApplySignatureIdentResponse res = (ApplySignatureIdentResponse)JSON.parseObject((byte[])response.getData(), ApplySignatureIdentResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    @Override
    public GetSignatureIdentListResponse getSignatureIdentList(GetSignatureIdentListRequest getSignatureIdentListRequest) throws Exception {
        RawResponse response = this.json("GetSignatureIdentList", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)getSignatureIdentListRequest));
        return this.getSignatureIdentListResponse(response);
    }

    public GetSignatureIdentListResponse getSignatureIdentListResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetSignatureIdentListResponse res = (GetSignatureIdentListResponse)JSON.parseObject((byte[])response.getData(), GetSignatureIdentListResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }

    @Override
    public BatchBindSignatureIdentResponse batchBindSignatureIdent(BatchBindSignatureIdentRequest batchBindSignatureIdentRequest) throws Exception {
        RawResponse response = this.json("BatchBindSignatureIdent", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)batchBindSignatureIdentRequest));
        return this.batchBindSignatureIdentResponse(response);
    }

    public BatchBindSignatureIdentResponse batchBindSignatureIdentResponse(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        BatchBindSignatureIdentResponse res = (BatchBindSignatureIdentResponse)JSON.parseObject((byte[])response.getData(), BatchBindSignatureIdentResponse.class, (Feature[])new Feature[0]);
        if (res.getResponseMetadata().getError() != null) {
            ResponseMetadata meta = res.getResponseMetadata();
            throw new Exception(meta.getRequestId() + "error:" + meta.getError().getMessage());
        }
        res.getResponseMetadata().setService("volcSMS");
        return res;
    }
}

