/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.vikingDB;

import com.volcengine.service.vikingDB.APINotImplementedException;
import com.volcengine.service.vikingDB.CalcEmbeddingFailedException;
import com.volcengine.service.vikingDB.CollectionExistException;
import com.volcengine.service.vikingDB.CollectionNotExistException;
import com.volcengine.service.vikingDB.DataNotFoundException;
import com.volcengine.service.vikingDB.DelOpFailedException;
import com.volcengine.service.vikingDB.IndexExistException;
import com.volcengine.service.vikingDB.IndexFetchDataException;
import com.volcengine.service.vikingDB.IndexNotExistException;
import com.volcengine.service.vikingDB.IndexNotReadyException;
import com.volcengine.service.vikingDB.IndexRecallException;
import com.volcengine.service.vikingDB.InvalidPartitionException;
import com.volcengine.service.vikingDB.InvalidPrimaryKeyException;
import com.volcengine.service.vikingDB.InvalidProxyServiceException;
import com.volcengine.service.vikingDB.InvalidQueryVecException;
import com.volcengine.service.vikingDB.InvalidRequestException;
import com.volcengine.service.vikingDB.InvalidScalarCondException;
import com.volcengine.service.vikingDB.ListEmbeddingModelsException;
import com.volcengine.service.vikingDB.NoPermissionException;
import com.volcengine.service.vikingDB.OperationNotAllowedException;
import com.volcengine.service.vikingDB.ParamsNotBuildException;
import com.volcengine.service.vikingDB.ParamsNotExistException;
import com.volcengine.service.vikingDB.PrimaryKeyErrorException;
import com.volcengine.service.vikingDB.QueryOpFailedException;
import com.volcengine.service.vikingDB.TokenMismatchException;
import com.volcengine.service.vikingDB.UnauthorizedException;
import com.volcengine.service.vikingDB.UpsertOpFailedException;
import com.volcengine.service.vikingDB.VikingDBServerException;

public class VikingDBException
extends Exception {
    private Integer code = 1000028;
    private String requestId = "1000028";
    private String message = "";

    public VikingDBException(Integer code, String requestId, String message) {
        this.code = code;
        this.requestId = requestId;
        this.message = String.format("%s, code:%s, request_id:%s", message, this.code, this.requestId);
    }

    public VikingDBException(Long code, String requestId, String message) {
        this.code = code.intValue();
        this.requestId = requestId;
        this.message = String.format("%s, code:%s, request_id:%s", message, this.code, this.requestId);
    }

    public VikingDBException() {
    }

    public Exception getErrorCodeException(Integer code, String requestId, String message) {
        if (code == 1000001) {
            return new UnauthorizedException(code, requestId, message);
        }
        if (code == 1000002) {
            return new NoPermissionException(code, requestId, message);
        }
        if (code == 1000003) {
            return new InvalidRequestException(code, requestId, message);
        }
        if (code == 1000004) {
            return new CollectionExistException(code, requestId, message);
        }
        if (code == 1000005) {
            return new CollectionNotExistException(code, requestId, message);
        }
        if (code == 1000006) {
            return new OperationNotAllowedException(code, requestId, message);
        }
        if (code == 1000007) {
            return new IndexExistException(code, requestId, message);
        }
        if (code == 1000008) {
            return new IndexNotExistException(code, requestId, message);
        }
        if (code == 1000010) {
            return new QueryOpFailedException(code, requestId, message);
        }
        if (code == 1000011) {
            return new DataNotFoundException(code, requestId, message);
        }
        if (code == 1000013) {
            return new DelOpFailedException(code, requestId, message);
        }
        if (code == 1000014) {
            return new UpsertOpFailedException(code, requestId, message);
        }
        if (code == 1000015) {
            return new TokenMismatchException(code, requestId, message);
        }
        if (code == 1000016) {
            return new InvalidQueryVecException(code, requestId, message);
        }
        if (code == 1000017) {
            return new InvalidPrimaryKeyException(code, requestId, message);
        }
        if (code == 1000018) {
            return new InvalidPartitionException(code, requestId, message);
        }
        if (code == 1000019) {
            return new InvalidScalarCondException(code, requestId, message);
        }
        if (code == 1000020) {
            return new InvalidProxyServiceException(code, requestId, message);
        }
        if (code == 1000021) {
            return new IndexRecallException(code, requestId, message);
        }
        if (code == 1000022) {
            return new IndexFetchDataException(code, requestId, message);
        }
        if (code == 1000023) {
            return new IndexNotReadyException(code, requestId, message);
        }
        if (code == 1000024) {
            return new APINotImplementedException(code, requestId, message);
        }
        if (code == 1000025) {
            return new CalcEmbeddingFailedException(code, requestId, message);
        }
        if (code == 1000026) {
            return new ListEmbeddingModelsException(code, requestId, message);
        }
        if (code == 1000030) {
            return new ParamsNotExistException(message);
        }
        if (code == 1000031) {
            return new ParamsNotBuildException(message);
        }
        if (code == 1000032) {
            return new PrimaryKeyErrorException(message);
        }
        return new VikingDBServerException(code, requestId, message);
    }

    public Exception getErrorCodeException(Long code, String requestId, String message) {
        return this.getErrorCodeException(code.intValue(), requestId, message);
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        String message = this.message;
        return message != null ? s + ": " + message : s;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VikingDBException)) {
            return false;
        }
        VikingDBException other = (VikingDBException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VikingDBException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }
}

