/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.businessSecurity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.request.ActivateRiskBasePackageRequest;
import com.volcengine.model.request.ActivateRiskResultRequest;
import com.volcengine.model.request.ActivateRiskSampleDataRequest;
import com.volcengine.model.request.AsyncRiskDetectionRequest;
import com.volcengine.model.request.CompleteUploadFileRequest;
import com.volcengine.model.request.CreateAppRequest;
import com.volcengine.model.request.DataReportRequest;
import com.volcengine.model.request.GetDailyMarketingPackageRequest;
import com.volcengine.model.request.GetUploadIdRequest;
import com.volcengine.model.request.GetUploadedPartListRequest;
import com.volcengine.model.request.ListAppsRequest;
import com.volcengine.model.request.PushTrafficRiskDataRequest;
import com.volcengine.model.request.RiskDetectionRequest;
import com.volcengine.model.request.RiskResultRequest;
import com.volcengine.model.request.RiskStatRequest;
import com.volcengine.model.request.UploadFileRequest;
import com.volcengine.model.response.ActivateRiskBasePackageResponse;
import com.volcengine.model.response.ActivateRiskResultResponse;
import com.volcengine.model.response.ActivateRiskSampleDataResponse;
import com.volcengine.model.response.AsyncRiskDetectionResponse;
import com.volcengine.model.response.CreateAppResponse;
import com.volcengine.model.response.DataReportResponse;
import com.volcengine.model.response.ElementVerifyResponseV2;
import com.volcengine.model.response.GetDailyMarketingPackageResponse;
import com.volcengine.model.response.ListAppsResponse;
import com.volcengine.model.response.MobileStatusResponseV2;
import com.volcengine.model.response.PushTrafficRiskDataResponse;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.RiskDetectionResponse;
import com.volcengine.model.response.RiskResultResponse;
import com.volcengine.model.response.RiskStatResponse;
import com.volcengine.model.response.RiskVConsoleResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.businessSecurity.BusinessSecurityConfig;
import com.volcengine.service.businessSecurity.BusinessSecurityService;
import com.volcengine.util.AesUtil;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class BusinessSecurityServiceImpl
extends BaseServiceImpl
implements BusinessSecurityService {
    private static final Integer PART_FILE_SIZE = 0x700000;
    private static final BusinessSecurityServiceImpl businessSecurityInstance = new BusinessSecurityServiceImpl();
    private static final BusinessSecurityServiceImpl businessSecurityOpenapiInstance = new BusinessSecurityServiceImpl("risk_console");

    private BusinessSecurityServiceImpl() {
        super(BusinessSecurityConfig.serviceInfo, BusinessSecurityConfig.apiInfoList);
    }

    private BusinessSecurityServiceImpl(String service) {
        super(BusinessSecurityConfig.serviceInfoMapping.get(service), BusinessSecurityConfig.apiInfoList);
    }

    public static BusinessSecurityService getInstance() {
        return businessSecurityInstance;
    }

    public static BusinessSecurityService getInstanceOpenapi() {
        return businessSecurityOpenapiInstance;
    }

    @Override
    public RiskDetectionResponse RiskDetection(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("RiskDetection", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RiskDetectionResponse)JSON.parseObject((byte[])response.getData(), RiskDetectionResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public AsyncRiskDetectionResponse AsyncRiskDetection(AsyncRiskDetectionRequest asyncRiskDetectionRequest) throws Exception {
        RawResponse response = this.json("AsyncRiskDetection", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)asyncRiskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (AsyncRiskDetectionResponse)JSON.parseObject((byte[])response.getData(), AsyncRiskDetectionResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RiskResultResponse RiskResult(RiskResultRequest riskResultRequest) throws Exception {
        RawResponse response = this.query("RiskResult", Utils.mapToPairList(Utils.paramsToMap(riskResultRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RiskResultResponse)JSON.parseObject((byte[])response.getData(), RiskResultResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public DataReportResponse DataReport(DataReportRequest dataReportRequest) throws Exception {
        RawResponse response = this.json("DataReport", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)dataReportRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (DataReportResponse)JSON.parseObject((byte[])response.getData(), DataReportResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RiskDetectionResponse AccountRisk(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("AccountRisk", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RiskDetectionResponse)JSON.parseObject((byte[])response.getData(), RiskDetectionResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public MobileStatusResponseV2 MobileStatusV2(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("MobileStatusV2", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (MobileStatusResponseV2)JSON.parseObject((byte[])response.getData(), MobileStatusResponseV2.class, (Feature[])new Feature[0]);
    }

    @Override
    public ElementVerifyResponseV2 ElementVerifyV2(RiskDetectionRequest riskDetectionRequest) throws Exception {
        RawResponse response = this.json("ElementVerifyV2", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ElementVerifyResponseV2)JSON.parseObject((byte[])response.getData(), ElementVerifyResponseV2.class, (Feature[])new Feature[0]);
    }

    @Override
    public ElementVerifyResponseV2 ElementVerifyEncrypted(String key, String encryptedType, RiskDetectionRequest riskDetectionRequest) throws Exception {
        String parameters = AesUtil.aesCBCEncryptWithBase64(riskDetectionRequest.getParameters(), key);
        riskDetectionRequest.setParameters(parameters);
        riskDetectionRequest.setEncryptedType(encryptedType);
        RawResponse response = this.json("ElementVerifyEncrypted", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)riskDetectionRequest));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ElementVerifyResponseV2)JSON.parseObject((byte[])response.getData(), ElementVerifyResponseV2.class, (Feature[])new Feature[0]);
    }

    @Override
    public RiskStatResponse.CommonRiskStatResponse SimpleRiskStat(RiskStatRequest.CommonProductStatisticsReq commonProductStatisticsReq) throws Exception {
        RawResponse response = this.json("SimpleRiskStat", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)commonProductStatisticsReq));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RiskStatResponse.CommonRiskStatResponse)JSON.parseObject((byte[])response.getData(), RiskStatResponse.CommonRiskStatResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RiskStatResponse.CommonRiskStatResponse ContentRiskStat(RiskStatRequest.CommonProductStatisticsReq commonProductStatisticsReq) throws Exception {
        RawResponse response = this.json("ContentRiskStat", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)commonProductStatisticsReq));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RiskStatResponse.CommonRiskStatResponse)JSON.parseObject((byte[])response.getData(), RiskStatResponse.CommonRiskStatResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public RiskVConsoleResponse.GetUploadIdResult GetUploadId(GetUploadIdRequest request) throws Exception {
        RawResponse response = this.json("GetUploadId", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RiskVConsoleResponse.GetUploadIdResult)JSON.parseObject((byte[])response.getData(), RiskVConsoleResponse.GetUploadIdResult.class, (Feature[])new Feature[0]);
    }

    @Override
    public RiskVConsoleResponse.UploadFileResult UploadFile(UploadFileRequest request) throws Exception {
        ArrayList<NameValuePair> fromData = new ArrayList<NameValuePair>();
        fromData.add((NameValuePair)new BasicNameValuePair("app_id", String.valueOf(request.getAppId())));
        fromData.add((NameValuePair)new BasicNameValuePair("upload_id", String.valueOf(request.getUploadId())));
        fromData.add((NameValuePair)new BasicNameValuePair("part_size", String.valueOf(request.getPartSize())));
        fromData.add((NameValuePair)new BasicNameValuePair("part_num", String.valueOf(request.getPartNum())));
        RawResponse response = this.postFileMultiPart("UploadFile", fromData, "content", request.getFileName(), request.getContent());
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RiskVConsoleResponse.UploadFileResult)JSON.parseObject((byte[])response.getData(), RiskVConsoleResponse.UploadFileResult.class, (Feature[])new Feature[0]);
    }

    @Override
    public RiskVConsoleResponse.CompleteUploadFileResult CompleteUploadFile(CompleteUploadFileRequest request) throws Exception {
        RawResponse response = this.json("CompleteUploadFile", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RiskVConsoleResponse.CompleteUploadFileResult)JSON.parseObject((byte[])response.getData(), RiskVConsoleResponse.CompleteUploadFileResult.class, (Feature[])new Feature[0]);
    }

    @Override
    public RiskVConsoleResponse.GetUploadedPartListResult GetUploadedPartList(GetUploadedPartListRequest request) throws Exception {
        RawResponse response = this.json("GetUploadedPartList", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (RiskVConsoleResponse.GetUploadedPartListResult)JSON.parseObject((byte[])response.getData(), RiskVConsoleResponse.GetUploadedPartListResult.class, (Feature[])new Feature[0]);
    }

    @Override
    public PushTrafficRiskDataResponse PushTrafficRiskData(PushTrafficRiskDataRequest request) throws Exception {
        int bytesRead;
        FileInfo fileInfo = this.getFileInfo(request.getFilePath());
        String fileName = request.getFilePath().substring(request.getFilePath().lastIndexOf("/") + 1);
        GetUploadIdRequest getUploadIdRequest = new GetUploadIdRequest();
        getUploadIdRequest.setAppId(request.getAppId());
        getUploadIdRequest.setFileName(fileName);
        getUploadIdRequest.setFileHash(fileInfo.getFileHash());
        getUploadIdRequest.setPartSize(PART_FILE_SIZE);
        RiskVConsoleResponse.GetUploadIdResult response = this.GetUploadId(getUploadIdRequest);
        String uploadId = response.getResult().getData().getUploadId();
        FileInputStream fis = new FileInputStream(request.getFilePath());
        GetUploadedPartListRequest getUploadedPartListRequest = new GetUploadedPartListRequest();
        getUploadedPartListRequest.setUploadId(uploadId);
        getUploadedPartListRequest.setAppId(request.getAppId());
        RiskVConsoleResponse.GetUploadedPartListResult uploadedPartListResult = this.GetUploadedPartList(getUploadedPartListRequest);
        List<Integer> uploadedPartList = uploadedPartListResult.getResult().getData();
        HashSet<Integer> set = new HashSet<Integer>();
        if (uploadedPartList != null) {
            set.addAll(uploadedPartList);
        }
        byte[] buffer = new byte[PART_FILE_SIZE.intValue()];
        int partNum = 1;
        while ((bytesRead = fis.read(buffer)) != -1) {
            RiskVConsoleResponse.UploadFileResult result;
            if (set.contains(partNum)) {
                ++partNum;
                continue;
            }
            UploadFileRequest uploadFileRequest = new UploadFileRequest();
            uploadFileRequest.setAppId(request.getAppId());
            uploadFileRequest.setFileName(fileName);
            uploadFileRequest.setUploadId(uploadId);
            uploadFileRequest.setPartNum(partNum++);
            uploadFileRequest.setPartSize(bytesRead);
            if (bytesRead == PART_FILE_SIZE) {
                uploadFileRequest.setContent(buffer);
            } else {
                byte[] newBuffer = new byte[bytesRead];
                System.arraycopy(buffer, 0, newBuffer, 0, bytesRead);
                uploadFileRequest.setContent(newBuffer);
            }
            if ("0".equals((result = this.UploadFile(uploadFileRequest)).getResult().getErrCode())) continue;
            return PushTrafficRiskDataResponse.builder().success(false).build();
        }
        CompleteUploadFileRequest completeUploadFileRequest = new CompleteUploadFileRequest();
        completeUploadFileRequest.setAppId(request.getAppId());
        completeUploadFileRequest.setUploadId(uploadId);
        completeUploadFileRequest.setBusinessType(request.getBusinessType());
        completeUploadFileRequest.setDataType(request.getDataType());
        completeUploadFileRequest.setScene(request.getScene());
        RiskVConsoleResponse.CompleteUploadFileResult completeUploadFileResult = this.CompleteUploadFile(completeUploadFileRequest);
        return PushTrafficRiskDataResponse.builder().success(true).packageId(completeUploadFileResult.getResult().getData()).build();
    }

    @Override
    public GetDailyMarketingPackageResponse GetDailyMarketingPackage(GetDailyMarketingPackageRequest request) throws Exception {
        RawResponse response = this.json("GetDailyMarketingPackage", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (GetDailyMarketingPackageResponse)JSON.parseObject((byte[])response.getData(), GetDailyMarketingPackageResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ActivateRiskResultResponse ActivateRiskResult(ActivateRiskResultRequest request) throws Exception {
        RawResponse response = this.json("ActivateRiskResult", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ActivateRiskResultResponse)JSON.parseObject((byte[])response.getData(), ActivateRiskResultResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ActivateRiskSampleDataResponse ActivateRiskSampleData(ActivateRiskSampleDataRequest request) throws Exception {
        RawResponse response = this.json("ActivateRiskSampleData", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ActivateRiskSampleDataResponse)JSON.parseObject((byte[])response.getData(), ActivateRiskSampleDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ActivateRiskBasePackageResponse ActivateRiskBasePackage(ActivateRiskBasePackageRequest request) throws Exception {
        RawResponse response = this.json("ActivateRiskBasePackage", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)request));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ActivateRiskBasePackageResponse)JSON.parseObject((byte[])response.getData(), ActivateRiskBasePackageResponse.class, (Feature[])new Feature[0]);
    }

    private FileInfo getFileInfo(String filePath) throws Exception {
        int bytesRead;
        if (StringUtils.isBlank((CharSequence)filePath)) {
            throw new Exception("filePath is null");
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFilePath(filePath);
        fileInfo.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        long fileSize = 0L;
        int partNum = 0;
        MessageDigest md = MessageDigest.getInstance("MD5");
        FileInputStream fis = new FileInputStream(filePath);
        byte[] buffer = new byte[PART_FILE_SIZE.intValue()];
        while ((bytesRead = fis.read(buffer)) != -1) {
            ++partNum;
            fileSize += (long)bytesRead;
            md.update(buffer, 0, bytesRead);
        }
        fis.close();
        byte[] hash = md.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        fileInfo.setPartNum(partNum);
        fileInfo.setFileHash(hexString.toString());
        fileInfo.setFileSize(fileSize);
        return fileInfo;
    }

    @Override
    public CreateAppResponse.CommonCreateAppResponse CreateApp(CreateAppRequest createAppRequest) throws Exception {
        RawResponse response = this.query("CreateApp", Utils.mapToPairList(Utils.paramsToMap(createAppRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CreateAppResponse.CommonCreateAppResponse)JSON.parseObject((byte[])response.getData(), CreateAppResponse.CommonCreateAppResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public ListAppsResponse.CommonListAppsResponse ListApps(ListAppsRequest listAppsRequest) throws Exception {
        RawResponse response = this.query("ListApps", Utils.mapToPairList(Utils.paramsToMap(listAppsRequest)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (ListAppsResponse.CommonListAppsResponse)JSON.parseObject((byte[])response.getData(), ListAppsResponse.CommonListAppsResponse.class, (Feature[])new Feature[0]);
    }

    static class FileInfo {
        private long fileSize;
        private String fileName;
        private String filePath;
        private String fileHash;
        private int partNum;

        public long getFileSize() {
            return this.fileSize;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getFileHash() {
            return this.fileHash;
        }

        public int getPartNum() {
            return this.partNum;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public void setFileHash(String fileHash) {
            this.fileHash = fileHash;
        }

        public void setPartNum(int partNum) {
            this.partNum = partNum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileInfo)) {
                return false;
            }
            FileInfo other = (FileInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFileSize() != other.getFileSize()) {
                return false;
            }
            if (this.getPartNum() != other.getPartNum()) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            String this$filePath = this.getFilePath();
            String other$filePath = other.getFilePath();
            if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
                return false;
            }
            String this$fileHash = this.getFileHash();
            String other$fileHash = other.getFileHash();
            return !(this$fileHash == null ? other$fileHash != null : !this$fileHash.equals(other$fileHash));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $fileSize = this.getFileSize();
            result = result * 59 + (int)($fileSize >>> 32 ^ $fileSize);
            result = result * 59 + this.getPartNum();
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            String $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
            String $fileHash = this.getFileHash();
            result = result * 59 + ($fileHash == null ? 43 : $fileHash.hashCode());
            return result;
        }

        public String toString() {
            return "BusinessSecurityServiceImpl.FileInfo(fileSize=" + this.getFileSize() + ", fileName=" + this.getFileName() + ", filePath=" + this.getFilePath() + ", fileHash=" + this.getFileHash() + ", partNum=" + this.getPartNum() + ")";
        }
    }
}

