/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.vikingDB;

import com.google.gson.internal.LinkedTreeMap;
import com.volcengine.service.vikingDB.Collection;
import com.volcengine.service.vikingDB.VikingDBException;
import com.volcengine.service.vikingDB.VikingDBService;
import com.volcengine.service.vikingDB.common.DataObject;
import com.volcengine.service.vikingDB.common.FetchDataParam;
import com.volcengine.service.vikingDB.common.SearchByIdParam;
import com.volcengine.service.vikingDB.common.SearchByTextParam;
import com.volcengine.service.vikingDB.common.SearchByVectorParam;
import com.volcengine.service.vikingDB.common.SearchParam;
import com.volcengine.service.vikingDB.common.VectorIndexParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Index {
    private String collectionName = null;
    private String indexName = null;
    private String description = "";
    private VectorIndexParams vectorIndex = null;
    private List<String> scalarIndex = null;
    private String stat = null;
    private VikingDBService vikingDBService = null;
    private Integer cpuQuota = 2;
    private Object partitionBy = null;
    private String primaryKey = null;
    private String createTime = null;
    private String updateTime = null;
    private String updatePerson = null;
    private Integer shardCount = null;
    private String shardPolicy = null;
    private HashMap<String, Object> indexCost = null;

    public Index() {
    }

    public Index(String collectionName, String indexName, VectorIndexParams vectorIndex, List<String> scalarIndex, String stat, VikingDBService vikingDBService) {
        this.collectionName = collectionName;
        this.indexName = indexName;
        this.vectorIndex = vectorIndex;
        this.scalarIndex = scalarIndex;
        this.stat = stat;
        this.vikingDBService = vikingDBService;
    }

    public void setCpuQuota(Integer cpuQuota) {
        this.cpuQuota = cpuQuota;
    }

    public void setCpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota.intValue();
    }

    public void setShardCount(Integer shardCount) {
        this.shardCount = shardCount;
    }

    public void setShardCount(Long shardCount) {
        this.shardCount = shardCount.intValue();
    }

    public void setShardPolicy(String shardPolicy) {
        this.shardPolicy = shardPolicy;
    }

    public String requestPrimaryKey() throws Exception {
        if (this.primaryKey != null) {
            return this.primaryKey;
        }
        Collection collection = this.vikingDBService.getCollection(this.collectionName);
        this.primaryKey = collection.getPrimaryKey();
        return this.primaryKey;
    }

    public List<DataObject> search(SearchParam searchParam) throws Exception {
        if (searchParam.getIsBuild() == 0) {
            VikingDBException vikingDBException = new VikingDBException(1000031, null, "Param dose not build");
            throw vikingDBException.getErrorCodeException(1000031, null, "Param dose not build");
        }
        List<DataObject> res = new ArrayList<DataObject>();
        if (searchParam.getVectorOrder() != null) {
            if (searchParam.getVectorOrder().getVector() != null) {
                SearchByVectorParam searchByVectorParam = new SearchByVectorParam().setFilter(searchParam.getFilter()).setLimit(searchParam.getLimit()).setOutputFields(searchParam.getOutputFields()).setPartition(searchParam.getPartition()).setVector(searchParam.getVectorOrder().getVector()).setDenseWeight(searchParam.getDenseWeight()).setSparseVectors(searchParam.getVectorOrder().getSparseVectors()).build();
                return this.searchByVector(searchByVectorParam);
            }
            if (searchParam.getVectorOrder().getId() != null) {
                SearchByIdParam searchByIdParam = new SearchByIdParam().setFilter(searchParam.getFilter()).setLimit(searchParam.getLimit()).setOutputFields(searchParam.getOutputFields()).setPartition(searchParam.getPartition()).setId(searchParam.getVectorOrder().getId()).setDenseWeight(searchParam.getDenseWeight()).build();
                res = this.searchById(searchByIdParam);
            }
        } else if (searchParam.getScalarOrder() != null) {
            HashMap<String, String> orderByScalar = new HashMap<String, String>();
            orderByScalar.put("order", searchParam.getScalarOrder().getOrder());
            orderByScalar.put("field_name", searchParam.getScalarOrder().getFieldName());
            HashMap<String, Object> search = new HashMap<String, Object>();
            search.put("order_by_scalar", orderByScalar);
            search.put("limit", searchParam.getLimit());
            search.put("partition", searchParam.getPartition());
            if (searchParam.getOutputFields() != null) {
                search.put("output_fields", searchParam.getOutputFields());
            }
            if (searchParam.getFilter() != null) {
                search.put("filter", searchParam.getFilter());
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("collection_name", this.collectionName);
            params.put("index_name", this.indexName);
            params.put("search", search);
            LinkedTreeMap<String, Object> resData = this.vikingDBService.doRequest("SearchIndex", null, params);
            res = this.getDatas(resData, searchParam.getOutputFields());
        } else {
            HashMap<String, Object> search = new HashMap<String, Object>();
            search.put("limit", searchParam.getLimit());
            search.put("partition", searchParam.getPartition());
            if (searchParam.getOutputFields() != null) {
                search.put("output_fields", searchParam.getOutputFields());
            }
            if (searchParam.getFilter() != null) {
                search.put("filter", searchParam.getFilter());
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("collection_name", this.collectionName);
            params.put("index_name", this.indexName);
            params.put("search", search);
            LinkedTreeMap<String, Object> resData = this.vikingDBService.doRequest("SearchIndex", null, params);
            res = this.getDatas(resData, searchParam.getOutputFields());
        }
        return res;
    }

    public List<DataObject> searchById(SearchByIdParam searchByIdParam) throws Exception {
        if (searchByIdParam.getIsBuild() == 0) {
            VikingDBException vikingDBException = new VikingDBException(1000031, null, "Param dose not build");
            throw vikingDBException.getErrorCodeException(1000031, null, "Param dose not build");
        }
        ArrayList<Object> idList = new ArrayList<Object>();
        idList.add(searchByIdParam.getId());
        HashMap<String, ArrayList<Object>> orderById = new HashMap<String, ArrayList<Object>>();
        orderById.put("primary_keys", idList);
        HashMap<String, Object> search = new HashMap<String, Object>();
        search.put("order_by_vector", orderById);
        search.put("limit", searchByIdParam.getLimit());
        search.put("partition", searchByIdParam.getPartition());
        if (searchByIdParam.getOutputFields() != null) {
            search.put("output_fields", searchByIdParam.getOutputFields());
        }
        if (searchByIdParam.getFilter() != null) {
            search.put("filter", searchByIdParam.getFilter());
        }
        if (searchByIdParam.getDenseWeight() != null) {
            search.put("dense_weight", searchByIdParam.getDenseWeight());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", this.collectionName);
        params.put("index_name", this.indexName);
        params.put("search", search);
        LinkedTreeMap<String, Object> resData = this.vikingDBService.doRequest("SearchIndex", null, params);
        return this.getDatas(resData, searchByIdParam.getOutputFields());
    }

    public List<DataObject> searchByVector(SearchByVectorParam searchByVectorParam) throws Exception {
        if (searchByVectorParam.getIsBuild() == 0) {
            VikingDBException vikingDBException = new VikingDBException(1000031, null, "Param dose not build");
            throw vikingDBException.getErrorCodeException(1000031, null, "Param dose not build");
        }
        ArrayList<List<Double>> vectorList = new ArrayList<List<Double>>();
        vectorList.add(searchByVectorParam.getVector());
        HashMap orderByVector = new HashMap();
        orderByVector.put("vectors", vectorList);
        if (searchByVectorParam.getSparseVectors() != null) {
            ArrayList<Map<String, Object>> sparseVectorList = new ArrayList<Map<String, Object>>();
            sparseVectorList.add(searchByVectorParam.getSparseVectors());
            orderByVector.put("sparse_vectors", sparseVectorList);
        }
        HashMap<String, Object> search = new HashMap<String, Object>();
        search.put("order_by_vector", orderByVector);
        search.put("limit", searchByVectorParam.getLimit());
        search.put("partition", searchByVectorParam.getPartition());
        if (searchByVectorParam.getOutputFields() != null) {
            search.put("output_fields", searchByVectorParam.getOutputFields());
        }
        if (searchByVectorParam.getFilter() != null) {
            search.put("filter", searchByVectorParam.getFilter());
        }
        if (searchByVectorParam.getDenseWeight() != null) {
            search.put("dense_weight", searchByVectorParam.getDenseWeight());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", this.collectionName);
        params.put("index_name", this.indexName);
        params.put("search", search);
        LinkedTreeMap<String, Object> resData = this.vikingDBService.doRequest("SearchIndex", null, params);
        return this.getDatas(resData, searchByVectorParam.getOutputFields());
    }

    public List<DataObject> searchByText(SearchByTextParam searchByTextParam) throws Exception {
        if (searchByTextParam.getIsBuild() == 0) {
            VikingDBException vikingDBException = new VikingDBException(1000031, null, "Param dose not build");
            throw vikingDBException.getErrorCodeException(1000031, null, "Param dose not build");
        }
        HashMap<String, String> orderByRaw = new HashMap<String, String>();
        orderByRaw.put("text", searchByTextParam.getText().getText());
        HashMap<String, Object> search = new HashMap<String, Object>();
        search.put("order_by_raw", orderByRaw);
        search.put("limit", searchByTextParam.getLimit());
        search.put("partition", searchByTextParam.getPartition());
        if (searchByTextParam.getOutputFields() != null) {
            search.put("output_fields", searchByTextParam.getOutputFields());
        }
        if (searchByTextParam.getFilter() != null) {
            search.put("filter", searchByTextParam.getFilter());
        }
        if (searchByTextParam.getDenseWeight() != null) {
            search.put("dense_weight", searchByTextParam.getDenseWeight());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", this.collectionName);
        params.put("index_name", this.indexName);
        params.put("search", search);
        LinkedTreeMap<String, Object> resData = this.vikingDBService.doRequest("SearchIndex", null, params);
        return this.getDatas(resData, searchByTextParam.getOutputFields());
    }

    public <T> DataObject fetchData(T id, FetchDataParam fetchDataParam) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", this.collectionName);
        params.put("index_name", this.indexName);
        params.put("primary_keys", id);
        params.put("partition", fetchDataParam.getPartition());
        if (fetchDataParam.getOutputFields() != null) {
            params.put("output_fields", fetchDataParam.getOutputFields());
        }
        LinkedTreeMap<String, Object> resData = this.vikingDBService.doRequest("FetchIndexData", null, params);
        ArrayList res = (ArrayList)resData.get((Object)"data");
        HashMap<String, Object> hashMap = this.vikingDBService.convertLinkedTreeMapToHashMap((LinkedTreeMap<String, Object>)((LinkedTreeMap)res.get(0)));
        LinkedTreeMap fieldsLinkedTreeMap = (LinkedTreeMap)hashMap.get("fields");
        HashMap<String, Object> fieldsHashMap = new HashMap();
        fieldsHashMap = fieldsLinkedTreeMap == null ? hashMap : this.vikingDBService.convertLinkedTreeMapToHashMap((LinkedTreeMap<String, Object>)fieldsLinkedTreeMap);
        DataObject dataObject = new DataObject().setFields(fieldsHashMap).setId(id);
        return dataObject;
    }

    public List<DataObject> fetchData(List<?> ids, FetchDataParam fetchDataParam) throws Exception {
        ArrayList<DataObject> dataObjects = new ArrayList<DataObject>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("collection_name", this.collectionName);
        params.put("index_name", this.indexName);
        params.put("primary_keys", ids);
        params.put("partition", fetchDataParam.getPartition());
        if (fetchDataParam.getOutputFields() != null) {
            params.put("output_fields", fetchDataParam.getOutputFields());
        }
        LinkedTreeMap<String, Object> resData = this.vikingDBService.doRequest("FetchIndexData", null, params);
        ArrayList res = (ArrayList)resData.get((Object)"data");
        for (LinkedTreeMap LinkedTreeMap2 : res) {
            LinkedTreeMap fieldsLinkedTreeMap = (LinkedTreeMap)LinkedTreeMap2.get((Object)"fields");
            HashMap<String, Object> fieldsHashMap = new HashMap();
            fieldsHashMap = fieldsLinkedTreeMap == null ? this.vikingDBService.convertLinkedTreeMapToHashMap((LinkedTreeMap<String, Object>)LinkedTreeMap2) : this.vikingDBService.convertLinkedTreeMapToHashMap((LinkedTreeMap<String, Object>)fieldsLinkedTreeMap);
            DataObject dataObject = new DataObject().setFields(fieldsHashMap).setId(LinkedTreeMap2.get((Object)this.requestPrimaryKey()));
            dataObjects.add(dataObject);
        }
        return dataObjects;
    }

    public List<DataObject> getDatas(LinkedTreeMap<String, Object> resData, List<String> outputFields) throws Exception {
        ArrayList res = (ArrayList)resData.get((Object)"data");
        ArrayList<DataObject> datas = new ArrayList<DataObject>();
        for (ArrayList linkedTreeMap : res) {
            for (LinkedTreeMap item : linkedTreeMap) {
                DataObject dataObject;
                Object id = null;
                id = item.get((Object)this.requestPrimaryKey()) instanceof String ? (String)item.get((Object)this.requestPrimaryKey()) : (Long)item.get((Object)this.requestPrimaryKey());
                HashMap<String, Object> fields = new HashMap();
                if (outputFields == null || outputFields.size() != 0) {
                    LinkedTreeMap map = (LinkedTreeMap)item.get((Object)"fields");
                    fields = this.vikingDBService.convertLinkedTreeMapToHashMap((LinkedTreeMap<String, Object>)map);
                }
                String text = null;
                if (item.containsKey((Object)"text")) {
                    text = (String)item.get((Object)"text");
                }
                if (item.get((Object)"score") instanceof Double) {
                    dataObject = new DataObject().setFields(fields).setId(id).setText(text).setScore((Double)item.get((Object)"score"));
                } else {
                    Long score = (Long)item.get((Object)"score");
                    dataObject = new DataObject().setFields(fields).setId(id).setText(text).setScore(score.doubleValue());
                }
                datas.add(dataObject);
            }
        }
        return datas;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getDescription() {
        return this.description;
    }

    public VectorIndexParams getVectorIndex() {
        return this.vectorIndex;
    }

    public List<String> getScalarIndex() {
        return this.scalarIndex;
    }

    public String getStat() {
        return this.stat;
    }

    public VikingDBService getVikingDBService() {
        return this.vikingDBService;
    }

    public Integer getCpuQuota() {
        return this.cpuQuota;
    }

    public Object getPartitionBy() {
        return this.partitionBy;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getUpdatePerson() {
        return this.updatePerson;
    }

    public Integer getShardCount() {
        return this.shardCount;
    }

    public String getShardPolicy() {
        return this.shardPolicy;
    }

    public HashMap<String, Object> getIndexCost() {
        return this.indexCost;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVectorIndex(VectorIndexParams vectorIndex) {
        this.vectorIndex = vectorIndex;
    }

    public void setScalarIndex(List<String> scalarIndex) {
        this.scalarIndex = scalarIndex;
    }

    public void setStat(String stat) {
        this.stat = stat;
    }

    public void setVikingDBService(VikingDBService vikingDBService) {
        this.vikingDBService = vikingDBService;
    }

    public void setPartitionBy(Object partitionBy) {
        this.partitionBy = partitionBy;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public void setIndexCost(HashMap<String, Object> indexCost) {
        this.indexCost = indexCost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Index)) {
            return false;
        }
        Index other = (Index)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$cpuQuota = this.getCpuQuota();
        Integer other$cpuQuota = other.getCpuQuota();
        if (this$cpuQuota == null ? other$cpuQuota != null : !((Object)this$cpuQuota).equals(other$cpuQuota)) {
            return false;
        }
        Integer this$shardCount = this.getShardCount();
        Integer other$shardCount = other.getShardCount();
        if (this$shardCount == null ? other$shardCount != null : !((Object)this$shardCount).equals(other$shardCount)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        VectorIndexParams this$vectorIndex = this.getVectorIndex();
        VectorIndexParams other$vectorIndex = other.getVectorIndex();
        if (this$vectorIndex == null ? other$vectorIndex != null : !((Object)this$vectorIndex).equals(other$vectorIndex)) {
            return false;
        }
        List<String> this$scalarIndex = this.getScalarIndex();
        List<String> other$scalarIndex = other.getScalarIndex();
        if (this$scalarIndex == null ? other$scalarIndex != null : !((Object)this$scalarIndex).equals(other$scalarIndex)) {
            return false;
        }
        String this$stat = this.getStat();
        String other$stat = other.getStat();
        if (this$stat == null ? other$stat != null : !this$stat.equals(other$stat)) {
            return false;
        }
        VikingDBService this$vikingDBService = this.getVikingDBService();
        VikingDBService other$vikingDBService = other.getVikingDBService();
        if (this$vikingDBService == null ? other$vikingDBService != null : !this$vikingDBService.equals(other$vikingDBService)) {
            return false;
        }
        Object this$partitionBy = this.getPartitionBy();
        Object other$partitionBy = other.getPartitionBy();
        if (this$partitionBy == null ? other$partitionBy != null : !this$partitionBy.equals(other$partitionBy)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        String this$updatePerson = this.getUpdatePerson();
        String other$updatePerson = other.getUpdatePerson();
        if (this$updatePerson == null ? other$updatePerson != null : !this$updatePerson.equals(other$updatePerson)) {
            return false;
        }
        String this$shardPolicy = this.getShardPolicy();
        String other$shardPolicy = other.getShardPolicy();
        if (this$shardPolicy == null ? other$shardPolicy != null : !this$shardPolicy.equals(other$shardPolicy)) {
            return false;
        }
        HashMap<String, Object> this$indexCost = this.getIndexCost();
        HashMap<String, Object> other$indexCost = other.getIndexCost();
        return !(this$indexCost == null ? other$indexCost != null : !((Object)this$indexCost).equals(other$indexCost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Index;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $cpuQuota = this.getCpuQuota();
        result = result * 59 + ($cpuQuota == null ? 43 : ((Object)$cpuQuota).hashCode());
        Integer $shardCount = this.getShardCount();
        result = result * 59 + ($shardCount == null ? 43 : ((Object)$shardCount).hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        VectorIndexParams $vectorIndex = this.getVectorIndex();
        result = result * 59 + ($vectorIndex == null ? 43 : ((Object)$vectorIndex).hashCode());
        List<String> $scalarIndex = this.getScalarIndex();
        result = result * 59 + ($scalarIndex == null ? 43 : ((Object)$scalarIndex).hashCode());
        String $stat = this.getStat();
        result = result * 59 + ($stat == null ? 43 : $stat.hashCode());
        VikingDBService $vikingDBService = this.getVikingDBService();
        result = result * 59 + ($vikingDBService == null ? 43 : $vikingDBService.hashCode());
        Object $partitionBy = this.getPartitionBy();
        result = result * 59 + ($partitionBy == null ? 43 : $partitionBy.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        String $updatePerson = this.getUpdatePerson();
        result = result * 59 + ($updatePerson == null ? 43 : $updatePerson.hashCode());
        String $shardPolicy = this.getShardPolicy();
        result = result * 59 + ($shardPolicy == null ? 43 : $shardPolicy.hashCode());
        HashMap<String, Object> $indexCost = this.getIndexCost();
        result = result * 59 + ($indexCost == null ? 43 : ((Object)$indexCost).hashCode());
        return result;
    }

    public String toString() {
        return "Index(collectionName=" + this.getCollectionName() + ", indexName=" + this.getIndexName() + ", description=" + this.getDescription() + ", vectorIndex=" + this.getVectorIndex() + ", scalarIndex=" + this.getScalarIndex() + ", stat=" + this.getStat() + ", vikingDBService=" + this.getVikingDBService() + ", cpuQuota=" + this.getCpuQuota() + ", partitionBy=" + this.getPartitionBy() + ", primaryKey=" + this.getPrimaryKey() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", updatePerson=" + this.getUpdatePerson() + ", shardCount=" + this.getShardCount() + ", shardPolicy=" + this.getShardPolicy() + ", indexCost=" + this.getIndexCost() + ")";
    }
}

