/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.cdn.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.helper.Utils;
import com.volcengine.model.ApiInfo;
import com.volcengine.model.beans.CDN;
import com.volcengine.model.response.RawResponse;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.cdn.CDNConfig;
import com.volcengine.service.cdn.CDNService;

public class CDNServiceImpl
extends BaseServiceImpl
implements CDNService {
    private CDNServiceImpl() {
        super(CDNConfig.serviceInfo, CDNConfig.apiInfoList);
    }

    public static CDNService getInstance() {
        return new CDNServiceImpl();
    }

    public static String useGet() {
        return "GET";
    }

    public static String usePost() {
        return "POST";
    }

    public RawResponse requestProxy(String api, Object body, String ... args) {
        RawResponse response;
        boolean isUseGet = false;
        if (args.length > 0) {
            String arg = args[0];
            if (CDNServiceImpl.useGet().equals(arg)) {
                isUseGet = true;
                ((ApiInfo)this.apiInfoList.get(api)).setMethod(CDNServiceImpl.useGet());
            }
        }
        if (isUseGet) {
            response = this.query(api, Utils.mapToPairList(Utils.paramsToMap(body)));
            ((ApiInfo)this.apiInfoList.get(api)).setMethod(CDNServiceImpl.usePost());
        } else {
            response = this.json(api, null, JSON.toJSONString((Object)body));
        }
        return response;
    }

    @Override
    public CDN.AddCdnDomainResponse addCdnDomain(CDN.AddCdnDomainRequest request) throws Exception {
        RawResponse response = this.requestProxy("AddCdnDomain", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.AddCdnDomainResponse)JSON.parseObject((byte[])response.getData(), CDN.AddCdnDomainResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.StartCdnDomainResponse startCdnDomain(CDN.StartCdnDomainRequest request) throws Exception {
        RawResponse response = this.requestProxy("StartCdnDomain", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.StartCdnDomainResponse)JSON.parseObject((byte[])response.getData(), CDN.StartCdnDomainResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.StopCdnDomainResponse stopCdnDomain(CDN.StopCdnDomainRequest request) throws Exception {
        RawResponse response = this.requestProxy("StopCdnDomain", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.StopCdnDomainResponse)JSON.parseObject((byte[])response.getData(), CDN.StopCdnDomainResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DeleteCdnDomainResponse deleteCdnDomain(CDN.DeleteCdnDomainRequest request) throws Exception {
        RawResponse response = this.requestProxy("DeleteCdnDomain", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DeleteCdnDomainResponse)JSON.parseObject((byte[])response.getData(), CDN.DeleteCdnDomainResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.ListCdnDomainsResponse listCdnDomains(CDN.ListCdnDomainsRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("ListCdnDomains", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.ListCdnDomainsResponse)JSON.parseObject((byte[])response.getData(), CDN.ListCdnDomainsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeCdnConfigResponse describeCdnConfig(CDN.DescribeCdnConfigRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeCdnConfig", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeCdnConfigResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeCdnConfigResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.UpdateCdnConfigResponse updateCdnConfig(CDN.UpdateCdnConfigRequest request) throws Exception {
        RawResponse response = this.requestProxy("UpdateCdnConfig", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.UpdateCdnConfigResponse)JSON.parseObject((byte[])response.getData(), CDN.UpdateCdnConfigResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeCdnDataResponse describeCdnData(CDN.DescribeCdnDataRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeCdnData", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeCdnDataResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeCdnDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeEdgeNrtDataSummaryResponse describeEdgeNrtDataSummary(CDN.DescribeEdgeNrtDataSummaryRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeEdgeNrtDataSummary", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeEdgeNrtDataSummaryResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeEdgeNrtDataSummaryResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeCdnOriginDataResponse describeCdnOriginData(CDN.DescribeCdnOriginDataRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeCdnOriginData", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeCdnOriginDataResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeCdnOriginDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeOriginNrtDataSummaryResponse describeOriginNrtDataSummary(CDN.DescribeOriginNrtDataSummaryRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeOriginNrtDataSummary", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeOriginNrtDataSummaryResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeOriginNrtDataSummaryResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeCdnDataDetailResponse describeCdnDataDetail(CDN.DescribeCdnDataDetailRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeCdnDataDetail", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeCdnDataDetailResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeCdnDataDetailResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeDistrictIspDataResponse describeDistrictIspData(CDN.DescribeDistrictIspDataRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeDistrictIspData", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeDistrictIspDataResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeDistrictIspDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeEdgeStatisticalDataResponse describeEdgeStatisticalData(CDN.DescribeEdgeStatisticalDataRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeEdgeStatisticalData", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeEdgeStatisticalDataResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeEdgeStatisticalDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeEdgeTopNrtDataResponse describeEdgeTopNrtData(CDN.DescribeEdgeTopNrtDataRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeEdgeTopNrtData", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeEdgeTopNrtDataResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeEdgeTopNrtDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeOriginTopNrtDataResponse describeOriginTopNrtData(CDN.DescribeOriginTopNrtDataRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeOriginTopNrtData", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeOriginTopNrtDataResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeOriginTopNrtDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeEdgeTopStatusCodeResponse describeEdgeTopStatusCode(CDN.DescribeEdgeTopStatusCodeRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeEdgeTopStatusCode", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeEdgeTopStatusCodeResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeEdgeTopStatusCodeResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeOriginTopStatusCodeResponse describeOriginTopStatusCode(CDN.DescribeOriginTopStatusCodeRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeOriginTopStatusCode", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeOriginTopStatusCodeResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeOriginTopStatusCodeResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeEdgeTopStatisticalDataResponse describeEdgeTopStatisticalData(CDN.DescribeEdgeTopStatisticalDataRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeEdgeTopStatisticalData", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeEdgeTopStatisticalDataResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeEdgeTopStatisticalDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeCdnRegionAndIspResponse describeCdnRegionAndIsp(CDN.DescribeCdnRegionAndIspRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeCdnRegionAndIsp", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeCdnRegionAndIspResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeCdnRegionAndIspResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeCdnServiceResponse describeCdnService() throws Exception {
        RawResponse response = this.requestProxy("DescribeCdnService", new Object(), new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeCdnServiceResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeCdnServiceResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeAccountingDataResponse describeAccountingData(CDN.DescribeAccountingDataRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeAccountingData", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeAccountingDataResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeAccountingDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.SubmitRefreshTaskResponse submitRefreshTask(CDN.SubmitRefreshTaskRequest request) throws Exception {
        RawResponse response = this.requestProxy("SubmitRefreshTask", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.SubmitRefreshTaskResponse)JSON.parseObject((byte[])response.getData(), CDN.SubmitRefreshTaskResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.SubmitPreloadTaskResponse submitPreloadTask(CDN.SubmitPreloadTaskRequest request) throws Exception {
        RawResponse response = this.requestProxy("SubmitPreloadTask", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.SubmitPreloadTaskResponse)JSON.parseObject((byte[])response.getData(), CDN.SubmitPreloadTaskResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeContentTasksResponse describeContentTasks(CDN.DescribeContentTasksRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeContentTasks", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeContentTasksResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeContentTasksResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeContentQuotaResponse describeContentQuota(String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeContentQuota", new Object(), args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeContentQuotaResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeContentQuotaResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.SubmitBlockTaskResponse submitBlockTask(CDN.SubmitBlockTaskRequest request) throws Exception {
        RawResponse response = this.requestProxy("SubmitBlockTask", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.SubmitBlockTaskResponse)JSON.parseObject((byte[])response.getData(), CDN.SubmitBlockTaskResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.SubmitUnblockTaskResponse submitUnblockTask(CDN.SubmitUnblockTaskRequest request) throws Exception {
        RawResponse response = this.requestProxy("SubmitUnblockTask", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.SubmitUnblockTaskResponse)JSON.parseObject((byte[])response.getData(), CDN.SubmitUnblockTaskResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeContentBlockTasksResponse describeContentBlockTasks(CDN.DescribeContentBlockTasksRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeContentBlockTasks", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeContentBlockTasksResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeContentBlockTasksResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeCdnAccessLogResponse describeCdnAccessLog(CDN.DescribeCdnAccessLogRequest request, String ... args) throws Exception {
        RawResponse response = this.requestProxy("DescribeCdnAccessLog", request, args);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeCdnAccessLogResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeCdnAccessLogResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeIPInfoResponse describeIPInfo(CDN.DescribeIPInfoRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeIPInfo", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeIPInfoResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeIPInfoResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeIPListInfoResponse describeIPListInfo(CDN.DescribeIPListInfoRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeIPListInfo", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeIPListInfoResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeIPListInfoResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeCdnUpperIpResponse describeCdnUpperIp(CDN.DescribeCdnUpperIpRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeCdnUpperIp", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeCdnUpperIpResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeCdnUpperIpResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.AddResourceTagsResponse addResourceTags(CDN.AddResourceTagsRequest request) throws Exception {
        RawResponse response = this.requestProxy("AddResourceTags", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.AddResourceTagsResponse)JSON.parseObject((byte[])response.getData(), CDN.AddResourceTagsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.UpdateResourceTagsResponse updateResourceTags(CDN.UpdateResourceTagsRequest request) throws Exception {
        RawResponse response = this.requestProxy("UpdateResourceTags", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.UpdateResourceTagsResponse)JSON.parseObject((byte[])response.getData(), CDN.UpdateResourceTagsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.ListResourceTagsResponse listResourceTags() throws Exception {
        RawResponse response = this.requestProxy("ListResourceTags", new Object(), new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.ListResourceTagsResponse)JSON.parseObject((byte[])response.getData(), CDN.ListResourceTagsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DeleteResourceTagsResponse deleteResourceTags(CDN.DeleteResourceTagsRequest request) throws Exception {
        RawResponse response = this.requestProxy("DeleteResourceTags", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DeleteResourceTagsResponse)JSON.parseObject((byte[])response.getData(), CDN.DeleteResourceTagsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.AddCdnCertificateResponse addCdnCertificate(CDN.AddCdnCertificateRequest request) throws Exception {
        RawResponse response = this.requestProxy("AddCdnCertificate", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.AddCdnCertificateResponse)JSON.parseObject((byte[])response.getData(), CDN.AddCdnCertificateResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.ListCertInfoResponse listCertInfo(CDN.ListCertInfoRequest request) throws Exception {
        RawResponse response = this.requestProxy("ListCertInfo", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.ListCertInfoResponse)JSON.parseObject((byte[])response.getData(), CDN.ListCertInfoResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.ListCdnCertInfoResponse listCdnCertInfo(CDN.ListCdnCertInfoRequest request) throws Exception {
        RawResponse response = this.requestProxy("ListCdnCertInfo", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.ListCdnCertInfoResponse)JSON.parseObject((byte[])response.getData(), CDN.ListCdnCertInfoResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeCertConfigResponse describeCertConfig(CDN.DescribeCertConfigRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeCertConfig", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeCertConfigResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeCertConfigResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.BatchDeployCertResponse batchDeployCert(CDN.BatchDeployCertRequest request) throws Exception {
        RawResponse response = this.requestProxy("BatchDeployCert", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.BatchDeployCertResponse)JSON.parseObject((byte[])response.getData(), CDN.BatchDeployCertResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DeleteCdnCertificateResponse deleteCdnCertificate(CDN.DeleteCdnCertificateRequest request) throws Exception {
        RawResponse response = this.requestProxy("DeleteCdnCertificate", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DeleteCdnCertificateResponse)JSON.parseObject((byte[])response.getData(), CDN.DeleteCdnCertificateResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeAccountingSummaryResponse describeAccountingSummary(CDN.DescribeAccountingSummaryRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeAccountingSummary", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeAccountingSummaryResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeAccountingSummaryResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeDistrictDataResponse describeDistrictData(CDN.DescribeDistrictDataRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeDistrictData", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeDistrictDataResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeDistrictDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeEdgeDataResponse describeEdgeData(CDN.DescribeEdgeDataRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeEdgeData", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeEdgeDataResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeEdgeDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeDistrictSummaryResponse describeDistrictSummary(CDN.DescribeDistrictSummaryRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeDistrictSummary", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeDistrictSummaryResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeDistrictSummaryResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeEdgeSummaryResponse describeEdgeSummary(CDN.DescribeEdgeSummaryRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeEdgeSummary", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeEdgeSummaryResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeEdgeSummaryResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeOriginDataResponse describeOriginData(CDN.DescribeOriginDataRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeOriginData", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeOriginDataResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeOriginDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeOriginSummaryResponse describeOriginSummary(CDN.DescribeOriginSummaryRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeOriginSummary", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeOriginSummaryResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeOriginSummaryResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeUserDataResponse describeUserData(CDN.DescribeUserDataRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeUserData", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeUserDataResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeUserDataResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeDistrictRankingResponse describeDistrictRanking(CDN.DescribeDistrictRankingRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeDistrictRanking", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeDistrictRankingResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeDistrictRankingResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeEdgeRankingResponse describeEdgeRanking(CDN.DescribeEdgeRankingRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeEdgeRanking", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeEdgeRankingResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeEdgeRankingResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeOriginRankingResponse describeOriginRanking(CDN.DescribeOriginRankingRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeOriginRanking", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeOriginRankingResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeOriginRankingResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeEdgeStatusCodeRankingResponse describeEdgeStatusCodeRanking(CDN.DescribeEdgeStatusCodeRankingRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeEdgeStatusCodeRanking", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeEdgeStatusCodeRankingResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeEdgeStatusCodeRankingResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeOriginStatusCodeRankingResponse describeOriginStatusCodeRanking(CDN.DescribeOriginStatusCodeRankingRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeOriginStatusCodeRanking", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeOriginStatusCodeRankingResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeOriginStatusCodeRankingResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeStatisticalRankingResponse describeStatisticalRanking(CDN.DescribeStatisticalRankingRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeStatisticalRanking", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeStatisticalRankingResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeStatisticalRankingResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.BatchUpdateCdnConfigResponse batchUpdateCdnConfig(CDN.BatchUpdateCdnConfigRequest request) throws Exception {
        RawResponse response = this.requestProxy("BatchUpdateCdnConfig", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.BatchUpdateCdnConfigResponse)JSON.parseObject((byte[])response.getData(), CDN.BatchUpdateCdnConfigResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.AddCertificateResponse addCertificate(CDN.AddCertificateRequest request) throws Exception {
        RawResponse response = this.requestProxy("AddCertificate", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.AddCertificateResponse)JSON.parseObject((byte[])response.getData(), CDN.AddCertificateResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DeleteUsageReportResponse deleteUsageReport(CDN.DeleteUsageReportRequest request) throws Exception {
        RawResponse response = this.requestProxy("DeleteUsageReport", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DeleteUsageReportResponse)JSON.parseObject((byte[])response.getData(), CDN.DeleteUsageReportResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.CreateUsageReportResponse createUsageReport(CDN.CreateUsageReportRequest request) throws Exception {
        RawResponse response = this.requestProxy("CreateUsageReport", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.CreateUsageReportResponse)JSON.parseObject((byte[])response.getData(), CDN.CreateUsageReportResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.ListUsageReportsResponse listUsageReports(CDN.ListUsageReportsRequest request) throws Exception {
        RawResponse response = this.requestProxy("ListUsageReports", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.ListUsageReportsResponse)JSON.parseObject((byte[])response.getData(), CDN.ListUsageReportsResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DescribeSharedConfigResponse describeSharedConfig(CDN.DescribeSharedConfigRequest request) throws Exception {
        RawResponse response = this.requestProxy("DescribeSharedConfig", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DescribeSharedConfigResponse)JSON.parseObject((byte[])response.getData(), CDN.DescribeSharedConfigResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.ListSharedConfigResponse listSharedConfig(CDN.ListSharedConfigRequest request) throws Exception {
        RawResponse response = this.requestProxy("ListSharedConfig", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.ListSharedConfigResponse)JSON.parseObject((byte[])response.getData(), CDN.ListSharedConfigResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.DeleteSharedConfigResponse deleteSharedConfig(CDN.DeleteSharedConfigRequest request) throws Exception {
        RawResponse response = this.requestProxy("DeleteSharedConfig", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.DeleteSharedConfigResponse)JSON.parseObject((byte[])response.getData(), CDN.DeleteSharedConfigResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.UpdateSharedConfigResponse updateSharedConfig(CDN.UpdateSharedConfigRequest request) throws Exception {
        RawResponse response = this.requestProxy("UpdateSharedConfig", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.UpdateSharedConfigResponse)JSON.parseObject((byte[])response.getData(), CDN.UpdateSharedConfigResponse.class, (Feature[])new Feature[0]);
    }

    @Override
    public CDN.AddSharedConfigResponse addSharedConfig(CDN.AddSharedConfigRequest request) throws Exception {
        RawResponse response = this.requestProxy("AddSharedConfig", request, new String[0]);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        return (CDN.AddSharedConfigResponse)JSON.parseObject((byte[])response.getData(), CDN.AddSharedConfigResponse.class, (Feature[])new Feature[0]);
    }
}

