/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.vod.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicates;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.volcengine.error.SdkError;
import com.volcengine.helper.IVodUploadStrategy;
import com.volcengine.helper.Utils;
import com.volcengine.helper.VodUploadProgressEventType;
import com.volcengine.helper.VodUploadProgressListener;
import com.volcengine.helper.VodUploadProgressListenerHelper;
import com.volcengine.model.Credentials;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.beans.Functions;
import com.volcengine.model.beans.PartInputStream;
import com.volcengine.model.beans.UploadCompleteInfo;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.sts2.Policy;
import com.volcengine.model.sts2.SecurityToken2;
import com.volcengine.model.sts2.Statement;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.vod.IVodService;
import com.volcengine.service.vod.UploadException;
import com.volcengine.service.vod.VodServiceConfig;
import com.volcengine.service.vod.model.business.CandidateUploadAddresses;
import com.volcengine.service.vod.model.business.PartUploadInfo;
import com.volcengine.service.vod.model.business.UploadAddress;
import com.volcengine.service.vod.model.business.VodApplyUploadInfoResult;
import com.volcengine.service.vod.model.business.VodHeaderPair;
import com.volcengine.service.vod.model.business.VodUploadAddress;
import com.volcengine.service.vod.model.business.VpcTosUploadAddress;
import com.volcengine.service.vod.model.request.AddOrUpdateCertificateV2Request;
import com.volcengine.service.vod.model.request.DescribeVodEnhanceImageDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodMostPlayedStatisDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodPlayedStatisDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodRealtimeMediaDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodRealtimeMediaDetailDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodSnapshotDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodSpaceAIStatisDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodSpaceDetectStatisDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodSpaceEditDetailDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodSpaceEditStatisDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodSpaceSubtitleStatisDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodSpaceTranscodeDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodSpaceWorkflowDetailDataRequest;
import com.volcengine.service.vod.model.request.DescribeVodVidTrafficFileLogRequest;
import com.volcengine.service.vod.model.request.GetCallbackRecordRequest;
import com.volcengine.service.vod.model.request.VodAddCallbackSubscriptionRequest;
import com.volcengine.service.vod.model.request.VodAddDomainToSchedulerRequest;
import com.volcengine.service.vod.model.request.VodApplyUploadInfoRequest;
import com.volcengine.service.vod.model.request.VodCancelDirectEditTaskRequest;
import com.volcengine.service.vod.model.request.VodCommitUploadInfoRequest;
import com.volcengine.service.vod.model.request.VodCreateCdnPreloadTaskRequest;
import com.volcengine.service.vod.model.request.VodCreateCdnRefreshTaskRequest;
import com.volcengine.service.vod.model.request.VodCreateDomainV2Request;
import com.volcengine.service.vod.model.request.VodCreateSpaceRequest;
import com.volcengine.service.vod.model.request.VodCreateTaskTemplateRequest;
import com.volcengine.service.vod.model.request.VodCreateVideoClassificationRequest;
import com.volcengine.service.vod.model.request.VodCreateWatermarkRequest;
import com.volcengine.service.vod.model.request.VodCreateWorkflowTemplateRequest;
import com.volcengine.service.vod.model.request.VodDeleteDomainRequest;
import com.volcengine.service.vod.model.request.VodDeleteMaterialRequest;
import com.volcengine.service.vod.model.request.VodDeleteMediaRequest;
import com.volcengine.service.vod.model.request.VodDeleteMediaTosFileRequest;
import com.volcengine.service.vod.model.request.VodDeleteSpaceRequest;
import com.volcengine.service.vod.model.request.VodDeleteTaskTemplateRequest;
import com.volcengine.service.vod.model.request.VodDeleteTranscodesRequest;
import com.volcengine.service.vod.model.request.VodDeleteVideoClassificationRequest;
import com.volcengine.service.vod.model.request.VodDeleteWatermarkRequest;
import com.volcengine.service.vod.model.request.VodDeleteWorkflowTemplateRequest;
import com.volcengine.service.vod.model.request.VodDescribeDomainConfigRequest;
import com.volcengine.service.vod.model.request.VodDescribeIPInfoRequest;
import com.volcengine.service.vod.model.request.VodDescribeVodDomainBandwidthDataRequest;
import com.volcengine.service.vod.model.request.VodDescribeVodDomainTrafficDataRequest;
import com.volcengine.service.vod.model.request.VodDescribeVodSpaceStorageDataRequest;
import com.volcengine.service.vod.model.request.VodExtractMediaMetaTaskRequest;
import com.volcengine.service.vod.model.request.VodGetAllPlayInfoRequest;
import com.volcengine.service.vod.model.request.VodGetAppInfoRequest;
import com.volcengine.service.vod.model.request.VodGetAudioEventDetectionForAuditRequest;
import com.volcengine.service.vod.model.request.VodGetAudioInfoForAuditRequest;
import com.volcengine.service.vod.model.request.VodGetAuditFramesForAuditRequest;
import com.volcengine.service.vod.model.request.VodGetAutomaticSpeechRecognitionForAuditRequest;
import com.volcengine.service.vod.model.request.VodGetBetterFramesForAuditRequest;
import com.volcengine.service.vod.model.request.VodGetCloudMigrateJobRequest;
import com.volcengine.service.vod.model.request.VodGetContentBlockTasksRequest;
import com.volcengine.service.vod.model.request.VodGetDirectEditProgressRequest;
import com.volcengine.service.vod.model.request.VodGetDirectEditResultRequest;
import com.volcengine.service.vod.model.request.VodGetFileInfosRequest;
import com.volcengine.service.vod.model.request.VodGetHlsDecryptionKeyRequest;
import com.volcengine.service.vod.model.request.VodGetMLFramesForAuditRequest;
import com.volcengine.service.vod.model.request.VodGetMediaInfosRequest;
import com.volcengine.service.vod.model.request.VodGetMediaListRequest;
import com.volcengine.service.vod.model.request.VodGetPlayInfoRequest;
import com.volcengine.service.vod.model.request.VodGetPlayInfoWithLiveTimeShiftSceneRequest;
import com.volcengine.service.vod.model.request.VodGetPrivateDrmPlayAuthRequest;
import com.volcengine.service.vod.model.request.VodGetRecommendedPosterRequest;
import com.volcengine.service.vod.model.request.VodGetSmartStrategyLitePlayInfoRequest;
import com.volcengine.service.vod.model.request.VodGetSpaceDetailRequest;
import com.volcengine.service.vod.model.request.VodGetSubtitleInfoListRequest;
import com.volcengine.service.vod.model.request.VodGetTaskTemplateRequest;
import com.volcengine.service.vod.model.request.VodGetWatermarkRequest;
import com.volcengine.service.vod.model.request.VodGetWorkflowExecutionStatusRequest;
import com.volcengine.service.vod.model.request.VodGetWorkflowResultRequest;
import com.volcengine.service.vod.model.request.VodGetWorkflowTemplateRequest;
import com.volcengine.service.vod.model.request.VodListBlockObjectTasksRequest;
import com.volcengine.service.vod.model.request.VodListCdnAccessLogRequest;
import com.volcengine.service.vod.model.request.VodListCdnPvDataRequest;
import com.volcengine.service.vod.model.request.VodListCdnStatusDataRequest;
import com.volcengine.service.vod.model.request.VodListCdnTasksRequest;
import com.volcengine.service.vod.model.request.VodListCdnTopAccessRequest;
import com.volcengine.service.vod.model.request.VodListCdnTopAccessUrlRequest;
import com.volcengine.service.vod.model.request.VodListCdnUsageDataRequest;
import com.volcengine.service.vod.model.request.VodListDomainRequest;
import com.volcengine.service.vod.model.request.VodListFileMetaInfosByFileNamesRequest;
import com.volcengine.service.vod.model.request.VodListSnapshotsRequest;
import com.volcengine.service.vod.model.request.VodListSpaceRequest;
import com.volcengine.service.vod.model.request.VodListTaskTemplateRequest;
import com.volcengine.service.vod.model.request.VodListVideoClassificationsRequest;
import com.volcengine.service.vod.model.request.VodListWatermarkRequest;
import com.volcengine.service.vod.model.request.VodListWorkflowTemplateRequest;
import com.volcengine.service.vod.model.request.VodQueryUploadTaskInfoRequest;
import com.volcengine.service.vod.model.request.VodRemoveDomainFromSchedulerRequest;
import com.volcengine.service.vod.model.request.VodRetrieveTranscodeResultRequest;
import com.volcengine.service.vod.model.request.VodSetCallbackEventRequest;
import com.volcengine.service.vod.model.request.VodSetCloudMigrateJobRequest;
import com.volcengine.service.vod.model.request.VodStartDomainRequest;
import com.volcengine.service.vod.model.request.VodStartWorkflowRequest;
import com.volcengine.service.vod.model.request.VodStopDomainRequest;
import com.volcengine.service.vod.model.request.VodSubmitBlockObjectTasksRequest;
import com.volcengine.service.vod.model.request.VodSubmitBlockTasksRequest;
import com.volcengine.service.vod.model.request.VodSubmitCloudMigrateJobRequest;
import com.volcengine.service.vod.model.request.VodSubmitDirectEditTaskAsyncRequest;
import com.volcengine.service.vod.model.request.VodSubmitDirectEditTaskSyncRequest;
import com.volcengine.service.vod.model.request.VodUpdateDomainAuthConfigV2Request;
import com.volcengine.service.vod.model.request.VodUpdateDomainConfigRequest;
import com.volcengine.service.vod.model.request.VodUpdateDomainExpireV2Request;
import com.volcengine.service.vod.model.request.VodUpdateDomainPlayRuleRequest;
import com.volcengine.service.vod.model.request.VodUpdateDomainUrlAuthConfigV2Request;
import com.volcengine.service.vod.model.request.VodUpdateFileStorageClassRequest;
import com.volcengine.service.vod.model.request.VodUpdateMediaInfoRequest;
import com.volcengine.service.vod.model.request.VodUpdateMediaPublishStatusRequest;
import com.volcengine.service.vod.model.request.VodUpdateMediaStorageClassRequest;
import com.volcengine.service.vod.model.request.VodUpdateSpaceRequest;
import com.volcengine.service.vod.model.request.VodUpdateSpaceUploadConfigRequest;
import com.volcengine.service.vod.model.request.VodUpdateSubtitleInfoRequest;
import com.volcengine.service.vod.model.request.VodUpdateSubtitleStatusRequest;
import com.volcengine.service.vod.model.request.VodUpdateTaskTemplateRequest;
import com.volcengine.service.vod.model.request.VodUpdateVideoClassificationRequest;
import com.volcengine.service.vod.model.request.VodUpdateWatermarkRequest;
import com.volcengine.service.vod.model.request.VodUpdateWorkflowTemplateRequest;
import com.volcengine.service.vod.model.request.VodUploadMaterialRequest;
import com.volcengine.service.vod.model.request.VodUploadMediaRequest;
import com.volcengine.service.vod.model.request.VodUrlUploadRequest;
import com.volcengine.service.vod.model.response.AddOrUpdateCertificateV2Response;
import com.volcengine.service.vod.model.response.DescribeVodEnhanceImageDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodMostPlayedStatisDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodPlayedStatisDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodRealtimeMediaDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodRealtimeMediaDetailDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodSnapshotDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodSpaceAIStatisDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodSpaceDetectStatisDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodSpaceEditDetailDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodSpaceEditStatisDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodSpaceSubtitleStatisDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodSpaceTranscodeDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodSpaceWorkflowDetailDataResponse;
import com.volcengine.service.vod.model.response.DescribeVodVidTrafficFileLogResponse;
import com.volcengine.service.vod.model.response.GetCallbackRecordResponse;
import com.volcengine.service.vod.model.response.VodAddCallbackSubscriptionResponse;
import com.volcengine.service.vod.model.response.VodAddDomainToSchedulerResponse;
import com.volcengine.service.vod.model.response.VodApplyUploadInfoResponse;
import com.volcengine.service.vod.model.response.VodCancelDirectEditTaskResponse;
import com.volcengine.service.vod.model.response.VodCdnStatisticsCommonResponse;
import com.volcengine.service.vod.model.response.VodCommitUploadInfoResponse;
import com.volcengine.service.vod.model.response.VodCreateCdnPreloadTaskResponse;
import com.volcengine.service.vod.model.response.VodCreateCdnRefreshTaskResponse;
import com.volcengine.service.vod.model.response.VodCreateDomainV2Response;
import com.volcengine.service.vod.model.response.VodCreateSpaceResponse;
import com.volcengine.service.vod.model.response.VodCreateTaskTemplateResponse;
import com.volcengine.service.vod.model.response.VodCreateVideoClassificationResponse;
import com.volcengine.service.vod.model.response.VodCreateWatermarkResponse;
import com.volcengine.service.vod.model.response.VodCreateWorkflowTemplateResponse;
import com.volcengine.service.vod.model.response.VodDeleteDomainResponse;
import com.volcengine.service.vod.model.response.VodDeleteMaterialResponse;
import com.volcengine.service.vod.model.response.VodDeleteMediaResponse;
import com.volcengine.service.vod.model.response.VodDeleteMediaTosFileResponse;
import com.volcengine.service.vod.model.response.VodDeleteSpaceResponse;
import com.volcengine.service.vod.model.response.VodDeleteTaskTemplateResponse;
import com.volcengine.service.vod.model.response.VodDeleteTranscodesResponse;
import com.volcengine.service.vod.model.response.VodDeleteVideoClassificationResponse;
import com.volcengine.service.vod.model.response.VodDeleteWatermarkResponse;
import com.volcengine.service.vod.model.response.VodDeleteWorkflowTemplateResponse;
import com.volcengine.service.vod.model.response.VodDescribeDomainConfigResponse;
import com.volcengine.service.vod.model.response.VodDescribeIPInfoResponse;
import com.volcengine.service.vod.model.response.VodDescribeVodDomainBandwidthDataResponse;
import com.volcengine.service.vod.model.response.VodDescribeVodDomainTrafficDataResponse;
import com.volcengine.service.vod.model.response.VodDescribeVodSpaceStorageDataResponse;
import com.volcengine.service.vod.model.response.VodExtractMediaMetaTaskResponse;
import com.volcengine.service.vod.model.response.VodGetAllPlayInfoResponse;
import com.volcengine.service.vod.model.response.VodGetAppInfoResponse;
import com.volcengine.service.vod.model.response.VodGetAudioEventDetectionForAuditResponse;
import com.volcengine.service.vod.model.response.VodGetAudioInfoForAuditResponse;
import com.volcengine.service.vod.model.response.VodGetAuditFramesForAuditResponse;
import com.volcengine.service.vod.model.response.VodGetAutomaticSpeechRecognitionForAuditResponse;
import com.volcengine.service.vod.model.response.VodGetBetterFramesForAuditResponse;
import com.volcengine.service.vod.model.response.VodGetCloudMigrateJobResponse;
import com.volcengine.service.vod.model.response.VodGetContentBlockTasksResponse;
import com.volcengine.service.vod.model.response.VodGetDirectEditProgressResponse;
import com.volcengine.service.vod.model.response.VodGetDirectEditResultResponse;
import com.volcengine.service.vod.model.response.VodGetFileInfosResponse;
import com.volcengine.service.vod.model.response.VodGetHlsDecryptionKeyResponse;
import com.volcengine.service.vod.model.response.VodGetMLFramesForAuditResponse;
import com.volcengine.service.vod.model.response.VodGetMediaInfosResponse;
import com.volcengine.service.vod.model.response.VodGetMediaListResponse;
import com.volcengine.service.vod.model.response.VodGetPlayInfoResponse;
import com.volcengine.service.vod.model.response.VodGetPlayInfoWithLiveTimeShiftSceneResponse;
import com.volcengine.service.vod.model.response.VodGetPrivateDrmPlayAuthResponse;
import com.volcengine.service.vod.model.response.VodGetRecommendedPosterResponse;
import com.volcengine.service.vod.model.response.VodGetSmartStrategyLitePlayInfoResponse;
import com.volcengine.service.vod.model.response.VodGetSpaceDetailResponse;
import com.volcengine.service.vod.model.response.VodGetSubtitleInfoListResponse;
import com.volcengine.service.vod.model.response.VodGetTaskTemplateResponse;
import com.volcengine.service.vod.model.response.VodGetWatermarkResponse;
import com.volcengine.service.vod.model.response.VodGetWorkflowExecutionStatusResponse;
import com.volcengine.service.vod.model.response.VodGetWorkflowResultResponse;
import com.volcengine.service.vod.model.response.VodGetWorkflowTemplateResponse;
import com.volcengine.service.vod.model.response.VodListBlockObjectTasksResponse;
import com.volcengine.service.vod.model.response.VodListCdnAccessLogResponse;
import com.volcengine.service.vod.model.response.VodListCdnTasksResponse;
import com.volcengine.service.vod.model.response.VodListCdnTopAccessResponse;
import com.volcengine.service.vod.model.response.VodListCdnTopAccessUrlResponse;
import com.volcengine.service.vod.model.response.VodListDomainResponse;
import com.volcengine.service.vod.model.response.VodListFileMetaInfosByFileNamesResponse;
import com.volcengine.service.vod.model.response.VodListSnapshotsResponse;
import com.volcengine.service.vod.model.response.VodListSpaceResponse;
import com.volcengine.service.vod.model.response.VodListTaskTemplateResponse;
import com.volcengine.service.vod.model.response.VodListVideoClassificationsResponse;
import com.volcengine.service.vod.model.response.VodListWatermarkResponse;
import com.volcengine.service.vod.model.response.VodListWorkflowTemplateResponse;
import com.volcengine.service.vod.model.response.VodQueryUploadTaskInfoResponse;
import com.volcengine.service.vod.model.response.VodRemoveDomainFromSchedulerResponse;
import com.volcengine.service.vod.model.response.VodRetrieveTranscodeResultResponse;
import com.volcengine.service.vod.model.response.VodSetCallbackEventResponse;
import com.volcengine.service.vod.model.response.VodSetCloudMigrateJobResponse;
import com.volcengine.service.vod.model.response.VodStartDomainResponse;
import com.volcengine.service.vod.model.response.VodStartWorkflowResponse;
import com.volcengine.service.vod.model.response.VodStopDomainResponse;
import com.volcengine.service.vod.model.response.VodSubmitBlockObjectTasksResponse;
import com.volcengine.service.vod.model.response.VodSubmitBlockTasksResponse;
import com.volcengine.service.vod.model.response.VodSubmitCloudMigrateJobResponse;
import com.volcengine.service.vod.model.response.VodSubmitDirectEditTaskAsyncResponse;
import com.volcengine.service.vod.model.response.VodSubmitDirectEditTaskSyncResponse;
import com.volcengine.service.vod.model.response.VodUpdateDomainAuthConfigV2Response;
import com.volcengine.service.vod.model.response.VodUpdateDomainConfigResponse;
import com.volcengine.service.vod.model.response.VodUpdateDomainExpireV2Response;
import com.volcengine.service.vod.model.response.VodUpdateDomainPlayRuleResponse;
import com.volcengine.service.vod.model.response.VodUpdateDomainUrlAuthConfigV2Response;
import com.volcengine.service.vod.model.response.VodUpdateFileStorageClassResponse;
import com.volcengine.service.vod.model.response.VodUpdateMediaInfoResponse;
import com.volcengine.service.vod.model.response.VodUpdateMediaPublishStatusResponse;
import com.volcengine.service.vod.model.response.VodUpdateMediaStorageClassResponse;
import com.volcengine.service.vod.model.response.VodUpdateSpaceResponse;
import com.volcengine.service.vod.model.response.VodUpdateSpaceUploadConfigResponse;
import com.volcengine.service.vod.model.response.VodUpdateSubtitleInfoResponse;
import com.volcengine.service.vod.model.response.VodUpdateSubtitleStatusResponse;
import com.volcengine.service.vod.model.response.VodUpdateTaskTemplateResponse;
import com.volcengine.service.vod.model.response.VodUpdateVideoClassificationResponse;
import com.volcengine.service.vod.model.response.VodUpdateWatermarkResponse;
import com.volcengine.service.vod.model.response.VodUpdateWorkflowTemplateResponse;
import com.volcengine.service.vod.model.response.VodUrlUploadResponse;
import com.volcengine.util.Sts2Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class VodServiceImpl
extends BaseServiceImpl
implements IVodService {
    private static final VodServiceImpl CN_NORTH_1_SERVICE = new VodServiceImpl("cn-north-1");
    private static final VodServiceImpl AP_SOUTHEAST_1_SERVICE = new VodServiceImpl("ap-southeast-1");

    public static IVodService getInstance() {
        return CN_NORTH_1_SERVICE;
    }

    protected VodServiceImpl(String region) {
        super(VodServiceImpl.getRegionServiceInfo(region), VodServiceConfig.apiInfoList);
    }

    private static ServiceInfo getRegionServiceInfo(final String region) {
        if (VodServiceConfig.ServiceInfoMap.containsKey(region)) {
            return VodServiceConfig.ServiceInfoMap.get(region);
        }
        return new ServiceInfo((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("ConnectionTimeout", 5000);
                this.put("SocketTimeout", 5000);
                this.put("Scheme", "https");
                this.put("Host", String.format("vod.%s.volcengineapi.com", region));
                this.put("Header", new ArrayList<Header>(){
                    {
                        this.add(new BasicHeader("Accept", "application/json"));
                    }
                });
                this.put("Credentials", new Credentials(region, "vod"));
            }
        });
    }

    public static IVodService getInstance(String region) throws Exception {
        switch (region) {
            case "cn-north-1": {
                return CN_NORTH_1_SERVICE;
            }
            case "ap-southeast-1": {
                return AP_SOUTHEAST_1_SERVICE;
            }
        }
        return new VodServiceImpl(region);
    }

    @Override
    public String getPrivateDrmAuthToken(VodGetPrivateDrmPlayAuthRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        return this.getSignUrl("GetPrivateDrmPlayAuth", Utils.mapToPairList(params));
    }

    @Override
    public String createSha1HlsDrmAuthToken(Long expireSeconds) throws Exception {
        return this.createHlsDrmAuthToken("HMAC-SHA1", expireSeconds);
    }

    public String createHlsDrmAuthToken(String dsa, Long expireSeconds) throws Exception {
        if (expireSeconds == null || expireSeconds <= 0L) {
            throw new Exception("Invalid Expire");
        }
        String token = this.createAuth(dsa, expireSeconds);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DrmAuthToken", token);
        params.put("X-Expires", expireSeconds.toString());
        return this.getSignUrl("GetHlsDecryptionKey", Utils.mapToPairList(params));
    }

    private String createAuth(String dsa, long expireSeconds) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.getAccessKey())) {
            throw new Exception("Invalid Ak");
        }
        if (StringUtils.isBlank((CharSequence)this.getSecretKey())) {
            throw new Exception("Invalid Sk");
        }
        long deadline = System.currentTimeMillis() / 1000L + expireSeconds;
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(tz);
        String deadlineDate = df.format(new Date(deadline * 1000L));
        String timestamp = String.valueOf(deadline);
        byte[] kDate = Utils.hmacSHA256(this.getSecretKey().getBytes(), deadlineDate);
        byte[] kRegion = Utils.hmacSHA256(kDate, this.getRegion());
        byte[] kService = Utils.hmacSHA256(kRegion, "vod");
        byte[] kCredentials = Utils.hmacSHA256(kService, "request");
        String key = Hex.encodeHexString((byte[])kCredentials);
        String signDataString = StringUtils.join((Object[])new String[]{dsa, "&", "2.0", "&", timestamp});
        String sign = "";
        switch (dsa) {
            case "HMAC-SHA1": {
                sign = Base64.encodeBase64String((byte[])Utils.hmacSHA1(key.getBytes(), signDataString));
                break;
            }
            case "HMAC-SHA256": {
                sign = Base64.encodeBase64String((byte[])Utils.hmacSHA256(key.getBytes(), signDataString));
                break;
            }
            default: {
                sign = Base64.encodeBase64String((byte[])"".getBytes());
            }
        }
        return StringUtils.join((Object[])new String[]{dsa, ":", "2.0", ":", timestamp, ":", this.getAccessKey(), ":", sign});
    }

    @Override
    public String getSubtitleAuthToken(VodGetSubtitleInfoListRequest input, Long expireSeconds) throws Exception {
        if ("".equals(input.getVid())) {
            throw new Exception("\u4f20\u5165\u7684Vid\u4e3a\u7a7a");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Vid", input.getVid());
        params.put("Status", "Published");
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getSubtitleAuthToken = this.getSignUrl("GetSubtitleInfoList", Utils.mapToPairList(params));
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("GetSubtitleAuthToken", getSubtitleAuthToken);
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public String getPlayAuthToken(VodGetPlayInfoRequest input, Long expireSeconds) throws Exception {
        Map<String, String> params = Utils.protoBufferToMap(input, false);
        if (expireSeconds != null && expireSeconds > 0L) {
            params.put("X-Expires", expireSeconds.toString());
        }
        String getPlayInfoToken = this.getSignUrl("GetPlayInfo", Utils.mapToPairList(params));
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("GetPlayInfoToken", getPlayInfoToken);
        ret.put("TokenVersion", "V2");
        String retStr = JSON.toJSONString(ret);
        Base64.Encoder encoder = java.util.Base64.getEncoder();
        return encoder.encodeToString(retStr.getBytes());
    }

    @Override
    public SecurityToken2 getUploadSts2() throws Exception {
        return this.getUploadSts2WithExpire(3600000L);
    }

    @Override
    public SecurityToken2 getUploadSts2WithExpire(long expire) throws Exception {
        Policy inlinePolicy = new Policy();
        ArrayList<String> actions = new ArrayList<String>();
        actions.add("vod:ApplyUploadInfo");
        actions.add("vod:CommitUploadInfo");
        ArrayList<String> resources = new ArrayList<String>();
        Statement statement = Sts2Utils.newAllowStatement(actions, resources);
        inlinePolicy.addStatement(statement);
        return this.signSts2(inlinePolicy, expire);
    }

    @Override
    public VodCommitUploadInfoResponse uploadMedia(VodUploadMediaRequest vodUploadMediaRequest, VodUploadProgressListener listener) throws Exception {
        UploadCompleteInfo uploadCompleteInfo = this.uploadToB(vodUploadMediaRequest.getSpaceName(), vodUploadMediaRequest.getFilePath(), "media", vodUploadMediaRequest.getFileName(), vodUploadMediaRequest.getFileExtension(), vodUploadMediaRequest.getClientNetWorkMode(), vodUploadMediaRequest.getClientIDCMode(), vodUploadMediaRequest.getStorageClass(), vodUploadMediaRequest.getUploadStrategy(), vodUploadMediaRequest.getUploadHostPrefer(), vodUploadMediaRequest.getChunkSize(), listener);
        VodCommitUploadInfoRequest vodCommitUploadInfoRequest = VodCommitUploadInfoRequest.newBuilder().setSpaceName(vodUploadMediaRequest.getSpaceName()).setSessionKey(uploadCompleteInfo.getSessionKey()).setFunctions(vodUploadMediaRequest.getFunctions()).setCallbackArgs(vodUploadMediaRequest.getCallbackArgs()).setExpireTime(vodUploadMediaRequest.getExpireTime()).build();
        VodCommitUploadInfoResponse vodCommitUploadInfoResponse = this.commitUploadInfo(vodCommitUploadInfoRequest);
        if (!vodCommitUploadInfoResponse.getResponseMetadata().hasError()) {
            VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, 1L);
        }
        return vodCommitUploadInfoResponse;
    }

    @Override
    public VodCommitUploadInfoResponse uploadLocalM3u8(VodUploadMediaRequest vodUploadM3u8Request, List<String> tsFilePaths, List<String> tsFileNames, VodUploadProgressListener listener) throws Exception {
        if (tsFileNames != null && tsFilePaths.size() != tsFileNames.size()) {
            throw new RuntimeException("ts \u53ef\u4ee5\u4e0d\u8bbe\u7f6e FileName\uff0c\u5982\u8bbe\u7f6e\uff0c\u5217\u8868\u957f\u5ea6\u5fc5\u987b\u4e0e ts \u6587\u4ef6\u8def\u5f84\u4e00\u4e00\u5bf9\u5e94");
        }
        HashMap<String, Long> fileSizeMap = new HashMap<String, Long>();
        long totalM3u8TsSize = this.checkAndGetFileSize(vodUploadM3u8Request.getFilePath());
        fileSizeMap.put(vodUploadM3u8Request.getFilePath(), totalM3u8TsSize);
        for (String tsFilePath : tsFilePaths) {
            long tsSize = this.checkAndGetFileSize(tsFilePath);
            fileSizeMap.put(tsFilePath, tsSize);
            totalM3u8TsSize += tsSize;
        }
        VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.FILE_SIZE_EVENT, totalM3u8TsSize);
        for (int i = 0; i < tsFilePaths.size(); ++i) {
            VodUploadMediaRequest vodUploadTsRequest;
            VodCommitUploadInfoResponse vodCommitUploadInfoResponse;
            ArrayList<Functions> functionsList = new ArrayList<Functions>();
            Functions getMetaFunc = Functions.GetMetaFunction();
            functionsList.add(getMetaFunc);
            VodUploadMediaRequest.Builder builder = VodUploadMediaRequest.newBuilder().setSpaceName(vodUploadM3u8Request.getSpaceName()).setFilePath(tsFilePaths.get(i)).setFunctions(JSON.toJSONString(functionsList));
            if (tsFileNames != null) {
                builder.setFileName(tsFileNames.get(i));
            }
            if ((vodCommitUploadInfoResponse = this.uploadObject(vodUploadTsRequest = builder.build(), null)).getResponseMetadata().hasError()) {
                return vodCommitUploadInfoResponse;
            }
            VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, (Long)fileSizeMap.get(tsFilePaths.get(i)));
        }
        UploadCompleteInfo uploadCompleteInfo = this.uploadToB(vodUploadM3u8Request.getSpaceName(), vodUploadM3u8Request.getFilePath(), "media", vodUploadM3u8Request.getFileName(), vodUploadM3u8Request.getFileExtension(), vodUploadM3u8Request.getClientNetWorkMode(), vodUploadM3u8Request.getClientIDCMode(), vodUploadM3u8Request.getStorageClass(), vodUploadM3u8Request.getUploadStrategy(), vodUploadM3u8Request.getUploadHostPrefer(), vodUploadM3u8Request.getChunkSize(), null);
        VodCommitUploadInfoRequest vodCommitUploadInfoRequest = VodCommitUploadInfoRequest.newBuilder().setSpaceName(vodUploadM3u8Request.getSpaceName()).setSessionKey(uploadCompleteInfo.getSessionKey()).setFunctions(vodUploadM3u8Request.getFunctions()).setCallbackArgs(vodUploadM3u8Request.getCallbackArgs()).setExpireTime(vodUploadM3u8Request.getExpireTime()).build();
        VodCommitUploadInfoResponse vodCommitUploadInfoResponse = this.commitUploadInfo(vodCommitUploadInfoRequest);
        if (!vodCommitUploadInfoResponse.getResponseMetadata().hasError()) {
            VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, (Long)fileSizeMap.get(vodUploadM3u8Request.getFilePath()));
        }
        return vodCommitUploadInfoResponse;
    }

    private long checkAndGetFileSize(String filePath) throws Exception {
        File file = new File(filePath);
        if (!file.isFile() || !file.exists()) {
            throw new Exception(SdkError.getErrorDesc(SdkError.ENOFILE));
        }
        return file.length();
    }

    @Override
    public VodCommitUploadInfoResponse uploadObject(VodUploadMediaRequest vodUploadMediaRequest, VodUploadProgressListener listener) throws Exception {
        UploadCompleteInfo uploadCompleteInfo = this.uploadToB(vodUploadMediaRequest.getSpaceName(), vodUploadMediaRequest.getFilePath(), "object", vodUploadMediaRequest.getFileName(), vodUploadMediaRequest.getFileExtension(), vodUploadMediaRequest.getClientNetWorkMode(), vodUploadMediaRequest.getClientIDCMode(), vodUploadMediaRequest.getStorageClass(), vodUploadMediaRequest.getUploadStrategy(), vodUploadMediaRequest.getUploadHostPrefer(), vodUploadMediaRequest.getChunkSize(), listener);
        VodCommitUploadInfoRequest vodCommitUploadInfoRequest = VodCommitUploadInfoRequest.newBuilder().setSpaceName(vodUploadMediaRequest.getSpaceName()).setSessionKey(uploadCompleteInfo.getSessionKey()).setFunctions(vodUploadMediaRequest.getFunctions()).setCallbackArgs(vodUploadMediaRequest.getCallbackArgs()).build();
        VodCommitUploadInfoResponse vodCommitUploadInfoResponse = this.commitUploadInfo(vodCommitUploadInfoRequest);
        if (!vodCommitUploadInfoResponse.getResponseMetadata().hasError()) {
            VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, 1L);
        }
        return vodCommitUploadInfoResponse;
    }

    private UploadCompleteInfo uploadToB(String spaceName, String filePath, String fileType, String fileName, String fileExtension, String clientNetWorkMode, String clientIDCMode, int storageClass, int uploadStrategy, String uploadHostPrefer, long chunkSize, VodUploadProgressListener listener) throws Exception {
        File file = new File(filePath);
        if (!file.isFile() || !file.exists()) {
            throw new Exception(SdkError.getErrorDesc(SdkError.ENOFILE));
        }
        if (chunkSize < 0x1400000L) {
            chunkSize = 0x1400000L;
        }
        VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.FILE_SIZE_EVENT, file.length());
        VodApplyUploadInfoRequest vodApplyUploadInfoRequest = VodApplyUploadInfoRequest.newBuilder().setSpaceName(spaceName).setFileName(fileName).setFileType(fileType).setFileExtension(fileExtension).setStorageClass(storageClass).setClientNetWorkMode(clientNetWorkMode).setClientIDCMode(clientIDCMode).setNeedFallback(true).setUploadHostPrefer(uploadHostPrefer).setFileSize(file.length()).build();
        VodApplyUploadInfoResponse vodApplyUploadInfoResponse = this.applyUploadInfo(vodApplyUploadInfoRequest);
        if (vodApplyUploadInfoResponse.getResponseMetadata().hasError()) {
            throw new Exception(vodApplyUploadInfoResponse.getResponseMetadata().getError().getMessage());
        }
        VpcTosUploadAddress vpcTosUploadAddress = vodApplyUploadInfoResponse.getResult().getData().getVpcTosUploadAddress();
        if (!vpcTosUploadAddress.getUploadMode().equals("")) {
            return this.vpcUpload(vodApplyUploadInfoResponse.getResult(), file, listener);
        }
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException().retryIfResult(Predicates.equalTo((Object)false)).retryIfResult(Predicates.isNull()).withWaitStrategy(WaitStrategies.exponentialWait()).withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).build();
        CandidateUploadAddresses candidateUploadAddresses = vodApplyUploadInfoResponse.getResult().getData().getCandidateUploadAddresses();
        ArrayList<UploadAddress> allUploadAddress = new ArrayList<UploadAddress>();
        allUploadAddress.addAll(candidateUploadAddresses.getMainUploadAddressesList());
        allUploadAddress.addAll(candidateUploadAddresses.getBackupUploadAddressesList());
        allUploadAddress.addAll(candidateUploadAddresses.getFallbackUploadAddressesList());
        UploadCompleteInfo uploadCompleteInfo = null;
        if (!allUploadAddress.isEmpty()) {
            for (UploadAddress uploadAddress : allUploadAddress) {
                if (uploadAddress.getUploadHostsList().isEmpty() || uploadAddress.getStoreInfosList().isEmpty() || uploadAddress.getStoreInfosList().get(0) == null) continue;
                String tosHost = uploadAddress.getUploadHosts(0);
                String oid = uploadAddress.getStoreInfos(0).getStoreUri();
                String sessionKey = uploadAddress.getSessionKey();
                String auth = uploadAddress.getStoreInfos(0).getAuth();
                ArrayList<VodHeaderPair> uploadHeaderList = new ArrayList<VodHeaderPair>();
                uploadAddress.getUploadHeaderList().forEach(ac -> uploadHeaderList.add(VodHeaderPair.newBuilder().setKey(ac.getKey()).setValue(ac.getValue()).build()));
                IVodUploadStrategy vodUploadCoreInstance = Utils.getVodUploadCoreInstance(uploadStrategy, chunkSize);
                try {
                    if (file.length() < chunkSize) {
                        vodUploadCoreInstance.directUpload(this, tosHost, oid, auth, uploadHeaderList, file, retryer, storageClass, listener);
                    } else {
                        vodUploadCoreInstance.chunkUpload(this, tosHost, oid, auth, uploadHeaderList, file, true, retryer, storageClass, listener);
                    }
                    uploadCompleteInfo = new UploadCompleteInfo(oid, sessionKey);
                    break;
                }
                catch (RetryException | UploadException e1) {
                }
            }
        } else {
            VodUploadAddress vodUploadAddress = vodApplyUploadInfoResponse.getResult().getData().getUploadAddress();
            if (!vodApplyUploadInfoResponse.hasResult() || vodUploadAddress.getStoreInfosCount() == 0) {
                throw new Exception("apply upload result is null");
            }
            String oid = vodUploadAddress.getStoreInfos(0).getStoreUri();
            String sessionKey = vodUploadAddress.getSessionKey();
            String auth = vodUploadAddress.getStoreInfos(0).getAuth();
            String host = vodUploadAddress.getUploadHosts(0);
            List<VodHeaderPair> uploadHeaderList = vodUploadAddress.getUploadHeaderList();
            IVodUploadStrategy vodUploadCoreInstance = Utils.getVodUploadCoreInstance(uploadStrategy, chunkSize);
            if (file.length() < chunkSize) {
                vodUploadCoreInstance.directUpload(this, host, oid, auth, uploadHeaderList, file, retryer, storageClass, listener);
            } else {
                vodUploadCoreInstance.chunkUpload(this, host, oid, auth, uploadHeaderList, file, true, retryer, storageClass, listener);
            }
            uploadCompleteInfo = new UploadCompleteInfo(oid, sessionKey);
        }
        if (uploadCompleteInfo == null) {
            throw new Exception("uploadToB failed");
        }
        return uploadCompleteInfo;
    }

    private UploadCompleteInfo vpcUpload(VodApplyUploadInfoResult applyResult, File file, VodUploadProgressListener listener) throws Exception {
        VpcTosUploadAddress vpcTosUploadAddress = applyResult.getData().getVpcTosUploadAddress();
        VodUploadAddress vodUploadAddress = applyResult.getData().getUploadAddress();
        String oid = vodUploadAddress.getStoreInfos(0).getStoreUri();
        String sessionKey = vodUploadAddress.getSessionKey();
        UploadCompleteInfo uploadCompleteInfo = new UploadCompleteInfo(oid, sessionKey);
        if (vpcTosUploadAddress.getQuickCompleteMode().equals("enable")) {
            return uploadCompleteInfo;
        }
        if (vpcTosUploadAddress.getUploadMode().equals("direct")) {
            this.vpcPut(vpcTosUploadAddress, file, listener);
        } else if (vpcTosUploadAddress.getUploadMode().equals("part")) {
            this.vpcPartUpload(vpcTosUploadAddress.getPartUploadInfo(), file, listener);
        }
        return uploadCompleteInfo;
    }

    private void vpcPartUpload(PartUploadInfo partUploadInfo, File file, VodUploadProgressListener listener) throws Exception {
        String etag2;
        Throwable throwable;
        InputStream inputStream;
        Throwable throwable2;
        FileInputStream fileInputStream;
        if (partUploadInfo == null) {
            throw new UploadException(-1, -1, "empty param");
        }
        long size = file.length();
        long chunkSize = partUploadInfo.getPartSize();
        long totalNum = size / chunkSize;
        if ((long)partUploadInfo.getPartPutUrlsList().size() != totalNum + 1L) {
            throw new UploadException(-1, -1, "mismatch part upload");
        }
        long partNumber = 0L;
        long offset = 0L;
        ArrayList<String> etagList = new ArrayList<String>();
        for (long i = 0L; i < totalNum; ++i) {
            fileInputStream = new FileInputStream(file);
            throwable2 = null;
            try {
                ((InputStream)fileInputStream).skip(offset);
                inputStream = Utils.newRepeatableInputStream(new PartInputStream(fileInputStream, chunkSize));
                throwable = null;
                try {
                    etag2 = this.vpcPartPut((String)partUploadInfo.getPartPutUrlsList().get((int)i), inputStream);
                    etagList.add(etag2);
                    VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, chunkSize);
                    offset += chunkSize;
                    continue;
                }
                catch (Throwable etag2) {
                    throwable = etag2;
                    throw etag2;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable etag2) {
                                throwable.addSuppressed(etag2);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (Throwable e) {
                throwable2 = e;
                throw e;
            }
            finally {
                if (fileInputStream != null) {
                    if (throwable2 != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (Throwable e) {
                            throwable2.addSuppressed(e);
                        }
                    } else {
                        ((InputStream)fileInputStream).close();
                    }
                }
            }
        }
        long lastChunkSize = size - offset;
        fileInputStream = new FileInputStream(file);
        throwable2 = null;
        try {
            ((InputStream)fileInputStream).skip(offset);
            inputStream = Utils.newRepeatableInputStream(new PartInputStream(fileInputStream, lastChunkSize));
            throwable = null;
            try {
                etag2 = this.vpcPartPut((String)partUploadInfo.getPartPutUrlsList().get((int)totalNum), inputStream);
                etagList.add(etag2);
                VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, lastChunkSize);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            throwable2 = throwable5;
            throw throwable5;
        }
        finally {
            if (fileInputStream != null) {
                if (throwable2 != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (Throwable throwable6) {
                        throwable2.addSuppressed(throwable6);
                    }
                } else {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
        this.vpcPost(partUploadInfo, etagList);
    }

    private void vpcPost(PartUploadInfo partUploadInfo, List<String> etagList) throws Exception {
        String partsInfo = IntStream.range(0, etagList.size()).mapToObj(i -> String.format("{\"PartNumber\":%d,\"Etag\":%s}", i + 1, etagList.get(i))).collect(Collectors.joining(",", "", ""));
        String body = String.format("{\"Parts\": [%s]}", partsInfo);
        Map<String, String> headers = partUploadInfo.getCompleteUrlHeadersMap();
        HttpResponse httpResponse = this.postDataWithResponse(partUploadInfo.getCompletePartUrl(), body.getBytes(), headers);
        if (httpResponse == null) {
            throw new UploadException(-1, -1, "http null resp");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            Header logIdHeader = httpResponse.getFirstHeader("x-tos-request-id");
            String logId = "";
            if (logIdHeader != null) {
                logId = logIdHeader.getValue();
            }
            throw new UploadException(-1, -1, "post error: " + logId);
        }
    }

    private String vpcPartPut(String putUrl, InputStream inputStream) throws Exception {
        inputStream.mark(0);
        long crc64Ecma = Utils.crc64Ecma(inputStream);
        inputStream.reset();
        HttpResponse httpResponse = this.putDataWithResponse(putUrl, inputStream, null);
        if (httpResponse == null) {
            throw new UploadException(-1, -1, "http null resp");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            Header logIdHeader = httpResponse.getFirstHeader("x-tos-request-id");
            String logId = "";
            if (logIdHeader != null) {
                logId = logIdHeader.getValue();
            }
            throw new UploadException(-1, -1, "put error: " + logId);
        }
        Header crc64Header = httpResponse.getFirstHeader("x-tos-hash-crc64ecma");
        if (crc64Header != null) {
            String headerCrc64 = crc64Header.getValue();
            if (!Long.toUnsignedString(crc64Ecma).equals(headerCrc64)) {
                throw new UploadException(-1, -1, "integrity check failed");
            }
        }
        String etag = "";
        Header etagHeader = httpResponse.getFirstHeader("ETag");
        if (etagHeader != null) {
            etag = etagHeader.getValue();
        }
        return etag;
    }

    private void vpcPut(VpcTosUploadAddress vpcTosUploadAddress, File file, VodUploadProgressListener listener) throws Exception {
        String putUrl = vpcTosUploadAddress.getPutUrl();
        try (InputStream inputStream = Utils.newRepeatableInputStream(new FileInputStream(file));){
            inputStream.mark(0);
            long crc64Ecma = Utils.crc64Ecma(inputStream);
            inputStream.reset();
            Map<String, String> headers = vpcTosUploadAddress.getPutUrlHeadersMap();
            HttpResponse httpResponse = this.putDataWithResponse(putUrl, inputStream, headers);
            VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, file.length() - 1L);
            if (httpResponse == null) {
                throw new UploadException(-1, -1, "http null resp");
            }
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                Header logIdHeader = httpResponse.getFirstHeader("x-tos-request-id");
                String logId = "";
                if (logIdHeader != null) {
                    logId = logIdHeader.getValue();
                }
                throw new UploadException(-1, -1, "put error: " + logId);
            }
            Header crc64Header = httpResponse.getFirstHeader("x-tos-hash-crc64ecma");
            if (crc64Header != null) {
                String headerCrc64 = crc64Header.getValue();
                if (!String.valueOf(crc64Ecma).equals(headerCrc64)) {
                    throw new UploadException(-1, -1, "integrity check failed");
                }
            }
        }
    }

    public String initUploadPart(String host, String oid, String auth, boolean isLargeFile, List<VodHeaderPair> uploadHeaderList, Retryer retryer, int storageClass) throws ExecutionException, RetryException, IOException {
        HttpResponse httpResponse;
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("https://%s/%s?uploads", host, oidEncode);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        uploadHeaderList.forEach(vodHeaderPair -> headers.put(vodHeaderPair.getKey(), vodHeaderPair.getValue()));
        if (storageClass == 2) {
            headers.put("X-Upload-Storage-Class", "archive");
        }
        if (storageClass == 3) {
            headers.put("X-Upload-Storage-Class", "ia");
        }
        if ((httpResponse = (HttpResponse)retryer.call(() -> this.putDataWithResponse(url, new byte[0], (Map<String, String>)headers))) == null) {
            throw new RuntimeException("init part error,response is empty");
        }
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("http code is " + httpResponse.getStatusLine().getStatusCode());
        }
        String entity = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        JSONObject result = JSONObject.parseObject((String)entity);
        if (result.getIntValue("success") != 0) {
            JSONObject errObj = result.getJSONObject("error");
            throw new UploadException(errObj.getIntValue("code"), errObj.getIntValue("error_code"), errObj.getString("message"));
        }
        return result.getJSONObject("payload").getInnerMap().get("uploadID").toString();
    }

    public void uploadMergePart(String host, String oid, String auth, String uploadID, String[] checkSum, boolean isLargeFile, Retryer retryer, int storageClass, String objectContentType) throws ExecutionException, RetryException {
        boolean response;
        String oidEncode = StringUtils.replace((String)oid, (String)" ", (String)"%20");
        String url = String.format("https://%s/%s?uploadID=%s&ObjectContentType=%s", host, oidEncode, uploadID, objectContentType);
        String body = IntStream.range(0, checkSum.length).mapToObj(i -> String.format("%d:%s", i, checkSum[i])).collect(Collectors.joining(",", "", ""));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", auth);
        if (isLargeFile) {
            headers.put("X-Storage-Mode", "gateway");
        }
        if (storageClass == 2) {
            headers.put("X-Upload-Storage-Class", "archive");
        }
        if (storageClass == 3) {
            headers.put("X-Upload-Storage-Class", "ia");
        }
        if (!(response = ((Boolean)retryer.call(() -> this.putData(url, body.getBytes(), (Map<String, String>)headers))).booleanValue())) {
            throw new UploadException(-1, -1, "");
        }
    }

    @Override
    public VodCommitUploadInfoResponse uploadMaterial(VodUploadMaterialRequest vodUploadMaterialRequest, VodUploadProgressListener listener) throws Exception {
        UploadCompleteInfo uploadCompleteInfo = this.uploadToB(vodUploadMaterialRequest.getSpaceName(), vodUploadMaterialRequest.getFilePath(), vodUploadMaterialRequest.getFileType(), vodUploadMaterialRequest.getFileName(), vodUploadMaterialRequest.getFileExtension(), vodUploadMaterialRequest.getClientNetWorkMode(), vodUploadMaterialRequest.getClientIDCMode(), 0, vodUploadMaterialRequest.getUploadStrategy(), vodUploadMaterialRequest.getUploadHostPrefer(), vodUploadMaterialRequest.getChunkSize(), listener);
        VodCommitUploadInfoRequest vodCommitUploadInfoRequest = VodCommitUploadInfoRequest.newBuilder().setSpaceName(vodUploadMaterialRequest.getSpaceName()).setSessionKey(uploadCompleteInfo.getSessionKey()).setFunctions(vodUploadMaterialRequest.getFunctions()).setCallbackArgs(vodUploadMaterialRequest.getCallbackArgs()).build();
        VodCommitUploadInfoResponse vodCommitUploadInfoResponse = this.commitUploadInfo(vodCommitUploadInfoRequest);
        if (!vodCommitUploadInfoResponse.getResponseMetadata().hasError()) {
            VodUploadProgressListenerHelper.sendVodUploadEvent(listener, VodUploadProgressEventType.UPLOAD_BYTES_EVENT, 1L);
        }
        return vodCommitUploadInfoResponse;
    }

    @Override
    public VodSubmitDirectEditTaskAsyncResponse submitDirectEditTaskAsync(VodSubmitDirectEditTaskAsyncRequest input) throws Exception {
        RawResponse response;
        String jsonData = JsonFormat.printer().print((MessageOrBuilder)input);
        JSONObject inputMap = JSON.parseObject((String)jsonData);
        if (inputMap.containsKey("EditParam")) {
            JSONObject editParam = JSON.parseObject((String)input.getEditParam().toString(StandardCharsets.UTF_8));
            inputMap.put("EditParam", editParam);
        }
        if ((response = this.json("SubmitDirectEditTaskAsync", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)inputMap))).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodSubmitDirectEditTaskAsyncResponse.Builder responseBuilder = VodSubmitDirectEditTaskAsyncResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodSubmitDirectEditTaskSyncResponse submitDirectEditTaskSync(VodSubmitDirectEditTaskSyncRequest input) throws Exception {
        RawResponse response;
        String jsonData = JsonFormat.printer().print((MessageOrBuilder)input);
        JSONObject inputMap = JSON.parseObject((String)jsonData);
        if (inputMap.containsKey("EditParam")) {
            JSONObject editParam = JSON.parseObject((String)input.getEditParam().toString(StandardCharsets.UTF_8));
            inputMap.put("EditParam", editParam);
        }
        if ((response = this.json("SubmitDirectEditTaskSync", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)inputMap))).getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodSubmitDirectEditTaskSyncResponse.Builder responseBuilder = VodSubmitDirectEditTaskSyncResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public com.volcengine.service.vod.model.response.VodGetDirectEditResultResponse getDirectEditResult(VodGetDirectEditResultRequest input) throws Exception {
        String jsonData = JsonFormat.printer().print((MessageOrBuilder)input);
        RawResponse response = this.json("GetDirectEditResult", new ArrayList<NameValuePair>(), jsonData);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetDirectEditResultResponse resp = (VodGetDirectEditResultResponse)JSON.parseObject((byte[])response.getData(), VodGetDirectEditResultResponse.class, (Feature[])new Feature[0]);
        if (resp.result != null) {
            for (int i = 0; i < resp.result.size(); ++i) {
                Map<String, Object> value = resp.result.get(i);
                if (!value.containsKey("EditParam")) continue;
                Object editParam = value.get("EditParam");
                byte[] editParamBytes = JSON.toJSONBytes((Object)editParam, (SerializerFeature[])new SerializerFeature[0]);
                value.put("EditParam", editParamBytes);
                resp.result.set(i, value);
            }
        }
        VodGetDirectEditResultResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetDirectEditResultResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(JSON.toJSONBytes((Object)resp, (SerializerFeature[])new SerializerFeature[0]))), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public com.volcengine.service.vod.model.response.VodGetDirectEditProgressResponse getDirectEditProgress(VodGetDirectEditProgressRequest input) throws Exception {
        RawResponse response = this.query("GetDirectEditProgress", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetDirectEditProgressResponse resp = (VodGetDirectEditProgressResponse)JSON.parseObject((byte[])response.getData(), VodGetDirectEditProgressResponse.class, (Feature[])new Feature[0]);
        if (resp.result != null) {
            Result res = new Result();
            res.result = (Integer)resp.result;
            resp.result = res;
        }
        VodGetDirectEditProgressResponse.Builder responseBuilder = com.volcengine.service.vod.model.response.VodGetDirectEditProgressResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(JSON.toJSONBytes((Object)resp, (SerializerFeature[])new SerializerFeature[0]))), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCancelDirectEditTaskResponse cancelDirectEditTask(VodCancelDirectEditTaskRequest input) throws Exception {
        String jsonData = JsonFormat.printer().print((MessageOrBuilder)input);
        RawResponse response = this.json("CancelDirectEditTask", new ArrayList<NameValuePair>(), jsonData);
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCancelDirectEditTaskResponse.Builder responseBuilder = VodCancelDirectEditTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetAllPlayInfoResponse getAllPlayInfo(VodGetAllPlayInfoRequest input) throws Exception {
        RawResponse response = this.query("GetAllPlayInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetAllPlayInfoResponse.Builder responseBuilder = VodGetAllPlayInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetPlayInfoResponse getPlayInfo(VodGetPlayInfoRequest input) throws Exception {
        RawResponse response = this.query("GetPlayInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetPlayInfoResponse.Builder responseBuilder = VodGetPlayInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetPrivateDrmPlayAuthResponse getPrivateDrmPlayAuth(VodGetPrivateDrmPlayAuthRequest input) throws Exception {
        RawResponse response = this.query("GetPrivateDrmPlayAuth", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetPrivateDrmPlayAuthResponse.Builder responseBuilder = VodGetPrivateDrmPlayAuthResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetHlsDecryptionKeyResponse getHlsDecryptionKey(VodGetHlsDecryptionKeyRequest input) throws Exception {
        RawResponse response = this.query("GetHlsDecryptionKey", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetHlsDecryptionKeyResponse.Builder responseBuilder = VodGetHlsDecryptionKeyResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetPlayInfoWithLiveTimeShiftSceneResponse getPlayInfoWithLiveTimeShiftScene(VodGetPlayInfoWithLiveTimeShiftSceneRequest input) throws Exception {
        RawResponse response = this.query("GetPlayInfoWithLiveTimeShiftScene", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetPlayInfoWithLiveTimeShiftSceneResponse.Builder responseBuilder = VodGetPlayInfoWithLiveTimeShiftSceneResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodSubmitBlockObjectTasksResponse submitBlockObjectTasks(VodSubmitBlockObjectTasksRequest input) throws Exception {
        RawResponse response = this.post("SubmitBlockObjectTasks", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodSubmitBlockObjectTasksResponse.Builder responseBuilder = VodSubmitBlockObjectTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListBlockObjectTasksResponse listBlockObjectTasks(VodListBlockObjectTasksRequest input) throws Exception {
        RawResponse response = this.post("ListBlockObjectTasks", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListBlockObjectTasksResponse.Builder responseBuilder = VodListBlockObjectTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUrlUploadResponse uploadMediaByUrl(VodUrlUploadRequest input) throws Exception {
        RawResponse response = this.query("UploadMediaByUrl", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUrlUploadResponse.Builder responseBuilder = VodUrlUploadResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodQueryUploadTaskInfoResponse queryUploadTaskInfo(VodQueryUploadTaskInfoRequest input) throws Exception {
        RawResponse response = this.query("QueryUploadTaskInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodQueryUploadTaskInfoResponse.Builder responseBuilder = VodQueryUploadTaskInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodApplyUploadInfoResponse applyUploadInfo(VodApplyUploadInfoRequest input) throws Exception {
        RawResponse response = this.query("ApplyUploadInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodApplyUploadInfoResponse.Builder responseBuilder = VodApplyUploadInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCommitUploadInfoResponse commitUploadInfo(VodCommitUploadInfoRequest input) throws Exception {
        RawResponse response = this.query("CommitUploadInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCommitUploadInfoResponse.Builder responseBuilder = VodCommitUploadInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListFileMetaInfosByFileNamesResponse listFileMetaInfosByFileNames(VodListFileMetaInfosByFileNamesRequest input) throws Exception {
        RawResponse response = this.post("ListFileMetaInfosByFileNames", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListFileMetaInfosByFileNamesResponse.Builder responseBuilder = VodListFileMetaInfosByFileNamesResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateMediaInfoResponse updateMediaInfo(VodUpdateMediaInfoRequest input) throws Exception {
        RawResponse response = this.query("UpdateMediaInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateMediaInfoResponse.Builder responseBuilder = VodUpdateMediaInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateMediaPublishStatusResponse updateMediaPublishStatus(VodUpdateMediaPublishStatusRequest input) throws Exception {
        RawResponse response = this.query("UpdateMediaPublishStatus", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateMediaPublishStatusResponse.Builder responseBuilder = VodUpdateMediaPublishStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateMediaStorageClassResponse updateMediaStorageClass(VodUpdateMediaStorageClassRequest input) throws Exception {
        RawResponse response = this.query("UpdateMediaStorageClass", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateMediaStorageClassResponse.Builder responseBuilder = VodUpdateMediaStorageClassResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetMediaInfosResponse getMediaInfos(VodGetMediaInfosRequest input) throws Exception {
        RawResponse response = this.query("GetMediaInfos", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetMediaInfosResponse.Builder responseBuilder = VodGetMediaInfosResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetMediaInfosResponse getMediaInfos20230701(VodGetMediaInfosRequest input) throws Exception {
        RawResponse response = this.query("GetMediaInfos", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetMediaInfosResponse.Builder responseBuilder = VodGetMediaInfosResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetRecommendedPosterResponse getRecommendedPoster(VodGetRecommendedPosterRequest input) throws Exception {
        RawResponse response = this.query("GetRecommendedPoster", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetRecommendedPosterResponse.Builder responseBuilder = VodGetRecommendedPosterResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteMediaResponse deleteMedia(VodDeleteMediaRequest input) throws Exception {
        RawResponse response = this.query("DeleteMedia", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteMediaResponse.Builder responseBuilder = VodDeleteMediaResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteTranscodesResponse deleteTranscodes(VodDeleteTranscodesRequest input) throws Exception {
        RawResponse response = this.query("DeleteTranscodes", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteTranscodesResponse.Builder responseBuilder = VodDeleteTranscodesResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetFileInfosResponse getFileInfos(VodGetFileInfosRequest input) throws Exception {
        RawResponse response = this.query("GetFileInfos", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetFileInfosResponse.Builder responseBuilder = VodGetFileInfosResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateFileStorageClassResponse updateFileStorageClass(VodUpdateFileStorageClassRequest input) throws Exception {
        RawResponse response = this.post("UpdateFileStorageClass", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateFileStorageClassResponse.Builder responseBuilder = VodUpdateFileStorageClassResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteMediaTosFileResponse deleteMediaTosFile(VodDeleteMediaTosFileRequest input) throws Exception {
        RawResponse response = this.post("DeleteMediaTosFile", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteMediaTosFileResponse.Builder responseBuilder = VodDeleteMediaTosFileResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetMediaListResponse getMediaList(VodGetMediaListRequest input) throws Exception {
        RawResponse response = this.query("GetMediaList", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetMediaListResponse.Builder responseBuilder = VodGetMediaListResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteMaterialResponse deleteMaterial(VodDeleteMaterialRequest input) throws Exception {
        RawResponse response = this.query("DeleteMaterial", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteMaterialResponse.Builder responseBuilder = VodDeleteMaterialResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetSubtitleInfoListResponse getSubtitleInfoList(VodGetSubtitleInfoListRequest input) throws Exception {
        RawResponse response = this.query("GetSubtitleInfoList", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetSubtitleInfoListResponse.Builder responseBuilder = VodGetSubtitleInfoListResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSubtitleStatusResponse updateSubtitleStatus(VodUpdateSubtitleStatusRequest input) throws Exception {
        RawResponse response = this.query("UpdateSubtitleStatus", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSubtitleStatusResponse.Builder responseBuilder = VodUpdateSubtitleStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSubtitleInfoResponse updateSubtitleInfo(VodUpdateSubtitleInfoRequest input) throws Exception {
        RawResponse response = this.query("UpdateSubtitleInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSubtitleInfoResponse.Builder responseBuilder = VodUpdateSubtitleInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetAuditFramesForAuditResponse getAuditFramesForAudit(VodGetAuditFramesForAuditRequest input) throws Exception {
        RawResponse response = this.query("GetAuditFramesForAudit", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetAuditFramesForAuditResponse.Builder responseBuilder = VodGetAuditFramesForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetMLFramesForAuditResponse getMLFramesForAudit(VodGetMLFramesForAuditRequest input) throws Exception {
        RawResponse response = this.query("GetMLFramesForAudit", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetMLFramesForAuditResponse.Builder responseBuilder = VodGetMLFramesForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetBetterFramesForAuditResponse getBetterFramesForAudit(VodGetBetterFramesForAuditRequest input) throws Exception {
        RawResponse response = this.query("GetBetterFramesForAudit", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetBetterFramesForAuditResponse.Builder responseBuilder = VodGetBetterFramesForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetAudioInfoForAuditResponse getAudioInfoForAudit(VodGetAudioInfoForAuditRequest input) throws Exception {
        RawResponse response = this.query("GetAudioInfoForAudit", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetAudioInfoForAuditResponse.Builder responseBuilder = VodGetAudioInfoForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetAutomaticSpeechRecognitionForAuditResponse getAutomaticSpeechRecognitionForAudit(VodGetAutomaticSpeechRecognitionForAuditRequest input) throws Exception {
        RawResponse response = this.query("GetAutomaticSpeechRecognitionForAudit", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetAutomaticSpeechRecognitionForAuditResponse.Builder responseBuilder = VodGetAutomaticSpeechRecognitionForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetAudioEventDetectionForAuditResponse getAudioEventDetectionForAudit(VodGetAudioEventDetectionForAuditRequest input) throws Exception {
        RawResponse response = this.query("GetAudioEventDetectionForAudit", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetAudioEventDetectionForAuditResponse.Builder responseBuilder = VodGetAudioEventDetectionForAuditResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateVideoClassificationResponse createVideoClassification(VodCreateVideoClassificationRequest input) throws Exception {
        RawResponse response = this.query("CreateVideoClassification", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateVideoClassificationResponse.Builder responseBuilder = VodCreateVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateVideoClassificationResponse updateVideoClassification(VodUpdateVideoClassificationRequest input) throws Exception {
        RawResponse response = this.query("UpdateVideoClassification", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateVideoClassificationResponse.Builder responseBuilder = VodUpdateVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteVideoClassificationResponse deleteVideoClassification(VodDeleteVideoClassificationRequest input) throws Exception {
        RawResponse response = this.query("DeleteVideoClassification", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteVideoClassificationResponse.Builder responseBuilder = VodDeleteVideoClassificationResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListVideoClassificationsResponse listVideoClassifications(VodListVideoClassificationsRequest input) throws Exception {
        RawResponse response = this.query("ListVideoClassifications", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListVideoClassificationsResponse.Builder responseBuilder = VodListVideoClassificationsResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListSnapshotsResponse listSnapshots(VodListSnapshotsRequest input) throws Exception {
        RawResponse response = this.query("ListSnapshots", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListSnapshotsResponse.Builder responseBuilder = VodListSnapshotsResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodExtractMediaMetaTaskResponse extractMediaMetaTask(VodExtractMediaMetaTaskRequest input) throws Exception {
        RawResponse response = this.query("ExtractMediaMetaTask", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodExtractMediaMetaTaskResponse.Builder responseBuilder = VodExtractMediaMetaTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodStartWorkflowResponse startWorkflow(VodStartWorkflowRequest input) throws Exception {
        RawResponse response = this.query("StartWorkflow", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodStartWorkflowResponse.Builder responseBuilder = VodStartWorkflowResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodRetrieveTranscodeResultResponse retrieveTranscodeResult(VodRetrieveTranscodeResultRequest input) throws Exception {
        RawResponse response = this.query("RetrieveTranscodeResult", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodRetrieveTranscodeResultResponse.Builder responseBuilder = VodRetrieveTranscodeResultResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetWorkflowExecutionStatusResponse getWorkflowExecution(VodGetWorkflowExecutionStatusRequest input) throws Exception {
        RawResponse response = this.query("GetWorkflowExecution", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetWorkflowExecutionStatusResponse.Builder responseBuilder = VodGetWorkflowExecutionStatusResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetWorkflowResultResponse getWorkflowExecutionResult(VodGetWorkflowResultRequest input) throws Exception {
        RawResponse response = this.query("GetWorkflowExecutionResult", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetWorkflowResultResponse.Builder responseBuilder = VodGetWorkflowResultResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateTaskTemplateResponse createTaskTemplate(VodCreateTaskTemplateRequest input) throws Exception {
        RawResponse response = this.post("CreateTaskTemplate", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateTaskTemplateResponse.Builder responseBuilder = VodCreateTaskTemplateResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateTaskTemplateResponse updateTaskTemplate(VodUpdateTaskTemplateRequest input) throws Exception {
        RawResponse response = this.post("UpdateTaskTemplate", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateTaskTemplateResponse.Builder responseBuilder = VodUpdateTaskTemplateResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetTaskTemplateResponse getTaskTemplate(VodGetTaskTemplateRequest input) throws Exception {
        RawResponse response = this.query("GetTaskTemplate", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetTaskTemplateResponse.Builder responseBuilder = VodGetTaskTemplateResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListTaskTemplateResponse listTaskTemplate(VodListTaskTemplateRequest input) throws Exception {
        RawResponse response = this.query("ListTaskTemplate", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListTaskTemplateResponse.Builder responseBuilder = VodListTaskTemplateResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteTaskTemplateResponse deleteTaskTemplate(VodDeleteTaskTemplateRequest input) throws Exception {
        RawResponse response = this.post("DeleteTaskTemplate", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteTaskTemplateResponse.Builder responseBuilder = VodDeleteTaskTemplateResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateWorkflowTemplateResponse createWorkflowTemplate(VodCreateWorkflowTemplateRequest input) throws Exception {
        RawResponse response = this.post("CreateWorkflowTemplate", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateWorkflowTemplateResponse.Builder responseBuilder = VodCreateWorkflowTemplateResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateWorkflowTemplateResponse updateWorkflowTemplate(VodUpdateWorkflowTemplateRequest input) throws Exception {
        RawResponse response = this.post("UpdateWorkflowTemplate", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateWorkflowTemplateResponse.Builder responseBuilder = VodUpdateWorkflowTemplateResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetWorkflowTemplateResponse getWorkflowTemplate(VodGetWorkflowTemplateRequest input) throws Exception {
        RawResponse response = this.query("GetWorkflowTemplate", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetWorkflowTemplateResponse.Builder responseBuilder = VodGetWorkflowTemplateResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListWorkflowTemplateResponse listWorkflowTemplate(VodListWorkflowTemplateRequest input) throws Exception {
        RawResponse response = this.query("ListWorkflowTemplate", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListWorkflowTemplateResponse.Builder responseBuilder = VodListWorkflowTemplateResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteWorkflowTemplateResponse deleteWorkflowTemplate(VodDeleteWorkflowTemplateRequest input) throws Exception {
        RawResponse response = this.post("DeleteWorkflowTemplate", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteWorkflowTemplateResponse.Builder responseBuilder = VodDeleteWorkflowTemplateResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateWatermarkResponse createWatermarkTemplate(VodCreateWatermarkRequest input) throws Exception {
        RawResponse response = this.post("CreateWatermarkTemplate", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateWatermarkResponse.Builder responseBuilder = VodCreateWatermarkResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateWatermarkResponse updateWatermarkTemplate(VodUpdateWatermarkRequest input) throws Exception {
        RawResponse response = this.post("UpdateWatermarkTemplate", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateWatermarkResponse.Builder responseBuilder = VodUpdateWatermarkResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetWatermarkResponse getWatermarkTemplate(VodGetWatermarkRequest input) throws Exception {
        RawResponse response = this.query("GetWatermarkTemplate", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetWatermarkResponse.Builder responseBuilder = VodGetWatermarkResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListWatermarkResponse listWatermarkTemplate(VodListWatermarkRequest input) throws Exception {
        RawResponse response = this.query("ListWatermarkTemplate", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListWatermarkResponse.Builder responseBuilder = VodListWatermarkResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteWatermarkResponse deleteWatermarkTemplate(VodDeleteWatermarkRequest input) throws Exception {
        RawResponse response = this.post("DeleteWatermarkTemplate", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteWatermarkResponse.Builder responseBuilder = VodDeleteWatermarkResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteSpaceResponse deleteSpace(VodDeleteSpaceRequest input) throws Exception {
        RawResponse response = this.query("DeleteSpace", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteSpaceResponse.Builder responseBuilder = VodDeleteSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateSpaceResponse createSpace(VodCreateSpaceRequest input) throws Exception {
        RawResponse response = this.query("CreateSpace", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateSpaceResponse.Builder responseBuilder = VodCreateSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListSpaceResponse listSpace(VodListSpaceRequest input) throws Exception {
        RawResponse response = this.query("ListSpace", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListSpaceResponse.Builder responseBuilder = VodListSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetSpaceDetailResponse getSpaceDetail(VodGetSpaceDetailRequest input) throws Exception {
        RawResponse response = this.query("GetSpaceDetail", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetSpaceDetailResponse.Builder responseBuilder = VodGetSpaceDetailResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSpaceResponse updateSpace(VodUpdateSpaceRequest input) throws Exception {
        RawResponse response = this.query("UpdateSpace", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSpaceResponse.Builder responseBuilder = VodUpdateSpaceResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateSpaceUploadConfigResponse updateSpaceUploadConfig(VodUpdateSpaceUploadConfigRequest input) throws Exception {
        RawResponse response = this.query("UpdateSpaceUploadConfig", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateSpaceUploadConfigResponse.Builder responseBuilder = VodUpdateSpaceUploadConfigResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodAddDomainToSchedulerResponse addDomainToScheduler(VodAddDomainToSchedulerRequest input) throws Exception {
        RawResponse response = this.query("AddDomainToScheduler", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodAddDomainToSchedulerResponse.Builder responseBuilder = VodAddDomainToSchedulerResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodRemoveDomainFromSchedulerResponse removeDomainFromScheduler(VodRemoveDomainFromSchedulerRequest input) throws Exception {
        RawResponse response = this.query("RemoveDomainFromScheduler", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodRemoveDomainFromSchedulerResponse.Builder responseBuilder = VodRemoveDomainFromSchedulerResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateDomainPlayRuleResponse updateDomainPlayRule(VodUpdateDomainPlayRuleRequest input) throws Exception {
        RawResponse response = this.query("UpdateDomainPlayRule", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateDomainPlayRuleResponse.Builder responseBuilder = VodUpdateDomainPlayRuleResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodStartDomainResponse startDomain(VodStartDomainRequest input) throws Exception {
        RawResponse response = this.query("StartDomain", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodStartDomainResponse.Builder responseBuilder = VodStartDomainResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodStopDomainResponse stopDomain(VodStopDomainRequest input) throws Exception {
        RawResponse response = this.query("StopDomain", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodStopDomainResponse.Builder responseBuilder = VodStopDomainResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDeleteDomainResponse deleteDomain(VodDeleteDomainRequest input) throws Exception {
        RawResponse response = this.query("DeleteDomain", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDeleteDomainResponse.Builder responseBuilder = VodDeleteDomainResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListDomainResponse listDomain(VodListDomainRequest input) throws Exception {
        RawResponse response = this.query("ListDomain", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListDomainResponse.Builder responseBuilder = VodListDomainResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateCdnRefreshTaskResponse createCdnRefreshTask(VodCreateCdnRefreshTaskRequest input) throws Exception {
        RawResponse response = this.query("CreateCDNRefreshTask", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateCdnRefreshTaskResponse.Builder responseBuilder = VodCreateCdnRefreshTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateCdnPreloadTaskResponse createCdnPreloadTask(VodCreateCdnPreloadTaskRequest input) throws Exception {
        RawResponse response = this.query("CreateCDNPreloadTask", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateCdnPreloadTaskResponse.Builder responseBuilder = VodCreateCdnPreloadTaskResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListCdnTasksResponse listCdnTasks(VodListCdnTasksRequest input) throws Exception {
        RawResponse response = this.query("ListCdnTasks", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListCdnTasksResponse.Builder responseBuilder = VodListCdnTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListCdnAccessLogResponse listCdnAccessLog(VodListCdnAccessLogRequest input) throws Exception {
        RawResponse response = this.query("ListCdnAccessLog", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListCdnAccessLogResponse.Builder responseBuilder = VodListCdnAccessLogResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListCdnTopAccessUrlResponse listCdnTopAccessUrl(VodListCdnTopAccessUrlRequest input) throws Exception {
        RawResponse response = this.query("ListCdnTopAccessUrl", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListCdnTopAccessUrlResponse.Builder responseBuilder = VodListCdnTopAccessUrlResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodListCdnTopAccessResponse listCdnTopAccess(VodListCdnTopAccessRequest input) throws Exception {
        RawResponse response = this.query("ListCdnTopAccess", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodListCdnTopAccessResponse.Builder responseBuilder = VodListCdnTopAccessResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCdnStatisticsCommonResponse listCdnUsageData(VodListCdnUsageDataRequest input) throws Exception {
        RawResponse response = this.query("ListCdnUsageData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCdnStatisticsCommonResponse.Builder responseBuilder = VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCdnStatisticsCommonResponse listCdnStatusData(VodListCdnStatusDataRequest input) throws Exception {
        RawResponse response = this.query("ListCdnStatusData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCdnStatisticsCommonResponse.Builder responseBuilder = VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeIPInfoResponse describeIpInfo(VodDescribeIPInfoRequest input) throws Exception {
        RawResponse response = this.query("DescribeIpInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeIPInfoResponse.Builder responseBuilder = VodDescribeIPInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCdnStatisticsCommonResponse listCdnPvData(VodListCdnPvDataRequest input) throws Exception {
        RawResponse response = this.query("ListCdnPvData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCdnStatisticsCommonResponse.Builder responseBuilder = VodCdnStatisticsCommonResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodSubmitBlockTasksResponse submitBlockTasks(VodSubmitBlockTasksRequest input) throws Exception {
        RawResponse response = this.post("SubmitBlockTasks", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodSubmitBlockTasksResponse.Builder responseBuilder = VodSubmitBlockTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetContentBlockTasksResponse getContentBlockTasks(VodGetContentBlockTasksRequest input) throws Exception {
        RawResponse response = this.post("GetContentBlockTasks", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetContentBlockTasksResponse.Builder responseBuilder = VodGetContentBlockTasksResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodCreateDomainV2Response createDomain(VodCreateDomainV2Request input) throws Exception {
        RawResponse response = this.query("CreateDomain", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodCreateDomainV2Response.Builder responseBuilder = VodCreateDomainV2Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateDomainExpireV2Response updateDomainExpire(VodUpdateDomainExpireV2Request input) throws Exception {
        RawResponse response = this.query("UpdateDomainExpire", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateDomainExpireV2Response.Builder responseBuilder = VodUpdateDomainExpireV2Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateDomainAuthConfigV2Response updateDomainAuthConfig(VodUpdateDomainAuthConfigV2Request input) throws Exception {
        RawResponse response = this.query("UpdateDomainAuthConfig", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateDomainAuthConfigV2Response.Builder responseBuilder = VodUpdateDomainAuthConfigV2Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public AddOrUpdateCertificateV2Response addOrUpdateCertificate(AddOrUpdateCertificateV2Request input) throws Exception {
        RawResponse response = this.post("AddOrUpdateCertificate", new ArrayList<NameValuePair>(), Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        AddOrUpdateCertificateV2Response.Builder responseBuilder = AddOrUpdateCertificateV2Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateDomainUrlAuthConfigV2Response updateDomainUrlAuthConfig(VodUpdateDomainUrlAuthConfigV2Request input) throws Exception {
        RawResponse response = this.query("UpdateDomainUrlAuthConfig", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateDomainUrlAuthConfigV2Response.Builder responseBuilder = VodUpdateDomainUrlAuthConfigV2Response.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodUpdateDomainConfigResponse updateDomainConfig(VodUpdateDomainConfigRequest input) throws Exception {
        RawResponse response = this.query("UpdateDomainConfig", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodUpdateDomainConfigResponse.Builder responseBuilder = VodUpdateDomainConfigResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeDomainConfigResponse describeDomainConfig(VodDescribeDomainConfigRequest input) throws Exception {
        RawResponse response = this.query("DescribeDomainConfig", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeDomainConfigResponse.Builder responseBuilder = VodDescribeDomainConfigResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodAddCallbackSubscriptionResponse addCallbackSubscription(VodAddCallbackSubscriptionRequest input) throws Exception {
        RawResponse response = this.query("AddCallbackSubscription", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodAddCallbackSubscriptionResponse.Builder responseBuilder = VodAddCallbackSubscriptionResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodSetCallbackEventResponse setCallbackEvent(VodSetCallbackEventRequest input) throws Exception {
        RawResponse response = this.query("SetCallbackEvent", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodSetCallbackEventResponse.Builder responseBuilder = VodSetCallbackEventResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public GetCallbackRecordResponse getCallbackRecord(GetCallbackRecordRequest input) throws Exception {
        RawResponse response = this.query("GetCallbackRecordV2", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        GetCallbackRecordResponse.Builder responseBuilder = GetCallbackRecordResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetSmartStrategyLitePlayInfoResponse getSmartStrategyLitePlayInfo(VodGetSmartStrategyLitePlayInfoRequest input) throws Exception {
        RawResponse response = this.query("GetSmartStrategyLitePlayInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetSmartStrategyLitePlayInfoResponse.Builder responseBuilder = VodGetSmartStrategyLitePlayInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetAppInfoResponse getAppInfo(VodGetAppInfoRequest input) throws Exception {
        RawResponse response = this.query("GetAppInfo", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetAppInfoResponse.Builder responseBuilder = VodGetAppInfoResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodSpaceTranscodeDataResponse describeVodSpaceTranscodeData(DescribeVodSpaceTranscodeDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSpaceTranscodeData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodSpaceTranscodeDataResponse.Builder responseBuilder = DescribeVodSpaceTranscodeDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodSpaceAIStatisDataResponse describeVodSpaceAIStatisData(DescribeVodSpaceAIStatisDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSpaceAIStatisData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodSpaceAIStatisDataResponse.Builder responseBuilder = DescribeVodSpaceAIStatisDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodSpaceSubtitleStatisDataResponse describeVodSpaceSubtitleStatisData(DescribeVodSpaceSubtitleStatisDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSpaceSubtitleStatisData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodSpaceSubtitleStatisDataResponse.Builder responseBuilder = DescribeVodSpaceSubtitleStatisDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodSpaceDetectStatisDataResponse describeVodSpaceDetectStatisData(DescribeVodSpaceDetectStatisDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSpaceDetectStatisData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodSpaceDetectStatisDataResponse.Builder responseBuilder = DescribeVodSpaceDetectStatisDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodSpaceWorkflowDetailDataResponse describeVodSpaceWorkflowDetailData(DescribeVodSpaceWorkflowDetailDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSpaceWorkflowDetailData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodSpaceWorkflowDetailDataResponse.Builder responseBuilder = DescribeVodSpaceWorkflowDetailDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodSpaceEditDetailDataResponse describeVodSpaceEditDetailData(DescribeVodSpaceEditDetailDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSpaceEditDetailData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodSpaceEditDetailDataResponse.Builder responseBuilder = DescribeVodSpaceEditDetailDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodSnapshotDataResponse describeVodSnapshotData(DescribeVodSnapshotDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSnapshotData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodSnapshotDataResponse.Builder responseBuilder = DescribeVodSnapshotDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeVodSpaceStorageDataResponse describeVodSpaceStorageData(VodDescribeVodSpaceStorageDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSpaceStorageData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeVodSpaceStorageDataResponse.Builder responseBuilder = VodDescribeVodSpaceStorageDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeVodDomainTrafficDataResponse describeVodDomainTrafficData(VodDescribeVodDomainTrafficDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodDomainTrafficData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeVodDomainTrafficDataResponse.Builder responseBuilder = VodDescribeVodDomainTrafficDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodDescribeVodDomainBandwidthDataResponse describeVodDomainBandwidthData(VodDescribeVodDomainBandwidthDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodDomainBandwidthData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodDescribeVodDomainBandwidthDataResponse.Builder responseBuilder = VodDescribeVodDomainBandwidthDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodEnhanceImageDataResponse describeVodEnhanceImageData(DescribeVodEnhanceImageDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodEnhanceImageData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodEnhanceImageDataResponse.Builder responseBuilder = DescribeVodEnhanceImageDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodSpaceEditStatisDataResponse describeVodSpaceEditStatisData(DescribeVodSpaceEditStatisDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodSpaceEditStatisData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodSpaceEditStatisDataResponse.Builder responseBuilder = DescribeVodSpaceEditStatisDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodPlayedStatisDataResponse describeVodPlayedStatisData(DescribeVodPlayedStatisDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodPlayedStatisData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodPlayedStatisDataResponse.Builder responseBuilder = DescribeVodPlayedStatisDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodMostPlayedStatisDataResponse describeVodMostPlayedStatisData(DescribeVodMostPlayedStatisDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodMostPlayedStatisData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodMostPlayedStatisDataResponse.Builder responseBuilder = DescribeVodMostPlayedStatisDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodRealtimeMediaDataResponse describeVodRealtimeMediaData(DescribeVodRealtimeMediaDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodRealtimeMediaData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodRealtimeMediaDataResponse.Builder responseBuilder = DescribeVodRealtimeMediaDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodRealtimeMediaDetailDataResponse describeVodRealtimeMediaDetailData(DescribeVodRealtimeMediaDetailDataRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodRealtimeMediaDetailData", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodRealtimeMediaDetailDataResponse.Builder responseBuilder = DescribeVodRealtimeMediaDetailDataResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public DescribeVodVidTrafficFileLogResponse describeVodVidTrafficFileLog(DescribeVodVidTrafficFileLogRequest input) throws Exception {
        RawResponse response = this.query("DescribeVodVidTrafficFileLog", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        DescribeVodVidTrafficFileLogResponse.Builder responseBuilder = DescribeVodVidTrafficFileLogResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodSetCloudMigrateJobResponse setCloudMigrateJob(VodSetCloudMigrateJobRequest input) throws Exception {
        RawResponse response = this.query("SetCloudMigrateJob", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodSetCloudMigrateJobResponse.Builder responseBuilder = VodSetCloudMigrateJobResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodSubmitCloudMigrateJobResponse submitCloudMigrateJob(VodSubmitCloudMigrateJobRequest input) throws Exception {
        RawResponse response = this.query("SubmitCloudMigrateJob", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodSubmitCloudMigrateJobResponse.Builder responseBuilder = VodSubmitCloudMigrateJobResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    @Override
    public VodGetCloudMigrateJobResponse getCloudMigrateJob(VodGetCloudMigrateJobRequest input) throws Exception {
        RawResponse response = this.query("GetCloudMigrateJob", Utils.mapToPairList(Utils.protoBufferToMap(input, true)));
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        VodGetCloudMigrateJobResponse.Builder responseBuilder = VodGetCloudMigrateJobResponse.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge((Reader)new InputStreamReader(new ByteArrayInputStream(response.getData())), (Message.Builder)responseBuilder);
        return responseBuilder.build();
    }

    static class Result {
        @JSONField(name="Result")
        public Integer result;

        Result() {
        }
    }

    static class VodGetDirectEditProgressResponse {
        @JSONField(name="ResponseMetadata")
        public Map<String, Object> responseMetadata;
        @JSONField(name="Result")
        public Object result;

        VodGetDirectEditProgressResponse() {
        }
    }

    static class VodGetDirectEditResultResponse {
        @JSONField(name="ResponseMetadata")
        public Map<String, Object> responseMetadata;
        @JSONField(name="Result")
        public List<Map<String, Object>> result;

        VodGetDirectEditResultResponse() {
        }
    }

    public static class UploadPartResponse {
        private String checkSum;
        private String objectContentType;

        UploadPartResponse(String checkSum, String objectContentType) {
            this.checkSum = checkSum;
            this.objectContentType = objectContentType;
        }

        public static UploadPartResponseBuilder builder() {
            return new UploadPartResponseBuilder();
        }

        public String getCheckSum() {
            return this.checkSum;
        }

        public String getObjectContentType() {
            return this.objectContentType;
        }

        public void setCheckSum(String checkSum) {
            this.checkSum = checkSum;
        }

        public void setObjectContentType(String objectContentType) {
            this.objectContentType = objectContentType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UploadPartResponse)) {
                return false;
            }
            UploadPartResponse other = (UploadPartResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$checkSum = this.getCheckSum();
            String other$checkSum = other.getCheckSum();
            if (this$checkSum == null ? other$checkSum != null : !this$checkSum.equals(other$checkSum)) {
                return false;
            }
            String this$objectContentType = this.getObjectContentType();
            String other$objectContentType = other.getObjectContentType();
            return !(this$objectContentType == null ? other$objectContentType != null : !this$objectContentType.equals(other$objectContentType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UploadPartResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $checkSum = this.getCheckSum();
            result = result * 59 + ($checkSum == null ? 43 : $checkSum.hashCode());
            String $objectContentType = this.getObjectContentType();
            result = result * 59 + ($objectContentType == null ? 43 : $objectContentType.hashCode());
            return result;
        }

        public String toString() {
            return "VodServiceImpl.UploadPartResponse(checkSum=" + this.getCheckSum() + ", objectContentType=" + this.getObjectContentType() + ")";
        }

        public static class UploadPartResponseBuilder {
            private String checkSum;
            private String objectContentType;

            UploadPartResponseBuilder() {
            }

            public UploadPartResponseBuilder checkSum(String checkSum) {
                this.checkSum = checkSum;
                return this;
            }

            public UploadPartResponseBuilder objectContentType(String objectContentType) {
                this.objectContentType = objectContentType;
                return this;
            }

            public UploadPartResponse build() {
                return new UploadPartResponse(this.checkSum, this.objectContentType);
            }

            public String toString() {
                return "VodServiceImpl.UploadPartResponse.UploadPartResponseBuilder(checkSum=" + this.checkSum + ", objectContentType=" + this.objectContentType + ")";
            }
        }
    }
}

