/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.maas.v2.impl.images;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.volcengine.error.SdkError;
import com.volcengine.model.maas.api.v2.ErrorResp;
import com.volcengine.model.maas.api.v2.ImagesQuickGenRequest;
import com.volcengine.model.maas.api.v2.ImagesQuickGenResponse;
import com.volcengine.model.maas.api.v2.ImagesRequest;
import com.volcengine.model.maas.api.v2.ImagesResponse;
import com.volcengine.model.response.RawResponse;
import com.volcengine.service.maas.MaasException;
import com.volcengine.service.maas.v2.impl.MaasServiceImpl;
import java.nio.charset.StandardCharsets;

public class Images {
    private MaasServiceImpl service;
    private static final ObjectMapper mapper = new ObjectMapper();

    public Images(MaasServiceImpl service) {
        this.service = service;
    }

    public ImagesQuickGenResponse ImagesQuickGen(String endpointId, ImagesQuickGenRequest req) throws MaasException {
        String logId = this.service.genReqId();
        RawResponse response = null;
        String apikey = this.service.getApikey();
        try {
            response = this.service.json(endpointId, "images.quick_gen", logId, new ObjectMapper().writeValueAsString((Object)req), apikey);
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), null);
        }
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            try {
                ErrorResp resp = Images.json_parse(response.getException().getMessage().getBytes(StandardCharsets.UTF_8), ErrorResp.class);
                throw new MaasException(resp.getError(), logId);
            }
            catch (JsonProcessingException ignored) {
                throw new MaasException(response.getException(), logId);
            }
        }
        try {
            ImagesQuickGenResponse resp = Images.json_parse(response.getData(), ImagesQuickGenResponse.class);
            resp.setRequestId(logId);
            return resp;
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), logId);
        }
    }

    public ImagesResponse ImagesFlexGen(String endpointId, ImagesRequest req) throws MaasException {
        String reqId = this.service.genReqId();
        RawResponse response = null;
        String apikey = this.service.getApikey();
        try {
            response = this.service.json(endpointId, "images.flex_gen", reqId, new ObjectMapper().writeValueAsString((Object)req), apikey);
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), null);
        }
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            try {
                ErrorResp resp = Images.json_parse(response.getException().getMessage().getBytes(StandardCharsets.UTF_8), ErrorResp.class);
                throw new MaasException(resp.getError(), reqId);
            }
            catch (JsonProcessingException ignored) {
                throw new MaasException(response.getException(), reqId);
            }
        }
        try {
            ImagesResponse resp = Images.json_parse(response.getData(), ImagesResponse.class);
            resp.setRequestId(reqId);
            return resp;
        }
        catch (JsonProcessingException e) {
            throw new MaasException((Exception)((Object)e), reqId);
        }
    }

    private static <T> T json_parse(byte[] data, Class<T> valueType) throws JsonProcessingException {
        return (T)mapper.readValue(new String(data, StandardCharsets.UTF_8), valueType);
    }
}

