/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.model.maas.api.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.volcengine.model.maas.api.v2.Reference;
import com.volcengine.model.maas.api.v2.ToolCall;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"role", "content", "name", "references", "tool_calls", "tool_call_id"})
public class Message {
    @JsonProperty(value="role")
    @JsonPropertyDescription(value="An enumeration.")
    private ChatRole role;
    @JsonProperty(value="content")
    private Object content;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="references")
    private List<Reference> references = new ArrayList<Reference>();
    @JsonProperty(value="tool_calls")
    private List<ToolCall> toolCalls = new ArrayList<ToolCall>();
    @JsonProperty(value="tool_call_id")
    private String toolCallId;

    @JsonProperty(value="role")
    public ChatRole getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    public void setRole(ChatRole role) {
        this.role = role;
    }

    public Message withRole(ChatRole role) {
        this.role = role;
        return this;
    }

    @JsonProperty(value="content")
    public Object getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    public void setContent(Object content) {
        this.content = content;
    }

    public Message withContent(Object content) {
        this.content = content;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Message withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="references")
    public List<Reference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    public Message withReferences(List<Reference> references) {
        this.references = references;
        return this;
    }

    @JsonProperty(value="tool_calls")
    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    @JsonProperty(value="tool_calls")
    public void setToolCalls(List<ToolCall> toolCalls) {
        this.toolCalls = toolCalls;
    }

    public Message withToolCalls(List<ToolCall> toolCalls) {
        this.toolCalls = toolCalls;
        return this;
    }

    @JsonProperty(value="tool_call_id")
    public String getToolCallId() {
        return this.toolCallId;
    }

    @JsonProperty(value="tool_call_id")
    public void setToolCallId(String toolCallId) {
        this.toolCallId = toolCallId;
    }

    public Message withToolCallId(String toolCallId) {
        this.toolCallId = toolCallId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Message.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("role");
        sb.append('=');
        sb.append(this.role == null ? "<null>" : this.role);
        sb.append(',');
        sb.append("content");
        sb.append('=');
        sb.append(this.content == null ? "<null>" : this.content);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("references");
        sb.append('=');
        sb.append(this.references == null ? "<null>" : this.references);
        sb.append(',');
        sb.append("toolCalls");
        sb.append('=');
        sb.append(this.toolCalls == null ? "<null>" : this.toolCalls);
        sb.append(',');
        sb.append("toolCallId");
        sb.append('=');
        sb.append(this.toolCallId == null ? "<null>" : this.toolCallId);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.role == null ? 0 : this.role.hashCode());
        result = result * 31 + (this.references == null ? 0 : this.references.hashCode());
        result = result * 31 + (this.toolCallId == null ? 0 : this.toolCallId.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.toolCalls == null ? 0 : this.toolCalls.hashCode());
        result = result * 31 + (this.content == null ? 0 : this.content.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Message)) {
            return false;
        }
        Message rhs = (Message)other;
        return (this.role == rhs.role || this.role != null && this.role.equals((Object)rhs.role)) && (this.references == rhs.references || this.references != null && this.references.equals(rhs.references)) && (this.toolCallId == rhs.toolCallId || this.toolCallId != null && this.toolCallId.equals(rhs.toolCallId)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.toolCalls == rhs.toolCalls || this.toolCalls != null && this.toolCalls.equals(rhs.toolCalls)) && (this.content == rhs.content || this.content != null && this.content.equals(rhs.content));
    }

    public static enum ChatRole {
        SYSTEM("system"),
        ASSISTANT("assistant"),
        USER("user"),
        FUNCTION("function");

        private final String value;
        private static final Map<String, ChatRole> CONSTANTS;

        private ChatRole(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ChatRole fromValue(String value) {
            ChatRole constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ChatRole>();
            for (ChatRole c : ChatRole.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

