package com.volcengine.model.tls.request;

import java.util.List;

import com.volcengine.model.tls.TagInfo;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class DescribeTopicsRequest {
    String projectId;
    String projectName;
    Integer pageNumber;
    Integer pageSize;
    Boolean IsFullName;
    String topicName;
    String topicId;
    List<TagInfo> tags;

    /**
     * @return 日志主题所属的日志项目 ID
     */
    public String getProjectId() {
        return projectId;
    }

    /**
     * @param projectId 日志主题所属的日志项目 ID
     */
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    /**
     * @return 日志主题的名称
     */
    public String getTopicName() {
        return topicName;
    }

    /**
     * @param topicName 日志主题的名称
     */
    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    /**
     * @return 根据 TopicName 筛选时，是否精确匹配
     */
    public Boolean getFullName() {
        return this.IsFullName;
    }

    /**
     * @param fullName TopicName 筛选时，是否精确匹配
     */
    public void setFullName(Boolean fullName) {
        this.IsFullName = fullName;
    }

    /**
     * @return 日志所在的日志主题 ID
     */
    public String getTopicId() {
        return topicId;
    }

    /**
     * @param topicId 日志所在的日志主题 ID
     */
    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    /**
     * @return 分页查询时的页码。默认为 1
     */
    public Integer getPageNumber() {
        return pageNumber;
    }

    /**
     * @param pageNumber 分页查询时的页码。默认为 1
     */
    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    /**
     * @return 分页大小。默认为 20，最大为 100
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * @param pageSize 分页大小。默认为 20，最大为 100
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * @return 日志主题标签信息
     */
    public List<TagInfo> getTags() {
        return tags;
    }

    /**
     * @param tags 日志主题标签信息
     */
    public void setTags(List<TagInfo> tags) {
        this.tags = tags;
    }

    /**
     * @return 检验必填参数，true合法false不合法
     */
    public boolean CheckValidation() {
        if (this.projectId == null) {
            return false;
        }
        return true;
    }
}
